
;;;; Copyright (c) 1994 Jeff Weisberg
;;;; see the file "License"

;;;; $Id: repl.jl,v 1.9 94/08/16 16:30:11 weisberg Exp Locker: weisberg $

(defun repl ()
  "(repl) read eval print loop "
  ;; catch eof and exit
  (set! .lineno 1)
  (set! *current-file* "user input")
  (while #t
    (if (catch 'repl
	  ;; display a prompt...
	  (prompt)
	  (display (eval (read)))	    
	  (display ?\n)
	  #f)
	(display "repl: Error detected\n"))))

(defun prompt ()
  "(prompt) displays the repl prompt"
  (display "> "))

(define %repl% '(catch 'eof (repl)))

