
;;;; Copyright (c) 1994 Jeff Weisberg
;;;; see the file "License"

;;;; $Id: mritool.jl,v 1.17 94/08/16 16:30:09 weisberg Exp Locker: weisberg $


;;; a lot of this is cruft for backwards compatability
;;; with old version

(load "mouse.jl")

(define patient 'patient)
(define study 'study)
(define series 'series)
(define image 'image)

(define next 'next)
(define prev 'prev)

(define mode 'mode)
(define view 'view)
(define info 'info)
(define segm 'segm)
(define contour 'contour)

(defun spt (p)   (set-patient p))
(defun sim (i)   (set-image i))
(defun shinim () (disp-l-nice (image-info)))
(defun shinpt () (disp-l-nice (patient-info)))
(defun shinse () (disp-l-nice (series-info)))
(defun shinst () (disp-l-nice (study-info)))

(define DRAWN   "=S/drawn:S/cont%I.ras")
(define CONT	"=S:S/cont.%I.ras.gz")
(define SEGM	"=G:S/segm.%I.ras.gz")


(define mri:stop-iterating #f "signal the snake to stop iterating")
(install-signal-handler SIGUSR1
			(lambda ()
			  (set! mri:stop-iterating #t)
			  (display "setting stop-iterating flag\n")))

(defmac mri:interpret-string (str)
  "(mri:interpret-string string) interprets the string
this is used extensively throught the mritool internals"
  `(catch 'eof
     (catch 'repl
       (eval (read (open:string ,str)))
       (set! .lineno (+ .lineno 1))
       (newline))))

(define mri:frame-list ()
  "a list of all of the frames we have created thus far")

(defun new-frame ()
  "(new-frame) create a new window frame, if possible"
  (if mri:windows
      (progn
	(run-hooks 'new-frame-hooks)
	(set! mri:frame-list (cons (new-xv) mri:frame-list))
	(car mri:frame-list))
    ()))

(defun mri:init-frame ()
  "(mri:new-frame) called by the internals to create the initial frame"

  (set! mri:init-frame (lambda () (display "frame already initialized\n")))
  (let ((ui (if mri:windows
		 (new-frame)
	       (set! mri:frame-list (cons (new-nowin) mri:frame-list))
	       (set! mri:background #f)
	       (car mri:frame-list))))
    (if (and mri:background (nzerop (fork)))
	(progn
	  (sleep 5)
	  (_quit)))
    (mri:init-msg)
    ui))

(defun mri:parse-X (str)
  "(mri:parse-X str) parse -XS:F -XF debugging flags from the command line"
  (let* ((ns (strsplit (substr str 2 (length str)) '( ?: )))
	(n1 (string->number (car ns))))
    (if (eq (length ns) 2)
	(set-debug-flag! n1 (string->number (cadr ns)))
      (for-each (lambda (sect)
		  (set-debug-flag! sect n1))
		(make-range 0 31)))))

;; set up default debugging flags
(mri:parse-X "-X3")
(mri:parse-X "-X4")
(mri:parse-X "-X5")
(mri:parse-X "-X6")
(mri:parse-X "-X7")

(defun disp-l-nice (l)
  "pretty print the list"
  (let ((n 0))
    (while (nnullp l)
      (if (consp (car l))
	  (print (caar l) ?\t (cdar l) ?\n)
	(print n ?\t (car l) ?\n)
	(++ n))
      (set! l (cdr l)))))

(defmac help (&optional what)
  "(help item) display the documentation for an item"
  (if (nboundp what)
      (show-help-popup)
    (if (eq what 'me)
	`(display "You are beyond help")
      `(display (docstr ,what)))))

(defun copyright ()
  (display "  
Copyright (c) 1993,1994 Jeff Weisberg
University of Rochester
    Dept. of Electrical Engineering
    Dept. of Neurology, C.E.P.
see the file \"License\" or type \"(license)\" at the prompt
"))

(defun license ()
  (cat-file (strcat mri:etcdir "/License")))

(defun mri:visine ()
  ;; called from mouse menu
  (visine)
  (set! mouse:last-x ())
  (set! mouse:last-y ())
  (refresh))

(defun show (what &rest argl)
  "(show ...) show various parameters,
such as: patients, studies, series, images, info, stats"
  (case what
	((patient patients pat pats pt pts)
	 (disp-l-nice (patient-list)))
	((studies study stdy std)
	 (disp-l-nice (study-list)))
	((series ser sers srs)
	 (disp-l-nice (series-list)))
	((images image img imgs)
	 (disp-l-nice (image-list)))
	((stats stat statistics)
	 (show-stats))
	((loi lois)
	 (disp-l-nice (loi-list)))
	(info
	 (case (car argl)
	       ((patient patients pat pats pt pts)
		(disp-l-nice (patient-info)))
	       ((studies study stdy std)
		(disp-l-nice (study-infio)))
	       ((series ser sers srs)
		(disp-l-nice (series-info)))
	       ((image images img imgs)
		(disp-l-nice (image-info)))
	       (#t
		(display "show info: must specify one of: patient, study, series, image\n"))))
	(#t
	 (display "show: must specify one of: patients, studies, series, images, info, stats, loi\n"))))


(defun set (what &rest argl)
  "(set ...) set various parameters,
such as patient, study, series, image"
  (case what
	((patient patients pat pats pt pts)
	 (set-patient (car argl))
	 (run-hooks 'set-patient-hooks)
	 (if (numberp (and (consp (cdr argl)) (cadr argl)))
	     (apply 'set 'study (cdr argl))))

	((studies study stdy std)
	 (set-study (car argl))
	 (run-hooks 'set-study-hooks)
	 (if (numberp (and (consp (cdr argl)) (cadr argl)))
	     (apply 'set 'series (cdr argl))))

	((series ser sers srs)
	 (set-series (car argl))
	 (run-hooks 'set-series-hooks)
	 (if (numberp (and (consp (cdr argl)) (cadr argl)))
	     (apply 'set 'image (cdr argl))))

	((images image img imgs)
	 (set-image (car argl))
	 (run-hooks 'set-image-hooks))
	
	((loi lois)
	 (set-loi argl))
	(mode
	 (case (car argl)
	       (segm
		(set-mode-segm))
	       (view
		(set-mode-view))
	       (#t
		(display "set mode: must specify one of: segm, view\n"))))
	(#t
	 (display "set: must specify one of: patients, studies, series, images, loi, mode\n"))))


(defun save (what &optional f t n)
  "(save what [from to] [filename]) save things, segm, contour, view"
  (let
      ((from (if (intp f) f (current-image)))
       (to   (if (intp t) t (current-image)))
       (file (if (stringp n) n
	       (if (stringp f) f
		 ()))))
       (case what
	     ((segment segm)
	      (save-segment f t 
			    (if (nullp file) SEGM file)))
	     ((contour cont)
	      (save-contour f t
			    (if (nullp file) SEGM file))))))


(defun mri:set-header ()
  "(mri:set-header) sets the frame header"
  ;; called by XV::done_thinking()
  (set-header-text (strcat "(" mri:versn ")   "
			   (mriname "P%: %P   T%: %T   S%: %S   I%: %I"))))





