
;;;; Copyright (c) 1994 Jeff Weisberg
;;;; see the file "License"
 
;;;; $Id: mouse.jl,v 1.4 94/08/16 16:30:06 weisberg Exp Locker: weisberg $

;;; format of event is:
;;; #(code flags shiftmask locx locy time action string)
;;; see .../xview/win_input.h


;;; some (possibly) useful defines
;;; mostly from /usr/openwin/include/xview/win_input.h

;;; event codes
(define MS_LEFT                32563 )
(define MS_MIDDLE              32564 )
(define MS_RIGHT               32565 )
(define LOC_DRAG               32515 )
			       
;;; shifmasks
(define CAPSLOCK        0      );         /* Caps Lock key                */
(define CAPSMASK        #x0001 )
(define SHIFTLOCK       1      );         /* Shift Lock key               */
(define LEFTSHIFT       2      );         /* Left-hand shift key          */
(define RIGHTSHIFT      3      );         /* Right-hand shift key         */
(define SHIFTMASK       #x000E )
(define LEFTCTRL        4      );         /* Left-hand (or only) ctrl key */
(define RIGHTCTRL       5      );         /* Right-hand control key       */
(define CTRLMASK        #x0030 )
 
(define META_SHIFT_MASK #x0040 )
(define MS_LEFT_MASK    #x0080 )
(define MS_MIDDLE_MASK  #x0100 )
(define MS_RIGHT_MASK   #x0200 )
(define MS_BUTTON_MASK  #x0380 )
(define ALTMASK         #x0400 )


(define mouse:start-x () "x coord. of the first point on the contour")
(define mouse:start-y () "y coord. of the first point on the contour")
(define mouse:last-x  () "x coord. of the most recent point on the contour")
(define mouse:last-y  () "y coord. of the most recent point on the contour")
(define mouse:mode    () "the current mouse mode")
(define mouse:selected 0 "currently selected contour")

(define mouse:menu
  '(("None"       "(progn (set! mouse:mode ())            (set-left-footer-text \"None\"))")
    ("Draw"       "(progn (set! mouse:mode 'mouse:DRAW)   (set-left-footer-text \"Draw\"))")
    ("Erase"      "(progn (set! mouse:mode 'mouse:ERASE)  (set-left-footer-text \"Erase\"))")
    ("W/L"        "(progn (set! mouse:mode 'mouse:FIDDLE) (set-left-footer-text \"Adjust W/L\"))")
    ("Visine"     "(mri:visine)")	; defined in mritool.jl
    ("Snake LOI"  "(progn (set! mouse:mode 'mouse:SELLOI) (set-left-footer-text \"Set LOI\"))")))


(defun mouse:handler (event)
  "(mouse:handler event) called from internally to handle mouse events"
  (let ((x (nth event 3))
	(y (nth event 4))
	(code (nth event 0)))
    ; (print "Mouse: " mouse:mode " " event ?\n)

    (if (or (and (= MS_LEFT  code) (=  1 (& (nth event 1) 1)))                ; left & down
	    (and (= LOC_DRAG code) (!= 0 (& (nth event 2) MS_LEFT_MASK)))     ; or left drag
	    (eq mouse:mode 'mouse:NXTSNK))
	
	(case mouse:mode
	  
	      (mouse:DRAW
	       (if (nullp mouse:last-x)
		   ;; first point
		   (progn
		     (set-left-footer-text (strcat "Draw: "
						   (nth mri:buttons mouse:selected)))
		     (set! mouse:start-x (set! mouse:last-x x))
		     (set! mouse:start-y (set! mouse:last-y y))
		     (draw-point x y mouse:selected))
		 (draw-line x y mouse:last-x mouse:last-y mouse:selected)
		 (set! mouse:last-x x)
		 (set! mouse:last-y y)))

	      (mouse:ERASE
	       (erase-area x y)
	       (set! mouse:last-x ())
	       (set! mouse:last-y ()))

	      (mouse:FIDDLE
	       (adjust-wl ($-$ y 256) ($-$ x 128))
	       (set-left-footer-text (strcat "W/L: "
					     (number->string ($-$ y 256))
					     "/"
					     (number->string ($-$ x 128)))))

	      (mouse:SELLOI
	       (set-left-footer-text (strcat "LOI: ("
					     (number->string x)
					     ", "
					     (number->string y)
					     ") = "
					     (number->string (mouse-set-loi x y mouse:selected)))))

	      (mouse:NXTSNK
	       ;; only reachable from clicking on measure button
	       (if (and (nnullp mouse:start-x)
			(nnullp mouse:last-x))
		     (draw-line mouse:start-x mouse:start-y mouse:last-x mouse:last-y mouse:selected))
	       (set! mouse:last-x ())
	       (set! mouse:last-y ())
	       (set! mouse:mode 'mouse:DRAW)
	       (set-left-footer-text (strcat "Draw: "
					     (nth mri:buttons mouse:selected))))

	  (#t
	   )))))

;; we want the this to be fairly quick
(set! mouse:handler (bind mouse:handler))



  

