
;;;; Copyright (c) 1994 Jeff Weisberg
;;;; see the file "License"

;;;; $Id: cmdline.jl,v 1.7 94/08/11 15:50:41 weisberg Exp Locker: weisberg $

(define %parse-cmd-line%
  "(parse-cmd-line) parse the command line args"
  '(eval (let ((x '(progn))
	       (andexit #f)
	       (userrc #t)
	       (sysrc #t)
	       carg
	       foo
		;; separate cmd line args
	       (argvl (cdr (vector->list *argv*))))
	   (run-hooks 'parse-cmd-line-hooks)
	   (while (nnullp argvl)
	     (set! carg (car argvl))
	     (cond
	      ((eqv "-f" carg)		             ; load a file
	       (set! argvl (cdr argvl))
	       (set! andexit #t)
	       (set! userrc #f)
	       (load (car argvl)))
	      
	      ((and (definedp 'mritool)
		    (eqv "-fore" carg))		     ; run in foreground
	       (set! mri:background #f))
	      
	      ((eqv "-f" (substr carg 0 2))	     ; load a file
	       (set! andexit #t)
	       (set! userrc #f)
	       (load (substr carg 2 (- (length carg) 2))))
	      
	      ((and (definedp 'mritool)
		    (or
		     (eqv "-nw" carg)		     ; run in interactive, no-window mode
		     (eqv "-nowin" carg)))
	       (set! mri:windows #f)
	       (set! mri:winsys  #f)
	       (set! mri:background #f))
	      
	      ((and (definedp 'mritool)
		    (eqv "-X" (substr carg 0 2)))
	       (mri:parse-X carg))
						     ; set debugging level
	      ((eqv "-norc" carg)
	       (set! userrc #f))
	      
	      ((eqv "-nosysrc" carg)
	       (set! sysrc #f))
	      
	      ((eqv "-e" carg)			     ; eval an expr
	       (set! argvl (cdr argvl))
	       (set! foo (read (open:string (car argvl))))
	       (set! x (append x (list foo)))))
	     
	     (set! argvl (cdr argvl)))
	   
	   (if userrc (set! x (append x '((catch 'error
					    (load (expand-filename "~/.jlisprc")))))))
	   (if (definedp 'mritool)
	       (progn
		 (if sysrc (set! x (append x '((catch 'error
						 (load "mrirc.jl"))))))
		 (if userrc (set! x (append x '((load (expand-filename "~/.mrirc"))))))))
	   (if andexit (quit))
	   x)))




