/*
    frame.h -- Frame stack and non-local jump.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


/*  IHS	Invocation History Stack  */

typedef struct invocation_history {
	object	ihs_function;
	object	*ihs_base;
} *ihs_ptr;

#define	IHSGETA		32

#ifdef MTCL
#define ihs_stack       clwp->lwp_ihs_stack
#else
extern struct invocation_history ihs_stack[IHSSIZE + IHSGETA + IHSGETA];
#endif

#define ihs_org		ihs_stack

#ifdef MTCL
#define ihs_limit       clwp->lwp_ihs_limit
#define ihs_top         clwp->lwp_ihs_top
#else
extern ihs_ptr ihs_limit;
extern ihs_ptr ihs_top;
#endif

#define	ihs_check  \
	if (ihs_top >= ihs_limit)  \
		ihs_overflow()

#define ihs_push(function, args)  \
	(++ihs_top)->ihs_function = (function);  \
	ihs_top->ihs_base = args

#define ihs_pop() 	(ihs_top--)

#define make_nil_block(r)  \
{  \
	object x;  \
  \
	lex_copy();  \
	x = new_frame_id();  \
	lex_block_bind(Cnil, x);  \
	r = frs_push(FRS_CATCH, x);  \
}


/*  Frame Stack  */

enum fr_class {
	FRS_CATCH,			/* for catch,block,tabbody */
	FRS_CATCHALL,                   /* for catchall */
	FRS_PROTECT                	/* for protect-all */
};

struct frame {
	jmp_buf		frs_jmpbuf;
	object		*frs_lex;
	bds_ptr		frs_bds_top;
	enum fr_class	frs_class;
	object		frs_val;
	ihs_ptr		frs_ihs;
};

typedef struct frame *frame_ptr;

/*
frs_class |            frs_value                 |  frs_prev
----------+--------------------------------------+--------------
CATCH     | frame-id, i.e.                       |
	  |    throw-tag,                        |
	  |    block-id (uninterned symbol), or  | value of ihs_top
	  |    tagbody-id (uninterned symbol)    | when the frame
----------+--------------------------------------| was pushed
CATCHALL  |               NIL                    |
----------+--------------------------------------|
PROTECT   |               NIL                    |
----------------------------------------------------------------
*/

#define FRSSIZE		1024
#define	FRSGETA		16

#ifdef MTCL
#define frame_stack       clwp->lwp_frame_stack
#else
struct frame frame_stack[FRSSIZE + FRSGETA + FRSGETA];
#endif

#define frs_org		frame_stack

#ifdef MTCL
#define frs_limit       clwp->lwp_frs_limit
#define frs_top         clwp->lwp_frs_top
#else
frame_ptr frs_limit;
frame_ptr frs_top;	/* frame stack top */
#endif

#define frs_push(class, val)  \
	(((++frs_top >= frs_limit) && frs_overflow()),  \
	frs_top->frs_lex = lex_env,\
	frs_top->frs_bds_top = bds_top,  \
	frs_top->frs_class = (class),  \
	frs_top->frs_val = (val),  \
	frs_top->frs_ihs = ihs_top,  \
        _setjmp(frs_top->frs_jmpbuf))

#define frs_pop()	frs_top--


/*  global variables used during non-local jump  */

#ifdef MTCL
#define nlj_fr           clwp->lwp_nlj_fr
#define nlj_tag          clwp->lwp_nlj_tag
#else
frame_ptr nlj_fr;	/* frame to return  */
object nlj_tag;		/* throw-tag, block-id, or */
			/* (tagbody-id . label).   */
#endif
