/*
    multival.c -- Multiple Values.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

Lvalues(int narg, ...)
{	int i;
	va_list args;
	va_start(args, narg);
	for (i = 0; i < narg; i++) VALUES(i) = va_arg(args, object);
	if (narg == 0) VALUES(0) = Cnil;
	RETURN(narg);
}

Lvalues_list(int narg, object list)
{	int i = 0;

	check_arg(1);
	while (!endp(list)) {	
		VALUES(i++) = CAR(list);
		list = CDR(list);
	}
	if (i == 0) VALUES(0) = Cnil;
	RETURN(i);
}

Fmultiple_value_list(object form)
{
	object list = Cnil;
	int nr;

	if (endp(form))
		FEtoo_few_argumentsF(form);
	if (!endp(CDR(form)))
		FEtoo_many_argumentsF(form);
	nr = eval(CAR(form));
	while (nr-- > 0) list = CONS(VALUES(nr), list);
	VALUES(0) = list;
	RETURN(1);
}

Fmultiple_value_call(object form)
{
	object fun;
	int nr, i, tr = 0;
	object *args, *args0;

	if (endp(form))
		FEtoo_few_argumentsF(form);
	eval(CAR(form));
	fun = VALUES(0);
	form = CDR(form);
	while (!endp(form)) {
	  nr = eval(CAR(form));
#ifdef DOWN_STACK
	  args = alloca(nr * sizeof(object));
	  for (i = 0; i < tr; i++)
	    args[i] = args0[i];
	  args0 = args;
	  for (i = 0; i < nr; i++)
	    args[tr++] = VALUES(i);
#endif DOWN_STACK
	  form = CDR(form);
	}
	return(apply(tr, fun, args));
}

Fmultiple_value_prog1(object forms)
{
	int nr;

	if (endp(forms))
		FEtoo_few_argumentsF(forms);
	nr = eval(CAR(forms));
	MV_SAVE(nr);
	forms = CDR(forms);
	while (!endp(forms)) {	
		eval(CAR(forms));
		forms = CDR(forms);
	}
	MV_RESTORE(nr);
	RETURN(nr);
}


init_multival()
{
	make_constant("MULTIPLE-VALUES-LIMIT",MAKE_FIXNUM(32));
	make_function("VALUES",Lvalues);
	make_function("VALUES-LIST",Lvalues_list);
	make_special_form("MULTIPLE-VALUE-CALL",Fmultiple_value_call);
	make_special_form("MULTIPLE-VALUE-PROG1",
			  Fmultiple_value_prog1);
	make_special_form("MULTIPLE-VALUE-LIST",Fmultiple_value_list);
}
