/*
    main.c --
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/



#include "config.h"
#include <sys/file.h>
#include <unistd.h>

/*		********  WARNING ********
    Do not insert any data definitions before data_start!
    Since this is the first file linked, the address of the following
    variable should correspond to the start of initialized data space.
    On some systems this is a constant that is independent of the text
    size for shared executables.  On others, it is a function of the
    text size. In short, this seems to be the most portable way to
    discover the start of initialized data space dynamically at runtime,
    for either shared or unshared executables, on either swapping or
    virtual systems.  It only requires that the linker allocate objects
    in the order encountered, a reasonable model for most Unix systems.
    Similarly, note that the address of _start() should be the start
    of text space.   Fred Fish, UniSoft Systems Inc.  */

/*  On SGI one could use extern _fdata[] instead */

int data_start = (int)&data_start;

#ifndef MSDOS
#include <sys/utsname.h>
static struct utsname uts;
#endif

/******************************* EXPORTS ******************************/

object Squote;
object Sfunction;
object Slambda;
object Slambda_block;
object Slambda_closure;
object Slambda_block_closure;
object Sspecial;

int ARGC;
char **ARGV;

int interrupt_flag;		/* console interupt flag */
int interrupt_enable;		/* console interupt enable */

#ifndef THREADS

object Values[VSSIZE];

struct bds_bd bind_stack[BDSSIZE + 2*BDSGETA];
bds_ptr bds_limit;
bds_ptr bds_top;

struct invocation_history ihs_stack[IHSSIZE + 2*IHSGETA];
ihs_ptr ihs_limit;
ihs_ptr ihs_top;

int *cs_org;
int *cs_limit;
int cssize;

#endif THREADS

char system_directory[MAXPATHLEN];
object siVsystem_directory;
#ifdef unix
char *ecl_self;
#endif

struct package *pack_pointer = NULL;

#define SIG_STACK_SIZE 1000
#if defined(HAVE_SIGACTION) || defined(HAVE_SIGVEC)
        struct sigstack estack;
#endif

/******************************* IMPORTS ******************************/

extern int gc_time;		/* Beppe */
extern int real_maxpage;

/******************************* ------- ******************************/

int initflag = FALSE;		/* initialized flag */
bool saving_system = FALSE;
int debug;			/* debug switch */

#ifdef THREADS
int intha();
object siVthread_top;
#endif THREADS

#ifdef BSD

#ifndef THREADS
#include <sys/time.h>
#endif THREADS

#include <sys/resource.h>
#endif BSD

char stdin_buf[BUFSIZ];
char stdout_buf[BUFSIZ];

object siVlisp_initialized;
object siVlisp_maxpages;
object siClisp_pagesize;
object siStop_level;

char *
expand_pathname(char *name)
{ char *path, *pn, *p;
  static char pathname[255];
  extern char *getenv();

  if (IS_DIR_SEPARATOR(name[0])) return(name);
  if ((path = getenv("PATH")) == NULL) error("No PATH in environment");
  p = path;
  pn = pathname;
  do {
    if ((*p == '\0') || (*p == PATH_SEPARATOR)) {
      if (pn != pathname) *pn++ = DIR_SEPARATOR; /* on SYSV . is empty */
LAST: strcpy(pn, name);
      if (access(pathname, X_OK) == 0)
	return (pathname);
      pn = pathname;
      if (p[0] == PATH_SEPARATOR && p[1] == '\0') { /* last entry is empty */
	p++;
	goto LAST;
      }
    }
    else
      *pn++ = *p;
  } while (*p++ != '\0');
  return(name);			/* should never occur */
}

get_directory(char *to, char *from)
{
#ifndef MSDOS
  /*  in DOS the disk unit name is prepended to the path  */
	if (!IS_DIR_SEPARATOR(from[0]))
	  strcpy(to, "./");
	else
#endif MSDOS
	  { int j;

	    strcpy(to, from);
	    for (j = strlen(to);
		 !IS_DIR_SEPARATOR(to[j-1]); --j)
	      ;
	    to[j] = '\0';
	  }
   }

main(int argc, char **argv, char **envp)
{
	lex_dcl;
#ifdef BSD
	struct rlimit rl;
#endif BSD

	setbuf(stdin,  stdin_buf);
	setbuf(stdout, stdout_buf);

	ARGC = argc;
	ARGV = argv;
#ifdef unix

	ecl_self = argv[0];

	if (argc > 1) {
	  if (!IS_DIR_SEPARATOR(argv[1][strlen(argv[1])-1]))
	    error("The system directory must terminate with '/'.");
	  strcpy(system_directory, argv[1]);
	} else
	  get_directory(system_directory, ecl_self);
#endif unix

	GC_enable = FALSE;
	gc_time = 0;		/* Beppe */

	frs_top = frs_org-1;
	frs_limit = &frs_org[FRSSIZE];
	bds_top = bds_org-1;
	bds_limit = &bds_org[BDSSIZE];
  	ihs_top = ihs_org-1;
	ihs_limit = &ihs_org[IHSSIZE];

	cs_org = &argc;
	cssize = CSSIZE;

#ifdef BSD
#ifdef RLIMIT_STACK
	getrlimit(RLIMIT_STACK, &rl);
	cssize = rl.rlim_cur/4 - 4*CSGETA; /* in THREADS I'm assigning to the main thread clwp */
#endif
#endif BSD

#ifdef DOWN_STACK
	cs_limit = cs_org - cssize; /* in THREADS I'm assigning to the main thread clwp */
#else
	cs_limit = cs_org + cssize;
#endif

#ifdef MSDOS
#include <sys/fcntl.h>
	_fmode = O_BINARY;	/* default to binary file mode */
#endif

	if (initflag) {

         	/* Restarting after dump with siLsave_system: */
		if (saving_system) {
		  brk(data_end); /* reobtain memory */
#ifdef MSDOS
		  /* dummy access for bug in go32 */
		  if (*(heap_end-1)) initflag = FALSE;
#endif MSDOS
		  saving_system = FALSE;
		  alloc_page(-(holepage + nrbpage));
		}
		get_directory(system_directory, ecl_self);
		siVsystem_directory->s.s_dbind = 
		  make_simple_string(system_directory);
		initflag = FALSE;
		GC_enable = TRUE;
		ihs_push(Cnil, (object *)Cnil);
		lex_new();

		/* Enable interrupt handlers */
		interrupt_enable = TRUE;
#ifdef unix
		enable_interrupt();
		siLcatch_bad_signals(0);
#endif
#ifdef THREADS
		enable_lwp();
#endif THREADS
		siVlisp_maxpages->s.s_dbind = MAKE_FIXNUM(real_maxpage);
		initflag = TRUE;
		ihs_push(siStop_level, lex_env);
		funcall(1, siStop_level);
		ihs_pop();
		exit(0);
	}
#ifndef MSDOS
	ecl_self = expand_pathname(ecl_self);
#endif MSDOS
	/* 	Initialization phase		*/

	printf("ECoLisp (Embeddable Common Lisp)  %d pages\n", MAXPAGE);
	fflush(stdout);

	ihs_push(Cnil, (object *)Cnil);
	lex_new();

	init_lisp();

	initflag = TRUE;
	interrupt_enable = TRUE;
#ifdef unix
	enable_interrupt();
#endif unix
	/* Simple minded top level loop */
	while (printf("\n> "), Lread(3, Cnil, Cnil, OBJNULL),
	       VALUES(0) != OBJNULL) {
	  eval(VALUES(0));
	  prin1(VALUES(0), Cnil);
	}
}

Lquit(int narg, object code)
{
#ifdef unix
	int i;

#ifdef THREADS
	frame_ptr fr;
#endif THREADS

	if (narg == 0)
		i = 0;
	else if (narg == 1) {
		if (FIXNUMP(code))
			i = fix(code);
		else
			FEerror("Illegal exit code: ~S.", 1, code);
	} else
		FEtoo_many_arguments(&narg);
#ifdef THREADS
	if (clwp != &main_lpd) {
	  fr = frs_sch_catch(siVthread_top);
	  if (fr == NULL)
	    FEerror("~S is an undefined tag.", 1, siVthread_top);
	  unwind(fr, siVthread_top, 1);
	  /* never reached */
	}
#endif THREADS
	printf("Bye.\n");
	exit(i);
#endif unix
}

siLargc(int narg)
{
	check_arg(0);
	VALUES(0) = MAKE_FIXNUM(ARGC);
	RETURN(1);
}

siLargv(int narg, object index)
{   int i;

	check_arg(1);
	if (!FIXNUMP(index) || (i = fix(index)) < 0 || i >= ARGC)
		FEerror("Illegal argument index: ~S.", 1, index);
	VALUES(0) = make_simple_string(ARGV[i]);
	RETURN(1);
}

#ifdef unix
siLgetenv(int narg, object var)
{
	char name[256];
	int i;
	char *value;
	extern char *getenv();

	check_arg(1);
	check_type_string(&var);
	if (var->st.st_fillp >= 256)
		FEerror("Too long name: ~S.", 1, var);
	for (i = 0;  i < var->st.st_fillp;  i++)
		name[i] = var->st.st_self[i];
	name[i] = '\0';
	if ((value = getenv(name)) != NULL)
		VALUES(0) = make_simple_string(value);
	else
		VALUES(0) = Cnil;
	RETURN(1);
}
#endif

siLreset_stack_limits(int narg)
{
	check_arg(0);
	if (bds_top < bds_org + BDSSIZE)
		bds_limit = bds_org + BDSSIZE;
	else
		error("can't reset bds_limit.");
	if (frs_top < frs_org + FRSSIZE)
		frs_limit = frs_org + FRSSIZE;
	else
		error("can't reset frs_limit.");
	if (ihs_top < ihs_org + IHSSIZE)
		ihs_limit = ihs_org + IHSSIZE;
	else
		error("can't reset ihs_limit.");
#ifdef DOWN_STACK
	if (&narg > cs_org - cssize + 16)
		cs_limit = cs_org - cssize;
#else
	if (&narg < cs_org + cssize - 16)
		cs_limit = cs_org + cssize;
#endif
	else
		error("can't reset cs_limit.");

	VALUES(0) = Cnil;
	RETURN(1);
}

siLaddress(int narg, object x)
{
	check_arg(1);
	VALUES(0) = MAKE_FIXNUM((int)x);
	RETURN(1);
}

siLnani(int narg, object x)
{
	check_arg(1);
	VALUES(0) = (object)fixint(x);
	RETURN(1);
}

Lidentity(int narg, object x)
{
	check_arg(1);
	VALUES(0) = x;
	RETURN(1);
}

#ifndef MSDOS
Lmachine_instance(int narg)
{
	check_arg(0);

	uname(&uts);
	VALUES(0) = make_simple_string(uts.nodename);
	RETURN(1);
}

Lmachine_version(int narg)
{
	check_arg(0);
	uname(&uts);
	VALUES(0) = make_simple_string(uts.machine);
	RETURN(1);
}

Lsoftware_type(int narg)
{
	check_arg(0);
	uname (&uts);
	VALUES(0) = make_simple_string(uts.sysname);
	RETURN(1);
}

Lsoftware_version(int narg)
{
	check_arg(0);
	uname (&uts);
	VALUES(0) = make_simple_string(uts.release);
	RETURN(1);
}
#endif MSDOS

siLsave_system(int narg, object file)
{	int i;
	char filename[256];

	check_arg(1);
	check_type_or_pathname_string_symbol_stream(&file);
	coerce_to_filename(file, filename);

#ifdef HAVE_YP_UNBIND
	{ char domain[200];
	  extern object truename(), namestring();
	  /* prevent subsequent consultation of yp by getting
	     truename now */
	  file = namestring(truename(file));
	  if (0 == getdomainname(&domain, sizeof(domain)))
	    yp_unbind(&domain);
	}
#endif

	saving_system = TRUE;
	GC(t_contiguous);

	siLreset_gc_count(0);

	siVlisp_initialized->s.s_dbind = Cnil;

	unexec(filename, ecl_self, 0, 0, 0);
	_exit(0);
}

init_main()
{
	make_function("QUIT", Lquit);

	make_function("IDENTITY", Lidentity);

	siStop_level=make_si_ordinary("TOP-LEVEL");
	enter_mark_origin(&siStop_level);

	siVlisp_initialized =
	make_si_special("*LISP-INITIALIZED*", Cnil);

	make_si_function("ARGC", siLargc);
	make_si_function("ARGV", siLargv);
#ifdef unix
	make_si_function("GETENV", siLgetenv);
#endif
	make_si_function("RESET-STACK-LIMITS", siLreset_stack_limits);
	make_si_function("POINTER", siLaddress);
	make_si_function("NANI", siLnani);
	make_ordinary("LISP-IMPLEMENTATION-VERSION");
#ifndef MSDOS
	make_function("MACHINE-INSTANCE", Lmachine_instance);
	make_function("MACHINE-VERSION", Lmachine_version);
	make_function("SOFTWARE-TYPE", Lsoftware_type);
	make_function("SOFTWARE-VERSION", Lsoftware_version);
#endif MSDOS

	siVlisp_maxpages =
	make_si_special("*LISP-MAXPAGES*", MAKE_FIXNUM(real_maxpage));

	siClisp_pagesize =
	make_si_constant("LISP-PAGESIZE", MAKE_FIXNUM(LISP_PAGESIZE));

	siVsystem_directory =
	make_si_special("*SYSTEM-DIRECTORY*",
			make_simple_string(system_directory));

	{ object features;
	  features =
	    CONS(make_keyword("ECL"),
		 CONS(make_keyword("COMMON"), Cnil));

#define ADD_FEATURE(name)	features = CONS(make_keyword(name),features)

#ifdef LOCATIVE
	 ADD_FEATURE("LOCATIVE");
#endif LOCATIVE

#ifdef THREADS
	 ADD_FEATURE("THREADS");
#endif THREADS
	
#ifdef CLOS
	 ADD_FEATURE("CLOS");
#endif CLOS

#ifdef PDE
	 ADD_FEATURE("PDE");
#endif PDE

/* ---------- Operating System ---------- */
#ifdef unix
	 ADD_FEATURE("UNIX");
#endif
#ifdef BSD
	 ADD_FEATURE("BSD");
#endif
#ifdef SYSV
	 ADD_FEATURE("SYSTEM-V");
#endif
#ifdef MSDOS
	 ADD_FEATURE("MS-DOS");
#endif

	 ADD_FEATURE(ARCHITECTURE);
	 ADD_FEATURE(BRAND);

#ifdef IEEEFLOAT
	 ADD_FEATURE("IEEE-FLOATING-POINT");
#endif

	 make_special("*FEATURES*", features);
       }
#ifdef THREADS
	siVthread_top = make_si_ordinary("THREAD-TOP");
#endif THREADS
	make_si_function("SAVE-SYSTEM", siLsave_system);
}
