/*
    macros.c -- Macros.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

/******************************* REQUIRES ******************************/

/* Requires expand-defmacro, from lsp/defmacro.lsp

/******************************* EXPORTS ******************************/

object Vmacroexpand_hook;
object siSexpand_defmacro;
object Sdefmacro;

/******************************* ------- ******************************/

object Swarn;

object siVinhibit_macro_special;

siLdefine_macro(int narg, object name, object expr, object doc, object pprint)
{
	check_arg(4);
	if (type_of(name) != t_symbol)
		not_a_symbol(name);
	if (SPECIAL(name)) {
		if (name->s.s_mflag) {
			if (symbol_value(siVinhibit_macro_special) != Cnil)
				name->s.s_sfdef = NOT_SPECIAL;
		} else if (symbol_value(siVinhibit_macro_special) != Cnil)
			FEerror("~S, a special form, cannot be redefined.",
				1, name);
	}
	clear_compiler_properties(name);
	if (name->s.s_hpack == lisp_package &&
	    name->s.s_gfdef != OBJNULL && initflag)
		funcall(3, Swarn,
			make_simple_string("~S is being redefined."), name);
	name->s.s_gfdef = expr;
	name->s.s_mflag = TRUE;
	if (doc != Cnil)
		name->s.s_plist
		= putf(name->s.s_plist, doc, siSfunction_documentation);
	if (pprint != Cnil)
		name->s.s_plist
		= putf(name->s.s_plist, pprint, siSpretty_print_format);
	VALUES(0) = name;
	RETURN(1);
}

/*
	MACRO_EXPAND1 is an internal function which simply applies the
	function EXP_FUN to FORM.  On return, the expanded form is stored
	in VALUES(0).
*/
void macro_expand1(object exp_fun, object form)
{
	int nr = 1;
/*	
	Macros may well need their functional environment to expand properly.
	For example setf needs to expand the place which may be a local
	macro.  They are not supposed to need the other parts of the
	environment
*/
	nr = funcall(4, symbol_value(Vmacroexpand_hook), exp_fun, form,
		     (lex_env[1] == OBJNULL) ? Cnil :
		     list(3, lex_env[0], lex_env[1], lex_env[2]));
	if (nr = 0)
		VALUES(0) = Cnil;
}

/*
	MACRO_DEF is an internal function which, given a form, returns
	the expansion function if the form is a macro form.  Otherwise,
	MACRO_DEF returns NIL.
*/
object
macro_def(object form)
{
	object head, fd;

	if (type_of(form) != t_cons)
		return(Cnil);
	head = CAR(form);
	if (type_of(head) != t_symbol)
		return(Cnil);
	fd = lex_fd_sch(head);
	if (Null(fd))
		if (head->s.s_mflag)
			return(head->s.s_gfdef);
		else
			return(Cnil);
	else if (CADR(fd) == Smacro)
		return(CADDR(fd));
	else
		return(Cnil);
}

Lmacroexpand(int narg, object form, object env)
{
	object exp_fun;
	object *lex_old = lex_env;
	lex_dcl;

	if (narg < 1)
		FEtoo_few_arguments(&narg);
	lex_env = lex;
	if (narg == 1)
		lex[0] = lex[1] = lex[2] = Cnil;
	else if (narg == 2) {
		lex[0] = car(env);
		lex[1] = car(env = cdr(env));
		lex[2] = cadr(env);
	} else
		FEtoo_many_arguments(&narg);
	exp_fun = macro_def(form);
	VALUES(1) = Cnil;
	while (!Null(exp_fun)) {
	  macro_expand1(exp_fun, form);
	  form = VALUES(0);
	  exp_fun = macro_def(form);
	  VALUES(1) = Ct;
	}
	lex_env = lex_old;
	VALUES(0) = form;
	RETURN(2);
}

Lmacroexpand_1(int narg, object form, object env)
{
	object exp_fun;
	object *lex_old=lex_env;
	lex_dcl;

	if (narg < 1)
		FEtoo_few_arguments(&narg);
	lex_env = lex;
	if (narg == 1)
		lex[0] = lex[1] = lex[2] = Cnil;
	else if (narg == 2) {
		lex[0] = car(env);
		lex[1] = car(env = cdr(env));
		lex[2] = cadr(env);
	} else
		FEtoo_many_arguments(&narg);
	exp_fun = macro_def(form);
	if (Null(exp_fun))
	  VALUES(1) = Cnil;
	else {
	  macro_expand1(exp_fun, form);
	  form = VALUES(0);
	  VALUES(1) = Ct;
	}
	lex_env = lex_old;
	VALUES(0) = form;
	RETURN(2);
}

/*
	MACRO_EXPAND expands a form as many times as possible and returns
	the finally expanded form.
*/
object
macro_expand(object form)
{
	object exp_fun, head, fd;
	int nr;

	/* Check if the given form is a macro form.  If not, return
	   immediately.  Macro definitions are superseded by special-
	   form definitions.
	*/
	while (TRUE) {
	  if (type_of(form) != t_cons)
	    break;
	  head = CAR(form);
	  if (type_of(head) != t_symbol)
	    break;
	  if (SPECIAL(head))
	    break;
	  fd = lex_fd_sch(head);
	  if (Null(fd))
	    if (head->s.s_mflag)
	      exp_fun = head->s.s_gfdef;
	    else
	      break;
	  else if (CADR(fd) == Smacro)
	    exp_fun = CADDR(fd);
	  else
	    break;

	  /*  macro_expand1(exp_fun, form);  */
	  nr = funcall(4, symbol_value(Vmacroexpand_hook), exp_fun, form,
		       (lex_env[1] == OBJNULL) ? Cnil :
		       list(3, lex_env[0], lex_env[1], lex_env[2]));
	  form = (nr = 0) ? Cnil : VALUES(0);
	}
	return(form);
}

init_macros()
{
	make_si_function("DEFINE-MACRO", siLdefine_macro);
	Vmacroexpand_hook
	= make_special("*MACROEXPAND-HOOK*", Sfuncall);
	make_function("MACROEXPAND", Lmacroexpand);
	make_function("MACROEXPAND-1", Lmacroexpand_1);

	Sdefmacro = make_ordinary("DEFMACRO");
	siSexpand_defmacro = make_si_ordinary("EXPAND-DEFMACRO");
	/* bootstrap for defmacro */
	{object x = intern("X", system_package),
	   env = intern("Y", system_package),
	   Scadr = find_symbol("CADR", 4, system_package),
	   Scaddr = find_symbol("CADDR", 5, system_package),
	   Scdddr = find_symbol("CDDDR", 5, system_package),
	   Sdefine_macro = make_si_function("DEFINE-MACRO", siLdefine_macro);

	 Sdefmacro->s.s_gfdef =
	   list(4, Slambda_block, Sdefmacro, list(2, x, env),
		list(4, Slist, list(2, Squote, Sdefine_macro),
		     list(3, Slist, list(2, Squote, Squote),
			  list(2, Scadr, x)),
		     list(5, Slist, list(2, Squote, siSexpand_defmacro),
			  list(3, Slist, list(2, Squote, Squote),
			       list(2, Scadr, x)),
			  list(3, Slist, list(2, Squote, Squote),
			       list(2, Scaddr, x)),
			  list(3, Slist, list(2, Squote, Squote),
			       list(2, Scdddr, x)))));
	 Sdefmacro->s.s_mflag = TRUE;
       }
	enter_mark_origin(&siSexpand_defmacro);

	siVinhibit_macro_special =
	make_si_special("*INHIBIT-MACRO-SPECIAL*", Cnil);
}
