/*
    catch.c -- Dynamic non-local exit.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

Fcatch(args)
object args;
{
	int nr;

	if (endp(args))
		FEtoo_few_argumentsF(args);
	eval(CAR(args));
	if ((nr = frs_push(FRS_CATCH, VALUES(0))) == 0)
	   nr = Fprogn(CDR(args));
	else
	  nr--;
	frs_pop();
	RETURN(nr);
}

siLerror_set(int narg, object form)
{
	object *lex_old = lex_env;

	check_arg(1);
	if (frs_push(FRS_CATCHALL, Cnil)) {
		VALUES(0) = nlj_tag;
		frs_pop();
		lex_env = lex_old;
		RETURN(1);
	} else {
		 lex_dcl;
		 lex[0] = lex[1] = lex[2] = Cnil;
		 lex_env = lex;
		 eval(form);
		 VALUES(0) = Cnil;
		 frs_pop();
		 lex_env = lex_old;
		 RETURN(1);
	}
}

Funwind_protect(object args)
{
	int nr; bool unwinding = FALSE;

	if (endp(args)) FEtoo_few_argumentsF(args);

	if (nr = frs_push(FRS_PROTECT, Cnil)) {
	  nr--;
	  unwinding = TRUE;
	}
	else
	  nr = eval(CAR(args));
	frs_pop();
	MV_SAVE(nr);
	Fprogn(CDR(args));
	MV_RESTORE(nr);
	if (unwinding)
	  unwind(nlj_fr, nlj_tag, nr+1);
	else
	  RETURN(nr);
      }

Fthrow(object args)
{
	object tag;
	frame_ptr fr;
	int nr;

	if (endp(args) || endp(CDR(args)))
		FEtoo_few_argumentsF(args);
	if (!endp(CDDR(args)))
		FEtoo_many_argumentsF(args);
	eval(CAR(args));
	tag = VALUES(0);
	fr = frs_sch_catch(tag);
	if (fr == NULL)
		FEerror("~S is an undefined tag.", 1, tag);
	nr = eval(CADR(args));
	unwind(fr, tag, nr + 1); /*  +1 since longjmp cannot return 0  */
	/* never reached */
}

init_catch()
{
	make_special_form("CATCH", Fcatch);
	make_si_function("ERROR-SET", siLerror_set);
	make_special_form("UNWIND-PROTECT", Funwind_protect);
	make_special_form("THROW", Fthrow);
}
