/*
    assignment.c  -- Assignment.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

object Ssetf;

object Sget;
object Saref;
object Ssvref;
object Selt;
object Schar;
object Sschar;
object Sfill_pointer;
object Sgethash;
object Scar;
object Scdr;

object Spush;
object Spop;
object Sincf;
object Sdecf;

object siSstructure_access;
object siSsetf_lambda;
object Svector;
object Slist;

object siSclear_compiler_properties;
void clear_compiler_properties();

object Swarn;

object siVinhibit_macro_special;

#ifdef CLOS
object siSsetf_symbol;
#endif CLOS

#ifdef PDE
object siVrecord_source_pathname_p, siSrecord_source_pathname;
extern object Sdefun;
#endif PDE

void setq(object sym, object val)
{
	object vd;
	enum stype type;

	if(type_of(sym) != t_symbol)
		not_a_symbol(sym);
	type = (enum stype)sym->s.s_stype;
	if (type == stp_constant)
		FEinvalid_variable("Cannot assign to the constant ~S.", sym);
	else if(type == stp_special)
		sym->s.s_dbind = val;
	else {
		vd = lex_var_sch(sym);
		if(Null(vd) || endp(CDR(vd)))
			sym->s.s_dbind = val;
		else
			CADR(vd) = val;
	}
}

Fsetq(object form)
{
	if (endp(form))
		VALUES(0) = Cnil;
	else
		for (; !endp(form) ; form = CDDR(form)) {
			if (endp(CDR(form)))
				FEinvalid_form("No value for ~S.", CAR(form));
			eval(CADR(form));
			setq(CAR(form), VALUES(0));
		}
	RETURN(1);
}

Fpsetq(object arg)
{
	object val;
	if (!endp(arg)) {
	  if (endp(CDR(arg)))
	    FEinvalid_form("No value for ~S.", CAR(arg));
	  eval(CADR(arg));
	  val = VALUES(0);
	  Fpsetq(CDDR(arg));
	  setq(CAR(arg), val);
	}
	VALUES(0) = Cnil;
	RETURN(1);
}

Lset(int narg, object var, object val)
{
	check_arg(2);
	if (type_of(var) != t_symbol)
		not_a_symbol(var);
	if ((enum stype)var->s.s_stype == stp_constant)
		FEinvalid_variable("Cannot assign to the constant ~S.", var);
	VALUES(0) = var->s.s_dbind = val;
	RETURN(1);
}

#ifdef CLOS
object setf_namep(object fun_spec)
{	object cdr;
	if (type_of(fun_spec) == t_cons && 
	    !endp(cdr = CDR(fun_spec)) &&
	    endp(CDR(cdr)) &&
	    CAR(fun_spec) == Ssetf) {
	  object fn_name, sym;
	  fn_name = CAR(cdr);
	  sym = getf(fn_name->s.s_plist, siSsetf_symbol, Cnil);
	  if (Null(sym) || type_of(sym) != t_symbol) {
	    int l = fn_name->s.s_fillp + 7;
	    char *str = alloc_contblock(l+1);
	    strncpy(str, "(SETF ", 6);
	    strncpy(str + 6, fn_name->s.s_self, fn_name->s.s_fillp);
	    str[l-1] = ')';
	    str[l] = '\0';
	    sym = intern(str, fn_name->s.s_hpack);
	    fn_name->s.s_plist =
	      putf(fn_name->s.s_plist, sym, siSsetf_symbol);
	  }
	  return(sym);
	} else return(OBJNULL);
}

siLsetf_namep(int narg, object arg)
{
	check_arg(1);

	VALUES(0) = (setf_namep(arg) != OBJNULL) ? Ct : Cnil;
	RETURN(1);
}
#endif CLOS

#ifdef vax
extern char *sprintf();
#endif vax
extern char *strncpy();

siLfset(int narg, object fun, object def)
{
	check_arg(2);
	if (type_of(fun) != t_symbol)
#ifdef CLOS
	  {  object sym;
	     if ((sym=setf_namep(fun)) != OBJNULL)
	       fun = sym;
	     else not_a_symbol(fun);
	   }
#else 
	not_a_symbol(fun); 
#endif 
	if (SPECIAL(fun)) {
		if (fun->s.s_mflag) {
			if (symbol_value(siVinhibit_macro_special) != Cnil)
				fun->s.s_sfdef = NOT_SPECIAL;
		} else if (symbol_value(siVinhibit_macro_special) != Cnil)
			FEerror("~S, a special form, cannot be redefined.", 1, fun);
	}
	clear_compiler_properties(fun);
	if (fun->s.s_hpack == lisp_package &&
	    fun->s.s_gfdef != OBJNULL && initflag)
		funcall(3, Swarn, make_simple_string("~S is being redefined."), fun);
	if (type_of(def) == t_cfun ||
	    type_of(def) == t_cclosure) {
	        fun->s.s_gfdef = def;
		fun->s.s_mflag = FALSE;
#ifdef CLOS
	} else if (type_of(def) == t_gfun) {
		fun->s.s_gfdef = def;
		fun->s.s_mflag = FALSE;
#endif
	} else if (car(def) == Sspecial)
		FEerror("Cannot define a special form.", 0);
	else if (CAR(def) == Smacro) {
		fun->s.s_gfdef = CDR(def);
		fun->s.s_mflag = TRUE;
	} else {
		fun->s.s_gfdef = def;
		fun->s.s_mflag = FALSE;
	}
	VALUES(0) = def;
	RETURN(1);
}

Fmultiple_value_setq(form)
object form;
{
	object vars;
	int nr, i;

	if (endp(form) || endp(CDR(form)) ||
	    !endp(CDDR(form)))
	    FEinvalid_form("~S is an illegal argument to MULTIPLE-VALUE-SETQ",
			   form);
	vars = CAR(form);
	nr = eval(CADR(form));
	for (i = 0;  !endp(vars);  i++, vars = CDR(vars))
		if (i < nr)
			setq(CAR(vars), VALUES(i));
		else
			setq(CAR(vars), Cnil);
	RETURN(1);
}

Lmakunbound(int narg, object sym)
{
	check_arg(1);
	if (type_of(sym) != t_symbol)
		not_a_symbol(sym);
	if ((enum stype)sym->s.s_stype == stp_constant)
		FEinvalid_variable("Cannot unbind the constant ~S.", sym);
	sym->s.s_dbind = OBJNULL;
	VALUES(0) = sym;
	RETURN(1);
}
	
Lfmakunbound(int narg, object sym)
{
	check_arg(1);
	if(type_of(sym) != t_symbol) {
#ifdef CLOS
	  object sym1;
	  if ((sym1=setf_namep(sym)) != OBJNULL)
	      sym = sym1;
	  else
#endif
	    not_a_symbol(sym);
	}
	if (SPECIAL(sym)) {
	  if (sym->s.s_mflag) {
	    if (symbol_value(siVinhibit_macro_special) != Cnil)
	      sym->s.s_sfdef = NOT_SPECIAL;
	  } else if (symbol_value(siVinhibit_macro_special) != Cnil)
	    FEerror("~S, a special form, cannot be redefined.", 1, sym);
	}
	clear_compiler_properties(sym);
#ifdef PDE
	remprop(sym, Sdefun);
#endif PDE
	if (sym->s.s_hpack == lisp_package &&
	    sym->s.s_gfdef != OBJNULL && initflag)
	       funcall(3, Swarn, make_simple_string("~S is being redefined."), sym);
	sym->s.s_gfdef = OBJNULL;
	sym->s.s_mflag = FALSE;
	VALUES(0) = sym;
	RETURN(1);
      }

Fsetf(object form)
{
	if (endp(form))
		VALUES(0) = Cnil;
	else
		for (; !endp(form); form = CDDR(form)) {
			if (endp(CDR(form)))
			   FEinvalid_form("No value for ~S.", CAR(form));
			setf(CAR(form), CADR(form));
		}
	RETURN(1);
}

setf(object place, object form)
{
	object fun, args;
	object x, y;

	if (type_of(place) != t_cons) {
		eval(form);
		setq(place, VALUES(0));
		RETURN(1);
	}
	fun = CAR(place);
	if (type_of(fun) != t_symbol)
		goto OTHERWISE;
	args = CDR(place);
	if (fun == Sget) {
		eval(car(args));
		x = VALUES(0);
		eval(car(CDR(args)));
		y = VALUES(0);
		eval(form);
		VALUES(0) = putprop(x, VALUES(0), y);
		RETURN(1);
	}
	if (fun == Scar) {
		eval(CAR(args));
		x = VALUES(0);
		if (type_of(x) != t_cons)
			FEerror("~S is not a cons.", 1, x);
		eval(form);
		CAR(x) = VALUES(0);
		RETURN(1);
	}
	if (fun == Scdr) {
		eval(CAR(args));
		x = VALUES(0);
		if (type_of(x) != t_cons)
			FEerror("~S is not a cons.", 1, x);
		eval(form);
		CDR(x) = VALUES(0);
		RETURN(1);
	}

OTHERWISE:
	x = list(3, Ssetf, place, form);
	y = (lex_env[1] != OBJNULL) ?
	  list(3, lex_env[0], lex_env[1], lex_env[2]) : Cnil;
	if (!Ssetf->s.s_mflag || Ssetf->s.s_gfdef == OBJNULL)
	  FEerror("Where is SETF?", 0);
	funcall(3, Ssetf->s.s_gfdef, x, y);
	eval(VALUES(0));
	RETURN(1);
}

Fpush(object form)
{
	object var;

	if (endp(form) || endp(CDR(form)))
		FEtoo_few_argumentsF(form);
	if (!endp(CDDR(form)))
		FEtoo_many_argumentsF(form);
	var = CADR(form);
	if (type_of(var) != t_cons) {
		eval(CAR(form));
		form = VALUES(0);
		eval(var);
		setq(var, VALUES(0) = CONS(form, VALUES(0)));
		RETURN(1);
	}
	if (!Spush->s.s_mflag || Spush->s.s_gfdef == OBJNULL)
		FEerror("Where is PUSH?", 0);
	funcall(3, Spush->s.s_gfdef, CONS(Spush, form), Cnil);
	RETURN(eval(VALUES(0)));
}

Fpop(object form)
{
	object var;

	if (endp(form))
		FEtoo_few_argumentsF(form);
	if (!endp(CDR(form)))
		FEtoo_many_argumentsF(form);
	var = CAR(form);
	if (type_of(var) != t_cons) {
		eval(var);
		setq(var, cdr(VALUES(0)));
		VALUES(0) = car(VALUES(0));
		RETURN(1);
	}
	if (!Spop->s.s_mflag || Spop->s.s_gfdef == OBJNULL)
		FEerror("Where is POP?", 0);
	funcall(3, Spop->s.s_gfdef, CONS(Spop, form), Cnil);
	RETURN(eval(VALUES(0)));
}

Fincf(object form)
{
	object var;
	object one_plus(), number_plus();

	if (endp(form))
		FEtoo_few_argumentsF(form);
	if (!endp(CDR(form)) && !endp(CDDR(form)))
		FEtoo_many_argumentsF(form);
	var = CAR(form);
	if (type_of(var) != t_cons) {
		if (endp(CDR(form))) {
			eval(var);
			VALUES(0) = one_plus(VALUES(0));
			setq(var, VALUES(0));
			RETURN(1);
		}
		eval(CADR(form));
		form = VALUES(0);
		eval(var);
		VALUES(0) = number_plus(VALUES(0), form);
		setq(var, VALUES(0));
		RETURN(1);
	}
	if (!Sincf->s.s_mflag || Sincf->s.s_gfdef == OBJNULL)
		FEerror("Where is INCF?", 0);
	funcall(3, Sincf->s.s_gfdef, CONS(Sincf, form), Cnil);
	RETURN(eval(VALUES(0)));
}

Fdecf(object form)
{
	object var;
	object one_minus(), number_minus();

	if (endp(form))
		FEtoo_few_argumentsF(form);
	if (!endp(CDR(form)) && !endp(CDDR(form)))
		FEtoo_many_argumentsF(form);
	var = CAR(form);
	if (type_of(var) != t_cons) {
		if (endp(CDR(form))) {
			eval(var);
			VALUES(0) = one_minus(VALUES(0));
			setq(var, VALUES(0));
			RETURN(1);
		}
		eval(CADR(form));
		form = VALUES(0);
		eval(var);
		VALUES(0) = number_minus(VALUES(0), form);
		setq(var, VALUES(0));
		RETURN(1);
	}
	if (!Sdecf->s.s_mflag || Sdecf->s.s_gfdef == OBJNULL)
		FEerror("Where is DECF?", 0);
	funcall(3, Sdecf->s.s_gfdef, CONS(Sdecf, form), Cnil);
	RETURN(eval(VALUES(0)));
}

void clear_compiler_properties(object sym)
{
	siLunlink_symbol(1, sym);
	if (symbol_value(siVinhibit_macro_special) != Cnil)
		(void)funcall(2, siSclear_compiler_properties, sym);
}

siLclear_compiler_properties(int narg, object sym)
{
	check_arg(1);
	VALUES(0) = sym;
	RETURN(1);
}

#ifdef PDE
void record_source_pathname(object sym, object def)
{
  if (symbol_value(siVrecord_source_pathname_p) != Cnil)
    (void)funcall(3, siSrecord_source_pathname, sym, def);
}
#endif PDE

init_assignment()
{
	make_special_form("SETQ", Fsetq);
	make_special_form("PSETQ", Fpsetq);
	make_function("SET", Lset);
	make_si_function("FSET", siLfset);

	make_special_form("MULTIPLE-VALUE-SETQ", Fmultiple_value_setq);

	make_function("MAKUNBOUND", Lmakunbound);
	make_function("FMAKUNBOUND", Lfmakunbound);

	Ssetf = make_ordinary("SETF");

	Sget = make_ordinary("GET");
	Saref = make_ordinary("AREF");
	Ssvref = make_ordinary("SVREF");
	Selt = make_ordinary("ELT");
	Schar = make_ordinary("CHAR");
	Sschar = make_ordinary("SCHAR");
	Sfill_pointer = make_ordinary("FILL-POINTER");
	Sgethash = make_ordinary("GETHASH");
	Scar = make_ordinary("CAR");
	Scdr = make_ordinary("CDR");

	make_special_form("SETF", Fsetf);

	Spush = make_ordinary("PUSH");
	Spop = make_ordinary("POP");
	Sincf = make_ordinary("INCF");
	Sdecf = make_ordinary("DECF");

	make_special_form("PUSH", Fpush);
	make_special_form("POP", Fpop);
	make_special_form("INCF", Fincf);
	make_special_form("DECF", Fdecf);

	siSstructure_access = make_si_ordinary("STRUCTURE-ACCESS");
	enter_mark_origin(&siSstructure_access);
	siSsetf_lambda = make_si_ordinary("SETF-LAMBDA");
	enter_mark_origin(&siSsetf_lambda);
	Svector = make_ordinary("VECTOR");
	Slist = make_ordinary("LIST");

	siSclear_compiler_properties
	= make_si_function("CLEAR-COMPILER-PROPERTIES",
			   siLclear_compiler_properties);
#ifdef PDE
	siVrecord_source_pathname_p
	  = make_si_special("*RECORD-SOURCE-PATHNAME-P*", Cnil);
	siSrecord_source_pathname
	  = make_si_ordinary("RECORD-SOURCE-PATHNAME");
#endif PDE
#ifdef CLOS
	siSsetf_symbol = make_si_ordinary("SETF-SYMBOL");
	enter_mark_origin(&siSsetf_symbol);
	make_si_function("SETF-NAMEP", siLsetf_namep);
#endif CLOS
}
