/*
    apply.c -- Interface to C call mechanism.
*/
/*
    Copyright (c) 1993, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

APPLY(int n, int (*fn)(), object *x)
#ifdef ARGCALL
{ int i; ARGSTACK(n);
  for (i = 0; i < n; i++)
    CPUSH(*x++);
  return(ARGCALL(n, fn));
}
#else
{
  switch (n) {
  case 0:  return (*fn)(0);
  case 1:  return (*fn)(1, x[0]);
  case 2:  return (*fn)(2, x[0],x[1]);
  case 3:  return (*fn)(3, x[0],x[1],x[2]);
  case 4:  return (*fn)(4, x[0],x[1],x[2],x[3]);
  case 5:  return (*fn)(5, x[0],x[1],x[2],x[3],x[4]);
  case 6:  return (*fn)(6, x[0],x[1],x[2],x[3],x[4],x[5]);
  case 7:  return (*fn)(7, x[0],x[1],x[2],x[3],x[4],x[5],x[6]);
  case 8:  return (*fn)(8, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7]);
  case 9:  return (*fn)(9, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		     x[8]);
  case 10: return (*fn)(10, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9]);
  case 11: return (*fn)(11, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10]);
  case 12: return (*fn)(12, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11]);
  case 13: return (*fn)(13, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12]);
  case 14: return (*fn)(14, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13]);
  case 15: return (*fn)(15, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14]);
  case 16: return (*fn)(16, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15]);
  case 17: return (*fn)(17, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16]);
  case 18: return (*fn)(18, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17]);
  case 19: return (*fn)(19, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18]);
  case 20: return (*fn)(20, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19]);
  case 21: return (*fn)(21, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20]);
  case 22: return (*fn)(22, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21]);
  case 23: return (*fn)(23, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22]);
  case 24: return (*fn)(24, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23]);
  case 25: return (*fn)(25, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24]);
  case 26: return (*fn)(26, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25]);
  case 27: return (*fn)(27, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26]);
  case 28: return (*fn)(28, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27]);
  case 29: return (*fn)(29, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28]);
  case 30: return (*fn)(30, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29]);
  case 31: return (*fn)(31, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30]);
  case 32: return (*fn)(32, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31]);
  case 33: return (*fn)(33, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32]);
  case 34: return (*fn)(34, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33]);
  case 35: return (*fn)(35, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34]);
  case 36: return (*fn)(36, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35]);
  case 37: return (*fn)(37, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36]);
  case 38: return (*fn)(38, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37]);
  case 39: return (*fn)(39, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38]);
  case 40: return (*fn)(40, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39]);
  case 41: return (*fn)(41, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40]);
  case 42: return (*fn)(42, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41]);
  case 43: return (*fn)(43, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42]);
  case 44: return (*fn)(44, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43]);
  case 45: return (*fn)(45, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44]);
  case 46: return (*fn)(46, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45]);
  case 47: return (*fn)(47, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46]);
  case 48: return (*fn)(48, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47]);
  case 49: return (*fn)(49, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48]);
  case 50: return (*fn)(50, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49]);
  case 51: return (*fn)(51, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50]);
  case 52: return (*fn)(52, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50],x[51]);
  case 53: return (*fn)(53, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50],x[51],x[52]);
  case 54: return (*fn)(54, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50],x[51],x[52],x[53]);
  case 55: return (*fn)(55, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50],x[51],x[52],x[53],x[54]);
  case 56: return (*fn)(56, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50],x[51],x[52],x[53],x[54],x[55]);
  case 57: return (*fn)(57, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50],x[51],x[52],x[53],x[54],x[55],x[56]);
  case 58: return (*fn)(58, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50],x[51],x[52],x[53],x[54],x[55],x[56],
		      x[57]);
  case 59: return (*fn)(59, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50],x[51],x[52],x[53],x[54],x[55],x[56],
		      x[57],x[58]);
  case 60: return (*fn)(60, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50],x[51],x[52],x[53],x[54],x[55],x[56],
		      x[57],x[58],x[59]);
  case 61: return (*fn)(61, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50],x[51],x[52],x[53],x[54],x[55],x[56],
		      x[57],x[58],x[59],x[60]);
  case 62: return (*fn)(62, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50],x[51],x[52],x[53],x[54],x[55],x[56],
		      x[57],x[58],x[59],x[60],x[61]);
  case 63: return (*fn)(63, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50],x[51],x[52],x[53],x[54],x[55],x[56],
		      x[57],x[58],x[59],x[60],x[61],x[62]);
  case 64: return (*fn)(64, x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],
		      x[8],x[9],x[10],x[11],x[12],x[13],x[14],
		      x[15],x[16],x[17],x[18],x[19],x[20],x[21],
		      x[22],x[23],x[24],x[25],x[26],x[27],x[28],
		      x[29],x[30],x[31],x[32],x[33],x[34],x[35],
		      x[36],x[37],x[38],x[39],x[40],x[41],x[42],
		      x[43],x[44],x[45],x[46],x[47],x[48],x[49],
		      x[50],x[51],x[52],x[53],x[54],x[55],x[56],
		      x[57],x[58],x[59],x[60],x[61],x[62],x[63]);
  default: FEerror("Exceeded call-arguments-limit.", 0);
  } 
}
#endif ARGCALL
