;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Module: Animation Examples
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/examples/animation-examples.lisp
;;; File Creation Date: 6/23/89 10:31:37
;;; Last Modification Time: 09/21/92 08:36:31
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :xit)

;_______________________________________________________________________________

#+allegro
(declaim (special *display*
	           animation-window animation-switch
		   blinker hourglass-animation xit-ad))

#-allegro
(proclaim '(special *display*
	            animation-window animation-switch
	            blinker hourglass-animation xit-ad))

(setq animation-window
      (make-window 'intel-example-window
		   :name :animation-examples
		   :x 100 :y 200 :width 300 :height 250
		   :window-icon `(intel-example-icon :parent ,icon-menu
						     :text "Animation")
		   :state :managed
		   :title "Animation"
		   :reactivity-entries
		   '((:map-notify
		      (call :eval (setf (identification animation-switch) :on)))
		     (:unmap-notify
		      (call :eval (setf (identification animation-switch) :off))))
		   ))

(setq animation-switch
    (make-gio 'text-switch
	      :parent animation-window
	      :x 20 :y 50
	      :border-width 1
	      :part-font '(:face :bold)
	      :action-mode :down
	      :selection :off
	      :reactivity-entries
	      '((:select "Change animation mode"
			 (call :self switch))
		(:write-event

		 (call :eval
		  (if (eq (identification *self*) :on)
		      (progn 
			(set-timer blinker 2)
			(set-timer hourglass-animation 0.5)
			(set-timer xit-ad 1))
		    (progn 
			(remove-timer blinker)
			(remove-timer hourglass-animation)
			(remove-timer xit-ad))))))
	      :parts
	      '((:view-of :on
		 :text "Start")
		(:view-of :off
		 :text "Stop"))))
	      

(setq blinker
    (make-gio 'text-dispel
	      :parent animation-window
	      :x 20 :y 100
	      :text "Blink" :font '(:size 18)
	      :border-width 2
	      :background "white"
	      ;;:timer 2 ;; means 2 seconds interval
	      :reactivity-entries '((:timer (call :self flash-window)))))

(setq hourglass-animation
    (make-gio 'bitmap-switch
	      :parent animation-window
	      :x 150 :y 100
	      ;:timer 0.25
	      :reactivity-entries '((:timer (call :self switch)))
	      :parts
	      '((:bitmap "hourglass-0")
		(:bitmap "hourglass-1-8")
		(:bitmap "hourglass-1-4")
		(:bitmap "hourglass-3-8")
		(:bitmap "hourglass-1-2")
		(:bitmap "hourglass-5-8")
		(:bitmap "hourglass-3-4")
		(:bitmap "hourglass-7-8")
		(:bitmap "hourglass-1")
		(:bitmap "hourglass-h"))))
		

(setq xit-ad
    (make-gio 'text-switch
	      :parent animation-window
	      :x 20 :y 150
	      :border-width 1
	      :inside-border 0
	      :part-font '(:size 24)
	      :selection :start
	      ;;:timer 1
	      :reactivity-entries '((:timer (call :self switch)))
	      :parts
	      '((:view-of :start
		 :text "")
		(:text "X")
		(:text "XI")
		(:text "XIT")
		(:text "The X User Interface Toolkit"
		 :inside-border 10
		 :font (:size 18))
		(:text "The X User Interface Toolkit"
		 :inside-border 10
		 :background "black"
		 :foreground "white"
		 :font (:size 18))
		(:text "The X User Interface Toolkit"
		 :inside-border 10
		 :font (:size 18)))))
		
	      
;(update-state *display*)
;(process-all-events *display*)

;(shrink animation-window)

(update-state *display*)
(process-all-events *display*)
