;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: johnb $
;;; $Source: RCS/color.cl,v $
;;; $Revision: 1.1.1.1 $
;;; $Date: 92/04/03 16:47:42 $
;;;

(in-package "PT")

(defclass color (pmc)
  ((res
    :initform nil
    :type vector
    :reader res)
   (pixel
    :initarg :pixel
    :initform nil
    :type integer
    :reader pixel)
   (name
    :initarg :name
    :initform ""
    :type string
    :reader name)
   (colormap
    :initarg :colormap
    :initform nil
    :type colormap
    :reader colormap)
   (red 
    :initarg :red
    :initform nil 
    :type integer
    :reader red)
   (green 
    :initarg :green
    :initform nil
    :type integer
    :reader green)
   (blue 
    :initarg :blue
    :initform nil 
    :type integer
    :reader blue)
   (hardware-color-p 
    :initform nil
    :initarg :hardware-color-p
    :reader hardware-color-p)
   (ref-count
    :initarg :ref-count
    :initform 0
    :type integer)))

(defun make-color (&rest args
			 &key
			 (name nil)
			 (colormap nil mapp)
			 (attach-p nil)
			 red green blue
			 &allow-other-keys 
			 &aux color)
  (unless (and mapp (colormap-p colormap))
	  (setq colormap (default-colormap)))
  (setf (getf args :colormap) colormap)
  (when (color-p name) 
	(setq name (name name))
	(setf (getf args :name) name))
  (if (and 
       (setq color (get-color name colormap))
       (not (or red green blue))) 
      (progn 
       (when attach-p (attach color))
       color)
      (apply #'make-instance 'color :allow-other-keys t args)))

(defmethod new-instance ((self color)
			 &key 
			 (attach-p nil) ;; attach right now
			 (name nil)
			 (colormap nil mapp)
			 &allow-other-keys)
  ;; colormap must be valid
  (unless (and mapp (colormap-p colormap))
	  (setq colormap (default-colormap)))
  (setf (slot-value self 'colormap) colormap)
  
  ;; check name
  (when (color-p name) 
	(setq name (name name)))
  (when name
	(if (get-color name colormap)
	    (warn "color.new-instance: name \'~s\' already exists in colormap. Aborted." name)))
  
  ;; add to colormap hash table
  (setf (gethash name (hashtab colormap)) self)
  
  (when attach-p (attach self))
  self)

(defmethod do-attach ((self color))
  ;; don't reattach if ref-count is positive
  (when (> (slot-value self 'ref-count) 0)
	(incf (slot-value self 'ref-count))
	(return-from do-attach))

  ;; attach. . .
  (let* ((red (red self))
	 (green (green self))
	 (blue (blue self))
	 (lookup-p (if (or red green blue) nil t))
	 (name (name self))
	 (colormap (colormap self))
	 (hcp (hardware-color-p self))
	 sc
	 hc
	 )

	(unless (attached-p colormap) (attach colormap))

	;; if a color component is nil, set it to 0.
	(unless red (setq red 0))
	(unless green (setq green 0))
	(unless blue (setq blue 0))

	(cond (lookup-p
	       (when (stringp name) 
		     (multiple-value-setq 
		      (sc hc) 
		      (xlib:lookup-color (res colormap) name)) 
		     (if hcp
			 (setf (slot-value self 'res) sc)
			       ;; (slot-value self 'red) (xlib:color-red sc)
			       ;; (slot-value self 'green) (xlib:color-green sc)
			       ;; (slot-value self 'blue) (xlib:color-blue sc)
			 (setf (slot-value self 'res) hc)
			       ;; (slot-value self 'red) (xlib:color-red hc)
			       ;; (slot-value self 'green) (xlib:color-green hc)
			       ;; (slot-value self 'blue) (xlib:color-blue hc)
			 )
		     ))

	      ;; no lookup
	      ((and (<= 0 red 1) (<= 0 green 1) (<= 0 blue 1))
	       (setq hc (xlib:make-color :blue blue :green green :red red)) 
	       (setf (slot-value self 'res) hc
		     (slot-value self 'red) (xlib:color-red hc)
		     (slot-value self 'green) (xlib:color-green hc)
		     (slot-value self 'blue) (xlib:color-blue hc))
	       )
	      (t
	       (warn "color.new-instance: bad rgb values (~s ~s ~s)" 
		     red green blue))
	      )
	(setf (slot-value self 'pixel)
	      (xlib:alloc-color (res colormap) (res self))
	      (slot-value self 'ref-count) 1)
	)
  self)
  
;;;
;;;	Do not normally detach colors
;;;

(defmethod do-detach ((self color))
  ;; don't detach if ref-count is 0
  (when (> (slot-value self 'ref-count) 1) 
	(decf (slot-value self 'ref-count))
	(return-from do-detach))
  (when (< (slot-value self 'ref-count) 1) 
	(return-from do-detach))
  ;; detach only when ref-count is 1.
  (let ((p (pixel self)))
       (cond ((not p)
	      (warn "Color ~S already detached" self))
	     (t
	      ;; (xlib:free-colors (res (colormap self)) (list (pixel self)))
	      (setf (slot-value self 'pixel) nil
		    (slot-value self 'ref-count) 0))))
  (setf (slot-value self 'res) nil)
  )

