;;; -*- Mode: Lisp; Package: USER -*-
;;;
;;;	(c) Copyright 1989, 1990, 1991 Sun Microsystems, Inc. 
;;;	Sun design patents pending in the U.S. and foreign countries. 
;;;	See LEGAL_NOTICE file for terms of the license.
;;;
;;; Created:       Wed May 29 11:36:30 1991 by Conal Elliott
;;; Last Modified: Wed Oct 23 13:18:58 1991 by Conal Elliott
;;;
;;; Build the XGL interface.
;;;
;;; Sccs Id %W% %G%
;;;

(in-package :USER)

(defun load-xgl ()
  (let ((files
	 '("xgl"
	   "foreign-c"
	   "other-xgl-stuff"
	   "xgl-h"		; Generated by etranslate.el
	   "xgl-functions"
	   "xgl-ut-functions")))
    (LCL:with-deferred-warnings
	(dolist (file files)
	  (load file :if-source-only :compile :if-source-newer :compile))))
  (let ((arch #+sparc "sun4" #+mc68000 "sun3"))
    #+mc68000 (error "Sorry, no sun3 xgl lib that I know of.")
    (FFI:load-foreign-files
     (list (format nil "xgl.~A.o" arch))
     (list (format nil "~a/lib/libxgl.a" (environment-variable "XGLHOME"))
	   "xglut/libxglut.a"
	   "-lm" "-lc")))
  (pushnew :xgl *features*))

(load-xgl)

;;; Put other preloaded files here.
(when (environment-variable "GTG")
  (defun load-ergo ()
    ;; Do this so that the working dir will be reset after the let.
    (let ((working-dir (working-directory)))
      (cd (concatenate 'string (environment-variable "GTG")
		       "/packages/ess/sys/ergolisp/rel"))
      (flet ((doload (file)
	       (load file :if-source-only :compile :if-source-newer :compile)))
	(doload "ergolisp")
	(doload "ergolisp-exports")
	(doload "ergo-system")
	(doload "ergo-types")
	(doload "type-check")
	(doload "dlambda")
	(doload "dlambda-lib")
	(cd "../../constr/rel")
	(doload "constr"))
      (cd working-dir)
      )
    (use-package :ergolisp :user)
    (pushnew :ergolisp *features*))

  ;; Comment out the following if you don't want ergo stuff.
  (load-ergo))

(format t "You can say (disksave-xgl <target, default=\"lisp-xgl\">) now.~%")

(defun disksave-xgl (&optional (file-name "lisp-xgl"))
  (disksave file-name :full-gc t))
