;;;	(c) Copyright 1989, 1990, 1991 Sun Microsystems, Inc. 
;;;	Sun design patents pending in the U.S. and foreign countries. 
;;;	See LEGAL_NOTICE file for terms of the license.

;;;@(#)attributes.lisp	3.7 10/11/91


(in-package :xview :use '(lisp))


;;; To update the values of the XView constants defined with def-xview-attribute
;;; remove the #+ignore that hides the second definition of def-xview-constant
;;; (below) and load this file.  The resulting C printf statements should inserted
;;; into the body of main in build-xview-defs.c.  When compiled and executed the 
;;; output of build-xview-defs.c should be used to replace the def-xview-attribute
;;; forms below.


;;; XView enumeration constants, typically used as attribute identifiers in 
;;; attribute value lists, are represented by Lisp keywords.  The value of 
;;; the C enumeration constant is stored on the keywords property list under
;;; 'attribute-value.  Each set of enumerated constants are associated with 
;;; a C type (this isn't strictly true but it is true for all of the enums
;;; used by the XView implementations).  Each distinct C enum type is defined
;;; as a foreign integer type, the values for all of the enum constants for a
;;; particular type are stored under 'attribute-values on the types property-list.
;;;
;;; For example:  given a C enum defined like this: 
;;;
;;;     typedef enum {one = 1, not-two 12345, three = 3} my_enum;
;;;
;;; (def-foreign-synonym-type my-enum :signed-32bit)
;;; (setf (get :one 'attribute-value) 1
;;;       (get :not-two 'attribute-value) 12345
;;;       (get :three 'attribute-value) 3
;;;       (get 'my-enum 'attribute-values) (list 1 12345 3))
;;;
;;; When the attribute is created we make sure that it wasn't previously
;;; defined with a different attribute value, we also check that the attributes
;;; type (that's the C enum type) is unique.  Errors should not occur here, if they
;;; do it's very likely because of a name collision caused by ignoring case
;;; in C identifiers.

(defun make-xview-attribute (name value type)
  (let ((foreign-type (intern (C-id-to-lisp-id type)))
	(attribute (intern (C-id-to-lisp-id name) (find-package :keyword))))
    (if (defined-foreign-type-p foreign-type)
	(when (and (get foreign-type 'original-attribute-type-name)
		   (not (equal type (get foreign-type 'original-attribute-type-name))))
	  (error "More than one attribute type called ~A" type))
      (progn
	(LUCID::define-foreign-synonym-type foreign-type :signed-32bit)
	(export (list foreign-type))
	(setf (get foreign-type 'original-attribute-type-name) type)))
    (pushnew value (get foreign-type 'attribute-values))
    (when (and (get attribute 'attribute-value) 
	       (not (= (get attribute 'attribute-value) value)))
      (error "More than one attribute called ~A" name))
    (setf (get attribute 'attribute-value) value)))

(defmacro def-xview-attribute (name value type)
  `(progn 
     (make-xview-attribute ,name ,value ,type)
     (export '(,(intern name)))
     (defconstant ,(intern name) ,value)))
     


;;; Print a C printf statement that, when compiled and executed, will print
;;; a make-xview-attribute form.  For example:
;;;
;;; printf("(def-xview-attribute \"XV_Y\" %d \"Xv_generic_attr\"")\n", XV_Y);
;;; 

#+ignore
(defmacro def-xview-attribute (name value type)
  (declare (ignore value))
  (format t "   printf(\"(def-xview-attribute \\\"~A\\\" %d \\\"~A\\\")\\n\", ~A);~%"
	   name
	   type
	   name))

#|
(def-xview-attribute "ATTR_CU_POSITION" 0 "Attr_cu_type")
(def-xview-attribute "ATTR_CU_LENGTH" 536870912 "Attr_cu_type")
(def-xview-attribute "ATTR_LIST_IS_INLINE" 0 "Attr_list_ptr_type")
(def-xview-attribute "ATTR_LIST_IS_PTR" 1 "Attr_list_ptr_type")
(def-xview-attribute "ATTR_NONE" 0 "Attr_list_type")
(def-xview-attribute "ATTR_RECURSIVE" 1 "Attr_list_type")
(def-xview-attribute "ATTR_NULL" 2 "Attr_list_type")
(def-xview-attribute "ATTR_COUNTED" 3 "Attr_list_type")
(def-xview-attribute "ATTR_BASE_NO_VALUE" 81 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_INT" 64 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_LONG" 88 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_SHORT" 89 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_ENUM" 73 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_CHAR" 74 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_STRING" 75 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_FUNCTION_PTR" 83 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_BOOLEAN" 72 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_OPAQUE" 80 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_X" 66 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_INDEX_X" 67 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_Y" 68 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_INDEX_Y" 69 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_XY" 70 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_INDEX_XY" 71 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_PIXRECT_PTR" 76 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_PIXFONT_PTR" 77 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_RECT_PTR" 79 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_AV" 82 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_ICON_PTR" 84 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_SINGLE_COLOR_PTR" 85 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_CURSOR_PTR" 86 "Attr_base_type")
(def-xview-attribute "ATTR_BASE_LAST" 89 "Attr_base_type")
(def-xview-attribute "ATTR_NO_VALUE" 2592 "Attr_base_cardinality")
(def-xview-attribute "ATTR_INT" 2049 "Attr_base_cardinality")
(def-xview-attribute "ATTR_INT_PAIR" 2050 "Attr_base_cardinality")
(def-xview-attribute "ATTR_INT_TRIPLE" 2051 "Attr_base_cardinality")
(def-xview-attribute "ATTR_LONG" 2817 "Attr_base_cardinality")
(def-xview-attribute "ATTR_SHORT" 2849 "Attr_base_cardinality")
(def-xview-attribute "ATTR_ENUM" 2337 "Attr_base_cardinality")
(def-xview-attribute "ATTR_CHAR" 2369 "Attr_base_cardinality")
(def-xview-attribute "ATTR_STRING" 2401 "Attr_base_cardinality")
(def-xview-attribute "ATTR_FUNCTION_PTR" 2657 "Attr_base_cardinality")
(def-xview-attribute "ATTR_BOOLEAN" 2305 "Attr_base_cardinality")
(def-xview-attribute "ATTR_OPAQUE" 2561 "Attr_base_cardinality")
(def-xview-attribute "ATTR_OPAQUE_PAIR" 2562 "Attr_base_cardinality")
(def-xview-attribute "ATTR_OPAQUE_TRIPLE" 2563 "Attr_base_cardinality")
(def-xview-attribute "ATTR_X" 2113 "Attr_base_cardinality")
(def-xview-attribute "ATTR_INDEX_X" 2146 "Attr_base_cardinality")
(def-xview-attribute "ATTR_Y" 2177 "Attr_base_cardinality")
(def-xview-attribute "ATTR_INDEX_Y" 2210 "Attr_base_cardinality")
(def-xview-attribute "ATTR_XY" 2242 "Attr_base_cardinality")
(def-xview-attribute "ATTR_INDEX_XY" 2275 "Attr_base_cardinality")
(def-xview-attribute "ATTR_PIXRECT_PTR" 2433 "Attr_base_cardinality")
(def-xview-attribute "ATTR_PIXFONT_PTR" 2465 "Attr_base_cardinality")
(def-xview-attribute "ATTR_RECT_PTR" 2529 "Attr_base_cardinality")
(def-xview-attribute "ATTR_AV" 2625 "Attr_base_cardinality")
(def-xview-attribute "ATTR_ICON_PTR" 2689 "Attr_base_cardinality")
(def-xview-attribute "ATTR_SINGLE_COLOR_PTR" 2721 "Attr_base_cardinality")
(def-xview-attribute "ATTR_CURSOR_PTR" 2753 "Attr_base_cardinality")
(def-xview-attribute "ATTR_PKG_ZERO" 0 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_GENERIC" 64 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_CANVAS" 79 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_TERMSW" 81 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_CURSOR" 65 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_DRAWABLE" 66 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_ENTITY" 80 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_FONT" 67 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_SELN_BASE" 71 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_FRAME" 82 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_ICON" 83 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_IMAGE" 68 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_MENU" 84 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_PANEL" 85 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_SERVER_IMAGE" 69 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_SCREEN" 70 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_SCROLLBAR" 97 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_SERVER" 72 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_TEXTSW" 87 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_TTY" 88 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_WIN" 73 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_SV" 74 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_NOTICE" 89 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_HELP" 90 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_FULLSCREEN" 75 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_ERROR" 76 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_TEXTSW_VIEW" 91 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_PANEL_VIEW" 92 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_CANVAS_VIEW" 93 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_CANVAS_PAINT_WINDOW" 94 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_TTY_VIEW" 95 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_TERMSW_VIEW" 96 "Attr_pkg")
(def-xview-attribute "ATTR_PKG_LAST" 78 "Attr_pkg")
|#

(def-xview-attribute "ATTR_LIST" 1073768992 "Attr_generic")

#|
(def-xview-attribute "ATTR_NOP0" 1074792992 "Attr_generic")
(def-xview-attribute "ATTR_NOP1" 1074858497 "Attr_generic")
(def-xview-attribute "ATTR_NOP2" 1074924034 "Attr_generic")
(def-xview-attribute "ATTR_NOP3" 1074989571 "Attr_generic")
(def-xview-attribute "ATTR_NOP4" 1075055108 "Attr_generic")
|#

(def-xview-attribute "CANVAS_AUTO_EXPAND" 1325467905 "Canvas_attribute")
(def-xview-attribute "CANVAS_AUTO_SHRINK" 1325730049 "Canvas_attribute")
(def-xview-attribute "CANVAS_FIXED_IMAGE" 1326057729 "Canvas_attribute")
(def-xview-attribute "CANVAS_HEIGHT" 1326385281 "Canvas_attribute")
(def-xview-attribute "CANVAS_MIN_PAINT_HEIGHT" 1326712961 "Canvas_attribute")
(def-xview-attribute "CANVAS_MIN_PAINT_WIDTH" 1327040577 "Canvas_attribute")
(def-xview-attribute "CANVAS_NTH_PAINT_WINDOW" 1327368705 "Canvas_attribute")
(def-xview-attribute "CANVAS_REPAINT_PROC" 1327696481 "Canvas_attribute")
(def-xview-attribute "CANVAS_RESIZE_PROC" 1328024161 "Canvas_attribute")
(def-xview-attribute "CANVAS_RETAINED" 1328351489 "Canvas_attribute")
(def-xview-attribute "CANVAS_VIEW_MARGIN" 1328678913 "Canvas_attribute")
(def-xview-attribute "CANVAS_VIEWABLE_RECT" 1329007073 "Canvas_attribute")
(def-xview-attribute "CANVAS_WIDTH" 1329334337 "Canvas_attribute")
(def-xview-attribute "CANVAS_X_PAINT_WINDOW" 1329662209 "Canvas_attribute")
(def-xview-attribute "CANVAS_VIEW_PAINT_WINDOW" 1560349185 "Canvas_view_attribute")
(def-xview-attribute "CANVAS_VIEW_CANVAS_WINDOW" 1560414721 "Canvas_view_attribute")
(def-xview-attribute "CANVAS_PAINT_CANVAS_WINDOW" 1577126401 "Canvas_paint_attribute")
(def-xview-attribute "CURSOR_IMAGE" 1090587009 "Cursor_attribute")
(def-xview-attribute "CURSOR_MASK_CHAR" 1090848769 "Cursor_attribute")
(def-xview-attribute "CURSOR_OP" 1091176449 "Cursor_attribute")
(def-xview-attribute "CURSOR_SRC_CHAR" 1091504129 "Cursor_attribute")
(def-xview-attribute "CURSOR_XHOT" 1091831809 "Cursor_attribute")
(def-xview-attribute "CURSOR_YHOT" 1092159489 "Cursor_attribute")
(def-xview-attribute "CURSOR_BASIC_PTR" 1092487681 "Cursor_attribute")
(def-xview-attribute "CURSOR_MOVE_PTR" 1092815361 "Cursor_attribute")
(def-xview-attribute "CURSOR_COPY_PTR" 1093143041 "Cursor_attribute")
(def-xview-attribute "CURSOR_BUSY_PTR" 1093470721 "Cursor_attribute")
(def-xview-attribute "CURSOR_PANNING_PTR" 1093798401 "Cursor_attribute")
(def-xview-attribute "CURSOR_NAVIGATION_LEVEL_PTR" 1094126081 "Cursor_attribute")
(def-xview-attribute "CURSOR_STOP_PTR" 1094453761 "Cursor_attribute")
(def-xview-attribute "DRAWABLE_INFO" 1113852417 "Drawable_attr")
(def-xview-attribute "FONT_CHAR_WIDTH" 1124141377 "Font_attribute")
(def-xview-attribute "FONT_CHAR_HEIGHT" 1124403521 "Font_attribute")
(def-xview-attribute "FONT_DEFAULT_CHAR_HEIGHT" 1124731424 "Font_attribute")
(def-xview-attribute "FONT_DEFAULT_CHAR_WIDTH" 1125059104 "Font_attribute")
(def-xview-attribute "FONT_FAMILY" 1125386593 "Font_attribute")
(def-xview-attribute "FONT_NAME" 1125714273 "Font_attribute")
(def-xview-attribute "FONT_RESCALE_OF" 1126042114 "Font_attribute")
(def-xview-attribute "FONT_SCALE" 1126696961 "Font_attribute")
(def-xview-attribute "FONT_SIZE" 1127024641 "Font_attribute")
(def-xview-attribute "FONT_SIZES_FOR_SCALE" 1127352324 "Font_attribute")
(def-xview-attribute "FONT_STRING_DIMS" 1127680514 "Font_attribute")
(def-xview-attribute "FONT_STYLE" 1128008033 "Font_attribute")
(def-xview-attribute "FONT_TYPE" 1128335649 "Font_attribute")
(def-xview-attribute "FONT_HEAD" 1128663041 "Font_attribute")
(def-xview-attribute "FONT_UNKNOWN_HEAD" 1128990721 "Font_attribute")
(def-xview-attribute "FONT_INFO" 1129318913 "Font_attribute")
(def-xview-attribute "FONT_TYPE_TEXT" 0 "Font_type")
(def-xview-attribute "FONT_TYPE_CURSOR" 1 "Font_type")
(def-xview-attribute "FONT_TYPE_GLYPH" 2 "Font_type")
(def-xview-attribute "FRAME_BACKGROUND_COLOR" 1376062113 "Frame_attribute")
(def-xview-attribute "FRAME_BUSY" 1376389377 "Frame_attribute")
(def-xview-attribute "FRAME_CLOSED" 1376717057 "Frame_attribute")
(def-xview-attribute "FRAME_CLOSED_RECT" 1377044961 "Frame_attribute")
(def-xview-attribute "FRAME_CMD_PANEL" 1377372673 "Frame_attribute")
(def-xview-attribute "FRAME_CURRENT_RECT" 1378028001 "Frame_attribute")
(def-xview-attribute "FRAME_OLD_RECT" 1378093537 "Frame_attribute")
(def-xview-attribute "FRAME_DEFAULT_DONE_PROC" 1378355809 "Frame_attribute")
(def-xview-attribute "FRAME_DONE_PROC" 1378683489 "Frame_attribute")
(def-xview-attribute "FRAME_FOREGROUND_COLOR" 1379011233 "Frame_attribute")
(def-xview-attribute "FRAME_ICON" 1379338753 "Frame_attribute")
(def-xview-attribute "FRAME_INHERIT_COLORS" 1379666177 "Frame_attribute")
(def-xview-attribute "FRAME_LEFT_FOOTER" 1379993953 "Frame_attribute")
(def-xview-attribute "FRAME_NO_CONFIRM" 1380321537 "Frame_attribute")
(def-xview-attribute "FRAME_NTH_SUBFRAME" 1380648961 "Frame_attribute")
(def-xview-attribute "FRAME_NTH_SUBWINDOW" 1380976641 "Frame_attribute")
(def-xview-attribute "FRAME_PROPERTIES_PROC" 1381304929 "Frame_attribute")
(def-xview-attribute "FRAME_PROPS_PANEL" 1377372673 "Frame_attribute")
(def-xview-attribute "FRAME_CMD_PUSHPIN_IN" 1382615297 "Frame_attribute")
(def-xview-attribute "FRAME_PROPS_PUSHPIN_IN" 1382615297 "Frame_attribute")
(def-xview-attribute "FRAME_RIGHT_FOOTER" 1383270753 "Frame_attribute")
(def-xview-attribute "FRAME_SHOW_FOOTER" 1383926017 "Frame_attribute")
(def-xview-attribute "FRAME_SHOW_LABEL" 1384253697 "Frame_attribute")
(def-xview-attribute "FRAME_SHOW_RESIZE_CORNER" 1384122625 "Frame_attribute")
(def-xview-attribute "FRAME_GROUP_LEADER" 1384581377 "Frame_attribute")
(def-xview-attribute "FRAME_NEXT_CHILD" 1384909313 "Frame_attribute")
(def-xview-attribute "FRAME_SCALE_STATE" 1385236481 "Frame_attribute")
(def-xview-attribute "FRAME_SUBWINDOWS_ADJUSTABLE" 1385564417 "Frame_attribute")
(def-xview-attribute "FRAME_COUNT" 1386219521 "Frame_attribute")
(def-xview-attribute "FRAME_SCALE_SMALL" 0 "Frame_rescale_state")
(def-xview-attribute "FRAME_SCALE_MEDIUM" 1 "Frame_rescale_state")
(def-xview-attribute "FRAME_SCALE_LARGE" 2 "Frame_rescale_state")
(def-xview-attribute "FRAME_SCALE_EXTRALARGE" 3 "Frame_rescale_state")
(def-xview-attribute "FULLSCREEN_CURSOR_WINDOW" 1258621441 "Fullscreen_attr")
(def-xview-attribute "FULLSCREEN_INPUT_WINDOW" 1258949121 "Fullscreen_attr")
(def-xview-attribute "FULLSCREEN_PAINT_WINDOW" 1259276801 "Fullscreen_attr")
(def-xview-attribute "FULLSCREEN_RECT" 1259604512 "Fullscreen_attr")
(def-xview-attribute "FULLSCREEN_SYNC" 1259931649 "Fullscreen_attr")
(def-xview-attribute "FULLSCREEN_ALLOW_SYNC_EVENT" 1260259872 "Fullscreen_attr")
(def-xview-attribute "XV_KEY_DATA" 1077938178 "Xv_generic_attr")
(def-xview-attribute "XV_KEY_DATA_COPY_PROC" 1078004226 "Xv_generic_attr")
(def-xview-attribute "XV_KEY_DATA_REMOVE" 1078069249 "Xv_generic_attr")
(def-xview-attribute "XV_KEY_DATA_REMOVE_PROC" 1078135298 "Xv_generic_attr")
(def-xview-attribute "XV_REF_COUNT" 1078200321 "Xv_generic_attr")
(def-xview-attribute "XV_TYPE" 1078266369 "Xv_generic_attr")
(def-xview-attribute "XV_IS_SUBTYPE_OF" 1078331905 "Xv_generic_attr")
(def-xview-attribute "XV_LABEL" 1078397281 "Xv_generic_attr")
(def-xview-attribute "XV_NAME" 1078462817 "Xv_generic_attr")
(def-xview-attribute "XV_STATUS" 1078528001 "Xv_generic_attr")
(def-xview-attribute "XV_STATUS_PTR" 1078594049 "Xv_generic_attr")
(def-xview-attribute "XV_HELP" 1078987105 "Xv_generic_attr")
(def-xview-attribute "XV_HELP_STRING_FILENAME" 1079118177 "Xv_generic_attr")
(def-xview-attribute "XV_SHOW" 1079052545 "Xv_generic_attr")
(def-xview-attribute "XV_COPY_OF" 1078659585 "Xv_generic_attr")
(def-xview-attribute "XV_END_CREATE" 1078725152 "Xv_generic_attr")
(def-xview-attribute "XV_SELF" 1078790657 "Xv_generic_attr")
(def-xview-attribute "XV_OWNER" 1078856193 "Xv_generic_attr")
(def-xview-attribute "XV_AUTO_CREATE" 1078921217 "Xv_generic_attr")
(def-xview-attribute "XV_FONT" 1245710849 "Xv_generic_attr")
(def-xview-attribute "XV_MARGIN" 1245775873 "Xv_generic_attr")
(def-xview-attribute "XV_LEFT_MARGIN" 1245841409 "Xv_generic_attr")
(def-xview-attribute "XV_TOP_MARGIN" 1245906945 "Xv_generic_attr")
(def-xview-attribute "XV_RIGHT_MARGIN" 1245972481 "Xv_generic_attr")
(def-xview-attribute "XV_BOTTOM_MARGIN" 1246038017 "Xv_generic_attr")
(def-xview-attribute "XV_X" 1246103617 "Xv_generic_attr")
(def-xview-attribute "XV_Y" 1246169217 "Xv_generic_attr")
(def-xview-attribute "XV_WIDTH" 1246234689 "Xv_generic_attr")
(def-xview-attribute "XV_HEIGHT" 1246300289 "Xv_generic_attr")
(def-xview-attribute "XV_RECT" 1246366177 "Xv_generic_attr")
(def-xview-attribute "XV_XNAME" 1247807841 "Xv_generic_attr")
(def-xview-attribute "XV_DEVICE_NUMBER" 1247873793 "Xv_generic_attr")
(def-xview-attribute "XV_XID" 1247873793 "Xv_generic_attr")
(def-xview-attribute "XV_ROOT" 1247939073 "Xv_generic_attr")
(def-xview-attribute "XV_DISPLAY" 1248725505 "Xv_generic_attr")
(def-xview-attribute "XV_GC" 1248922113 "Xv_generic_attr")
(def-xview-attribute "XV_SCREEN" 1249118721 "Xv_generic_attr")
(def-xview-attribute "XV_VISUAL_CLASS" 1249183745 "Xv_generic_attr")
(def-xview-attribute "XV_INIT_ARGS" 1241712642 "Xv_attr")
(def-xview-attribute "XV_INIT_ARGC_PTR_ARGV" 1241909250 "Xv_attr")
(def-xview-attribute "XV_USAGE_PROC" 1242106465 "Xv_attr")
(def-xview-attribute "ICON_IMAGE" 1392839041 "Icon_attribute")
(def-xview-attribute "ICON_IMAGE_RECT" 1393166817 "Icon_attribute")
(def-xview-attribute "ICON_LABEL_RECT" 1393494497 "Icon_attribute")
(def-xview-attribute "ICON_TRANSPARENT" 1393821953 "Icon_attribute")
(def-xview-attribute "ICON_MASK_IMAGE" 1394149761 "Icon_attribute")
(def-xview-attribute "ICON_TRANSPARENT_LABEL" 1394477409 "Icon_attribute")
(def-xview-attribute "NOTICE_BUTTON" 1493239810 "Notice_attribute")
(def-xview-attribute "NOTICE_BUTTON_NO" 1493502305 "Notice_attribute")
(def-xview-attribute "NOTICE_BUTTON_YES" 1493829985 "Notice_attribute")
(def-xview-attribute "NOTICE_FOCUS_XY" 1494157506 "Notice_attribute")
(def-xview-attribute "NOTICE_FONT" 1494485409 "Notice_attribute")
(def-xview-attribute "NOTICE_MESSAGE_STRINGS" 1494845793 "Notice_attribute")
(def-xview-attribute "NOTICE_MESSAGE_STRINGS_ARRAY_PTR" 1495140705 "Notice_attribute")
(def-xview-attribute "NOTICE_NO_BEEPING" 1495468289 "Notice_attribute")
(def-xview-attribute "NOTICE_TRIGGER" 1495795713 "Notice_attribute")
(def-xview-attribute "NOTIFY_ALL" 0 "Notify_dump_type")
(def-xview-attribute "NOTIFY_DETECT" 1 "Notify_dump_type")
(def-xview-attribute "NOTIFY_DISPATCH" 2 "Notify_dump_type")
(def-xview-attribute "NOTIFY_DONE" 0 "Notify_value")
(def-xview-attribute "NOTIFY_IGNORED" 1 "Notify_value")
(def-xview-attribute "NOTIFY_UNEXPECTED" 2 "Notify_value")
(def-xview-attribute "NOTIFY_OK" 0 "Notify_error")
(def-xview-attribute "NOTIFY_UNKNOWN_CLIENT" 1 "Notify_error")
(def-xview-attribute "NOTIFY_NO_CONDITION" 2 "Notify_error")
(def-xview-attribute "NOTIFY_BAD_ITIMER" 3 "Notify_error")
(def-xview-attribute "NOTIFY_BAD_SIGNAL" 4 "Notify_error")
(def-xview-attribute "NOTIFY_NOT_STARTED" 5 "Notify_error")
(def-xview-attribute "NOTIFY_DESTROY_VETOED" 6 "Notify_error")
(def-xview-attribute "NOTIFY_INTERNAL_ERROR" 7 "Notify_error")
(def-xview-attribute "NOTIFY_SRCH" 8 "Notify_error")
(def-xview-attribute "NOTIFY_BADF" 9 "Notify_error")
(def-xview-attribute "NOTIFY_NOMEM" 10 "Notify_error")
(def-xview-attribute "NOTIFY_INVAL" 11 "Notify_error")
(def-xview-attribute "NOTIFY_FUNC_LIMIT" 12 "Notify_error")
(def-xview-attribute "NOTIFY_SYNC" 0 "Notify_signal_mode")
(def-xview-attribute "NOTIFY_ASYNC" 1 "Notify_signal_mode")
(def-xview-attribute "NOTIFY_SAFE" 0 "Notify_event_type")
(def-xview-attribute "NOTIFY_IMMEDIATE" 1 "Notify_event_type")
(def-xview-attribute "DESTROY_PROCESS_DEATH" 0 "Destroy_status")
(def-xview-attribute "DESTROY_CHECKING" 1 "Destroy_status")
(def-xview-attribute "DESTROY_CLEANUP" 2 "Destroy_status")
(def-xview-attribute "MENU_ACTION_IMAGE" 1409353730 "Menu_attribute")
(def-xview-attribute "MENU_ACTION_ITEM" 1409484802 "Menu_attribute")
(def-xview-attribute "MENU_APPEND_ITEM" 1409878529 "Menu_attribute")
(def-xview-attribute "MENU_CLASS" 1410074913 "Menu_attribute")
(def-xview-attribute "MENU_COL_MAJOR" 1410468097 "Menu_attribute")
(def-xview-attribute "MENU_DEFAULT" 1410664449 "Menu_attribute")
(def-xview-attribute "MENU_DEFAULT_ITEM" 1410861569 "Menu_attribute")
(def-xview-attribute "MENU_DESCEND_FIRST" 1411057921 "Menu_attribute")
(def-xview-attribute "MENU_DISABLE_ITEM" 1411254561 "Menu_attribute")
(def-xview-attribute "MENU_DONE_PROC" 1411320417 "Menu_attribute")
(def-xview-attribute "MENU_FEEDBACK" 1411451137 "Menu_attribute")
(def-xview-attribute "MENU_FIRST_EVENT" 1411648032 "Menu_attribute")
(def-xview-attribute "MENU_GEN_PIN_WINDOW" 1411844098 "Menu_attribute")
(def-xview-attribute "MENU_GEN_PROC" 1412041313 "Menu_attribute")
(def-xview-attribute "MENU_GEN_PROC_IMAGE" 1412237314 "Menu_attribute")
(def-xview-attribute "MENU_GEN_PROC_ITEM" 1412433922 "Menu_attribute")
(def-xview-attribute "MENU_GEN_PULLRIGHT" 1412631137 "Menu_attribute")
(def-xview-attribute "MENU_GEN_PULLRIGHT_IMAGE" 1412827138 "Menu_attribute")
(def-xview-attribute "MENU_GEN_PULLRIGHT_ITEM" 1413023746 "Menu_attribute")
(def-xview-attribute "MENU_IMAGE" 1413220865 "Menu_attribute")
(def-xview-attribute "MENU_IMAGES" 1413450241 "Menu_attribute")
(def-xview-attribute "MENU_IMAGE_ITEM" 1413613570 "Menu_attribute")
(def-xview-attribute "MENU_INACTIVE" 1413810433 "Menu_attribute")
(def-xview-attribute "MENU_INSERT" 1414596610 "Menu_attribute")
(def-xview-attribute "MENU_INSERT_ITEM" 1414793218 "Menu_attribute")
(def-xview-attribute "MENU_INVERT" 1414990081 "Menu_attribute")
(def-xview-attribute "MENU_ITEM" 1415203393 "Menu_attribute")
(def-xview-attribute "MENU_LAST_EVENT" 1415776800 "Menu_attribute")
(def-xview-attribute "MENU_MENU" 1415973408 "Menu_attribute")
(def-xview-attribute "MENU_NCOLS" 1416169473 "Menu_attribute")
(def-xview-attribute "MENU_NITEMS" 1416366624 "Menu_attribute")
(def-xview-attribute "MENU_NOTIFY_PROC" 1409682017 "Menu_attribute")
(def-xview-attribute "MENU_NOTIFY_STATUS" 1416562689 "Menu_attribute")
(def-xview-attribute "MENU_NTH_ITEM" 1416759297 "Menu_attribute")
(def-xview-attribute "MENU_NROWS" 1416955905 "Menu_attribute")
(def-xview-attribute "MENU_PARENT" 1417087489 "Menu_attribute")
(def-xview-attribute "MENU_PIN" 1417152769 "Menu_attribute")
(def-xview-attribute "MENU_PIN_PROC" 1417349729 "Menu_attribute")
(def-xview-attribute "MENU_PIN_WINDOW" 1417546241 "Menu_attribute")
(def-xview-attribute "MENU_PULLRIGHT" 1417742849 "Menu_attribute")
(def-xview-attribute "MENU_PULLRIGHT_IMAGE" 1418135554 "Menu_attribute")
(def-xview-attribute "MENU_PULLRIGHT_ITEM" 1418332162 "Menu_attribute")
(def-xview-attribute "MENU_RELEASE" 1418529312 "Menu_attribute")
(def-xview-attribute "MENU_RELEASE_IMAGE" 1418725920 "Menu_attribute")
(def-xview-attribute "MENU_REMOVE" 1418921985 "Menu_attribute")
(def-xview-attribute "MENU_REMOVE_ITEM" 1419119105 "Menu_attribute")
(def-xview-attribute "MENU_REPLACE" 1419315202 "Menu_attribute")
(def-xview-attribute "MENU_REPLACE_ITEM" 1419511810 "Menu_attribute")
(def-xview-attribute "MENU_SELECTED" 1419708417 "Menu_attribute")
(def-xview-attribute "MENU_SELECTED_ITEM" 1419905537 "Menu_attribute")
(def-xview-attribute "MENU_STRING" 1420101985 "Menu_attribute")
(def-xview-attribute "MENU_STRINGS" 1420331361 "Menu_attribute")
(def-xview-attribute "MENU_STRING_ITEM" 1420494850 "Menu_attribute")
(def-xview-attribute "MENU_TITLE" 1420692000 "Menu_attribute")
(def-xview-attribute "MENU_TITLE_IMAGE" 1420888577 "Menu_attribute")
(def-xview-attribute "MENU_TITLE_ITEM" 1421085025 "Menu_attribute")
(def-xview-attribute "MENU_TYPE" 1421281824 "Menu_attribute")
(def-xview-attribute "MENU_VALID_RESULT" 1421477889 "Menu_attribute")
(def-xview-attribute "MENU_VALUE" 1421675009 "Menu_attribute")
(def-xview-attribute "MENU_BUTTON" 1422264321 "Menu_attribute")
(def-xview-attribute "MENU_CURSOR" 1422461441 "Menu_attribute")
(def-xview-attribute "MENU_ENABLE_RECT" 1422854145 "Menu_attribute")
(def-xview-attribute "MENU_FD" 1423050753 "Menu_attribute")
(def-xview-attribute "MENU_HORIZONTAL_LINE" 1423247361 "Menu_attribute")
(def-xview-attribute "MENU_IE" 1423443969 "Menu_attribute")
(def-xview-attribute "MENU_LINE_AFTER_ITEM" 1423640577 "Menu_attribute")
(def-xview-attribute "MENU_POS" 1423837186 "Menu_attribute")
(def-xview-attribute "MENU_POSITION_RECT" 1424033793 "Menu_attribute")
(def-xview-attribute "MENU_PULLDOWN" 1424230401 "Menu_attribute")
(def-xview-attribute "MENU_VERTICAL_LINE" 1424623617 "Menu_attribute")
(def-xview-attribute "MENU_ACTION" 1409682017 "Menu_attribute")
(def-xview-attribute "MENU_ACTION_PROC" 1409682017 "Menu_attribute")
(def-xview-attribute "MENU_CLIENT_DATA" 1410271745 "Menu_attribute")
(def-xview-attribute "MENU_PULLRIGHT_DELTA" 1417938945 "Menu_attribute")
(def-xview-attribute "MENU_COMMAND" 0 "Menu_class")
(def-xview-attribute "MENU_CHOICE" 1 "Menu_class")
(def-xview-attribute "MENU_TOGGLE" 2 "Menu_class")
(def-xview-attribute "MENU_PROVIDE_FEEDBACK" 0 "Menu_feedback")
(def-xview-attribute "MENU_REMOVE_FEEDBACK" 1 "Menu_feedback")
(def-xview-attribute "MENU_SELECTED_DEFAULT_FEEDBACK" 2 "Menu_feedback")
(def-xview-attribute "MENU_DEFAULT_FEEDBACK" 3 "Menu_feedback")
(def-xview-attribute "MENU_DISPLAY" 0 "Menu_generate")
(def-xview-attribute "MENU_DISPLAY_DONE" 1 "Menu_generate")
(def-xview-attribute "MENU_NOTIFY" 2 "Menu_generate")
(def-xview-attribute "MENU_NOTIFY_DONE" 3 "Menu_generate")
(def-xview-attribute "OPENWIN_SPLIT_HORIZONTAL" 0 "Openwin_split_direction")
(def-xview-attribute "OPENWIN_SPLIT_VERTICAL" 1 "Openwin_split_direction")
(def-xview-attribute "OPENWIN_ADJUST_FOR_HORIZONTAL_SCROLLBAR" 1442908417 "Openwin_attribute")
(def-xview-attribute "OPENWIN_ADJUST_FOR_VERTICAL_SCROLLBAR" 1443170561 "Openwin_attribute")
(def-xview-attribute "OPENWIN_AUTO_CLEAR" 1443498241 "Openwin_attribute")
(def-xview-attribute "OPENWIN_HORIZONTAL_SCROLLBAR" 1443826177 "Openwin_attribute")
(def-xview-attribute "OPENWIN_NVIEWS" 1444153345 "Openwin_attribute")
(def-xview-attribute "OPENWIN_NO_MARGIN" 1444481281 "Openwin_attribute")
(def-xview-attribute "OPENWIN_NTH_VIEW" 1444809217 "Openwin_attribute")
(def-xview-attribute "OPENWIN_SELECTED_VIEW" 1445136897 "Openwin_attribute")
(def-xview-attribute "OPENWIN_SHOW_BORDERS" 1445464321 "Openwin_attribute")
(def-xview-attribute "OPENWIN_SPLIT" 1445808705 "Openwin_attribute")
(def-xview-attribute "OPENWIN_SPLIT_DIRECTION" 1446119713 "Openwin_attribute")
(def-xview-attribute "OPENWIN_SPLIT_POSITION" 1446447169 "Openwin_attribute")
(def-xview-attribute "OPENWIN_SPLIT_VIEW" 1446775297 "Openwin_attribute")
(def-xview-attribute "OPENWIN_SPLIT_VIEW_START" 1447102529 "Openwin_attribute")
(def-xview-attribute "OPENWIN_VERTICAL_SCROLLBAR" 1447430657 "Openwin_attribute")
(def-xview-attribute "OPENWIN_VIEW_ATTRS" 1447774785 "Openwin_attribute")
(def-xview-attribute "OPENWIN_SPLIT_INIT_PROC" 1447823969 "Openwin_attribute")
(def-xview-attribute "OPENWIN_SPLIT_DESTROY_PROC" 1447889505 "Openwin_attribute")
(def-xview-attribute "OPENWIN_VIEW_CLASS" 1448086017 "Openwin_attribute")
(def-xview-attribute "PANEL_ACCEPT_KEYSTROKE" 1426131201 "Panel_attr")
(def-xview-attribute "PANEL_BACKGROUND_PROC" 1426197089 "Panel_attr")
(def-xview-attribute "PANEL_BLINK_CARET" 1426327809 "Panel_attr")
(def-xview-attribute "PANEL_BOLD_FONT" 1426459041 "Panel_attr")
(def-xview-attribute "PANEL_CARET_ITEM" 1426590209 "Panel_attr")
(def-xview-attribute "PANEL_CHOICES_BOLD" 1426721025 "Panel_attr")
(def-xview-attribute "PANEL_CHOICE_FONT" 1426849890 "Panel_attr")
(def-xview-attribute "PANEL_CHOICE_FONTS" 1427016097 "Panel_attr")
(def-xview-attribute "PANEL_CHOICE_IMAGE" 1427111970 "Panel_attr")
(def-xview-attribute "PANEL_CHOICE_IMAGES" 1427278209 "Panel_attr")
(def-xview-attribute "PANEL_CHOICE_NROWS" 1427441665 "Panel_attr")
(def-xview-attribute "PANEL_CHOICE_NCOLS" 1427310593 "Panel_attr")
(def-xview-attribute "PANEL_CHOICE_STRING" 1427374082 "Panel_attr")
(def-xview-attribute "PANEL_CHOICE_STRINGS" 1427540321 "Panel_attr")
(def-xview-attribute "PANEL_CHOICE_X" 1427769442 "Panel_attr")
(def-xview-attribute "PANEL_CHOICE_XS" 1427933249 "Panel_attr")
(def-xview-attribute "PANEL_CHOICE_Y" 1428031650 "Panel_attr")
(def-xview-attribute "PANEL_CHOICE_YS" 1428195457 "Panel_attr")
(def-xview-attribute "PANEL_CHOOSE_ONE" 1428293889 "Panel_attr")
(def-xview-attribute "PANEL_CHOOSE_NONE" 1428228353 "Panel_attr")
(def-xview-attribute "PANEL_CLIENT_DATA" 1428425217 "Panel_attr")
(def-xview-attribute "PANEL_DEFAULT_ITEM" 1428556289 "Panel_attr")
(def-xview-attribute "PANEL_DEFAULT_VALUE" 1428687361 "Panel_attr")
(def-xview-attribute "PANEL_DISPLAY_LEVEL" 1428818209 "Panel_attr")
(def-xview-attribute "PANEL_EVENT_PROC" 1428949601 "Panel_attr")
(def-xview-attribute "PANEL_EXTRA_PAINT_HEIGHT" 1429080193 "Panel_attr")
(def-xview-attribute "PANEL_EXTRA_PAINT_WIDTH" 1429211201 "Panel_attr")
(def-xview-attribute "PANEL_FEEDBACK" 1429342497 "Panel_attr")
(def-xview-attribute "PANEL_FIRST_ITEM" 1429473793 "Panel_attr")
(def-xview-attribute "PANEL_INACTIVE" 1429604609 "Panel_attr")
(def-xview-attribute "PANEL_ITEM_CLASS" 1429735937 "Panel_attr")
(def-xview-attribute "PANEL_ITEM_COLOR" 1429866497 "Panel_attr")
(def-xview-attribute "PANEL_ITEM_MENU" 1429998081 "Panel_attr")
(def-xview-attribute "PANEL_ITEM_RECT" 1430129121 "Panel_attr")
(def-xview-attribute "PANEL_ITEM_X" 1430194241 "Panel_attr")
(def-xview-attribute "PANEL_ITEM_Y" 1430259841 "Panel_attr")
(def-xview-attribute "PANEL_ITEM_X_GAP" 1430325313 "Panel_attr")
(def-xview-attribute "PANEL_ITEM_Y_GAP" 1430390913 "Panel_attr")
(def-xview-attribute "PANEL_LABEL_BOLD" 1430522113 "Panel_attr")
(def-xview-attribute "PANEL_LABEL_FONT" 1430653345 "Panel_attr")
(def-xview-attribute "PANEL_LABEL_IMAGE" 1430784385 "Panel_attr")
(def-xview-attribute "PANEL_LABEL_STRING" 1430915425 "Panel_attr")
(def-xview-attribute "PANEL_LABEL_WIDTH" 1431046145 "Panel_attr")
(def-xview-attribute "PANEL_LABEL_X" 1431177281 "Panel_attr")
(def-xview-attribute "PANEL_LABEL_Y" 1431308417 "Panel_attr")
(def-xview-attribute "PANEL_LAYOUT" 1431439649 "Panel_attr")
(def-xview-attribute "PANEL_LIST_CLIENT_DATA" 1431830658 "Panel_attr")
(def-xview-attribute "PANEL_LIST_CLIENT_DATAS" 1431996929 "Panel_attr")
(def-xview-attribute "PANEL_LIST_DELETE" 1432094721 "Panel_attr")
(def-xview-attribute "PANEL_LIST_DISPLAY_ROWS" 1432225793 "Panel_attr")
(def-xview-attribute "PANEL_LIST_FONT" 1432354914 "Panel_attr")
(def-xview-attribute "PANEL_LIST_FONTS" 1432521121 "Panel_attr")
(def-xview-attribute "PANEL_LIST_GLYPH" 1432616994 "Panel_attr")
(def-xview-attribute "PANEL_LIST_GLYPHS" 1432783233 "Panel_attr")
(def-xview-attribute "PANEL_LIST_INSERT" 1433012225 "Panel_attr")
(def-xview-attribute "PANEL_LIST_NROWS" 1433143297 "Panel_attr")
(def-xview-attribute "PANEL_LIST_ROW_HEIGHT" 1433274369 "Panel_attr")
(def-xview-attribute "PANEL_LIST_SELECT" 1433405442 "Panel_attr")
(def-xview-attribute "PANEL_LIST_STRING" 1433534466 "Panel_attr")
(def-xview-attribute "PANEL_LIST_STRINGS" 1433700705 "Panel_attr")
(def-xview-attribute "PANEL_LIST_WIDTH" 1434060801 "Panel_attr")
(def-xview-attribute "PANEL_MARK_IMAGE" 1434189858 "Panel_attr")
(def-xview-attribute "PANEL_MARK_IMAGES" 1434356097 "Panel_attr")
(def-xview-attribute "PANEL_MARK_X" 1434454114 "Panel_attr")
(def-xview-attribute "PANEL_MARK_XS" 1434617921 "Panel_attr")
(def-xview-attribute "PANEL_MARK_Y" 1434716322 "Panel_attr")
(def-xview-attribute "PANEL_MARK_YS" 1434880129 "Panel_attr")
(def-xview-attribute "PANEL_MASK_CHAR" 1434978625 "Panel_attr")
(def-xview-attribute "PANEL_MAX_VALUE" 1435109377 "Panel_attr")
(def-xview-attribute "PANEL_MIN_VALUE" 1435502593 "Panel_attr")
(def-xview-attribute "PANEL_NEXT_ITEM" 1435634177 "Panel_attr")
(def-xview-attribute "PANEL_NOMARK_IMAGE" 1435762722 "Panel_attr")
(def-xview-attribute "PANEL_NOMARK_IMAGES" 1435928961 "Panel_attr")
(def-xview-attribute "PANEL_NOTIFY_LEVEL" 1436027169 "Panel_attr")
(def-xview-attribute "PANEL_NOTIFY_PROC" 1436158561 "Panel_attr")
(def-xview-attribute "PANEL_NOTIFY_STATUS" 1436289025 "Panel_attr")
(def-xview-attribute "PANEL_NOTIFY_STRING" 1436420449 "Panel_attr")
(def-xview-attribute "PANEL_PAINT" 1436551457 "Panel_attr")
(def-xview-attribute "PANEL_READ_ONLY" 1436682497 "Panel_attr")
(def-xview-attribute "PANEL_REPAINT_PROC" 1436813921 "Panel_attr")
(def-xview-attribute "PANEL_SHOW_RANGE" 1437337857 "Panel_attr")
(def-xview-attribute "PANEL_SHOW_VALUE" 1437468929 "Panel_attr")
(def-xview-attribute "PANEL_SLIDER_END_BOXES" 1437534465 "Panel_attr")
(def-xview-attribute "PANEL_SLIDER_WIDTH" 1437599809 "Panel_attr")
(def-xview-attribute "PANEL_TOGGLE_VALUE" 1437728834 "Panel_attr")
(def-xview-attribute "PANEL_VALUE" 1437861889 "Panel_attr")
(def-xview-attribute "PANEL_VALUE_DISPLAY_LENGTH" 1437992961 "Panel_attr")
(def-xview-attribute "PANEL_VALUE_FONT" 1438124449 "Panel_attr")
(def-xview-attribute "PANEL_VALUE_STORED_LENGTH" 1438255105 "Panel_attr")
(def-xview-attribute "PANEL_VALUE_UNDERLINED" 1438386433 "Panel_attr")
(def-xview-attribute "PANEL_VALUE_X" 1438517313 "Panel_attr")
(def-xview-attribute "PANEL_VALUE_Y" 1438648449 "Panel_attr")
(def-xview-attribute "PANEL_CHOICE_OFFSET" 1438910465 "Panel_attr")
(def-xview-attribute "PANEL_LABEL_INVERTED" 1439172865 "Panel_attr")
(def-xview-attribute "PANEL_TEXT_CURSOR" 1439566337 "Panel_attr")
(def-xview-attribute "PANEL_CLEAR" 0 "Panel_setting")
(def-xview-attribute "PANEL_NO_CLEAR" 1 "Panel_setting")
(def-xview-attribute "PANEL_NONE" 2 "Panel_setting")
(def-xview-attribute "PANEL_ALL" 3 "Panel_setting")
(def-xview-attribute "PANEL_NON_PRINTABLE" 4 "Panel_setting")
(def-xview-attribute "PANEL_SPECIFIED" 5 "Panel_setting")
(def-xview-attribute "PANEL_CURRENT" 6 "Panel_setting")
(def-xview-attribute "PANEL_DONE" 7 "Panel_setting")
(def-xview-attribute "PANEL_MARKED" 8 "Panel_setting")
(def-xview-attribute "PANEL_VERTICAL" 9 "Panel_setting")
(def-xview-attribute "PANEL_HORIZONTAL" 10 "Panel_setting")
(def-xview-attribute "PANEL_INVERTED" 11 "Panel_setting")
(def-xview-attribute "PANEL_INSERT" 12 "Panel_setting")
(def-xview-attribute "PANEL_NEXT" 13 "Panel_setting")
(def-xview-attribute "PANEL_PREVIOUS" 14 "Panel_setting")
(def-xview-attribute "PANEL_NONE_DOWN" 15 "Panel_setting")
(def-xview-attribute "PANEL_LEFT_DOWN" 16 "Panel_setting")
(def-xview-attribute "PANEL_MIDDLE_DOWN" 17 "Panel_setting")
(def-xview-attribute "PANEL_RIGHT_DOWN" 18 "Panel_setting")
(def-xview-attribute "PANEL_CHORD_DOWN" 19 "Panel_setting")
(def-xview-attribute "PANEL_MESSAGE_ITEM" 0 "Panel_item_type")
(def-xview-attribute "PANEL_BUTTON_ITEM" 1 "Panel_item_type")
(def-xview-attribute "PANEL_CHOICE_ITEM" 2 "Panel_item_type")
(def-xview-attribute "PANEL_TOGGLE_ITEM" 3 "Panel_item_type")
(def-xview-attribute "PANEL_TEXT_ITEM" 4 "Panel_item_type")
(def-xview-attribute "PANEL_SLIDER_ITEM" 6 "Panel_item_type")
(def-xview-attribute "PANEL_LIST_ITEM" 7 "Panel_item_type")
(def-xview-attribute "SCREEN_NUMBER" 1175062529 "Screen_attr")
(def-xview-attribute "SCREEN_SERVER" 1175390721 "Screen_attr")
(def-xview-attribute "SCREEN_STATIC_VISUAL" 1175718401 "Screen_attr")
(def-xview-attribute "SCREEN_DYNAMIC_VISUAL" 1176046081 "Screen_attr")
(def-xview-attribute "SCROLLBAR_COMPUTE_SCROLL_PROC" 1627785825 "Scrollbar_attribute")
(def-xview-attribute "SCROLLBAR_DIRECTION" 1627916577 "Scrollbar_attribute")
(def-xview-attribute "SCROLLBAR_LAST_VIEW_START" 1628047361 "Scrollbar_attribute")
(def-xview-attribute "SCROLLBAR_MENU" 1628113409 "Scrollbar_attribute")
(def-xview-attribute "SCROLLBAR_NORMALIZE_PROC" 1627720289 "Scrollbar_attribute")
(def-xview-attribute "SCROLLBAR_NOTIFY_CLIENT" 1627982337 "Scrollbar_attribute")
(def-xview-attribute "SCROLLBAR_OBJECT_LENGTH" 1627457537 "Scrollbar_attribute")
(def-xview-attribute "SCROLLBAR_OVERSCROLL" 1628178433 "Scrollbar_attribute")
(def-xview-attribute "SCROLLBAR_PAGE_LENGTH" 1627654145 "Scrollbar_attribute")
(def-xview-attribute "SCROLLBAR_PIXELS_PER_UNIT" 1627392001 "Scrollbar_attribute")
(def-xview-attribute "SCROLLBAR_SPLITTABLE" 1627851009 "Scrollbar_attribute")
(def-xview-attribute "SCROLLBAR_VIEW_START" 1627523073 "Scrollbar_attribute")
(def-xview-attribute "SCROLLBAR_VIEW_LENGTH" 1627588609 "Scrollbar_attribute")
(def-xview-attribute "SCROLLBAR_ABSOLUTE" 0 "Scroll_motion")
(def-xview-attribute "SCROLLBAR_POINT_TO_MIN" 1 "Scroll_motion")
(def-xview-attribute "SCROLLBAR_PAGE_FORWARD" 2 "Scroll_motion")
(def-xview-attribute "SCROLLBAR_LINE_FORWARD" 3 "Scroll_motion")
(def-xview-attribute "SCROLLBAR_MIN_TO_POINT" 4 "Scroll_motion")
(def-xview-attribute "SCROLLBAR_PAGE_BACKWARD" 5 "Scroll_motion")
(def-xview-attribute "SCROLLBAR_LINE_BACKWARD" 6 "Scroll_motion")
(def-xview-attribute "SCROLLBAR_TO_END" 7 "Scroll_motion")
(def-xview-attribute "SCROLLBAR_TO_START" 8 "Scroll_motion")
(def-xview-attribute "SCROLLBAR_PAGE_ALIGNED" 9 "Scroll_motion")
(def-xview-attribute "SCROLLBAR_NONE" 10 "Scroll_motion")
(def-xview-attribute "SCROLLBAR_VERTICAL" 0 "Scrollbar_setting")
(def-xview-attribute "SCROLLBAR_HORIZONTAL" 1 "Scrollbar_setting")
#|
(def-xview-attribute "SELN_REQ_BYTESIZE" 1191249921 "Seln_attribute")
(def-xview-attribute "SELN_REQ_COMMIT_PENDING_DELETE" 1195444768 "Seln_attribute")
(def-xview-attribute "SELN_REQ_CONTENTS_ASCII" 1191348545 "Seln_attribute")
(def-xview-attribute "SELN_REQ_CONTENTS_PIECES" 1191414081 "Seln_attribute")
(def-xview-attribute "SELN_REQ_DELETE" 1195510304 "Seln_attribute")
(def-xview-attribute "SELN_REQ_END_REQUEST" 1207765536 "Seln_attribute")
(def-xview-attribute "SELN_REQ_FAILED" 1207896065 "Seln_attribute")
(def-xview-attribute "SELN_REQ_FAKE_LEVEL" 1197606913 "Seln_attribute")
(def-xview-attribute "SELN_REQ_FILE_NAME" 1191807297 "Seln_attribute")
(def-xview-attribute "SELN_REQ_FIRST" 1191446529 "Seln_attribute")
(def-xview-attribute "SELN_REQ_FIRST_UNIT" 1191512065 "Seln_attribute")
(def-xview-attribute "SELN_REQ_LAST" 1191577601 "Seln_attribute")
(def-xview-attribute "SELN_REQ_LAST_UNIT" 1191643137 "Seln_attribute")
(def-xview-attribute "SELN_REQ_LEVEL" 1191708673 "Seln_attribute")
(def-xview-attribute "SELN_REQ_RESTORE" 1195575840 "Seln_attribute")
(def-xview-attribute "SELN_REQ_SET_LEVEL" 1197672449 "Seln_attribute")
(def-xview-attribute "SELN_REQ_UNKNOWN" 1207830529 "Seln_attribute")
(def-xview-attribute "SELN_REQ_YIELD" 1197541665 "Seln_attribute")
(def-xview-attribute "SELN_AGENT_INFO" 1197738497 "Seln_attribute")
(def-xview-attribute "SELN_REQ_FUNC_KEY_STATE" 1197803521 "Seln_attribute")
(def-xview-attribute "SELN_REQ_SELECTED_WINDOWS" 1197901825 "Seln_attribute")
(def-xview-attribute "SELN_REQ_CONTENTS_OBJECT" 1197967681 "Seln_attribute")
(def-xview-attribute "SELN_REQ_OBJECT_SIZE" 1198000129 "Seln_attribute")
(def-xview-attribute "SELN_REQ_IS_READONLY" 1198065921 "Seln_attribute")
(def-xview-attribute "SELN_TRACE_ACQUIRE" 1203833089 "Seln_attribute")
(def-xview-attribute "SELN_TRACE_DONE" 1203898625 "Seln_attribute")
(def-xview-attribute "SELN_TRACE_DUMP" 1204291873 "Seln_attribute")
(def-xview-attribute "SELN_TRACE_HOLD_FILE" 1203964161 "Seln_attribute")
(def-xview-attribute "SELN_TRACE_INFORM" 1204029697 "Seln_attribute")
(def-xview-attribute "SELN_TRACE_INQUIRE" 1204095233 "Seln_attribute")
(def-xview-attribute "SELN_TRACE_STOP" 1204226305 "Seln_attribute")
(def-xview-attribute "SELN_TRACE_YIELD" 1204160769 "Seln_attribute")
(def-xview-attribute "SELN_LEVEL_FIRST" 1073741825 "Seln_level")
(def-xview-attribute "SELN_LEVEL_LINE" 1073742081 "Seln_level")
(def-xview-attribute "SELN_LEVEL_ALL" 1073774593 "Seln_level")
(def-xview-attribute "SELN_LEVEL_NEXT" 1073803265 "Seln_level")
(def-xview-attribute "SELN_LEVEL_PREVIOUS" 1073803266 "Seln_level")
(def-xview-attribute "SELN_FAILED" 0 "Seln_result")
(def-xview-attribute "SELN_SUCCESS" 1 "Seln_result")
(def-xview-attribute "SELN_NON_EXIST" 2 "Seln_result")
(def-xview-attribute "SELN_DIDNT_HAVE" 3 "Seln_result")
(def-xview-attribute "SELN_WRONG_RANK" 4 "Seln_result")
(def-xview-attribute "SELN_CONTINUED" 5 "Seln_result")
(def-xview-attribute "SELN_CANCEL" 6 "Seln_result")
(def-xview-attribute "SELN_UNRECOGNIZED" 7 "Seln_result")
(def-xview-attribute "SELN_OVER" 8 "Seln_result")
(def-xview-attribute "SELN_UNKNOWN" 0 "Seln_rank")
(def-xview-attribute "SELN_CARET" 1 "Seln_rank")
(def-xview-attribute "SELN_PRIMARY" 2 "Seln_rank")
(def-xview-attribute "SELN_SECONDARY" 3 "Seln_rank")
(def-xview-attribute "SELN_SHELF" 4 "Seln_rank")
(def-xview-attribute "SELN_UNSPECIFIED" 5 "Seln_rank")
(def-xview-attribute "SELN_FN_ERROR" 0 "Seln_function")
(def-xview-attribute "SELN_FN_STOP" 1 "Seln_function")
(def-xview-attribute "SELN_FN_AGAIN" 2 "Seln_function")
(def-xview-attribute "SELN_FN_PROPS" 3 "Seln_function")
(def-xview-attribute "SELN_FN_UNDO" 4 "Seln_function")
(def-xview-attribute "SELN_FN_FRONT" 5 "Seln_function")
(def-xview-attribute "SELN_FN_PUT" 6 "Seln_function")
(def-xview-attribute "SELN_FN_OPEN" 7 "Seln_function")
(def-xview-attribute "SELN_FN_GET" 8 "Seln_function")
(def-xview-attribute "SELN_FN_FIND" 9 "Seln_function")
(def-xview-attribute "SELN_FN_DELETE" 10 "Seln_function")
(def-xview-attribute "SELN_NONE" 0 "Seln_state")
(def-xview-attribute "SELN_EXISTS" 1 "Seln_state")
(def-xview-attribute "SELN_FILE" 2 "Seln_state")
(def-xview-attribute "SELN_IGNORE" 0 "Seln_response")
(def-xview-attribute "SELN_REQUEST" 1 "Seln_response")
(def-xview-attribute "SELN_FIND" 2 "Seln_response")
(def-xview-attribute "SELN_SHELVE" 3 "Seln_response")
(def-xview-attribute "SELN_DELETE" 4 "Seln_response")
|#
(def-xview-attribute "SERVER_ASCII_KEYSTATE" 1208420865 "Server_attr")
(def-xview-attribute "SERVER_ASCII_TO_KEYCODE_MAP" 1208355329 "Server_attr")
(def-xview-attribute "SERVER_FONT_WITH_NAME" 1208224097 "Server_attr")
(def-xview-attribute "SERVER_JOURNAL_SYNC_EVENT" 1210451969 "Server_attr")
(def-xview-attribute "SERVER_JOURNALLING" 1210321153 "Server_attr")
(def-xview-attribute "SERVER_KEY_EVENTS_MAP" 1208289793 "Server_attr")
(def-xview-attribute "SERVER_NONASCII_KEYSTATE" 1208486401 "Server_attr")
(def-xview-attribute "SERVER_NTH_SCREEN" 1208092674 "Server_attr")
(def-xview-attribute "SERVER_SEMANTIC_MAP" 1208879617 "Server_attr")
(def-xview-attribute "SERVER_XV_MAP" 1208814081 "Server_attr")
(def-xview-attribute "SERVER_SYNC" 1210059009 "Server_attr")
(def-xview-attribute "SERVER_SYNC_AND_PROCESS_EVENTS" 1210124832 "Server_attr")
#|
(def-xview-attribute "SERVER_WM_RESCALE" 1209600513 "Server_attr")
(def-xview-attribute "SERVER_WM_RESCALE_STATE" 1209076225 "Server_attr")
(def-xview-attribute "SERVER_WM_STATE" 1209338369 "Server_attr")
(def-xview-attribute "SERVER_WM_TAKE_FOCUS" 1209928193 "Server_attr")
(def-xview-attribute "SERVER_WM_WINDOW_MOVED" 1209797121 "Server_attr")
(def-xview-attribute "SERVER_WM_WIN_ATTR" 1210190337 "Server_attr")
(def-xview-attribute "SERVER_WM_ADD_DECOR" 1210255873 "Server_attr")
(def-xview-attribute "SERVER_WM_DELETE_DECOR" 1210583553 "Server_attr")
(def-xview-attribute "SERVER_WM_DECOR_CLOSE" 1210911233 "Server_attr")
(def-xview-attribute "SERVER_WM_DECOR_FOOTER" 1211566593 "Server_attr")
(def-xview-attribute "SERVER_WM_DECOR_RESIZE" 1211894273 "Server_attr")
(def-xview-attribute "SERVER_WM_DECOR_HEADER" 1212221953 "Server_attr")
(def-xview-attribute "SERVER_WM_DECOR_OK" 1212549633 "Server_attr")
(def-xview-attribute "SERVER_WM_DECOR_PIN" 1212877313 "Server_attr")
(def-xview-attribute "SERVER_WM_SCALE_SMALL" 1213204993 "Server_attr")
(def-xview-attribute "SERVER_WM_SCALE_MEDIUM" 1213532673 "Server_attr")
(def-xview-attribute "SERVER_WM_SCALE_LARGE" 1213860353 "Server_attr")
(def-xview-attribute "SERVER_WM_SCALE_XLARGE" 1214188033 "Server_attr")
(def-xview-attribute "SERVER_WM_PIN_STATE" 1214515713 "Server_attr")
(def-xview-attribute "SERVER_WM_WIN_BUSY" 1214843393 "Server_attr")
(def-xview-attribute "SERVER_WM_WINMSG_STATE" 1215171073 "Server_attr")
(def-xview-attribute "SERVER_WM_WINMSG_ERROR" 1215498753 "Server_attr")
(def-xview-attribute "SERVER_WM_WT_BASE" 1215891969 "Server_attr")
(def-xview-attribute "SERVER_WM_WT_CMD" 1216154113 "Server_attr")
(def-xview-attribute "SERVER_WM_WT_PROP" 1216481793 "Server_attr")
(def-xview-attribute "SERVER_WM_WT_HELP" 1216809473 "Server_attr")
(def-xview-attribute "SERVER_WM_WT_NOTICE" 1217137153 "Server_attr")
(def-xview-attribute "SERVER_WM_WT_OTHER" 1217464833 "Server_attr")
(def-xview-attribute "SERVER_WM_MENU_FULL" 1217792513 "Server_attr")
(def-xview-attribute "SERVER_WM_MENU_LIMITED" 1218120193 "Server_attr")
(def-xview-attribute "SERVER_WM_NONE" 1218447873 "Server_attr")
(def-xview-attribute "SERVER_WM_PIN_IN" 1218775553 "Server_attr")
(def-xview-attribute "SERVER_WM_PIN_OUT" 1219103233 "Server_attr")
(def-xview-attribute "SERVER_DO_DRAG_MOVE" 1215826433 "Server_attr")
(def-xview-attribute "SERVER_DO_DRAG_COPY" 1215957505 "Server_attr")
(def-xview-attribute "SERVER_DO_DRAG_LOAD" 1216023041 "Server_attr")
(def-xview-attribute "SERVER_JOURNAL_SYNC_ATOM" 1216153601 "Server_attr")
(def-xview-attribute "SERVER_WM_DISMISS" 1221069313 "Server_attr")
(def-xview-attribute "SERVER_WM_SAVE_YOURSELF" 1221724673 "Server_attr")
|#
(def-xview-attribute "SERVER_IMAGE_DEPTH" 1157695489 "Server_image_attribute")
(def-xview-attribute "SERVER_IMAGE_BITS" 1157761537 "Server_image_attribute")
(def-xview-attribute "SERVER_IMAGE_COLORMAP" 1157892449 "Server_image_attribute")
(def-xview-attribute "SERVER_IMAGE_X_BITS" 1157827073 "Server_image_attribute")
(def-xview-attribute "SERVER_IMAGE_BITMAP_FILE" 1157957985 "Server_image_attribute")
(def-xview-attribute "SERVER_IMAGE_PIXMAP" 1158023681 "Server_image_attribute")
(def-xview-attribute "SERVER_IMAGE_SAVE_PIXMAP" 1158088961 "Server_image_attribute")
(def-xview-attribute "TERMSW_MODE_TYPE" 0 "Termsw_mode")
(def-xview-attribute "TTYSW_MODE_TYPE" 1 "Termsw_mode")
(def-xview-attribute "TERMSW_MODE" 1359022081 "Termsw_attribute")
(def-xview-attribute "TEXTSW_ADJUST_IS_PENDING_DELETE" 1459685633 "Textsw_attribute")
(def-xview-attribute "TEXTSW_AGAIN_RECORDING" 1459751169 "Textsw_attribute")
(def-xview-attribute "TEXTSW_AUTO_INDENT" 1459882241 "Textsw_attribute")
(def-xview-attribute "TEXTSW_AUTO_SCROLL_BY" 1460013057 "Textsw_attribute")
(def-xview-attribute "TEXTSW_BLINK_CARET" 1460144385 "Textsw_attribute")
(def-xview-attribute "TEXTSW_BROWSING" 1460275457 "Textsw_attribute")
(def-xview-attribute "TEXTSW_CHECKPOINT_FREQUENCY" 1460406273 "Textsw_attribute")
(def-xview-attribute "TEXTSW_CLIENT_DATA" 1460537857 "Textsw_attribute")
(def-xview-attribute "TEXTSW_CONFIRM_OVERWRITE" 1460668673 "Textsw_attribute")
(def-xview-attribute "TEXTSW_CONTENTS" 1460799841 "Textsw_attribute")
(def-xview-attribute "TEXTSW_CONTROL_CHARS_USE_FONT" 1460930817 "Textsw_attribute")
(def-xview-attribute "TEXTSW_DISABLE_CD" 1461061889 "Textsw_attribute")
(def-xview-attribute "TEXTSW_DISABLE_LOAD" 1461192961 "Textsw_attribute")
(def-xview-attribute "TEXTSW_SUBMENU_EDIT" 1461324320 "Textsw_attribute")
(def-xview-attribute "TEXTSW_EDIT_COUNT" 1461454849 "Textsw_attribute")
(def-xview-attribute "TEXTSW_EXTRAS_CMD_MENU" 1461585921 "Textsw_attribute")
(def-xview-attribute "TEXTSW_FILE" 1461717345 "Textsw_attribute")
(def-xview-attribute "TEXTSW_SUBMENU_FILE" 1461848608 "Textsw_attribute")
(def-xview-attribute "TEXTSW_FILE_CONTENTS" 1461979489 "Textsw_attribute")
(def-xview-attribute "TEXTSW_SUBMENU_FIND" 1462110752 "Textsw_attribute")
(def-xview-attribute "TEXTSW_FIRST" 1462241281 "Textsw_attribute")
(def-xview-attribute "TEXTSW_FIRST_LINE" 1462372353 "Textsw_attribute")
(def-xview-attribute "TEXTSW_HISTORY_LIMIT" 1462503425 "Textsw_attribute")
(def-xview-attribute "TEXTSW_IGNORE_LIMIT" 1462634497 "Textsw_attribute")
(def-xview-attribute "TEXTSW_INSERTION_POINT" 1462765569 "Textsw_attribute")
(def-xview-attribute "TEXTSW_INSERT_FROM_FILE" 1462896993 "Textsw_attribute")
(def-xview-attribute "TEXTSW_INSERT_MAKES_VISIBLE" 1463028001 "Textsw_attribute")
(def-xview-attribute "TEXTSW_LENGTH" 1463158785 "Textsw_attribute")
(def-xview-attribute "TEXTSW_LINE_BREAK_ACTION" 1463290145 "Textsw_attribute")
(def-xview-attribute "TEXTSW_LOWER_CONTEXT" 1463420929 "Textsw_attribute")
(def-xview-attribute "TEXTSW_MEMORY_MAXIMUM" 1463552001 "Textsw_attribute")
(def-xview-attribute "TEXTSW_MODIFIED" 1463683329 "Textsw_attribute")
(def-xview-attribute "TEXTSW_MULTI_CLICK_SPACE" 1463814145 "Textsw_attribute")
(def-xview-attribute "TEXTSW_MULTI_CLICK_TIMEOUT" 1463945217 "Textsw_attribute")
(def-xview-attribute "TEXTSW_NOTIFY_PROC" 1464076897 "Textsw_attribute")
(def-xview-attribute "TEXTSW_READ_ONLY" 1464207617 "Textsw_attribute")
(def-xview-attribute "TEXTSW_STATUS" 1464338945 "Textsw_attribute")
(def-xview-attribute "TEXTSW_STORE_CHANGES_FILE" 1464469761 "Textsw_attribute")
(def-xview-attribute "TEXTSW_UPDATE_SCROLLBAR" 1464732192 "Textsw_attribute")
(def-xview-attribute "TEXTSW_UPPER_CONTEXT" 1464862721 "Textsw_attribute")
(def-xview-attribute "TEXTSW_SUBMENU_VIEW" 1464994336 "Textsw_attribute")
(def-xview-attribute "TEXTSW_AGAIN_LIMIT" 1465124865 "Textsw_attribute")
(def-xview-attribute "TEXTSW_COALESCE_WITH" 1465256449 "Textsw_attribute")
(def-xview-attribute "TEXTSW_DESTROY_ALL_VIEWS" 1465649409 "Textsw_attribute")
(def-xview-attribute "TEXTSW_EDIT_BACK_CHAR" 1466042689 "Textsw_attribute")
(def-xview-attribute "TEXTSW_EDIT_BACK_LINE" 1466173761 "Textsw_attribute")
(def-xview-attribute "TEXTSW_EDIT_BACK_WORD" 1466304833 "Textsw_attribute")
(def-xview-attribute "TEXTSW_ERROR_MSG" 1466435937 "Textsw_attribute")
(def-xview-attribute "TEXTSW_ES_CREATE_PROC" 1466567265 "Textsw_attribute")
(def-xview-attribute "TEXTSW_INSERT_ONLY" 1466697985 "Textsw_attribute")
(def-xview-attribute "TEXTSW_LOAD_DIR_IS_CD" 1466829089 "Textsw_attribute")
(def-xview-attribute "TEXTSW_MUST_SHOW_CARET" 1467091201 "Textsw_attribute")
(def-xview-attribute "TEXTSW_NAME_TO_USE" 1467222369 "Textsw_attribute")
(def-xview-attribute "TEXTSW_NOTIFY_LEVEL" 1467353089 "Textsw_attribute")
(def-xview-attribute "TEXTSW_NO_REPAINT_TIL_EVENT" 1467484417 "Textsw_attribute")
(def-xview-attribute "TEXTSW_NO_RESET_TO_SCRATCH" 1467615489 "Textsw_attribute")
(def-xview-attribute "TEXTSW_NO_SELECTION_SERVICE" 1467746561 "Textsw_attribute")
(def-xview-attribute "TEXTSW_RESET_MODE" 1468008737 "Textsw_attribute")
(def-xview-attribute "TEXTSW_RESET_TO_CONTENTS" 1468140064 "Textsw_attribute")
(def-xview-attribute "TEXTSW_SPARE_1" 1468303361 "Textsw_attribute")
(def-xview-attribute "TEXTSW_SPARE_2" 1468434433 "Textsw_attribute")
(def-xview-attribute "TEXTSW_TAB_WIDTH" 1468532737 "Textsw_attribute")
(def-xview-attribute "TEXTSW_TAB_WIDTHS" 1468696577 "Textsw_attribute")
(def-xview-attribute "TEXTSW_TEMP_FILENAME" 1468795233 "Textsw_attribute")
(def-xview-attribute "TEXTSW_WRAPAROUND_SIZE" 1468925953 "Textsw_attribute")
(def-xview-attribute "TEXTSW_END_ALL_VIEWS" 1469057568 "Textsw_attribute")
(def-xview-attribute "TEXTSW_FOR_ALL_VIEWS" 1469188640 "Textsw_attribute")
(def-xview-attribute "TEXTSW_ACTION_CAPS_LOCK" 1459685633 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_CHANGED_DIRECTORY" 1459947873 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_EDITED_FILE" 1460275553 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_EDITED_MEMORY" 1460603424 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_FILE_IS_READONLY" 1460930913 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_LOADED_FILE" 1461258593 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_TOOL_CLOSE" 1461586464 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_TOOL_DESTROY" 1461914113 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_TOOL_MGR" 1462241793 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_TOOL_QUIT" 1462569473 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_USING_MEMORY" 1462897184 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_DESTROY_VIEW" 1463224864 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_PAINTED" 1463552481 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_REPLACED" 1463879685 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_SAVING_FILE" 1464207904 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_SCROLLED" 1464535522 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_SPLIT_VIEW" 1464863233 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_STORING_FILE" 1465190753 "Textsw_action")
(def-xview-attribute "TEXTSW_ACTION_WRITE_FAILED" 1465518624 "Textsw_action")
(def-xview-attribute "TEXTSW_FATTR_INPUT" 1459685889 "Textsw_filter_attribute")
(def-xview-attribute "TEXTSW_FATTR_INPUT_EVENT" 1459948033 "Textsw_filter_attribute")
(def-xview-attribute "TEXTSW_FATTR_INSERTION_POINTS" 1460275713 "Textsw_filter_attribute")
(def-xview-attribute "TEXTSW_FATTR_INSERTION_LINE" 1460603393 "Textsw_filter_attribute")
(def-xview-attribute "TEXTSW_FATTR_SELECTION_ENDPOINTS" 1460931073 "Textsw_filter_attribute")
(def-xview-attribute "TEXTSW_STATUS_OKAY" 0 "Textsw_status")
(def-xview-attribute "TEXTSW_STATUS_OTHER_ERROR" 1 "Textsw_status")
(def-xview-attribute "TEXTSW_STATUS_CANNOT_ALLOCATE" 2 "Textsw_status")
(def-xview-attribute "TEXTSW_STATUS_CANNOT_OPEN_INPUT" 3 "Textsw_status")
(def-xview-attribute "TEXTSW_STATUS_BAD_ATTR" 4 "Textsw_status")
(def-xview-attribute "TEXTSW_STATUS_BAD_ATTR_VALUE" 5 "Textsw_status")
(def-xview-attribute "TEXTSW_STATUS_CANNOT_INSERT_FROM_FILE" 6 "Textsw_status")
(def-xview-attribute "TEXTSW_STATUS_OUT_OF_MEMORY" 7 "Textsw_status")
(def-xview-attribute "TEXTSW_EXPAND_OK" 0 "Textsw_expand_status")
(def-xview-attribute "TEXTSW_EXPAND_FULL_BUF" 1 "Textsw_expand_status")
(def-xview-attribute "TEXTSW_EXPAND_OTHER_ERROR" 2 "Textsw_expand_status")
(def-xview-attribute "TEXTSW_NEVER" 0 "Textsw_enum")
(def-xview-attribute "TEXTSW_ALWAYS" 1 "Textsw_enum")
(def-xview-attribute "TEXTSW_ONLY" 2 "Textsw_enum")
(def-xview-attribute "TEXTSW_IF_AUTO_SCROLL" 3 "Textsw_enum")
(def-xview-attribute "TEXTSW_CLIP" 4 "Textsw_enum")
(def-xview-attribute "TEXTSW_WRAP_AT_CHAR" 5 "Textsw_enum")
(def-xview-attribute "TEXTSW_WRAP_AT_WORD" 6 "Textsw_enum")
(def-xview-attribute "TEXTSW_WRAP_AT_LINE" 7 "Textsw_enum")
(def-xview-attribute "TEXTSW_MENU_NO_CMD" 0 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_LOAD" 1 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_SAVE" 2 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_STORE" 3 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_FILE_STUFF" 4 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_RESET" 5 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_AGAIN" 6 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_UNDO" 7 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_UNDO_ALL" 8 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_COPY" 9 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_PASTE" 10 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_CUT" 11 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_NORMALIZE_LINE" 12 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_COUNT_TO_LINE" 13 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_NORMALIZE_INSERTION" 14 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_WRAP_LINES_AT_CHAR" 15 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_WRAP_LINES_AT_WORD" 16 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_CLIP_LINES" 17 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_FIND_AND_REPLACE" 18 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_FIND" 19 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_FIND_BACKWARD" 20 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_SEL_MARK_TEXT" 21 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_SEL_ENCLOSE_FIELD" 22 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_SEL_NEXT_FIELD" 23 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_SEL_PREV_FIELD" 24 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_FILE_CMDS" 25 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_EDIT_CMDS" 26 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_VIEW_CMDS" 27 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_FIND_CMDS" 28 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_EXTRAS_CMDS" 29 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_MENU_LAST_CMD" 30 "Textsw_menu_cmd")
(def-xview-attribute "TEXTSW_FILTER_DELETE_RANGE" 0 "Textsw_filter_command")
(def-xview-attribute "TEXTSW_FILTER_INSERT" 1 "Textsw_filter_command")
(def-xview-attribute "TEXTSW_FILTER_SEND_RANGE" 2 "Textsw_filter_command")
(def-xview-attribute "TEXTSW_FILTER_SET_INSERTION" 3 "Textsw_filter_command")
(def-xview-attribute "TEXTSW_FILTER_SET_SELECTION" 4 "Textsw_filter_command")
(def-xview-attribute "TTY_ARGV" 1476463105 "Tty_attribute")
(def-xview-attribute "TTY_CONSOLE" 1476724993 "Tty_attribute")
(def-xview-attribute "TTY_INPUT" 1477052931 "Tty_attribute")
(def-xview-attribute "TTY_OUTPUT" 1477380611 "Tty_attribute")
(def-xview-attribute "TTY_PAGE_MODE" 1477708033 "Tty_attribute")
(def-xview-attribute "TTY_QUIT_ON_CHILD_DEATH" 1478035713 "Tty_attribute")
(def-xview-attribute "TTY_BOLDSTYLE" 1478363137 "Tty_attribute")
(def-xview-attribute "TTY_BOLDSTYLE_NAME" 1478691169 "Tty_attribute")
(def-xview-attribute "TTY_INVERSE_MODE" 1479018497 "Tty_attribute")
(def-xview-attribute "TTY_PID" 1479346177 "Tty_attribute")
(def-xview-attribute "TTY_PTY_FD" 1479673857 "Tty_attribute")
(def-xview-attribute "TTY_TTY_FD" 1480329217 "Tty_attribute")
(def-xview-attribute "TTY_UNDERLINE_MODE" 1480656897 "Tty_attribute")
(def-xview-attribute "WIN_ALARM" 1224804896 "Window_attribute")
(def-xview-attribute "WIN_BACK" 1224870432 "Window_attribute")
(def-xview-attribute "WIN_BELOW" 1225001473 "Window_attribute")
(def-xview-attribute "WIN_CLIENT_DATA" 1225263617 "Window_attribute")
(def-xview-attribute "WIN_CMS_DATA" 1240140289 "Window_attribute")
(def-xview-attribute "WIN_CMS_NAME" 1240205665 "Window_attribute")
(def-xview-attribute "WIN_CMS" 1239878145 "Window_attribute")
(def-xview-attribute "WIN_DYNAMIC_VISUAL" 1239943425 "Window_attribute")
(def-xview-attribute "WIN_COLUMNS" 1225525249 "Window_attribute")
(def-xview-attribute "WIN_COLUMN_GAP" 1225787393 "Window_attribute")
(def-xview-attribute "WIN_COLUMN_WIDTH" 1226049537 "Window_attribute")
(def-xview-attribute "WIN_CONSUME_EVENT" 1226311969 "Window_attribute")
(def-xview-attribute "WIN_CONSUME_EVENTS" 1226606881 "Window_attribute")
(def-xview-attribute "WIN_CURSOR" 1226836673 "Window_attribute")
(def-xview-attribute "WIN_DEPTH" 1227098656 "Window_attribute")
(def-xview-attribute "WIN_DESIRED_HEIGHT" 1227360257 "Window_attribute")
(def-xview-attribute "WIN_DESIRED_WIDTH" 1227622401 "Window_attribute")
(def-xview-attribute "WIN_ERROR_MSG" 1227884897 "Window_attribute")
(def-xview-attribute "WIN_EVENT_PROC" 1228147297 "Window_attribute")
(def-xview-attribute "WIN_FIT_HEIGHT" 1228671105 "Window_attribute")
(def-xview-attribute "WIN_FIT_WIDTH" 1228933185 "Window_attribute")
(def-xview-attribute "WIN_FRONT" 1229064736 "Window_attribute")
(def-xview-attribute "WIN_GRAB_ALL_INPUT" 1229195521 "Window_attribute")
(def-xview-attribute "WIN_HORIZONTAL_SCROLLBAR" 1229457921 "Window_attribute")
(def-xview-attribute "WIN_IGNORE_EVENT" 1229719841 "Window_attribute")
(def-xview-attribute "WIN_IGNORE_EVENTS" 1230014753 "Window_attribute")
(def-xview-attribute "WIN_INPUT_MASK" 1230244353 "Window_attribute")
(def-xview-attribute "WIN_IS_CLIENT_PANE" 1230506528 "Window_attribute")
(def-xview-attribute "WIN_MENU" 1230768641 "Window_attribute")
(def-xview-attribute "WIN_MOUSE_XY" 1231030466 "Window_attribute")
(def-xview-attribute "WIN_MOUSE_BUTTONS" 5 "Window_attribute")
(def-xview-attribute "WIN_PARENT" 1231292929 "Window_attribute")
(def-xview-attribute "WIN_PERCENT_HEIGHT" 1231554561 "Window_attribute")
(def-xview-attribute "WIN_PERCENT_WIDTH" 1231816705 "Window_attribute")
(def-xview-attribute "WIN_RIGHT_OF" 1232341505 "Window_attribute")
(def-xview-attribute "WIN_ROWS" 1232603137 "Window_attribute")
(def-xview-attribute "WIN_ROW_GAP" 1232865281 "Window_attribute")
(def-xview-attribute "WIN_ROW_HEIGHT" 1233127425 "Window_attribute")
(def-xview-attribute "WIN_SCREEN_RECT" 1233390112 "Window_attribute")
(def-xview-attribute "WIN_VERTICAL_SCROLLBAR" 1233914369 "Window_attribute")
(def-xview-attribute "WIN_MESSAGE_TYPE" 1233979905 "Window_attribute")
(def-xview-attribute "WIN_MESSAGE_FORMAT" 1234044929 "Window_attribute")
(def-xview-attribute "WIN_MESSAGE_DATA" 1234110977 "Window_attribute")
(def-xview-attribute "WIN_ALARM_DATA" 1234176513 "Window_attribute")
(def-xview-attribute "WIN_BORDER" 1234438401 "Window_attribute")
(def-xview-attribute "WIN_FINDINTERSECT" 1234700482 "Window_attribute")
(def-xview-attribute "WIN_FRAME" 1234962945 "Window_attribute")
(def-xview-attribute "WIN_INPUT_ONLY" 1235225120 "Window_attribute")
(def-xview-attribute "WIN_IS_IN_FULLSCREEN_MODE" 1235486721 "Window_attribute")
(def-xview-attribute "WIN_IS_ROOT" 1235749408 "Window_attribute")
(def-xview-attribute "WIN_KBD_FOCUS" 1236011265 "Window_attribute")
(def-xview-attribute "WIN_LAYOUT_PROC" 1236273761 "Window_attribute")
(def-xview-attribute "WIN_LOCKDATA" 1236535840 "Window_attribute")
(def-xview-attribute "WIN_MAP" 1236797697 "Window_attribute")
(def-xview-attribute "WIN_NOTIFY_EVENT_PROC" 1237322337 "Window_attribute")
(def-xview-attribute "WIN_OUTER_RECT" 1237846497 "Window_attribute")
(def-xview-attribute "WIN_RECT_INFO" 1238108161 "Window_attribute")
(def-xview-attribute "WIN_RETAINED" 1238370561 "Window_attribute")
(def-xview-attribute "WIN_SELECTION_WINDOW" 1238632992 "Window_attribute")
(def-xview-attribute "WIN_TOP_LEVEL" 1238894849 "Window_attribute")
(def-xview-attribute "WIN_TOP_LEVEL_NO_DECOR" 1239156993 "Window_attribute")
(def-xview-attribute "WIN_SAVE_UNDER" 1239550209 "Window_attribute")
(def-xview-attribute "WIN_SET_FOCUS" 1239681568 "Window_attribute")
(def-xview-attribute "WIN_X_PAINT_WINDOW" 1239746817 "Window_attribute")
(def-xview-attribute "WIN_X_CLIP_RECTS" 1240009217 "Window_attribute")
(def-xview-attribute "WIN_TYPE" 1239419169 "Window_attribute")
(def-xview-attribute "WIN_BIT_GRAVITY" 1240270849 "Window_attribute")
(def-xview-attribute "WIN_WINDOW_GRAVITY" 1240336385 "Window_attribute")
(def-xview-attribute "WIN_FOREGROUND_COLOR" 1240401921 "Window_attribute")
(def-xview-attribute "WIN_BACKGROUND_COLOR" 1240467457 "Window_attribute")
(def-xview-attribute "WIN_X_COLOR_INDICES" 1240664577 "Window_attribute")
(def-xview-attribute "WIN_CONSUME_X_EVENT_MASK" 1240992513 "Window_attribute")
(def-xview-attribute "WIN_IGNORE_X_EVENT_MASK" 1241058049 "Window_attribute")
(def-xview-attribute "WIN_X_EVENT_MASK" 1241123585 "Window_attribute")
(def-xview-attribute "WIN_CREATE" 0 "Window_layout_op")
(def-xview-attribute "WIN_INSERT" 1 "Window_layout_op")
(def-xview-attribute "WIN_REMOVE" 2 "Window_layout_op")
(def-xview-attribute "WIN_DESTROY" 3 "Window_layout_op")
(def-xview-attribute "WIN_GET_RIGHT_OF" 4 "Window_layout_op")
(def-xview-attribute "WIN_GET_BELOW" 5 "Window_layout_op")
(def-xview-attribute "WIN_ADJUST_RECT" 6 "Window_layout_op")
(def-xview-attribute "WIN_GET_X" 7 "Window_layout_op")
(def-xview-attribute "WIN_GET_Y" 8 "Window_layout_op")
(def-xview-attribute "WIN_GET_WIDTH" 9 "Window_layout_op")
(def-xview-attribute "WIN_GET_HEIGHT" 10 "Window_layout_op")
(def-xview-attribute "WIN_GET_RECT" 11 "Window_layout_op")
(def-xview-attribute "WIN_LAYOUT" 12 "Window_layout_op")
(def-xview-attribute "WIN_INSTALL" 13 "Window_layout_op")
(def-xview-attribute "WM_None" 0 "WM_Direction")
(def-xview-attribute "WM_N" 1 "WM_Direction")
(def-xview-attribute "WM_NE" 2 "WM_Direction")
(def-xview-attribute "WM_E" 3 "WM_Direction")
(def-xview-attribute "WM_SE" 4 "WM_Direction")
(def-xview-attribute "WM_S" 5 "WM_Direction")
(def-xview-attribute "WM_SW" 6 "WM_Direction")
(def-xview-attribute "WM_W" 7 "WM_Direction")
(def-xview-attribute "WM_NW" 8 "WM_Direction")
(def-xview-attribute "PANEL_LIST_OP_DESELECT" 0 "Panel_list_op")
(def-xview-attribute "PANEL_LIST_OP_SELECT" 1 "Panel_list_op")
(def-xview-attribute "PANEL_LIST_OP_VALIDATE" 2 "Panel_list_op")
(def-xview-attribute "PANEL_LIST_OP_DELETE" 3 "Panel_list_op")
(def-xview-attribute "PANEL_LIST_SELECTED" 1433470977 "Panel_attr")
(def-xview-attribute "XV_STATIC_CMS" 1 "Xv_cmstype")
(def-xview-attribute "XV_DYNAMIC_CMS" 2 "Xv_cmstype")
(def-xview-attribute "ERROR_RECOVERABLE" 0 "Error_severity")
(def-xview-attribute "ERROR_NON_RECOVERABLE" 1 "Error_severity")
(def-xview-attribute "ERROR_SYSTEM" 0 "Error_layer")
(def-xview-attribute "ERROR_SERVER" 1 "Error_layer")
(def-xview-attribute "ERROR_TOOLKIT" 2 "Error_layer")
(def-xview-attribute "ERROR_PROGRAM" 3 "Error_layer")
(def-xview-attribute "ERROR_BAD_ATTR" 1275136513 "Error_attr")
(def-xview-attribute "ERROR_BAD_VALUE" 1275267586 "Error_attr")
(def-xview-attribute "ERROR_CANNOT_GET" 1275464193 "Error_attr")
(def-xview-attribute "ERROR_CANNOT_SET" 1275660801 "Error_attr")
(def-xview-attribute "ERROR_CREATE_ONLY" 1275857409 "Error_attr")
(def-xview-attribute "ERROR_INVALID_OBJECT" 1276053857 "Error_attr")
(def-xview-attribute "ERROR_LAYER" 1276250401 "Error_attr")
(def-xview-attribute "ERROR_PKG" 1276447233 "Error_attr")
(def-xview-attribute "ERROR_SEVERITY" 1276643617 "Error_attr")
(def-xview-attribute "ERROR_STRING" 1276840289 "Error_attr")
(def-xview-attribute "XV_ERROR_PROC" 1242303073 "Xv_attr")
(def-xview-attribute "CMS_TYPE" 1292175649 "Cms_attribute")
(def-xview-attribute "CMS_SIZE" 1292503041 "Cms_attribute")
(def-xview-attribute "CMS_COLORS" 1292831393 "Cms_attribute")
(def-xview-attribute "CMS_NAMED_COLORS" 1292929377 "Cms_attribute")
(def-xview-attribute "CMS_X_COLORS" 1292962305 "Cms_attribute")
(def-xview-attribute "CMS_INDEX" 1293158401 "Cms_attribute")
(def-xview-attribute "CMS_COLOR_COUNT" 1293486081 "Cms_attribute")
(def-xview-attribute "CMS_SCREEN" 1293814273 "Cms_attribute")
(def-xview-attribute "CMS_INDEX_TABLE" 1294141953 "Cms_attribute")
(def-xview-attribute "CMS_FOREGROUND_PIXEL" 1294469121 "Cms_attribute")
(def-xview-attribute "CMS_BACKGROUND_PIXEL" 1294796801 "Cms_attribute")
(def-xview-attribute "CMS_PIXEL" 1295124481 "Cms_attribute")
(def-xview-attribute "CMS_CMS_DATA" 1295452673 "Cms_attribute")
(def-xview-attribute "CMS_CONTROL_CMS" 1295780097 "Cms_attribute")
(def-xview-attribute "CMS_DEFAULT_CMS" 1296435457 "Cms_attribute")
(def-xview-attribute "CMS_FRAME_CMS" 1296763137 "Cms_attribute")
(def-xview-attribute "CMS_CMAP_ID" 1297091073 "Cms_attribute")
(def-xview-attribute "CMS_CMAP_TYPE" 1297418529 "Cms_attribute")
(def-xview-attribute "CMS_STATUS_BITS" 1297745921 "Cms_attribute")
(def-xview-attribute "PANEL_DIRECTION" 1428752673 "Panel_attr")
(def-xview-attribute "PANEL_TICKS" 1437665281 "Panel_attr")
(def-xview-attribute "PANEL_GAUGE_WIDTH" 1429538817 "Panel_attr")
