;;|=========================================================================|
;;|                         COPYRIGHT NOTICE                                |
;;|                                                                         |
;;|             Copyright 1990, 1991, 1992, 1993, 1994 Mark Tarver          |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|

(in-package :sequel)

(defun defrew1
       (fp1)
       (cond ((consp fp1)
              (funcall 'define1
                       (cons (car fp1)
                             (append (cdr fp1)
                                     (default-rewrite-code
                                       (arity-rewrite (cdr fp1))))))
              (pushnew (car fp1) *rewrites*)
              (setq *rewrites* (sort *rewrites* '<-symbol))
              (car fp1))
             (t (raise "code 13: No Patterns have Fired in defrew1"))))

(defun default-rewrite-code
       (fp1)
       (cond ((equal 1 fp1) '(x -> x))
             ((equal 2 fp1) '(x _ -> x))
             (t (raise "code 33: rewrite rule must have an arity of 1 or 2"))))

(defun arity-rewrite
       (fp1)
       (find-arity-rewrite (bracket fp1)))

(defun find-arity-rewrite
       (fp1)
       (cond ((and (consp fp1)
                   (eq '|{| (car fp1)))
              (sleep-until-rcurly (cdr fp1)))
             ((and (consp fp1)
                   (eq '<- (car fp1)))
              0)
             ((and (consp fp1)
                   (eq '-> (car fp1)))
              0)
             ((and (consp fp1)
                   (guard (car fp1)))
              (find-arity-rewrite (cdr fp1)))
             ((consp fp1) (1+ (find-arity-rewrite (cdr fp1))))
             (t
              (raise "code 13: No Patterns have Fired in find-arity-rewrite"))))

(defun sleep-until-rcurly
       (fp1)
       (cond ((and (consp fp1)
                   (eq '|}| (car fp1)))
              (find-arity-rewrite (cdr fp1)))
             ((consp fp1) (sleep-until-rcurly (cdr fp1)))
             (t
              (raise "code 13: No Patterns have Fired in sleep-until-rcurly"))))
