(defun otter (&rest x) (otter1 x))

(set *tactics0* [otter])

(define otter1
  [_ []] -> []
  [settings? sequents?] (not (listp settings?)) 
   -> (prog2 (warn "OTTER requires a list parameter") sequents?)
  [settings? [sequent? | sequents?]] 
   -> (if (sequent->otter-problem settings? (external-form sequent?))
          sequents?
          [sequent? | sequents?])
  [[sequent? | sequents?]] -> 
  (progn (warn "OTTER requires parameters.")
         (warn "Assuming binary resolution with factoring.") 
         (if (sequent->otter-problem [[binary_res +] [factor +]] 
                                     (external-form sequent?))
             sequents?
          [sequent? | sequents?]))
  x -> (progn (warn "OTTER cannot process this.") 
              (warn "Look at the OTTER manual and the online help for this tactic.")
              (head (last x))))

(define external-form
  [<A>? |- p?] -> (external-vars-out 
                   [(mapcar external-syntax-out (mapcar rem-dn <A>?)) 
                     |- (external-syntax-out (rem-dn p?))]))

(define rem-dn
  [~ [~ p?]] -> (rem-dn p?)
  [x | y] -> (mapcar rem-dn [x | y])
  x -> x)

(define sequent->otter-problem
  settings? [<A>? |- p?]  
               -> (progn (if (probe-file "temp")
                             (delete-file "temp"))
                             (preamble settings?)
                          (otter-axioms <A>?)
                          (otter-conclusion p?)
                          (if (probe-file "see")
                              (delete-file "see"))
                          (run-unix-program "otter" :input "temp" :output "see")
                          (get-otter-result "see")))

(define get-otter-result
  x -> (progn (set stream (open x :direction :input))
              (prog1 (gor1 []) (close %stream%))))

(define gor1
  [#\Y #\T #\P #\M #\E | y] -> (progn (look-for-ans-clause y) t)
  [#\T #\I #\N #\U | y] -> (progn (look-for-ans-clause y) t)
  [nil | _] -> nil
  [w x y z | _] -> (gor1 [(read-char-no-hang %stream% nil) w x y z])
  x -> (gor1 [(read-char-no-hang %stream% nil) | x])) 

(define look-for-ans-clause
  [nil | _] -> nil 
  [#\s #\n #\a #\$ | _] -> (format t "ANSWER = ~A~%" 
                               (car (ch-from-otter-sequel-syn (read %stream%))))
  [w x y z | _] -> (look-for-ans-clause [(read-char-no-hang %stream% nil) w x y z]) 
  x -> (look-for-ans-clause [(read-char-no-hang %stream% nil) | x]))

(define ch-from-otter-sequel-syn
  [] -> []
  [x | y] (comma x) -> (ch-from-otter-sequel-syn y)
  [f? [x | y] | z] (symbolp f?) -> (ch-from-otter-sequel-syn [[f? x | y] | z])
  [[x | y] | z] -> [(ch-from-otter-sequel-syn [x | y])
                      | (ch-from-otter-sequel-syn z)]
  [x | y] -> [x | (ch-from-otter-sequel-syn y)]) 
                  
(define preamble
  [] -> (progn (set stream (open "temp" :direction :output))
               (write-line "set(hyper_res)." %stream%)
               (write-line "formula_list(usable)." %stream%)
               (close %stream%))
  settings? -> (progn (set stream (open "temp" :direction :output))
                      (mapcar preamble-line settings?)
                      (write-line "formula_list(usable)." %stream%)
                      (close %stream%)))

(define preamble-line
  [flag? status?] (member status? [+ -]) 
  (member flag? [input_sos_queue sos_queue sos_stack print_given binary_res
                 hyper_res ur_res para_into para_from demod_inf para_from_left
                 para_from_right para_into_left para_into_right para_from_vars
                 para_into_vars para_from_units_only para_into_units_only 
                 para_skip_skolem para_ones_rule para_all very_verbose order_eq
                 sort_literals delete_identical_nested_skolem for_sub 
                 unit_deletion print_kept print_proofs back_sub print_back_sub 
                 factor demod_history demod_linear demod_out_in dynamic_demod 
                 dynamic_demod_all print_new_demod back_demod print_back_demod 
                 symbol_elim knuth_bendix lex_rpo dynamic_demod_lex_dep 
                 lex_order_vars for_sub_fpa no_fapl no_fanl check_arity 
                 process_input simplify_fol bird_print free_all_mem
                 atom_wt_max_args term_wt_max_args print_lists_at_end 
                 really_delete_clauses])
     -> (write-line (format nil "~A(~A)." (otter-status status?) flag?) 
                    %stream%) 
  [param? n?] (integerp n?) (>= n? 0)
             (member param? [report max_seconds max_gen max_kept max_given 
                             max_mem max_literals max_weight demod_limit 
                             max_proofs neg_weight])
              -> (write-line (format nil "assign(~A,~A)." param? n?) %stream%)
  [fpa_literals n?] (integerp n?) (>= n? 0) (>= 8 n?) 
    -> (write-line (format nil "assign(fpa_literals,~A)." n?) %stream%)
  [fpa_terms n?] (integerp n?) (>= n? 0) (>= 8 n?) 
    -> (write-line (format nil "assign(fpa_terms ,~A)." n?) %stream%)
  [stats_level n?] (integerp n?) (>= n? 0) (>= 3 n?) 
   -> (write-line (format nil "assign(stats_level,~A)." n?) %stream%)
  x -> (warn (format nil "~A is not a legal OTTER setting.~%" x)))

(define otter-status
  + -> set
  - -> clear)

(define otter-axioms
  <A>? -> (mapcar %#'(lambda (x) (with-open-file (out "temp" :direction
                                              :output :if-exists :append)
                                  (write-line (sequel-wff->otter-wff x) out)))%
                  <A>?))

(define otter-conclusion
  p? -> (with-open-file (out "temp" :direction :output :if-exists :append)
        (progn (write-line "end_of_list." %out%)
               (write-line "formula_list(sos)." %out%)
               (write-line (sequel-wff->otter-wff (compl p?)) %out%))))

(define compl 
  [~ p?] -> p?
  p? -> [~ p?])

(define sequel-wff->otter-wff 
 x -> (combine-strings (otter-strings (preprocess-to-otter x))))

(define otter-strings 
  [- | x] -> [(otter-strings1 [- | x]) <> ["."]]
  x -> (if (otter-literal x) 
           [(otter-strings1 x) <> ["."]]
           [["(" | (otter-strings1 x)] <> [")."]]))

(define otter-strings1
  [] -> []
  [- x | y] -> [(format nil "-") | (otter-strings1 [x | y])]
  [-> | y] -> [(format nil "-> ") | (otter-strings1 y)]
  [x [y | z] | w] (otter-literal [y | z]) 
  -> [(format nil "~A(" x) | (otter-strings1 [[y | z] [")"] <> w])]
  [x [y | z] | w] -> [(format nil "~A (" x) | (otter-strings1 [[y | z] [") "] <> w])]
  [[y | z] | w] -> [(format nil "(") | (otter-strings1 [[y | z] [")"] <> w])]
  [x ")" | y] -> [(format nil "~A) " x) | (otter-strings1 y)] 
  [x | y] -> [(format nil "~A " x) | (otter-strings1 y)])

(define preprocess-to-otter
  [[some x] y] -> (comb-otter-literals [exists x (preprocess-to-otter y)])
  [[all x] y] -> (comb-otter-literals [all x (preprocess-to-otter y)])
  [~ x] -> (comb-otter-literals [- (preprocess-to-otter x)])
  [x => y] -> (comb-otter-literals [(preprocess-to-otter x) -> (preprocess-to-otter y)])
  [x <=> y] -> (comb-otter-literals [(preprocess-to-otter x) <-> (preprocess-to-otter y)]) 
  [x V y] -> (comb-otter-literals [(preprocess-to-otter x) "| " (preprocess-to-otter y)]) 
  [x & y] -> (comb-otter-literals [(preprocess-to-otter x) & (preprocess-to-otter y)])
  x -> (preprocess-to-otter-literalic-otter x))

(define comb-otter-literals
  [- x] (otter-literal x) -> [[-] <> x]
  [exists x y] (otter-literal y) -> [exists x | y]
  [exists x y] -> [exists x y]
  [all x y] (otter-literal y) -> [all x | y]
  [all x y] -> [all x y]
  [x conn? y] (otter-literal x) (otter-literal y) -> [x <> [conn?] y]
  [x conn? y] (otter-literal x) -> [x <> [conn? y]] 
  [x conn? y] (otter-literal y) -> [[x conn?] <> y]
  x -> x)

(define otter-literal
  [- | x] (not (or (occurs exists x) (occurs all x) (occurs -> x)
                   (occurs <-> x) (occurs "| " x) (occurs & x))) -> t
  x (or (occurs exists x)
        (occurs all x)
        (occurs -> x)
        (occurs <-> x)
        (occurs "| " x)
        (occurs & x)) -> nil
 _ -> t)

(define preprocess-to-otter-literalic-otter
  [= x y] -> [[(preprocess-to-otter-terms [x]) <> [=] 
               <> (preprocess-to-otter-terms [y])]]
  [predicate? | terms?] -> [predicate? (preprocess-to-otter-terms terms?)] 
  otter-literal? -> [otter-literal?])
 
(define preprocess-to-otter-terms
  [] -> []
  [[f? | x]] -> [f? (preprocess-to-otter-terms x)]
  [x] -> [x]
  [[f? | x] | y] -> [f? (preprocess-to-otter-terms x) "," 
                         | (preprocess-to-otter-terms y)]
  [x | y] -> [x "," | (preprocess-to-otter-terms y)])
  
(define combine-strings
  [x] -> x 
  [x y | z] -> (combine-strings [(format nil "~A~A" x y) | z]))
