(global *hierarchy* identifier (list (list symbol)))

(set *hierarchy* [[dr o] [o p] [pp p] [p c] [dc c] [ec c o] [tp ec]
                  [ntp ec p] [po p o] [ntpp ntp p] [tp-1 tp] [tpp-1 tpp] 
                  [ntpp-1 ntpp] 
                  [p-inside-1 p-inside]
                  [outside-1 outside]
                  [inside-1 inside]

                  [p_p1_d p-inside p-inside-1 dc] 
                  [p_p1_e p-inside p-inside-1 ec]
                  [p_i1_d p-inside inside-1 dc]
                  [p_i1_e p-inside inside-1 ec]
                  [p_o1_d p-inside outside-1 dc]
                  [p_o1_e p-inside outside-1 ec]

                  [o_p1_d outside p-inside-1 dc]
                  [o_p1_e outside p-inside-1 ec]
                  [o_i1_d outside inside-1 dc]
                  [o_i1_e outside inside-1 ec]
                  [o_o1_d outside outside-1 dc]
                  [o_o1_e outside outside-1 ec]

                  [i_p1_d inside p-inside-1 dc]
                  [i_p1_e inside p-inside-1 ec]
                  [i_o1_d inside outside-1 dc]
                  [i_o1_e inside outside-1 ec]])

(deftactic topos 
  {proof -> proof}
   proof? -> (fixpoint naive-physics-atp1 (indirect-proof proof?)))

(define naive-physics-atp1
  {proof -> proof}
   proof? -> (c-refl-axiom (c-sym-axiom (naive-physics-atp-help proof?))))

(define naive-physics-atp-help
  {proof -> proof}
  proof? -> (bledsoe (relevant-concepts (head proof?)) zap+ proof?))

(define relevant-concepts
  {sequent -> (list (t-expr -> t-expr))}
  sequent? 
    -> [cxx==>true | (mapcar find-assoc-rewrite-rule 
                  (all-constituents 
                      (predicates-in-sequent sequent?)
                      (eval *hierarchy*)))])

(define find-assoc-rewrite-rule
  {symbol -> (t-expr -> t-expr)} 
    c -> cxy==>cyx 
    p -> pxy==>all_z<czx=>czy> 
    pp -> ppxy==><pxy&~pxy>
    o -> oxy==>some_z<pzx&pzy> 
    ec -> ecxy==>cxy&~oxy 
    dc -> dcxy==>~cxy 
    ntp -> ntpxy==>pxy&~some_z<eczx&eczy>
    dr -> drxy==>~oxy 
    po -> poxy==>oxy&~pxy&~pyx 
    tp -> tpxy==>pxy&some_z<eczx&eczy> 
    tpi -> tpixy==>tpxy&pyx
    tpp -> tppxy==>tpxy&~pyx
    ntpxy -> ntpxy==>pxy&~some_z<eczx&eczy>
    ntpp -> ntppxy==>ntpxy&~pyx 
    ntpi -> ntpixy==>ntpxy&pyx 
    = -> =xy==>pxy&pyx
    tp-1 -> tp-1
    tpp-1 -> tpp-1
    ntpp-1 -> ntpp-1
   
    inside -> inside
    outside -> outside
    p-inside -> p-inside

    inside-1 -> inside-1
    outside-1 -> outside-1
    p-inside-1 -> p-inside-1 

    p_p1_d -> p_p1_d
    p_p1_e -> p_p1_e
    p_i1_d -> p_i1_d
    p_i1_e -> p_i1_e
    p_o1_d -> p_i1_d
    p_o1_e -> p_o1_e 

    o_p1_d -> o_p1_d
    o_p1_e -> o_p1_e
    o_i1_d -> o_i1_d
    o_i1_e -> o_i1_e
    o_o1_d -> o_i1_d
    o_o1_e -> o_o1_e

    i_p1_d -> i_p1_d
    i_p1_e -> i_p1_e
    i_o1_d -> i_o1_d
    i_o1_e -> i_o1_e

    x -> (raise (format nil "~A is not a TOPOS concept" x)))
