; -*- mode:     CL -*- ----------------------------------------------------- ;
; File:         recompile-defsys.l
; Description:  Recompile DEFSYS if necessary
; Author:       Joachim H. Laubsch
; Created:       8-Jul-91
; Modified:     Tue Aug 11 12:05:59 1992 (Joachim H. Laubsch)
; Language:     CL
; Package:      CL-USER
;;; *************************************************************************
;;; Copyright (c) 1989, Hewlett-Packard Company
;;; All rights reserved.
;;;
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted.  Any distribution of this
;;; software or derivative works must comply with all applicable United
;;; States export control laws.
;;; 
;;; This software is made available AS IS, and Hewlett-Packard Company
;;; makes no warranty about the software, its performance or its conformity
;;; to any specification.
;;; 
;;; Suggestions, comments and requests for improvements are welcome
;;; and should be mailed to laubsch@hplabs.com.
;;; *************************************************************************

(in-package "CL-USER")

(proclaim '(optimize (speed 3) (safety 0) (compilation-speed 0)))
;; This just recompiles defsys when necessary

(or (member "expand-file-name" *modules* :test #'string=)
    (let ((*default-pathname-defaults* *DEFSYSTEM-DIRECTORY*))
      (load "expand-file-name.l")))

(let* ((*default-pathname-defaults*
	(pathname (expand-file-name *DEFSYSTEM-DIRECTORY*)))
      #-CCL
      (*cl2loadpath*
       (pathname (expand-file-name
		  (format nil "~A/" (environment-variable "CL2LOADPATH")))))
      (binary-type  #+LUCID (car *load-binary-pathname-types*)
		    #+KCL   "o"
		    #+(or MCL ALLEGRO) "fasl"
		    #-(or LUCID KCL MCL ALLEGRO) "bin")
      (defsystem-directory-binary
	  (make-pathname :directory
			 (append
			  (pathname-directory *default-pathname-defaults*)
			  '("binary"))))
      new)
  #-(or LCL4.0 MCL) (require "defpackage")
  (dolist (f '("expand-file-name" 
	       #-(or LCL4.0 MCL) "defpackage"
	       "P-defsys"
	       "defsys"))
    (let ((source (some #'(lambda (type)
                            (probe-file (format nil "~A.~A" f type)))
                        '("l" "lisp")))
	  (binary (merge-pathnames
		   (make-pathname :name f :type binary-type)
		   defsystem-directory-binary)))
      (when (or new
                ;; the remaining files depend on this one!
                (not (probe-file binary))
                (> (file-write-date source)
                   (file-write-date (probe-file binary))))
        (format t "~%Recompiling ~S to ~S " source binary)
        (setq new t)
        (compile-file source :OUTPUT-FILE binary))
      (require f binary)))

  )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                          End of recompile-defsys.l
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

