; -*- mode:     CL -*- ----------------------------------------------------- ;
; File:         defpackage.l
; Description:  CL defpackage
; Author:       Joachim H. Laubsch
; Created:      20-Sep-91
; Modified:     Tue Aug 11 12:04:31 1992 (Joachim H. Laubsch)
; Language:     CL
; Package:      USER
; RCS $Header: $
;
;;; *************************************************************************
;;; Copyright (c) 1989, Hewlett-Packard Company
;;; All rights reserved.
;;;
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted.  Any distribution of this
;;; software or derivative works must comply with all applicable United
;;; States export control laws.
;;; 
;;; This software is made available AS IS, and Hewlett-Packard Company
;;; makes no warranty about the software, its performance or its conformity
;;; to any specification.
;;; 
;;; Suggestions, comments and requests for improvements are welcome
;;; and should be mailed to laubsch@hplabs.com.
;;; *************************************************************************
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Revisions:
; RCS $Log: $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; still incomplete!!

(in-package "USER")
(provide "defpackage")

(defmacro defpackage (name &rest keylist &aux result)
  `(let ((package 
	  (or (find-package ',name)
	      (make-package
	       ',name
	       ,@(let ((nn (assoc :nicknames keylist)))
		   (when nn
		     `(:nicknames ',(cdr (the cons nn)))))))))
    ,@(dolist (pair (sort keylist
			  #'(lambda (x y)
			      (member y (member x '(:shadow :shadowing-import-from
						    :use :import-from
						    :intern :export))))
			  :key #'car) (nreverse result))
	(let* ((key (car pair))
	       (value (let ((v (cdr pair)))
			(if (every #'(lambda (e)
				       (or (symbolp e) (stringp e)))
				   v)
			    v
			  (error
			   "Key ~S should be followed by (unquoted) symbols or strings, not: ~% ~S"
			   key v))))
	       (cmd (case key
		      (:export `(dolist (x ',value)
				 (export (intern (string x) package)
				  package)))
		      (:unexport `(dolist (x ',value)
				   (unexport (intern (string x) package)
				    package)))
		      (:import-from
		       `(let ((p (find-package ,(car value))))
			 (import (mapcar #'(lambda (s)
					     (or (intern (string s) p)
						 (error "~S not found in ~S" s p)))
				  ',(cdr value))
			  package)))
		      (:shadowing-import-from
		       `(let ((P ',(car value)))
			 (dolist (S ',(cdr value))
			   (let ((A (find-symbol (string S) (find-package P))))
			     (if A
				 (shadowing-import A package)
			       (error "Defining ~A. Trying to do :SHADOWING-IMPORT-FROM ~S ~A, but ~A is not in package ~S" package P S S P))))))
		      (if `(shadowing-import  package))
		      (:shadow           `(shadow ',value package))
		      (:use              `(use-package ',value package))
		      (:unuse            `(unuse-package ',value package))
		      (:nicknames)
		      (T (error "Wrong key in defpackage: ~S" key)))))
	  (when cmd (push cmd result))))
    package))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                             End of defpackage.l
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
