(defmacro with-cursor (was &body body)
     (declare (ignore was))
     `(progn ,@body))

(defmacro with-focused-view (was &body body)
     (declare (ignore was))
     `(progn ,@body))


(defparameter B_DIALOGFENSTER-POSITION-OBEN
     (make-position 10 10))

(defparameter b_stop-icon warning-icon)
(defparameter  *STOP-ICON* warning-icon)         


(defun plist (hugo)
     (symbol-plist hugo))

(defun b=fenster-breite ()
    (window-exterior-width *unser-haupt-fenster*)
     )

(defun b=fenster-hoehe ()
    (window-exterior-height *unser-haupt-fenster*)
     )

(defun b=fenster-einer-fensterklasse (&key class include-invisibles)
     (let ((fenster (windows *unser-haupt-fenster*)))
         (remove-if-not
             #'(lambda(fenster)
                    (and
                            (typep fenster (or class (find-class 'window)))
                            (if include-invisibles
                               t
                              (not  (or (eq (window-state fenster) :shrunk)
                                                          (eq (window-state fenster) :icon))))))
             fenster)))

(defun b=verstecke-fenster-einer-fensterklasse (klasse)
     (remove-if-not
             #'(lambda(fenster)
                    (and
                            (typep fenster klasse)
                            (or (eq (window-state fenster) :shrunk)
                                                          (eq (window-state fenster) :icon))))
         (windows *unser-haupt-fenster*)))

(defun map-windows (funktion &key (class 'window)
                                      (include-invisibles nil))
     (when (find-class class nil)
     (dolist (fenster
                    (b=fenster-einer-fensterklasse :class class :include-invisibles include-invisibles))
          (funcall funktion fenster))))

;; mit irgendeinem cursor
;; wenn fenster gesetzt ist, wird dieses genommen
;; vorsicht, wenn das fenster im BODY geschlossen wird!!
;; ansonsten (default) wird das momentan selektierte
;; Kind-fenster des aktuellen applikationsfenster genommen.
;; alles klar??
(defmacro b=mit-cursor ((&key (cursor waiting-cursor)
                                            fenster) &body body)
     `(let* ((win (if ,fenster ,fenster
                               (SELECTED-WINDOW (pc::selected-window-or-screen))))
              (alter-cursor (cursor win))
              )
          (set-cursor win ,cursor)
          (unwind-protect
                  (progn
                      ,@body)
               (when (windowp win)
                    (set-cursor win alter-cursor))
               )))

(defun B=MENUEPUNKT-SEPARATOR-ERZEUGEN ()
      menu-separator)


(defun b=windows (&key (class nil) (include-invisibles nil))
     (b=fenster-einer-fensterklasse :class class :include-invisibles include-invisibles))
                           
         
(defun b=schrift-mit-style (schrift style)
     (declare (ignore style))
     schrift)


(defun b=grosser-Bildschirm-p ()
     (when (> *screen-width* 640)
          t)
     )

(defun b=Standard-Fensterposition ()
     (make-point 4 4))
