(defclass view-widget (mac-dialog-item-mixin cg:dialog-item)
      ())

(defclass *b-view* (view-widget)
      ())

(defclass view-widget-pane (*at-fenster*)
      ()
     (:default-initargs
      :user-resizable nil
      :user-movable nil
      :user-scrollable nil))


(defclass view-widget-pane-mit-horizontal-scroller (view-widget-pane)
      ()
     (:default-initargs
      :window-border :plain-dialog-box
      :user-scrollable :horizontal))


(defclass view-widget-pane-mit-vertikal-scroller (view-widget-pane)
      ()
     (:default-initargs
      :window-border :plain-dialog-box
      :user-scrollable :vertical))

(defclass view-widget-pane-mit-beiden-scroller (view-widget-pane)
      ()
     (:default-initargs
      :window-border :plain-dialog-box
      :user-scrollable t))


(defclass *b-view-mit-scroller* (*b-view*)
      (
       (pane-type :accessor pane-type)
       )
     )

(defmethod initialize-instance ((ich *b-view-mit-scroller*)
                                                 &rest init-list
                                                 &key 
                                                 (v-scrollp t)
                                                 (h-scrollp t)
                                                 )
     (setf (pane-type ich)
             (cond ((and h-scrollp v-scrollp)
                       'view-widget-pane-mit-beiden-scroller)
                      (h-scrollp 
                          'view-widget-pane-mit-horizontal-scroller)
                      (v-scrollp
                          'view-widget-pane-mit-vertikal-scroller)
                      (t  'view-widget-pane)))
     (call-next-method)
     )

(defmethod widget-device ((item view-widget) dialog)
     'view-widget-pane)


(defmethod widget-device ((item *b-view-mit-scroller*) dialog)
     (pane-type item))

;Wegen Fehler in ACL/PC notwendig, dass Fenster in Fenster welche gescrollt sind
;nicht richtig reinkommen


(defun b-point-zerop (point)
   (and (= 0 (position-x point))
        (= 0 (position-y point)))
   )

(defmethod set-view-container :after ((widget view-widget) fenster)
   #+:aclnt
   (when fenster
      (set-view-position (dialog-item-window widget) (view-position widget)))
 )

(defmethod set-view-position ((ich view-widget) h &optional v)
  (call-next-method)
   )

(defmethod view-position ((ich view-widget))
   (call-next-method))


(defmethod set-view-container ((widget mac-dialog-item-mixin) (ich view-widget))
     (set-view-container widget (dialog-item-window ich))
     )

(defmethod set-field-size ((ich view-widget) h &optional v)
     (when (dialog-item-window ich)
     (set-field-size (dialog-item-window ich) h v)))

(defmethod view-scroll-position ((ich view-widget))
     (view-scroll-position (dialog-item-window ich)))

(defmethod add-subviews ((ich view-widget) &rest egal)
     (apply #'add-subviews (dialog-item-window ich) egal))

(defmethod dialog-items ((ich view-widget))
     (dialog-items (dialog-item-window ich)))


(defmethod dialog-items (tt)
     nil)
#|
(defvar fenster)
(defvar subview)

(setq fenster
     (m->a=erzeuge-fenster '*b-window*
        :user-scrollable t))

(setq subview (m->a=erzeuge-dialog-item
                        '*b-view-mit-scroller*
                        :view-position (make-point 10 10)
                        :view-size (make-point 200 200)))

(dialog-item-box subview)

(add-widget  subview fenster)

(setq subview1 (m->a=erzeuge-dialog-item
                        '*b-view-mit-scroller*
                        :view-position (make-point 220 10)
                        :view-size (make-point 200 200)))


(add-subviews fenster subview1)

(view-position subview)
(add-subviews subview
    (m->a=erzeuge-dialog-item '*b-auswahl-light*
      ;  :wert 'b
       :view-font (make-font nil nil 30)
        :auswahlelemente '(a b c d e)))

(set-view-position subview (make-point 50 50))

(set-view-position subview (make-point 100 100))
(view-position subview)
(view-scroll-position fenster)

(m->a=erzeuge-fenster '*b-window*
     :view-subviews
     (list (setq hugo
                 (m->a=erzeuge-dialog-item
             '*b-view-mit-scroller*
                 ; :h-scroller t :v-scroller nil
                   :h-scroller nil :v-scroller t
                  :view-size (make-point 100 100)
                  :view-position (make-point 0 0)))))

|#