;Implementierung einer einfachen Hierarchie, bei der Knoten und Linien selektiert werden koennen

#+:aclpc
(defclass *b-hierarchie-window* (*b-hierarchie-window-light*)
      ()
     )

#+:aclpc
(defmethod initialize-instance ((ich *b-hierarchie-window*) &rest init-list
                                &key Default-Fensterposition Fensterhoehe F-Vorgaenger
                                Objekt-Einmal-P Linientypen-Layout F-Linientyp Objekttypen-Layout
                                F-Objekttyp Selektionstyp-Linien F-Doppelklick-Objekt)
  (declare (ignore Default-Fensterposition Fensterhoehe F-Vorgaenger
                   Objekt-Einmal-P Linientypen-Layout F-Linientyp Objekttypen-Layout
                   F-Objekttyp Selektionstyp-Linien F-Doppelklick-Objekt)
           #-:aclpc (ignore init-list))
  (call-next-method))

#+:aclpc
(defmethod Alles-Deselektieren ((ich *b-hierarchie-window*))
  )

#+:aclpc
(defmethod Objekttransfer-Aktiv-P ((ich *b-hierarchie-window*))
  nil
  )


(defclass *b-hierarchie-window-light* (*b-graphics-window*)
  ())


(defmethod initialize-instance ((ich *b-hierarchie-window-light*) &rest init-list
                                &key
                                ;fuer den scroller
                                (scroller '*hi-scroller-view*)
                                (f-objektname #'b=erzeuge-string)
                                (selektionstyp :single)
                                f-selektionstyp
                                f-pop-up-menue
                                (pop-up-menu-anfang :rechts)
                                absolutes-anfangsobjekt
                                f-nachfolger
                                knoten-liste
                                linien-liste
                                scroller-field-size
                                ;fuer mich selbst
                                (HIERARCHIENAME "Eine Hierarchie")
                                )
  (apply #'call-next-method ich
         (init-list-default init-list
                            :window-title HIERARCHIENAME
                            :scroller scroller
                            :scroller-parameter
                            (list 
                             :f-objektname f-objektname
                             :selektionstyp selektionstyp
                             :f-selektionstyp f-selektionstyp
                             :f-pop-up-menue f-pop-up-menue
                             :pop-up-menu-anfang pop-up-menu-anfang
                             :absolutes-anfangsobjekt absolutes-anfangsobjekt
                             :f-nachfolger f-nachfolger
                             :knoten-liste knoten-liste
                             :linien-liste linien-liste
                             :scroller-field-size scroller-field-size
                             )))
  
  )
  
(defclass *hi-scroller-view* (*b-scroller-view*)
  (
   (f-objektname :initform #'b=erzeuge-string 
                 :initarg :f-objektname
                 :accessor hi-f-objektname)
   (selektionstyp :initarg :selektionstyp :initform :single :Accessor hi-selektionstyp)
   (f-selektionstyp :initarg :f-selektionstyp :initform nil :accessor f-selektionstyp)
   (selektionstyp-linie :initarg :selektionstyp-linie :initform :single :Accessor hi-selektionstyp-linie)
   ;:nicht-selektierbar , :single , :multiple, :pop-up-menu
   (f-pop-up-menue :initarg :f-pop-up-menue :initform nil :accessor f-pop-up-menu-funktion)
   (pop-up-menu-anfang :initarg :pop-up-menu-anfang :initform :rechts :accessor pop-up-menu-anfang)
   ;; :rechts, :unterhalb, echter punkt
   
   ;lokal zur Effienzsteigerung
   (kn-hash :initform (make-hash-table) :accessor hi-kn-hash)
   (kn-liste :initarg :knoten-liste :accessor hi-kn-liste)
   (selektierte-knoten :initform nil :accessor hi-selektierte)
   (selektierte-linien :initform nil :accessor hi-selektierte-linien)
   (linien-liste :initarg :linien-liste :accessor hi-linien-liste)
   
   ;
   (modus :accessor hi-modus)
   )
  )

(defstruct hi-knoten-info ;(:conc-name hi-)
  links-oben
  rechts-unten
  text-anfang
  )

(defun hi-berechne-knoten-und-linien-liste (anfang nachfolger-fn)
     (let ((merker (make-hash-table))
            (linien-liste)
            (kn-liste)
            (x-pos 10)
            (y-pos 10)
            (inkrement-x 70)
            (inkrement-y 20)
            (max-x 10)
            )
         (labels ((rek (knoten funk pos-x )
                    (let ((kinder (funcall funk knoten))
                          )
                      (setq max-x (max max-x pos-x))
                      (unless (gethash knoten merker)
                        (cond (kinder
                               
                               (setf (gethash knoten merker) t)
                               (push `(,knoten ,(make-point pos-x y-pos)) kn-liste)
                               ;(incf y-pos inkrement-y)
                               
                               (dolist (var kinder)
                                 (incf y-pos inkrement-y)
                                 (push `(,knoten ,var) linien-liste)
                                 (rek var funk (+ pos-x inkrement-x))))
                              (t
                               (setf (gethash knoten merker) t)
                               (push `(,knoten ,(make-point pos-x y-pos)) kn-liste))))))
                      )
            (rek anfang nachfolger-fn x-pos)
         (values kn-liste linien-liste max-x y-pos)
         )
     ))

(defmethod initialize-instance ((ich *hi-scroller-view*)
                                &rest init-list
                                &key absolutes-anfangsobjekt f-nachfolger scroller-field-size)
  (remf init-list :field-size) 
  (cond ((and absolutes-anfangsobjekt f-nachfolger)
         (multiple-value-bind
           (kn-liste linien-liste  max-x y-pos)
           (hi-berechne-knoten-und-linien-liste absolutes-anfangsobjekt f-nachfolger)
           (apply #'call-next-method
                  ich
                  (init-list-default init-list
                                     :field-size (make-point (+ 250 max-x) (+ 50 y-pos))))
           (setf (hi-modus ich) :hierarchie)
           (setf (hi-kn-liste ich) kn-liste)
           (setf (hi-linien-liste ich) linien-liste)
           ))
        (T
         (apply #'call-next-method
                ich
                (init-list-default init-list
                                   :field-size scroller-field-size
                                   ))
         (setf (hi-modus ich) :graph)
         ))
  )

  
(defmethod hi-hash-tabelle-belegen ((ich *hi-scroller-view*) kn-liste)
  (multiple-value-bind 
    (ascent descent max-width leading)
    (b=view-font-info ich)
    (declare (ignore max-width))
    (let ((subtrahiere (+  ascent  leading 1))
           (wie-hoch (+ ascent descent leading )))
      (dolist (var kn-liste)
        (let ((knoten (first var))
              (x (point-h (second var)))
              (y (point-v (second var)))
              (string (funcall (hi-f-objektname ich) (first var))))
          (setf (gethash knoten (hi-kn-hash ich))
                (make-hi-knoten-info
                 :text-anfang (make-point x (+ y subtrahiere))
                 :links-oben (make-point (- x 3) y)
                 :rechts-unten (make-point (+ x 2(hi-string-breite string ich )) (+ y wie-hoch 1))
                 )) 
          ))
      )))

#+:aclpc
(defun hi-string-breite (string stream)
  (stream-string-width stream string)
  )

#+:ccl-2
(defun hi-string-breite (string stream)
  (string-width string (view-font stream)))


(defmethod hi-Bild-zeichnen ((ich *hi-scroller-view*))
     (when (hi-kn-liste ich)
          (hi-hash-tabelle-belegen ich (hi-kn-liste ich))
          (setf (hi-kn-liste ich) nil))
     (with-focused-view ich
      (maphash #'(lambda (key wert)
                              (hi-knoten-malen ich wert (funcall (hi-f-objektname ich) key))
                              )
            (hi-kn-hash ich))
      (multiple-value-bind 
              (ascent descent max-width leading)
             (b=view-font-info ich)
            (declare (ignore max-width))
            (let ((wie-hoch (+ ascent descent leading )))      
                (dolist (paar (hi-linien-liste ich))
                     (hi-linie-malen ich  (first paar) (second paar) wie-hoch))))))


(defmethod view-draw-contents ((ich *hi-scroller-view*))
  (hi-Bild-zeichnen ich))

(defmethod view-draw-contents :after ((ich *hi-scroller-view*))
  (hi-alle-knoten-invertieren ich)
  (hi-alle-linien-invertieren ich)
  )

(defmethod hi-knoten-nach-linie-anfangs-punkt ((ich *hi-scroller-view*) knoten wie-hoch)
  (ecase (hi-modus ich)
    (:hierarchie
     (add-points (hi-knoten-info-links-oben (gethash knoten (hi-kn-hash ich)))
                 (make-point 0 wie-hoch)))
    (:graph (subtract-points (hi-knoten-info-rechts-unten (gethash knoten (hi-kn-hash ich)))
              (make-point 0 (ash wie-hoch -1))))))

(defmethod hi-knoten-nach-linie-end-punkt ((ich *hi-scroller-view*) knoten)
  (hi-knoten-info-links-oben (gethash knoten (hi-kn-hash ich))))

#+:aclpc
(defmethod event ((ich *hi-scroller-view*) event buttons data time)
      (select event
           (mouse-right-down
                 (let ((box  (get-box ich t t (COPY-POSITION data)))
                        )
                     (when box
                          (hi-selektiere-knoten-in-region ich box)))
                 (call-next-method))
           (t (call-next-method))))

#+:aclpc
(defun hi-selektiere-knoten-in-region (ich region)
  (maphash #'(lambda (key value)
               (when (hi-struct-in-box-p value region)
                 (if (member key (hi-selektierte ich))
                   (hi-knoten-deselektieren&loeschen ich key)
                   (hi-knoten-selktieren&eintragen ich key))
                 ))
           (hi-kn-hash ich))
  )

#+:aclpc
(defun hi-struct-in-box-p (value region)
     (box-intersect
          (make-box-from-corners
                (hi-knoten-info-links-oben value)
                (hi-knoten-info-rechts-unten value))
          region)
     )

(defmethod view-click-event-handler ((ich *hi-scroller-view*) point)
     (call-next-method)
     (let ((knoten (unless (eq (hi-selektionstyp ich) :nicht-selektierbar)
                             (Block :hashtabelle
                                 (maphash #'(lambda(key value)
                                                         (when (hi-punkt-im-rechtseck-p  value point)
                                                              (return-from :hashtabelle key)))
                                       (hi-kn-hash ich))))))
         (cond (knoten
                       (hi-klick-auf-knoten ich knoten))
                  (t
                     (let* ((versatz (b=stream-schrifthoehe ich))
                             (linie
                                (unless (eq (hi-selektionstyp-linie ich) :nicht-selektierbar)
                                     (dolist (linie  (hi-linien-liste ich))
                                          (let ((von (hi-knoten-nach-linie-anfangs-punkt ich (first linie) versatz))
                                                 (bis (hi-knoten-nach-linie-end-punkt ich (second linie))))
                                              (when (hi-punkt-auf-linie-p  point von bis 4)
                                                   (return linie))))))
                             )
                         (cond (linie
                                     (hi-klick-auf-linie ich linie)
                                     )
                                  (t
                                     (hi-alles-deselektieren&loeschen ich))))))))

(defmethod hi-klick-auf-knoten ((ich *hi-scroller-view*) knoten)
  ;ich habe auf einen Knoten geklickt
  (case (or (and (f-selektionstyp ich)
                         (funcall (f-selektionstyp ich) knoten)
                         )
                  (hi-selektionstyp ich))
      (:single
     ;alle alten loeschen
     (cond ((member knoten (hi-selektierte ich))
            (hi-alle-knoten-deselektieren&loeschen ich))
           (T
            (hi-alle-knoten-deselektieren&loeschen ich)
            (hi-knoten-selktieren&eintragen ich knoten))))
    (:multiple
     (if (member knoten (hi-selektierte ich))
       (hi-knoten-deselektieren&loeschen ich knoten)
       (hi-knoten-selktieren&eintragen ich knoten)))
      (:pop-up
       (when (f-pop-up-menu-funktion ich)
            (let ((menu (funcall (f-pop-up-menu-funktion ich) knoten))
                   )
                (when menu
                     (multiple-value-bind (pos breite hoehe)
                            (hi=knoten-masse ich knoten)
                            (b=Pop-up-Menue-aufklappen ich menu
                                  (case (pop-up-menu-anfang ich)
                                      (:rechts 
                                       (add-points pos (make-point breite 0)))
                                      (:unterhalb
                                       (add-points pos (make-point 0 hoehe)))
                                      (t
                                         (add-points pos  (pop-up-menu-anfang ich)))
                                       )))))
                )
            ))
      )
      
(defun hi=knoten-masse (ich knoten)
     (let* ((struct (gethash knoten (hi-kn-hash ich)))
             (links-oben (hi-knoten-info-links-oben struct))
             (rechts-unten (hi-knoten-info-rechts-unten struct))
             (breite (- (point-h rechts-unten) (point-h links-oben)))
             (hoehe (- (point-v rechts-unten) (point-v links-oben)))
             )
         (values links-oben breite hoehe)
         ))

      
(defmethod hi-klick-auf-linie ((ich *hi-scroller-view*) linie)
  ;ich habe auf eine Linie geklickt
  (case (hi-selektionstyp-linie ich)
    (:single
     ;alle alten loeschen
     (cond ((hi-linie-selektiert-p ich linie)
            (hi-alle-linien-deselektieren&loeschen ich))
           (t (hi-alle-linien-deselektieren&loeschen ich)
              (hi-linie-selktieren&eintragen ich linie))))
    (:multiple
     (if (member linie (hi-selektierte ich))
       (hi-linie-deselektieren&loeschen ich linie)
       (hi-linie-selktieren&eintragen ich linie))))
  )

(defun hi-punkt-auf-linie-p (punkt punkt-1 punkt-2 delta)
  (b=punkt-auf-linie-p punkt punkt-1 punkt-2 :delta delta))
  

(defmethod hi-knoten-deselektieren&loeschen ((ich *hi-scroller-view*) knoten)
  (setf (hi-selektierte ich) (delete knoten (hi-selektierte ich)))
  (hi-knoten-invertieren ich knoten))

(defmethod HI-LINIE-DESELEKTIEREN&LOESCHEN ((ich *hi-scroller-view*) linie)
  (setf (hi-selektierte-linien ich) (delete linie (hi-selektierte ich)
                                            :test #'(lambda(a b)
                                                      (and (eq (first a)(first b))
                                                           (eq (second a)(second b))))))
  (hi-linie-deinvertieren ich (first linie)(second linie)))

(defmethod hi-linie-selektiert-p ((ich *hi-scroller-view*) linie)
  (member linie (hi-selektierte-linien ich)
          :test #'(lambda(a b)
                    (and (eq (first a)(first b))
                         (eq (second a)(second b))))))



(defmethod hi-knoten-selktieren&eintragen ((ich *hi-scroller-view*) knoten)
  (push  knoten (hi-selektierte ich))
  (hi-knoten-invertieren ich knoten))

(defmethod hi-linie-selktieren&eintragen ((ich *hi-scroller-view*) linie)
  (push linie (hi-selektierte-linien ich))
  (hi-linie-invertieren ich (first linie)(second linie)))
           
(defmethod hi-alle-knoten-deselektieren&loeschen ((ich *hi-scroller-view*))
  (hi-alle-knoten-invertieren ich)
  (setf (hi-selektierte ich) nil))

(defmethod hi-alle-linien-deselektieren&loeschen ((ich *hi-scroller-view*))
  (hi-alle-linien-deinvertieren ich)
  (setf (hi-selektierte-linien ich) nil))

(defmethod hi-alles-deselektieren&loeschen ((ich *hi-scroller-view*))
  (hi-alle-knoten-deselektieren&loeschen ich)
  (hi-alle-linien-deselektieren&loeschen ich))

(defmethod selektierte-objekte ((ich *hi-scroller-view*))
  (hi-selektierte ich))

(defmethod selektierte-linien ((ich *hi-scroller-view*))
  (hi-selektierte-linien ich))

(defmethod selektierte-objekte ((ich *b-hierarchie-window-light*))
  (selektierte-objekte (view ich)))

(defmethod selektierte-linien ((ich *b-hierarchie-window-light*))
  (selektierte-linien (view ich)))


#|
(defparameter hi-window nil)


(setq hi-window 
      (m->a=erzeuge-fenster `*b-hierarchie-window-light*
                            :buttons (list (m->a=erzeuge-dialog-item
                                            '*b-ok-button*
                                            :dialog-item-action
                                            #'(lambda(knopf)
                                                (declare (ignore knopf))
                                                (print (selektierte-objekte hi-window))
                                                (window-close hi-window))))
                            :selektionstyp :multiple
                            :f-nachfolger #'class-direct-subclasses
                            :f-objektname #'(lambda(klasse)
                                              (string (class-name klasse)))
                            :absolutes-anfangsobjekt (find-class 't))
      )



(setq hi-window (m->a=erzeuge-fenster `*b-hierarchie-window-light*
                                      :buttons (list (m->a=erzeuge-dialog-item
                                                      '*b-ok-button*
                                                      :dialog-item-action
                                                      #'(lambda(knopf)
                                                          (print (selektierte-linien (view-container knopf)))
                                                          (window-close (view-container knopf)))))
                                      :selektionstyp :pop-up
                                      :f-nachfolger #'class-direct-subclasses
                                      :f-objektname #'(lambda(klasse)
                                                        (string (class-name klasse)))
                                      :f-pop-up-menue #'(lambda (x)
                                                          (hi-menu x))                              
                                      :absolutes-anfangsobjekt (find-class 'window)))

#+:aclpc
(defun hi-menu (knoten)
     (open-menu
          (list
             (make-menu-item
                   :title "Inspect"
                   :name :inspect
                   :value :inspect
                   )
             (make-menu-item
                   :title "Edit"
                   :name :Edit
                   :value :Edit)
             (make-menu-item
                   :title "Lambda"
                   :name :lambda
                   :value :lambda)
             (make-menu-item
                   :title "Describe"
                   :name :describe
                   :value :describe)
             )
          'pop-up-menu
          *Screen*
          :selection-function
          #'(lambda (menu menu-item screen)
                 (hi-selection menu menu-item screen (class-name knoten)))
          ))

#+:ccl-2
(defun hi-menu (knoten)
  (make-instance '*b-pop-up-menu*
    :menu-items
    (list
     (make-instance '*b-menu-item*
       :MENU-ITEM-TITLE "Inspect"
       :menu-item-action #'(lambda()
                             (inspect knoten))
       )
     (make-instance '*b-menu-item*
       :MENU-ITEM-TITLE "Edit"
       :menu-item-action #'(lambda()
                             (edit-definition (class-name knoten)))
       ))))

#+:aclpc
(defun hi-selection (menu menu-item screen wert)
     (declare (ignore menu screen))
     (when wert
          (case (menu-item-value menu-item)
              (:inspect
               (inspect wert))
              (:edit
               (when (fboundp wert)
                    (ed wert)))
              (:lambda
               (acl::display-lambda-list wert))
              (:describe
               (ACL::DISPLAY-DESCRIBE wert))
              (t nil))))

|#