
;; scroller-view funktionen fuer mac
#|
Malmethoden und Konsorten
|#

#+:ccl-2
(defun b=view-font-info (view)
  (font-info (view-font view)))

#+:ccl-2
(defun b=fenster-schrifthoehe (view)
  (b=schrifthoehe (view-font view)))

#+:ccl-2
(defun hi-punkt-im-rechtseck-p (value point)
  (ccl::with-rectangle-arg
    (r (hi-knoten-info-links-oben value)(hi-knoten-info-rechts-unten value))
    (point-in-rect-p  r point))
  )

#+:ccl-2
(defun hi-knoten-malen (ich wert text)
  (declare (ignore ich))
  (#_moveto :long (hi-knoten-info-text-anfang wert))
  (with-pstrs ((string text))
    (#_DrawString :ptr string))
  (ccl::with-rectangle-arg
    (r (hi-knoten-info-links-oben wert)(hi-knoten-info-rechts-unten wert))
    (#_FrameRect r))
  )

#+:ccl-2
(defmethod hi-alle-knoten-invertieren ((ich *hi-scroller-view*))
  (with-focused-view ich
    (dolist (knoten (hi-selektierte ich))
      (let ((knotenobjekt (gethash knoten (hi-kn-hash ich))))
        (ccl::with-rectangle-arg (rechteck (hi-knoten-info-links-oben knotenobjekt)(hi-knoten-info-rechts-unten knotenobjekt))
          (#_InvertRect rechteck))))))

#+:ccl-2
(defmethod hi-knoten-invertieren ((ich *hi-scroller-view*) knoten)
  (with-focused-view ich
    (let ((knoten (gethash knoten (hi-kn-hash ich))))
      (ccl::with-rectangle-arg (rechteck (hi-knoten-info-links-oben knoten)(hi-knoten-info-rechts-unten knoten))
        (#_InvertRect rechteck)))))


#+:ccl-2
(defun hi-linie-malen (ich von-objekt bis-objekt &optional (wie-hoch (b=schrifthoehe (view-font ich))))
  (let ((von  (hi-knoten-nach-linie-anfangs-punkt ich von-objekt wie-hoch))
        (bis  (hi-knoten-nach-linie-end-punkt ich bis-objekt)))
    (#_moveto :long von)
    (#_lineto :long bis)))

#+:ccl-2
(defmethod hi-linie-invertieren ((ich *hi-scroller-view*) von nach)
  (multiple-value-bind 
    (ascent descent max-width leading)
    (font-info (view-font ich))
    (declare (ignore max-width))
    (let* ((wie-hoch (+ ascent descent leading ))     
           (pattern (pen-pattern ich))
           )
      (with-focused-view ich
        (#_PenPat *light-gray-pattern*)
        (hi-linie-malen ich von nach wie-hoch)
        (#_PenPat pattern)
        )))
  )

#+:ccl-2
(defmethod hi-linie-deinvertieren ((ich *hi-scroller-view*) von nach)
  (multiple-value-bind 
    (ascent descent max-width leading)
    (font-info (view-font ich))
    (declare (ignore max-width))
    (let* ((wie-hoch (+ ascent descent leading ))     
           (pattern (pen-pattern ich))
           )
      (with-focused-view ich
        (#_PenPat *black-pattern*)
        (hi-linie-malen ich von nach wie-hoch)
        (#_PenPat pattern)
        )))
  )



#+:ccl-2
(defmethod hi-alle-linien-deinvertieren ((ich *hi-scroller-view*))
  (multiple-value-bind 
    (ascent descent max-width leading)
    (font-info (view-font ich))
    (declare (ignore max-width))
    (let* ((wie-hoch (+ ascent descent leading ))     
           (pattern (pen-pattern ich))
           )
      (with-focused-view ich
        (#_PenPat *black-pattern*)
        (dolist (linie (hi-selektierte-linien ich))
          (hi-linie-malen ich (first linie) (second linie) wie-hoch))
        (#_PenPat pattern)))))

#+:ccl-2
(defmethod hi-alle-linien-invertieren ((ich *hi-scroller-view*))
  (multiple-value-bind 
    (ascent descent max-width leading)
    (font-info (view-font ich))
    (declare (ignore max-width))
    (let* ((wie-hoch (+ ascent descent leading ))     
           (pattern (pen-pattern ich))
           )
      (with-focused-view ich
        (#_PenPat *light-gray-pattern*)
        (dolist (linie (hi-selektierte-linien ich))
          (hi-linie-malen ich (first linie) (second linie) wie-hoch))
        (#_PenPat pattern)))))