#|
********************************************************************************
********************************************************************************
*****                                                                      *****
*****                        Dialogfunktion b=ja-nein-fenster              *****
*****                                                                      *****
*****    Autor: Klaus Goos                         Erstellt: 17.4.90       *****
*****           Klaus Goos                         Geaendert:  9.7.91       *****
*****                                                                      *****
********************************************************************************
********************************************************************************

Veraendert Karsten 14.2.91
Falls Text nicht mehr auf dem Bildschirm passt, wird er abgeschnitten

Portiert auf den AT - erste Version ; bambi 14.4.94
zweite Version Karsten 19.0.94
|#

(defclass *b-ja-nein-Fenster* (#+:ccl-2 *b-Selbstantwort-mixin* 
                               *b-window*)
    ())


(defun b=aenderungen-uebernehmen-ja-nein ()
   (b=ja-nein (b=s :aenderungen_uebernehmen?) :default-button :ja))

(defvar b_ja-nein-Fenster)
(defvar b_Frage-Icon)
(unless (boundp 'b_Frage-Icon)
   (setq b_Frage-Icon question-icon))

(defun b=ja-nein (fragetext &key (icon b_Frage-Icon)
                    (ja-text (b=s :ja))
                    (nein-text (b=s :nein))
                    (default-button NIL)
                    (abbrechen-text (b=s :abbrechen))
                    (fensterposition b_Dialogfenster-Position-oben)
                    (fensterbreite 350)
                    (schrift b_Chicagoschrift)
                    (throw-to-cancel t)
                    (sekunden nil)
                    (button-breite 90))
   #|Autor: Klaus, 17.04.90, letzte Aenderung 7.2.91 Klaus

Eingabeparameter:
- Fragetext:       Fragetext fuer den Benutzer
- Icon             Beliebiges Icon; default ist b-Nachrichten-Icon
- Ja-text:         Text des Ja-buttons (default: "Ja")
- Nein-text:       Text des Nein-buttons (default: "Nein")
Wenn Nein-text = nil -> ein Nein-button
erscheint nicht.
- Default-button   :ja fuer Ja-Button, :nein fuer Nein-Button
- Abbrechen-text:  Text des Abbrechen-buttons (default: "Abbrechen")
Wenn Abbrechen-text = nil -> ein Abbrechen-button
erscheint nicht.
- throw-to-cancel  t (= default) bedeutet, dass bei Abbrechen ein throw nach 
toplevel erfolgt (:cancel; genauso wie bei select-item-
from-list). Bei throw-to-cancel = nil wird bei Abbrechen
nil als Ergebnis zurueckgeliefert.
- Fensterposition: Position des Fensters = `(:top 50)
- Fensterbreite:   die Breite des Fensters in Pixel.
(Die Fensterhoehe wird immer automatisch berechnet)
- schrift:         (default = b_Chicagoschrift)

Ausgabe:
Liefert bei Anklicken des Ja-Buttons :Ja
Liefert bei Anklicken des Nein-Buttons :Nein
Liefert bei Anklicken des Abbrechen-Buttons Cancelled bzw. NIL 
entsprechend dem Flag Throw-to-cancel

Bemerkungen:
- Icon-pos:        Position des Icons im Dialog  = #@(10 10)

|#  

(let* ((icon-groesse 32)
       (button-hoehe 20)
       (button-size (make-point button-breite button-hoehe))
       (icon-pos #@(10 10))
       (text-breite (- fensterbreite (+ icon-groesse (* 3 (point-h icon-pos))))))
   (multiple-value-bind
        (text-item text-hoehe)
       (b=static-text fragetext text-breite 
          (+ icon-groesse (* 2 (point-h icon-pos)) )
          (point-v icon-pos) :font schrift)
      (let* ((fensterhoehe (+ text-hoehe (* 2 button-hoehe) (* 5 (point-v icon-pos))))
             (fensterhoehe1 (if (and sekunden abbrechen-text)
                               (+ fensterhoehe 30)
                               fensterhoehe)))
         
         (if (and (boundp 'b_ja-nein-Fenster)
                  (wptr b_ja-nein-Fenster))
            (progn
               #+:ccl-2 (sekunden-setzen b_ja-nein-fenster nil)
               (apply #'remove-subviews b_ja-nein-Fenster (subviews b_ja-nein-Fenster))
               #+:ccl-2 (sekunden-setzen b_ja-nein-fenster sekunden)
               (set-view-size b_ja-nein-Fenster (make-point fensterbreite fensterhoehe1)))
            (setq b_ja-nein-Fenster (m->a=erzeuge-modal-fenster
                                     '*b-ja-nein-Fenster*
                                     :window-title "Eingabe"
                                     :view-position fensterposition
                                     :window-show nil
                                     :view-size (make-point fensterbreite fensterhoehe1)
                                     :window-type :double-edge-box
                                     #+:ccl-2 :sekunden #+:ccl-2 sekunden
                                     )))
         
         
         (set-view-position b_ja-nein-Fenster fensterposition)
         ;Vielleicht passt das ganze nicht mehr auf dem Bildschirm ==> ueberpruefen
         (let* ((y-position (point-v (view-position b_ja-nein-Fenster)))
                (maximale-fensterhoehe (- *screen-height* y-position 10)))
            (when (> fensterhoehe maximale-fensterhoehe)
               ;Fenster passt nicht mehr auf dem Bildschirm !
               (let ((zu_gross (- fensterhoehe maximale-fensterhoehe)))
                  (-= fensterhoehe zu_gross)
                  (-= text-hoehe zu_gross)
                  (set-view-size b_ja-nein-Fenster (make-point fensterbreite fensterhoehe))
                  (set-view-size text-item (make-point (point-h (view-size text-item)) text-hoehe))
                  (set-dialog-item-text text-item 
                     (b-drei-punkte-einfuegen (dialog-item-text text-item) 
                        text-hoehe (b=schrifthoehe schrift)))
                  )))
         (add-subviews b_ja-nein-Fenster
            (m->a=erzeuge-dialog-item '*b-icon-dialog-item*
               :icon icon
               :view-position icon-pos
               ;:dialog-item-enabled-p nil;damit das icon nicht selektiert werden kann. (Bertil)
               )
            (m->a=erzeuge-dialog-item '*b-button*
             :dialog-item-text ja-text
             :default-button (eq default-button ':ja)
             :view-size button-size
             :view-position (make-point (- fensterbreite (+ (point-h icon-pos) button-breite))
                               (- fensterhoehe (+ (point-v icon-pos) button-hoehe)))
             :dialog-item-action #'(lambda (self)
                                      (declare (ignore self))
                                      (return-from-modal-dialog :ja))))
         
         (when nein-text (add-subviews b_ja-nein-Fenster
                            (m->a=erzeuge-dialog-item '*b-button*
                             :dialog-item-text nein-text
                             :default-button (eq default-button ':nein)
                             :view-size button-size
                             :view-position (make-point (- fensterbreite (+ (point-h icon-pos) button-breite))
                                               (- fensterhoehe (* 2 (+ (point-v icon-pos) button-hoehe))))
                             :dialog-item-action #'(lambda (self)
                                                      (declare (ignore self))
                                                      (return-from-modal-dialog :nein)))))
         (when abbrechen-text (add-subviews b_ja-nein-Fenster
                                 (m->a=erzeuge-dialog-item '*b-button*
                                  :dialog-item-text abbrechen-text
                                  :view-position (make-point (point-h icon-pos)
                                                    (- fensterhoehe (+ (point-v icon-pos) button-hoehe)))
                                  :view-size button-size
                                  :dialog-item-action #'(lambda (self)
                                                           (declare (ignore self))
                                                           (if throw-to-cancel
                                                              (return-from-modal-dialog :cancel)
                                                              (return-from-modal-dialog nil))))))
         (add-subviews b_ja-nein-Fenster text-item)
         (with-cursor *arrow-cursor*
            (modal-dialog b_ja-nein-Fenster NIL))))))



#| 
********************************************************************************
********************************************************************************
Beispiel:

(b=ja-nein "Wollen Sie die Auto-Wissensbasis laden ?")
(b=ja-nein "Wollen Sie die Auto-Wissensbasis laden ?" 
   :abbrechen-text NIL :default-button ':ja :sekunden 5)
(b=ja-nein "dkj" :icon warning-icon :Fensterbreite 700)

(b=ja-nein   "dkj
asdasd1
asd2
asd3
asd4
asd5
asd6
asd7
asd8
asd9
asd10" 
   :fensterposition (make-point 10 500)
   :button-breite 150
   )

********************************************************************************
********************************************************************************
|#
