#|
History

defaultbildgroesse auf Bildschirmhoehe - 150 gesetzt gesetzt
dialog-item-wert-setzen ((ich *b-bildindex-sequence*) positionen) mit scrollen
|#

#|

Ideensammlung zu BIld-window

Ein View/dialog-item, das das Bild darstellt,

dieser verwaleltet
, die Liste von Boxen, die Cursoraenderung, und das Anklicken von Objekten


Eingabe? Eine Liste von Koordinaten
Ausgabe Index der angeklicken Zelle

versteht dialog-item-wert, dialog-item-wert-setzen

Zur Veeinfachung:

Eine Extra Fenster zur Eingabe

links, dass Bild, rechts die Sequence,
Buttons nein/sonstiges, unbekannt, Abbrechen & OK
|#

(defvar *b-sondertaste-p* nil)

(unless (fboundp 'b=fenster-breite)
  (defun b=fenster-breite ()
    *screen-width*)
  (defun b=fenster-hoehe ()
    *screen-height*))

#+:ccl-2
(defmethod window-close :after ((ich *b-window*))
  (rekursiv-views-loeschen ich)
  )

#+:ccl-2
(defun rekursiv-views-loeschen (ich)
  (when (b=objekt-kann-methode-p ich  'reagieren-auf-fenster-schliessen)
    (reagieren-auf-fenster-schliessen ich))
  (do-subviews (view ich)
    (rekursiv-views-loeschen view)))

#+:ccl-2
(defclass *b-bild-view-papa* (*b-scroller-view*)
      ())

#+:aclpc
(defclass *b-bild-view-papa* (mac-dialog-item-mixin cg:dialog-item)
  ()
  )

#+:aclpc
(defclass *b-bild-pane* (mac-fenster-mixin bitmap-pane)
      ((item :accessor pane-item :initform nil :initarg :dialog-item))
     )

#+:aclpc
(defmethod widget-device ((item *b-bild-view-papa*) dialog)
     '*b-bild-pane*)


(defclass *b-bild-view* (*b-bild-view-papa*)
  ((Bilddatei :initarg :bilddatei :initform nil :accessor bbv=Bilddatei)
   (bild-view-size :initarg :bild-view-size :accessor bbv-bild-view-size)
   (bild :initform nil :Accessor bbv=bild)
   (rechteckliste :initarg :rechteckliste :initform nil :accessor bbv=rechtecke)
   (selektierte-rechtecke :initform nil :accessor bbv=selektierte-rechtecke)
   (selektionstyp :initarg :selektionstyp :accessor bbv=selektionstyp :initform :single)
   (f-bei-Wertaenderung :initArg :f-bei-Wertaenderung :initform nil
                        :accessor bbv-f-bei-Wertaenderung)
   )
  )

#+:ccl-2
(defmethod reagieren-auf-fenster-schliessen ((ich *b-bild-view*))
  (when (and (bbv=bild ich)
             (handlep (bbv=bild ich)))
    (kill-picture (bbv=bild ich))))

#+:aclpc
(defun b=bild-laden (datei &optional ppane)
  (multiple-value-bind
    (pane texture)
    (cg::copy-pixels-to-stream-from-file datei ppane)
    (unless ppane
      (shrink-window pane t))
    (list pane texture))
  )

#+:aclpc
(defun b=bildgroesse-normiert (pane&texture)
  (let ((texture (second pane&texture)))
    (make-point 
     (texture-info-WIDTH texture)
     (texture-info-HEIGHT texture))))

(defmethod tue-bild-rein ((ich *b-bild-view*))
     (when (and (bbv=Bilddatei ich)(probe-file (bbv=Bilddatei ich)))
          (setf (bbv=bild ich)
                  (b=bild-laden (bbv=Bilddatei ich) #+:aclpc (dialog-item-window ich)))
          (let ((bildgroesse (add-points #@(10 10) (b=bildgroesse-normiert (bbv=bild ich)))))
              #+:ccl-2
              (set-field-size ich bildgroesse)
              (set-view-size ich
                   (or  (bbv-bild-view-size ich)
                        (make-point
                              (min (- (b=fenster-breite) 250)(point-h bildgroesse))
                              (min (- (b=fenster-hoehe) 150)(point-v bildgroesse)))))
              #+:aclpc
              (set-field-size (dialog-item-window ich) bildgroesse)
              )
          )
     )

#+:ccl-2
(defmethod initialize-instance :after ((ich *b-bild-view*) &rest init-list)
  (declare (ignore init-list))
  (tue-bild-rein ich))

#+:aclpc
(defmethod set-view-container :after ((ich *b-bild-view*)(was view))
  (tue-bild-rein ich))

(defmethod view-draw-contents ((ich *b-bild-view*))
  #+:ccl-2
  (when (bbv=bild ich)
    (draw-picture ich (bbv=bild ich) #@(0 0) (b=bildgroesse-normiert (bbv=bild ich))))
  (dolist (index (bbv=selektierte-rechtecke ich))
    (male-rechteck ich index)
    ))

(defmethod male-rechteck ((ich *b-bild-view*) index)
  (let ((stream #+:ccl-2 ich #+:aclpc (dialog-item-window ich))
        (paar (nth index (bbv=rechtecke ich))))
    (when paar
      (invert-rect stream (first paar)(second paar)))))
                   
#+:ccl-2
(defmethod view-cursor ((ich *b-bild-view*) wo)
  (dolist (paar (bbv=rechtecke ich) *arrow-cursor*)
    (when (b=punkt-im-rechteck-p wo (first paar)(second paar))
      (return *gr-zeigefingerhand-cursor*))))

#+:aclpc
(defmethod view-click-event-handler ((ich *b-bild-pane*) punkt)
  (view-click-event-handler (pane-item ich) punkt))

(defmethod alle-ausklicken ((ich *b-bild-view*))
  (let ((vorher (bbv=selektierte-rechtecke ich)))
    (dolist (index vorher)
      (male-rechteck ich index))
    (setf (bbv=selektierte-rechtecke ich) nil)
    (when (bbv-f-bei-wertaenderung ich)
      (funcall (bbv-f-bei-wertaenderung ich) vorher nil))
    )
  )

(defmethod view-click-event-handler ((ich *b-bild-view*) punkt)
  (let ((index 0))
    (dolist (paar (bbv=rechtecke ich)(alle-ausklicken ich)
                  )
      (when (b=punkt-im-rechteck-p punkt (first paar)(second paar))
        (return (klick-auf-rechteck ich index)))
      (incf index))))

#+:aclpc
(defmethod cursor-setzen ((ich *b-bild-view*))
  (let* ((fenster (dialog-item-window ich))
         (punkt (cursor-position fenster))
         )
    (dolist (paar (bbv=rechtecke ich) (set-cursor fenster arrow-cursor))
      (when (b=punkt-im-rechteck-p punkt (first paar)(second paar))
        (return (set-cursor fenster cross-cursor))))))


#+:aclpc
(defmethod event ((ich *b-bild-pane*) (eve (eql mouse-moved)) button data time)
  (call-next-method)
  (cursor-setzen (pane-item ich)))


(defmethod sondertaste-p ((ich *b-bild-view*))
  (if *b-sondertaste-p*
    #+:ccl-2 (or (command-key-p)(shift-key-p))
    #+:aclpc (view-command-key-p (dialog-item-window ich))
    t
    )
  )

(defmethod klick-auf-rechteck ((ich *b-bild-view*) index)
  (let ((vorher (bbv=selektierte-rechtecke ich))
        (virtueller-selektionstyp
         (if (sondertaste-p ich)
           (bbv=selektionstyp ich)
           :single)))
    (ecase virtueller-selektionstyp
      (:single
       (if (member index (bbv=selektierte-rechtecke ich))
         (setf (bbv=selektierte-rechtecke ich) nil)
         (setf (bbv=selektierte-rechtecke ich) (list index))))
      (:multiple
       (if (member index (bbv=selektierte-rechtecke ich))
         (setf (bbv=selektierte-rechtecke ich)
               (remove index (bbv=selektierte-rechtecke ich)))
         (push index (bbv=selektierte-rechtecke ich)))))
    (let ((unterschied (set-exclusive-or (bbv=selektierte-rechtecke ich) vorher)))
      (dolist (index unterschied)
        ;neu selektierte oder nicht mehr selektierte 
        (male-rechteck ich index))
      (when (and unterschied (bbv-f-bei-wertaenderung ich))
        (funcall (bbv-f-bei-wertaenderung ich) vorher (bbv=selektierte-rechtecke ich)))
      )
    )
  )

(defmethod dialog-item-wert-setzen ((ich *b-bild-view*) was)
  (let ((vorher (bbv=selektierte-rechtecke ich)))
    (setf (bbv=selektierte-rechtecke ich) was)
    (let ((unterschied (set-exclusive-or (bbv=selektierte-rechtecke ich) vorher)))
      (dolist (index unterschied)
        ;neu selektierte oder nicht mehr selektierte 
        (male-rechteck ich index))
      )
    )
  )

(defmethod dialog-item-wert ((ich *b-bild-view*))
  (bbv=selektierte-rechtecke ich))
 

#|

(defparameter datei (b=dateiauswahl))

(progn
  (setq haus 
        (m->a=erzeuge-fenster '*b-graphics-window*))
  
  (add-subviews (view haus) 
                (setq der (m->a=erzeuge-dialog-item '*b-bild-view*
                            :selektionstyp :multiple
                            :rechteckliste
                            #+:ccl-2 (list (list 'k (make-point 10 10)(make-point 50 50))
                                           (list 'k (make-point 10 70)(make-point 50 120)))
                            #+:aclpc (list (list (make-point 10 10)(make-point 50 50))
                                           (list (make-point 10 70)(make-point 50 120)))
                           :bild-view-size (make-point 200 200)
                            :view-position (make-point 10 10)
                            :bilddatei datei))))
|#

(defclass *b-bildindex-sequence-papa* (#+:ccl-2 sequence-dialog-item
                                       #+:aclpc mac-dialog-item-mixin)
  ())

(defclass *b-bildindex-sequence* (*b-bildindex-sequence-papa*)
  (
   (f-bei-Wertaenderung :initArg :f-bei-Wertaenderung :initform nil
                        :accessor bbs-f-bei-Wertaenderung)
   
   (indexliste :initarg :indexliste :initform nil :accessor bbs-indexliste)
   (f-verbalisieren :initarg  :f-verbalisieren
                    :initform #'b=erzeuge-string
                    :accessor bbs-f-verbalisieren)
   )
  )

#+:ccl-2
(defmethod initialize-instance ((ich *b-bildindex-sequence*)
                                &rest init-list 
                                )
  
  (apply #'call-next-method ich
         (init-list-default init-list
                            :view-font b_kleinschrift
                            :table-hscrollp nil
                            :table-vscrollp t
                            :table-print-function #'(lambda(a b)
                                                      (princ (second a) b)))))

#+:aclpc
(defmethod initialize-instance ((ich *b-bildindex-sequence*)
                                &rest init-list 
                                )
  (apply #'call-next-method ich
         (init-list-default init-list
                            :set-value-fn #'(lambda(item jetzt vorher)
                                              (declare (ignore jetz vorher))
                                              (funcall (getf init-list :dialog-item-action
                                                             #'(lambda(a))) item)
                                              (values t nil)
                                              )
                            )
         )
  )

#+:ccl-2
(defmethod initialize-instance :after ((ich *b-bildindex-sequence*) 
                                       &rest init-list
                                       &key)
  (declare (ignore init-list))
  (set-table-sequence 
   ich
   (mapcar #'(lambda(was)
               (list was (funcall (bbs-f-verbalisieren ich) was)))
           (bbs-indexliste ich)
           ))
  )

#+:aclpc
(defmethod initialize-instance :after ((ich *b-bildindex-sequence*) 
                                       &rest init-list
                                       )
  (set-dialog-item-range 
   ich
   (bbs-indexliste ich))
  )

(defclass *b-single-bildindex-sequence* (*b-bildindex-sequence* #+:aclpc single-item-list)
  ()
  #+:ccl-2 
  (:default-initargs
    :selection-type :single))

(defclass *b-multiple-bildindex-sequence* (*b-bildindex-sequence* #+:aclpc multi-item-list)
  ()
  #+:ccl-2 
  (:default-initargs
    :selection-type :disjoint)
  )

#+:ccl-2
(defmethod dialog-item-wert ((ich *b-bildindex-sequence*))
  (mapcar #'point-v  (selected-cells ich)))

#+:ccl-2
(defmethod dialog-item-wert-setzen ((ich *b-bildindex-sequence*) positionen)
  (let ((sichtbar (point-v (visible-dimensions ich)))
        (gescrollt (point-v (scroll-position ich))))
    (dolist (zelle (selected-cells ich))
      (cell-deselect ich zelle))
    (dolist (position positionen)
      (when (numberp position)
        (when (and (numberp gescrollt)(numberp sichtbar))
          (unless (and 
                   (>= position gescrollt)
                   (<= position (+ gescrollt sichtbar)))
            (scroll-to-cell ich 0 position))
          (cell-select ich (make-point 0 position))))))
  )



#+:aclpc
(defmethod dialog-item-wert-setzen ((ich *b-single-bildindex-sequence*) positionen)
  (set-dialog-item-value ich
                         (first positionen)))

#+:aclpc
(defmethod dialog-item-wert ((ich *b-single-bildindex-sequence*))
  (let ((wert (dialog-item-value ich)))
    (if (null wert) nil
        (list wert))))


#+:aclpc
(defmethod dialog-item-wert-setzen ((ich *b-multiple-bildindex-sequence*) positionen)
  (set-dialog-item-value ich positionen))

#+:aclpc
(defmethod dialog-item-wert ((ich *b-multiple-bildindex-sequence*) )
  (dialog-item-value ich))

#|
Fehler, tut nicht wegen Strings
|#

(defun bb-index-to-string (paar)
  #+:ccl-2 (second paar)
  #+:aclpc "Hugo ist doof"
  )

(defmethod maximale-stringbreite ((ich *b-bildindex-sequence*))
  (let ((max 0)
        (font (view-font ich)))
    (dolist (paar #+:ccl-2 (table-sequence ich)
                  #+:aclpc (dialog-item-range ich)
                  )
      (let ((breite (string-width (bb-index-to-string paar)
                                  font)))
        (when (> breite max)
          (setq max breite))))
    max))

#|
(m->a=erzeuge-fenster '*b-window*
                      :view-subviews
                      (list
                       (m->a=erzeuge-dialog-item '*b-multiple-bildindex-sequence*
                                                 :indexliste '(a b c d)
                                                 :view-size (make-point 50 200)
                                                 :view-position (make-point 0 0))
                       (m->a=erzeuge-dialog-item '*b-single-bildindex-sequence*
                                                 :view-size (make-point 50 200)
                                                 :indexliste '(a b c d)
                                                 :view-position (make-point 100 0))
                       ))
|#
                      

(defclass *b-bild&text-dialog-item* (*b-dialog-item*)
  ((indizes :initform nil :initarg :indizes :accessor bbt-indizes)
   (rechtecke :initform nil :initarg :rechtecke :accessor bbt-rechtecke)
   (bilddatei :Accessor bbt=bilddatei :initarg :bilddatei)
   (bildobjekt :Accessor bbt=bild)
   (sequence :Accessor bbt=sequence)
   (selektionstyp :initarg :selektionstyp :initform nil :Accessor bbt-selektionstyp)
   (f-verbalisieren :initarg :f-verbalisieren :initform #'b=erzeuge-string
                    :accessor bbt-f-verbalisieren)
   (f-bei-Wertaenderung :initarg :f-bei-Wertaenderung
                        :accessor bbb-f-bei-Wertaenderung)
   )
  )

    
(defmethod initialize-instance :after ((ich *b-bild&text-dialog-item*) &rest init-list 
                                       &key bild-view-size)
  #-:aclpc (declare (ignore init-list))
  #+:aclpc
  (progn
    (set-view-position ich (make-point 0 0))
    (set-view-size ich (make-point 1 1))
    )
  (setf (bbt=bild ich)
        (m->a=erzeuge-dialog-item '*b-bild-view*
                                  :f-bei-Wertaenderung #'(lambda(vorher nachher)
                                                           (declare (ignore vorher))
                                                           (bbt-selektion-ueberpruefen ich nachher :bild))
                                  :selektionstyp (bbt-selektionstyp ich)
                                  :bild-view-size bild-view-size
                                  :bilddatei (bbt=bilddatei ich)
                                  :rechteckliste (bbt-rechtecke ich)))
  (setf (bbt=sequence ich)
        (m->a=erzeuge-dialog-item
         (case (bbt-selektionstyp ich)
           (:single '*b-single-bildindex-sequence*)
           (t '*b-multiple-bildindex-sequence*))
         :dialog-item-action #'(lambda(sequence)
                                 (bbt-selektion-ueberpruefen ich 
                                                             (dialog-item-wert sequence)
                                                             :sequence))
         #+:ccl-2 :f-verbalisieren #+:ccl-2  (bbt-f-verbalisieren ich)
         #+:ccl-2 :indexliste #+:ccl-2  (bbt-indizes ich)
         #+:aclpc :key #+:aclpc #'(lambda(zahl)
                                    (funcall (bbt-f-verbalisieren ich) (1+ zahl)))
         #+:aclpc :indexliste #+:aclpc (mapcar #'1- (bbt-indizes ich))
         )
        )
  )


(defmethod bbt-selektion-ueberpruefen ((ich *b-bild&text-dialog-item*) was wer)
  (case wer
    (:bild
     (dialog-item-wert-setzen (bbt=sequence ich) was))
    (:sequence
     (dialog-item-wert-setzen (bbt=bild ich) was)))
  (funcall (bbb-f-bei-Wertaenderung ich) ich
           nil (dialog-item-wert ich)))
  

(defmethod set-view-container ((ich *b-bild&text-dialog-item*) (container view))
  (call-next-method)
  (set-view-position (bbt=bild ich) (view-position ich))
  (set-view-container (bbt=bild ich) container)
  (set-view-position (bbt=sequence ich)
                     (bbt=sequence-position ich))
  (set-view-size (bbt=sequence ich)
                 (make-point (min 500 (+ 20 (maximale-stringbreite (bbt=sequence ich))))
                             (+ 15 (point-v (view-size (bbt=bild ich))))))
  (set-view-container (bbt=sequence ich) container)
  )

(defmethod set-view-container ((ich *b-bild&text-dialog-item*) (container (eql nil)))
  (call-next-method)
  (set-view-container (bbt=bild ich) container)
  (set-view-container (bbt=sequence ich) container)
  )

(defmethod bbt=sequence-position ((ich *b-bild&text-dialog-item*))
  (add-points (view-position ich)
              (make-point (+ 20 (point-h (view-size (bbt=bild ich))))
                          0)))

(defmethod dialog-item-wert ((ich *b-bild&text-dialog-item*))
  (let ((wert (dialog-item-wert (bbt=sequence ich))))
    (if (null wert)
      nil
      (if (eq (bbt-selektionstyp ich) :single)
        (1+ (first wert))
        (mapcar #'1+ wert)))))

(defmethod dialog-item-wert-setzen ((ich *b-bild&text-dialog-item*) wert)
  (unless (listp wert)
    (setq wert (list wert)))
  (setq wert (mapcar #'1- wert))
  (dialog-item-wert-setzen (bbt=bild ich) wert)
  (dialog-item-wert-setzen (bbt=sequence ich) wert))
  
(defmethod view-size ((ich *b-bild&text-dialog-item*))
  ;annahme beides gleiche y korrdinate, y addieren
  (if (and (view-container (bbt=bild ich))
           (view-container (bbt=sequence ich)))
  (make-point 
   (+ (+ 25 (point-h (view-size (bbt=bild ich))))
      (point-h (view-size (bbt=sequence ich))))
   (point-v (view-size (bbt=sequence ich))))
  (call-next-method)))

#|
(defparameter datei (b=dateiauswahl))

(progn
  (setq haus 
        (m->a=erzeuge-fenster '*b-graphics-window*))
  
  (add-subviews (view haus) 
                (setq der (m->a=erzeuge-dialog-item '*b-bild&text-dialog-item*
                                                    :selektionstyp :multiple
                                                    :rechtecke (list (list (make-point 10 10)(make-point 50 50))
                                                                     (list (make-point 10 70)(make-point 50 120)))
                                                    :bild-view-size (make-point 200 200)
                                                    :view-position (make-point 10 10)
                                                    :indizes (list 1 2)
                                                    :F-BEI-WERTAENDERUNG #'(lambda(&rest egal)
                                                                             (declare (ignore egal))
                                                                             nil)
                                                    :f-verbalisieren
                                                    #'(lambda(zahl)
                                                        (format nil "~R" zahl))
                                                    :bilddatei datei))))
|#
          