
(defvar *status-bar*)
(defvar *text-field*)

(defclass status-bar (dialog)
      ()
     )

(defclass status-text-field (static-text)
      ()
     )

(defun ensure-text-field ()
     (if (and (boundp '*text-field*)
                 (not (closed-stream-p *text-field*))
                 )
        *text-field*
        (setq *text-field*
             (make-dialog-item
                   :widget 'status-text-field
                   :box (make-box 10 10 600 100)
                   :value "ich"
                   ))
        ))

(defun ensure-status-bar ()
          (if (and (boundp '*status-bar*)
                     (not (closed-stream-p *status-bar*))
                     )
            *status-bar* ;(bring-window-to-front *status-bar*)
            (setq *status-bar*
                 (open-dialog
                      (list (ensure-text-field))
                      'status-bar
                      *lisp-main-window*
                      :user-resizable t
                      :pop-up-p nil
                      :title "status-bar"
                      :window-exterior (MAKE-BOX 217 640 824 763)
                      ))
            )
         )

(defun window-message (status-window format-text &rest form-args)
     (let ((var (front-window *lisp-main-window*)))
         
         (ensure-status-bar)
         (let ((text (apply #'format nil format-text form-args))
                )
             (set-dialog-item-value *text-field* text)
             )
         (unless (eq (front-window *lisp-main-window*) var)
         (select-window *lisp-main-window*)
         (select-window var))))

(defun window-warning (status-window format-text &rest form-args)
     (apply #'window-message
           status-window format-text form-args)
     (beep *status-bar*)
     )

(defun window-status-bar ()
     *status-bar*)