#+:aclpc
(defun hi-punkt-im-rechtseck-p (value point)
  (b=punkt-im-rechteck-p 
   point
   (hi-knoten-info-links-oben value)
    (hi-knoten-info-rechts-unten value)))



#+:aclpc
(defun hi-knoten-malen (ich wert text)
  (let* ((links-oben   (hi-knoten-info-links-oben wert))
         (rechts-unten  (hi-knoten-info-rechts-unten wert))
         (box-box (make-box-from-corners
                   links-oben
                   rechts-unten))
         (box-text 
          (make-box-from-corners
           (add-points (make-point 1 1) links-oben)
           (subtract-points rechts-unten (make-point 1 1))))
         )
    (draw-box ich box-box )
    (draw-string-in-box ich text 0 (length text) box-text
                        :center :center nil)
    )
  )

#+:aclpc 
(defun hi-linie-malen (ich von-objekt bis-objekt &optional (wie-hoch (font-height (fontmetrics ich))))
  (let ((von  (hi-knoten-nach-linie-anfangs-punkt ich von-objekt wie-hoch))
        (bis  (hi-knoten-nach-linie-end-punkt ich bis-objekt)))
    (draw-line ich von bis)
    )
  )


#+:aclpc
(defmethod hi-linie-invertieren ((ich *hi-scroller-view*) von nach)
  (let ((vorher (line-dashing ich)))
    (set-line-dashing ich :dash-double-dot)
    (hi-linie-malen ich von nach)
    (set-line-dashing ich vorher)
    )
  )

#+:aclpc 
(defmethod hi-linie-deinvertieren ((ich *hi-scroller-view*) von nach)
  (hi-linie-malen von nach)
  )


#+:aclpc 
(defmethod hi-alle-knoten-invertieren ((ich *hi-scroller-view*))
  (dolist (knoten (hi-selektierte ich))
    (hi-knoten-invertieren ich knoten)
    ))

#+:aclpc 
(defmethod hi-alle-linien-deinvertieren ((ich *hi-scroller-view*))
  (dolist (linie (hi-selektierte-linien ich))
    (hi-linie-malen ich  (first linie) (second linie) )))


#+:aclpc
(defmethod hi-alle-linien-invertieren ((ich *hi-scroller-view*))
  (dolist (linie (hi-selektierte-linien ich))
    (hi-linie-invertieren ich (first linie) (second linie)))
  )


#+:aclpc
(defmethod hi-knoten-invertieren ((ich *hi-scroller-view*) knoten)
  (let* ((strukt (gethash knoten (hi-kn-hash ich)))
         (box (make-box-from-corners 
               (hi-knoten-info-links-oben strukt)
               (hi-knoten-info-rechts-unten strukt))))
    
    (HIGHLIGHT-CONTENTS-BOX  ich gray
                             box)))

#+:aclpc
(defun b=box-eckpunkte (box)
  (list
   (box-top-left box)
   (box-top-right box)
   (box-bottom-right box)
   (box-bottom-left box)))
