;;;-*- Package: CL-USER; Syntax: Common-Lisp -*-

;;; MEASURES examples

(in-package :cl-user)

(use-package :measures)

(defmeasure length
  "m"
  :units :metric
  :format :base)

(defmeasure area
  ("qm" "m" "m")
  :units (("qkm" "km" "km")
          ("ar" 100 "qm")
          ("ha" 100 "ar")))
          
(defmeasure volume
  ("m3" "m" "m" "m")
  :units (("ccm" "cm" "cm" "cm")
          ("l" 1000 "ccm")))

(defmeasure time
  "s"
  :units (("min" 60 "s")
          ("h" 60 "min")
          ("ms" 0.001 "s"))
  :format (:step "h" "min" "s"))

(defmeasure speed
  "m/s"
  :units ("km/h"
          ("mph" 1.6 "km/h"))
  :format (:unit "km/h"))


(defmeasure currency
  "DM"
  :units (("Pfg" 0.01 "DM")
          ("$" 1.85 "DM")
          ("c" 0.01 "$")))


#|

? (dim+ 1m 4mm)
1.004m

? (dim* 1m 4mm)
0.004qm

? (dim- 1m 4mm)
0.996m

? (dim/ 1m 4mm)
250

? (dim/ 10m 3s)
12km/h

|#
