/*
 * Grammar for yacc/bison to describe lisp syntax
 */

%{
#include "lisp.h"
/*#define bu_symbol bu_string	/* should eventually have its own type... */
/*#define YYSTYPE lispobj_t*/
%}

%union {
    lispobj *bu_lispobj;
}

%token <bu_lispobj> NUMBER
%token <bu_lispobj> STRING
%token <bu_lispobj> SYMBOL
/* %token SHARP_QUOTE */

%token ERROR

%type <bu_lispobj> s_exp atom list s_exp_list

%%

start		:
			{ Frecord(Qeof); }
		| s_exp
    			{ Frecord($1); } /* record the s-exp found */
		;

s_exp		: atom
			{ $$ = $1; }
		| list
			{ $$ = $1; }
		| ERROR error
			{ YYABORT; }
		;

atom		: NUMBER
			{ $$ = $1; }
		| SYMBOL
			{ $$ = $1; }
		| STRING
			{ $$ = $1; }
		;

list		: '(' ')'
			{ $$ = Qnil; }
		| '(' s_exp_list ')'
			{ $$ = $2; }
		| '(' s_exp_list '.' s_exp ')'
			{ $$ = Fnconc2($2, $4); }
    		| '\'' s_exp
			{ $$ = Fcons(Qquote, Fcons($2, Qnil)); }
/*
		| SHARP_QUOTE s_exp
			{ $$ = Fcons(Qfunction, $2); }
*/
		;

s_exp_list	: s_exp
			{ $$ = Fcons($1, Qnil); }
		| s_exp_list s_exp
			{ $$ = Fnconc2($1, Fcons($2, Qnil)); }
		;
