#include "char-types.h"

struct char_types char_types[] = {
    { T_EOF, A_EOF },	/* -1 == EOF */
    { T_ILLEGAL, A_ILLEGAL },	/* ^@ */
    { T_ILLEGAL, A_ILLEGAL },	/* ^A */
    { T_ILLEGAL, A_ILLEGAL },	/* ^B */
    { T_ILLEGAL, A_ILLEGAL },	/* ^C */
    { T_ILLEGAL, A_ILLEGAL },	/* ^D */
    { T_ILLEGAL, A_ILLEGAL },	/* ^E */
    { T_ILLEGAL, A_ILLEGAL },	/* ^F */
    { T_ILLEGAL, A_ILLEGAL },	/* ^G */
    { T_CONSTITUENT, A_ILLEGAL },	/* ^H == backspace */
    { T_WHITESPACE, A_ILLEGAL },	/* ^I == tab */
    { T_WHITESPACE, A_ILLEGAL },	/* ^J == newline/linefeed */
    { T_ILLEGAL, A_ILLEGAL },	/* ^K */
    { T_WHITESPACE, A_ILLEGAL },	/* ^L == page/vertical tab */
    { T_WHITESPACE, A_ILLEGAL },	/* ^M == carriage return */
    { T_ILLEGAL, A_ILLEGAL },	/* ^N */
    { T_ILLEGAL, A_ILLEGAL },	/* ^O */
    { T_ILLEGAL, A_ILLEGAL },	/* ^P */
    { T_ILLEGAL, A_ILLEGAL },	/* ^Q */
    { T_ILLEGAL, A_ILLEGAL },	/* ^R */
    { T_ILLEGAL, A_ILLEGAL },	/* ^S */
    { T_ILLEGAL, A_ILLEGAL },	/* ^T */
    { T_ILLEGAL, A_ILLEGAL },	/* ^U */
    { T_ILLEGAL, A_ILLEGAL },	/* ^V */
    { T_ILLEGAL, A_ILLEGAL },	/* ^W */
    { T_ILLEGAL, A_ILLEGAL },	/* ^X */
    { T_ILLEGAL, A_ILLEGAL },	/* ^Y */
    { T_ILLEGAL, A_ILLEGAL },	/* ^Z */
    { T_ILLEGAL, A_ILLEGAL },	/* ^[ == escape */
    { T_ILLEGAL, A_ILLEGAL },	/* ^\ */
    { T_ILLEGAL, A_ILLEGAL },	/* ^] */
    { T_ILLEGAL, A_ILLEGAL },	/* ^^ */
    { T_ILLEGAL, A_ILLEGAL },	/* ^_ */
    { T_WHITESPACE, A_ILLEGAL }, /* 32 = space */
    { T_CONSTITUENT, A_ALPHABETIC }, /* ! */
    { T_MACRO_TERM, A_ALPHABETIC }, /* " */
    { T_MACRO_NONTERM, A_ALPHABETIC }, /* # */
    { T_CONSTITUENT, A_ALPHABETIC }, /* $ */
    { T_CONSTITUENT, A_ALPHABETIC }, /* % */
    { T_CONSTITUENT, A_ALPHABETIC }, /* & */
    { T_MACRO_TERM, A_ALPHABETIC }, /* ' */
    { T_MACRO_TERM, A_ALPHABETIC }, /* ( */
    { T_MACRO_TERM, A_ALPHABETIC }, /* ) */
    { T_CONSTITUENT, A_ALPHABETIC }, /* * */
    { T_CONSTITUENT, (A_ALPHABETIC | A_PLUS_SIGN) }, /* + */
    { T_MACRO_TERM, A_ALPHABETIC }, /* , */
    { T_CONSTITUENT, (A_ALPHABETIC | A_MINUS_SIGN) }, /* - */
    { T_CONSTITUENT, (A_ALPHABETIC | A_DOT) }, /* . */
    { T_CONSTITUENT, A_ALPHABETIC }, /* / */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* 48 == 0 */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* 1 */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* 2 */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* 3 */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* 4 */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* 5 */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* 6 */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* 7 */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* 8 */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* 9 */
    { T_CONSTITUENT, A_PACKAGE_MARKER }, /* : */
    { T_MACRO_TERM, A_ALPHABETIC }, /* ; */
    { T_CONSTITUENT, A_ALPHABETIC }, /* < */
    { T_CONSTITUENT, A_ALPHABETIC }, /* = */
    { T_CONSTITUENT, A_ALPHABETIC }, /* > */
    { T_CONSTITUENT, A_ALPHABETIC }, /* ? */
    { T_CONSTITUENT, A_ALPHABETIC }, /* 64 == @ */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* A */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* B */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* C */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* D */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* E */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* F */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* G */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* H */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* I */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* J */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* K */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* L */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* M */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* N */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* O */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* 80 == P */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* Q */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* R */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* S */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* T */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* U */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* V */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* W */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* X */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* Y */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* Z */
    { T_CONSTITUENT, A_ALPHABETIC }, /* [ */
    { T_SINGLE_ESCAPE, A_ALPHABETIC }, /* \ */
    { T_CONSTITUENT, A_ALPHABETIC }, /* ] */
    { T_CONSTITUENT, A_ALPHABETIC }, /* ^ */
    { T_CONSTITUENT, A_ALPHABETIC }, /* _ */
    { T_MACRO_TERM, A_ALPHABETIC }, /* 96 == ` */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* a */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* b */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* c */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* d */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* e */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* f */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* g */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* h */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* i */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* j */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* k */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* l */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* m */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* n */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* o */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* 112 == p */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* q */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* r */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* s */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* t */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* u */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* v */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* w */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* x */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* y */
    { T_CONSTITUENT, A_ALPHADIGIT }, /* z */
    { T_CONSTITUENT, A_ALPHABETIC }, /* { */
    { T_MULTIPLE_ESCAPE, A_ALPHABETIC }, /* | */
    { T_CONSTITUENT, A_ALPHABETIC }, /* } */
    { T_CONSTITUENT, A_ALPHABETIC }, /* ~ */
    { T_CONSTITUENT, A_ILLEGAL }, /* delete */
};
