;;;; -*- Mode:Common-Lisp; Package:CLIP-USER; Fonts:(MEDFNT); Base:10 -*-
;;;; *-* File: Titanic: /usr/users/eksl/systems/clip/demos/transsim-test-code.lisp *-*
;;;; *-* Last-edit: Monday, September 27, 1993  18:13:21; Edited-By: Westy *-* 
;;;; *-* Machine: Count (Explorer II, Microcode 489) *-*
;;;; *-* Software: TI Common Lisp System 6.49 *-*
;;;; *-* Lisp: TI Common Lisp System 6.49  *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *                                                                        *
;;;; *                           CLIPS Example                                *
;;;; *                                                                        *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: David L. Westbrook
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  01-19-93 File Created.  (WESTY)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;; --*--

(in-package #+CLTL2 clip-user #-CLTL2 'clip-user)

;;; --*--
;;; ***************************************************************************
;;; The Instrumentation Definitions

;;;----------------------------------------------------------------------------
;;; Periodic collection

(defclip current-time ()
  ()
  (transsim::current-time))

(defclip port-backlog-snapshot ()
  "Record the backlog at each port every 12 hours."
  (:output-file "port-backlog4"
   :period "12 hours"
   :map-function (transsim::find-instances 'transsim::port)
   :components   (each-port-backlog-snapshot)))

(defclip each-port-backlog-snapshot (port)
  "Record the current backlog at a port."
  ()

  (length (transsim::contents (transsim::docking-queue port))))


;;;----------------------------------------------------------------------------
;;; Post simulation collection

(defclip shipping-cost ()
  "Overall shipping costs"
  ()
  
  (reduce #'+ (transsim::find-instances 'transsim::ship) :key #'transsim::cumulative-cost))

(defclip delay-cost ()
  "Overall delay costs"
  ()

  (reduce #'+ (transsim::find-instances 'transsim::cargo) :key #'transsim::cumulative-cost))

(defclip storage-cost ()
  "Overall storage costs"
  ()

  (reduce #'+ (transsim::find-instances 'transsim::port) :key #'transsim::cumulative-cost))


(defclip loading-cost ()
  "Overall loading costs"
  ()

  (reduce #'+ (transsim::find-instances 'transsim::dock) :key #'transsim::cumulative-cost))

;;; ***************************************************************************
;;; The Experiment Definition

(define-simulator transsim
  :system-name "TransSim"
  :start-system (transsim::simulate nil)
  :reset-system transsim::initialize-simulation
  ;; a function that places functions to run on the queue of events.
  :schedule-function schedule-function-for-clips
  ;; a function that removes functions from the queue of events.
  :deactivate-scheduled-function transsim::reset
  :seconds-per-time-unit 3600
  :timestamp current-time)

(define-experiment test-experiment ()
  "A transsim test experiment."
  :simulator transsim
  :instrumentation
    (trial-number loading-cost storage-cost delay-cost shipping-cost
                  port-backlog-snapshot)
  :after-trial
    ;; Other options here include building CLASP datasets,
    ;; exporting to some database, massaging the data or some
    ;; combination fo these.
    (write-current-experiment-data)


  )

;;; ***************************************************************************
;;; Example

#|

; Executing this:

(run-experiment 'test-experiment :number-of-trials 10 :length-of-trial "1000 days" 
		:output-file "ed-buffer:out")

; Produces the following:
"
*************************************************************************************************************
****                                                                                                     ****
**** Experiment: Test-Experiment                                                                         ****
**** Machine: Count                                                                                      ****
**** TransSim version: RELEASE-4-1                                                                       ****
**** Date: 2/2/93 21:7                                                                                   ****
**** Scenario: None                                                                                      ****
**** Script-name: None                                                                                   ****
**** First trial number: 1                                                                               ****
**** Last trial number: 10                                                                               ****
**** Number of trials: 10                                                                                ****
**** Max trial length: 24000.0 hours                                                                     ****
*************************************************************************************************************

The key follows:"
"Trial"
"Loading-Cost "
"Storage-Cost "
"Delay-Cost "
"Shipping-Cost "
"Each-Port-Backlog-Snapshot PORT-3"
"Each-Port-Backlog-Snapshot PORT-2"
"Each-Port-Backlog-Snapshot PORT-1"
(1 20960.0 2696.0 2208.0 16105.06 0.0 0.007905139 0.0 )
(2 20960.0 2696.0 2208.0 16105.06 0.0 0.007905139 0.0 )
(3 20960.0 2696.0 2208.0 16105.06 0.0 0.007905139 0.0 )
(4 20960.0 2696.0 2208.0 16105.06 0.0 0.007905139 0.0 )
(5 20960.0 2696.0 2208.0 16105.06 0.0 0.007905139 0.0 )
(6 20960.0 2696.0 2208.0 16105.06 0.0 0.007905139 0.0 )
(7 20960.0 2696.0 2208.0 16105.06 0.0 0.007905139 0.0 )
(8 20960.0 2696.0 2208.0 16105.06 0.0 0.007905139 0.0 )
(9 20960.0 2696.0 2208.0 16105.06 0.0 0.007905139 0.0 )
(10 20960.0 2696.0 2208.0 16105.06 0.0 0.007905139 0.0 )

|#

;;; ***************************************************************************
;;; Utilities...

;;; This could probably be done using format, as well.
(defun round-to-n-significant-decimal-digits (x n &optional (divisor 1))
  "Returns a single-float with n significant digits.  This number-conses a
bunch so use it sparingly.  Remember - for single-float's the maximum total
significant digits is 7 or 8!"
  (let ((factor (expt 10 n)))
    (coerce (/ (round (* (coerce x 'double-float) factor) divisor) factor) 'float)))

(defun schedule-function-for-clips (function time period name)
  (if period
      (transsim::schedule-recurring-event (transsim::event-actuator :external)
                                          :function function
                                          :time time
                                          :period period
                                          :type (or name :instrumentation))
      (transsim::schedule-event (transsim::event-actuator :external)
                                :function function
                                :time time
                                :type (or name :instrumentation))))

;;; ***************************************************************************
;;; EOF






