;;;; -*- Mode:Common-Lisp; Package:USER; Fonts:(MEDFNT COURIERFB HL12I TR12 MEDFNB CPTFONTI HL12B); Base:10 -*-
;;;; *-* File: Titanic: /usr/users/eksl/stamant/mac-files/clips.lisp *-*
;;;; *-* Last-Edit: Friday, February 19, 1993  13:07:00; Edited-By: StAmant *-*
;;;; *-* Machine: Lester (Explorer II, Microcode 489) *-*
;;;; *-* Software: TI Common Lisp System 6.49 *-*
;;;; *-* Lisp: TI Common Lisp System 6.49  *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *                                                                        *
;;;; *                          Experiment Definition                         *
;;;; *                                                                        *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Transsim User
;;;             Experimental Knowledge Systems Laboratory
;;;             Paul R. Cohen, Principal Investigator
;;;             David L. Westbrook, Systems Manager
;;;             David M. Hart, Laboratory Manager
;;;             Department of Computer Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  02-19-93 File Created.  (StAmant)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;; --*--

(in-package #+CLTL2 USER #-CLTL2 'USER)

;;; --*--
;;; ***************************************************************************


;;; ---------------------------------------------------------------------------
;;; Clips
;;; ---------------------------------------------------------------------------

(clips:defclip current-date ()
  "current-date"
  ()
  (current-day))

;;; ---------------------------------------------------------------------------

(clips:defclip ships-in-parking-lot ()
  "#ships-in-parking-lot"
  ()
  (reduce #'+
          (map-over-objects #'contents 'parking-lot)
          :key #'length))

;;; ---------------------------------------------------------------------------

(clips:defclip ships-in-dock ()
  "#ships-in-dock"
  ()
  (reduce #'+
          (map-over-objects #'contents 'dock)
          :key #'length))

;;; ---------------------------------------------------------------------------

(clips:defclip ships-in-docking-queue ()
  "#ships-in-docking-queue"
  ()
  (reduce #'+
          (map-over-objects #'contents 'docking-queue)
          :key #'length))

;;; ---------------------------------------------------------------------------

(clips:defclip full-ships-in-transit ()
  "#ships-in-transit-with-cargo"
  ()
  (reduce #'+
          (map-over-objects #'(lambda (channel)
                                (count-if #'ship-carrying-cargo-p
                                          channel
                                          :key #'ships-in-channel))
                            'channel)))

;;; ---------------------------------------------------------------------------

(clips:defclip empty-ships-in-transit ()
  "#ships-in-transit-without-cargo"
  ()
  (reduce #'+
          (map-over-objects #'(lambda (channel)
                                (count-if-not #'ship-carrying-cargo-p
                                          channel
                                          :key #'ships-in-channel))
                            'channel)))

;;; ---------------------------------------------------------------------------
;;; Experiment
;;; ---------------------------------------------------------------------------

(clips:define-experiment ship-activity (number-of-trials
                                         resource-scenario
                                         schedule-constraints
                                         number-of-ships
                                         number-of-cargo)
  "Test sensitivity of ship activity prediction to scenario parameters."
  :start-system      run-transsim
  :ivs               ((number-of-ships)                     ; Declare independent variables
                      (number-of-cargo))
  :locals            ()
  :instrumentation   (trial-number                          ; Declare clips to be used
                       current-date
                       ships-in-parking-lot
                       ships-in-dock
                       ships-in-docking-queue
                       full-ships-in-transit
                       empty-ships-in-transit)

  :before-experiment (when (or (> number-of-ships (maximum-resource-bound 'ship))
                               (> number-of-cargo (maximum-product-bound 'cargo)))
                       (error "Scenario size outside currently defined boundaries."))
  
  :before-trial      (progn
                       (reset-scenario)
                       (flush-errors))

  :after-trial       (progn
                       (write-reports                       ; `Write-Reports' is part of Transsim, not CLIPS
                         (generate-report-filename 
                           resource-scenario
                           schedule-constraints))
                       (clips:write-current-experiment-data)))      ; Produce the data file
                       
;;; ---------------------------------------------------------------------------
;;; Example Invocation
;;; ---------------------------------------------------------------------------

;; (clips:run-experiment 'ship-activity
;;                        :args '(dss::rating-scheme :opportunistic)
;;	                  :output-file "transsim: experiments.results; activity.text")


;;; ---------------------------------------------------------------------------
;;; Example Datafile
;;; ---------------------------------------------------------------------------

;;;"
;;;***************************************************************************
;;;**** Experiment: Ship-Activity
;;;**** Machine: Lester
;;;**** Date: 2/19/93
;;;**** First trial number: 1
;;;**** Last trial number: 20
;;;**** Number of trials: 20
;;;***************************************************************************

;;;The key follows:"
;;;"Trial"
;;;"Resource-Scenario"
;;;"Schedule-Constraints"
;;;"Number-of-Ships"
;;;"Number-of-Cargo"
;;;"Current-Date"
;;;"#Ships-In-Parking-Lot"
;;;"#Ships-In-Dock"
;;;"#Ships-In-Docking-Queue"
;;;"#Ships-In-Transit-With-Cargo"
;;;"#Ships-In-Transit-Without-Cargo"
;;;(1 TEN-PORT-HUB OPPORTUNISTIC-365-50-275 0 50 0 0 0 0)
;;;(1 TEN-PORT-HUB OPPORTUNISTIC-365-50-275 1 41 6 0 0 3)
;;;(1 TEN-PORT-HUB OPPORTUNISTIC-365-50-275 2 41 6 0 0 3)
;;;(1 TEN-PORT-HUB OPPORTUNISTIC-365-50-275 3 40 6 0 0 4)
;;;(1 TEN-PORT-HUB OPPORTUNISTIC-365-50-275 4 44 5 0 6 5)
;;;. . .

;;; ***************************************************************************
;;; *                              End of File                                *
;;; ***************************************************************************
