;;;; -*- Mode:Common-Lisp; Package:CL-USER; Fonts:(MEDFNT); Base:10 -*-
;;;; *-* File: Titanic: /usr/users/eksl/systems/clip/development/defsys.lisp *-*
;;;; *-* Last-edit: Monday, August 30, 1993  17:41:14; Edited-By: Westy *-* 
;;;; *-* Machine: Count (Explorer II, Microcode 489) *-*
;;;; *-* Software: TI Common Lisp System 6.49 *-*
;;;; *-* Lisp: TI Common Lisp System 6.49  *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *                                                                        *
;;;; *                       CLIP System Definition                           *
;;;; *                                                                        *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Copyright (c) 1993 University of Massachusetts
;;; Department of Computer Science
;;; Experimental Knowledge Systems Laboratory
;;; Professor Paul Cohen, Director
;;; All rights reserved.
;;;
;;; Written by: David L. Westbrook
;;;             Experimental Knowledge Systems Laboratory
;;;             Paul R. Cohen, Director
;;;             David L. Westbrook, Systems Manager
;;;             David M. Hart, Laboratory Manager
;;;             Department of Computer Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  01-19-93 File Created.  (Westy)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;; --*--

(in-package #+CLTL2 COMMON-LISP-USER #-CLTL2 'USER)

;;; --*--
;;; ***************************************************************************

#+(or Allegro Lucid MCL)
(assert (or (find-package 'make)
	    (find-package 'portable-defsystem))
	nil
	"~%I really need the Public Domain DEFSYSTEM-Facility in Package MAKE"
	)

(load #-(or allegro lucid lispworks) "clip:extended-lisp;defsys"
      #+(or allegro lucid lispworks)
      (make-pathname
       :directory (pathname-directory *extended-lisp-root-pathname*)
       :name "defsys"
       #+lispworks :type #+lispworks "lisp"))

;;;----------------------------------------------------------------------------

#+Defsystem
(defun merge-binary-defaults (pathname)
  (make-pathname :defaults 
                 (merge-pathnames *default-binary-path* 
                                  pathname)
		 :host "EKSL"))

#+Defsystem
(portable-defsystem:defsystem CLIP
    (:default-pathname 
      #-(or allegro lucid lispworks)
      "clip:source;"
      #+(or allegro lucid lispworks)
      (make-pathname
       :directory `(,@(pathname-directory *clip-root-pathname*)
		      ,*clip-source-directory*))
      :default-binary-pathname
      #-(or allegro lucid lispworks)
      (make-pathname :host "CLIP" :defaults (merge-pathnames *default-binary-path* 
							     "clip:source;"))
      #+(or lucid allegro lispworks)
      (make-pathname
       :directory `(,@(pathname-directory *clip-root-pathname*)
		      ,*clip-source-directory*
		      #+(and allegro mips)
		      "bin-allegro-mips"
		      #+(and allegro sparc)
		      "bin-allegro-sparc"
		      #+lucid
		      "bin-lucid"
                      #+lispworks
                      "bin-harlequin"))
      :needed-systems (extended-lisp)
      :load-before-compile (extended-lisp))

  ("packages")
  #+(or allegro lucid)
  ("patches")
  ("utilities")
  ("super-intrinsic-mixins")
  ("time-definitions")
  ("macros")
  ("parameters")
  ("intrinsic-mixins")
  ("class-defs")
  ("instrumentation")
  ("defclip")
  ("simulator")
  ("experiment-runner")
  ("define-experiment"))
  
;;;----------------------------------------------------------------------------

#+Explorer
(ticl::defsystem COMMON-LISP-INSTRUMENTATION-PACKAGE
  (:name "Common Lisp Instrumentation Package")
  (:short-name "CLIP")
  (:pathname-default "clip:source;")
  (:default-output-directory "clip:binary;")
  (:component-systems
    :extended-lisp)
  (:do-components)
  (:compile-load-modules
    ("PACKAGES"
     "UTILITIES"
     "SUPER-INTRINSIC-MIXINS"
     "TIME-DEFINITIONS"
     "MACROS"
     "PARAMETERS"
     "INTRINSIC-MIXINS"
     "CLASS-DEFS"
     "INSTRUMENTATION"
     "DEFCLIP"
     "SIMULATOR"
     "EXPERIMENT-RUNNER"
     "DEFINE-EXPERIMENT")))

;;; ***************************************************************************
;;; EOF
