/*
 * These routines writen in C will allow use of the termcap file
 * by any lisp program. They are very basic routines which initialize
 * termcap and allow the lisp to execute any of the termcap functions.
 */

#include <stdio.h>		/*add definations for I/O and bandrate */
#include <sgtty.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <cmpinclude.h>

#undef putchar

int putchar();
int	tgetflag();		/* functions used from the termlib */
char	*getenv();
char	*tgoto();
char	*tgetstr();

char 	bpbuf[1024];
char 	tstrbuf[100];
extern short 	ospeed;
extern char	PC;
extern char   *BC;
extern char   *UP;


static Ltermcapinit();
static Ltermcapexe();
static char *Cstart;
static int Csize;
static object Cdata;
static object VV[3];

/* making termcap.o :
cc -c termcap.c -o termcap2.o
ld -r -ltermcap termcap2.o -o termcap.o
rm termcap2.o
cat termcap.data >> termcap.o
*/
/* contents of file termcap.data :

#(
"wrong number of arguments"
user::termcapinit
user::termcapexe
)
*/

init_code(start,size,data)
char *start;
int size;
object data;
{
    register    object *base = vs_top;
    register    object *sup = base;

    vs_top = sup;
    vs_check;
    Cstart = start;
    Csize = size;
    Cdata = data;
    set_VV (VV, 3, data);
    MF (VV[1], Ltermcapinit, start, size, data);
    MF (VV[2], Ltermcapexe, start, size, data);
    vs_top = vs_base = base;
}


/*
/*	This routine will initialize the termcap for the lisp programs.
/*	If the termcap file is not found, or terminal type is undefined,
/*	it will print out an error mesg.				*/

static Ltermcapinit()
{
    char   *cp = getenv ("TERM");
    char   *pc;
    int     found;
    struct sgttyb   tty;

    vs_reserve(1);
    check_arg(0);
    vs_top = vs_base + 1;
    found = tgetent (bpbuf, cp);/* open ther termcap file */
    switch (found) {
	case -1: 
	    printf ("\nError Termcap File not found \n");
	    break;
	case 0: 
	    printf ("\nError No Termcap Entry for this terminal \n");
	    break;
	case 1: {		/* everything was ok	 */
		gtty (1, &tty);
		ospeed = tty.sg_ospeed;
	    }
	    break;
    }
    cp = tstrbuf;
    BC = tgetstr ("bc", &cp);
    UP = tgetstr ("up", &cp);
    pc = tgetstr ("pc", &cp);
    if (pc)
	PC = *pc;
    vs_base[0] = Cnil;
    return;
}


/* This routine will execute any of the termcap functions used by the lisp
/* program. If the feature is not include in the terminal defined it will
/* ignore the call.
/*		option	: feature to execute
/*		line	: line if is nessery
/*		colum	: colum if is nessaery
/*									*/

static Ltermcapexe()
{
    register    object *base = vs_base;
    register    object *sup = base + 4;
    int     line,
            column,
            i,
            l;
    char    option[10],
           *s;

    vs_reserve (4);
    switch (vs_top - vs_base) {
	case 0: 
	    too_few_arguments ();
	case 1: 
	    line = column = 0;
	    break;
	case 2: 
	    base[3] = VV[0];
	    vs_top = (vs_base = base + 3) + 1;
	    Lerror ();
	    vs_top = sup;
	    break;
	case 3: 
	    line = fix (base[1]);
	    column = fix (base[2]);
	    break;
	default: 
	    too_many_arguments ();
    }
    l = base[0] -> st.st_fillp;
    s = base[0] -> st.st_self;
    for (i = 0; i < l; i++)
	option[i] = s[i];
    option[l] = '\0';
    base[0] = make_fixnum (show (option, &line, &column));
    vs_top = (vs_base = base) + 1;
    return;

}


static show (option, line, column)
char *option;
int  *line,*column;
{
    int     found;
    char    clbuf[20];
    char   *clbp = clbuf;
    char   *clear;

    clear = tgetstr (option, &clbp);
    if (!clear) {
	found = tgetnum (option);
	if (found)
	    return (found);
	return (-1);
    }
    PC = ' ';
    if (strcmp (option, "cm") == 0) {      /* if cursor motion, do it */
	clear = tgoto (clear, *column, *line);
	if (*clear == 'O')
	    clear = 0;
    }
    if (clear)			           /* execute the feature */
	tputs (clear, 0, putchar);
    return (0);
}

/*
 * A subroutine version of the macro putchar
 */
int putchar(c)
register c;
{
	putc(c, stdout);
}

