#! /bin/sh
# This is a shell archive.  Remove anything before this line, then unpack
# it by saving it into a file and typing "sh file".  To overwrite existing
# files, type "sh file -c".  You can also feed this as standard input via
# unshar, or by typing "sh <file", e.g..  If this archive is complete, you
# will see the following message at the end:
#		"End of shell archive."
# Contents:  termcap.c edit.lsp
# Wrapped by andreasg@sigi on Tue May 19 10:40:12 1992
PATH=/bin:/usr/bin:/usr/ucb ; export PATH
if test -f 'termcap.c' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'termcap.c'\"
else
echo shar: Extracting \"'termcap.c'\" \(4049 characters\)
sed "s/^X//" >'termcap.c' <<'END_OF_FILE'
X/*
X * These routines writen in C will allow use of the termcap file
X * by any lisp program. They are very basic routines which initialize
X * termcap and allow the lisp to execute any of the termcap functions.
X */
X
X#include <stdio.h>		/*add definations for I/O and bandrate */
X#include <sgtty.h>
X#include <sys/types.h>
X#include <sys/stat.h>
X#include <pwd.h>
X#include <cmpinclude.h>
X
X#undef putchar
X
Xint putchar();
Xint	tgetflag();		/* functions used from the termlib */
Xchar	*getenv();
Xchar	*tgoto();
Xchar	*tgetstr();
X
Xchar 	bpbuf[1024];
Xchar 	tstrbuf[100];
Xextern short 	ospeed;
Xextern char	PC;
Xextern char   *BC;
Xextern char   *UP;
X
X
Xstatic Ltermcapinit();
Xstatic Ltermcapexe();
Xstatic char *Cstart;
Xstatic int Csize;
Xstatic object Cdata;
Xstatic object VV[3];
X
X/* making termcap.o :
Xcc -c termcap.c -o termcap2.o
Xld -r -ltermcap termcap2.o -o termcap.o
Xrm termcap2.o
Xcat termcap.data >> termcap.o
X*/
X/* contents of file termcap.data :
X
X#(
X"wrong number of arguments"
Xuser::termcapinit
Xuser::termcapexe
X)
X*/
X
Xinit_code(start,size,data)
Xchar *start;
Xint size;
Xobject data;
X{
X    register    object *base = vs_top;
X    register    object *sup = base;
X
X    vs_top = sup;
X    vs_check;
X    Cstart = start;
X    Csize = size;
X    Cdata = data;
X    set_VV (VV, 3, data);
X    MF (VV[1], Ltermcapinit, start, size, data);
X    MF (VV[2], Ltermcapexe, start, size, data);
X    vs_top = vs_base = base;
X}
X
X
X/*
X/*	This routine will initialize the termcap for the lisp programs.
X/*	If the termcap file is not found, or terminal type is undefined,
X/*	it will print out an error mesg.				*/
X
Xstatic Ltermcapinit()
X{
X    char   *cp = getenv ("TERM");
X    char   *pc;
X    int     found;
X    struct sgttyb   tty;
X
X    vs_reserve(1);
X    check_arg(0);
X    vs_top = vs_base + 1;
X    found = tgetent (bpbuf, cp);/* open ther termcap file */
X    switch (found) {
X	case -1: 
X	    printf ("\nError Termcap File not found \n");
X	    break;
X	case 0: 
X	    printf ("\nError No Termcap Entry for this terminal \n");
X	    break;
X	case 1: {		/* everything was ok	 */
X		gtty (1, &tty);
X		ospeed = tty.sg_ospeed;
X	    }
X	    break;
X    }
X    cp = tstrbuf;
X    BC = tgetstr ("bc", &cp);
X    UP = tgetstr ("up", &cp);
X    pc = tgetstr ("pc", &cp);
X    if (pc)
X	PC = *pc;
X    vs_base[0] = Cnil;
X    return;
X}
X
X
X/* This routine will execute any of the termcap functions used by the lisp
X/* program. If the feature is not include in the terminal defined it will
X/* ignore the call.
X/*		option	: feature to execute
X/*		line	: line if is nessery
X/*		colum	: colum if is nessaery
X/*									*/
X
Xstatic Ltermcapexe()
X{
X    register    object *base = vs_base;
X    register    object *sup = base + 4;
X    int     line,
X            column,
X            i,
X            l;
X    char    option[10],
X           *s;
X
X    vs_reserve (4);
X    switch (vs_top - vs_base) {
X	case 0: 
X	    too_few_arguments ();
X	case 1: 
X	    line = column = 0;
X	    break;
X	case 2: 
X	    base[3] = VV[0];
X	    vs_top = (vs_base = base + 3) + 1;
X	    Lerror ();
X	    vs_top = sup;
X	    break;
X	case 3: 
X	    line = fix (base[1]);
X	    column = fix (base[2]);
X	    break;
X	default: 
X	    too_many_arguments ();
X    }
X    l = base[0] -> st.st_fillp;
X    s = base[0] -> st.st_self;
X    for (i = 0; i < l; i++)
X	option[i] = s[i];
X    option[l] = '\0';
X    base[0] = make_fixnum (show (option, &line, &column));
X    vs_top = (vs_base = base) + 1;
X    return;
X
X}
X
X
Xstatic show (option, line, column)
Xchar *option;
Xint  *line,*column;
X{
X    int     found;
X    char    clbuf[20];
X    char   *clbp = clbuf;
X    char   *clear;
X
X    clear = tgetstr (option, &clbp);
X    if (!clear) {
X	found = tgetnum (option);
X	if (found)
X	    return (found);
X	return (-1);
X    }
X    PC = ' ';
X    if (strcmp (option, "cm") == 0) {      /* if cursor motion, do it */
X	clear = tgoto (clear, *column, *line);
X	if (*clear == 'O')
X	    clear = 0;
X    }
X    if (clear)			           /* execute the feature */
X	tputs (clear, 0, putchar);
X    return (0);
X}
X
X/*
X * A subroutine version of the macro putchar
X */
Xint putchar(c)
Xregister c;
X{
X	putc(c, stdout);
X}
X
END_OF_FILE
if test 4049 -ne `wc -c <'termcap.c'`; then
    echo shar: \"'termcap.c'\" unpacked with wrong size!
fi
# end of 'termcap.c'
fi
if test -f 'edit.lsp' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'edit.lsp'\"
else
echo shar: Extracting \"'edit.lsp'\" \(11130 characters\)
sed "s/^X//" >'edit.lsp' <<'END_OF_FILE'
X;;;___________________________________________________________________________
X;;;
X;;;                       System: edit
X;;;                       (Version 1.1)
X;;;
X;;; Copyright (c): Forschungsgruppe INFORM
X;;;                Universitaet Stuttgart
X;;;
X;;; File:		       edit.lsp
X;;; Last Modification Time:    Thu Apr  7 11:40:39 1988
X;;; Last Modification By:      Andreas Girgensohn 
X;;;
X;;;
X;;; Changes (worth to be mentioned):
X;;; ================================
X;;;___________________________________________________________________________ 
X
X;;; terminal independent routines of TERMCAP are used
X
X(eval-when (compile load eval)
X  (unless (fboundp 'termcapinit)
X    (load "/users/andreasg/cl/topreader/termcap")))
X(termcapinit)
X
X(eval-when (compile load eval)
X  (defmacro tcexe (func &rest rest)
X    `(termcapexe ,(string-downcase (symbol-name func)) ,@rest))
X
X  (defconstant $left-paren-char$ #\()
X  (defconstant $right-paren-char$ #\))
X  (defconstant $double-quote-char$ #\")
X  
X  (defstruct (buffer-structure
X	       (:conc-name buffer-))
X	     (cursor-x 0)
X	     (cursor-y 0)
X	     (lines (list (get-empty-line))))
X)
X
X;;; main loop
X
X(defun editor-loop (*buffer* &optional (prompt ""))
X  (declare (special *buffer*))
X  (check-type prompt string)
X  (let ((*indent* (length prompt)))
X    (declare (special *indent*))
X    (princ prompt)
X    (display-buffer *buffer*)
X    (do ((*exit-flag* nil))
X	(*exit-flag* *buffer*)
X	(declare (special *exit-flag*))
X	(in-tyimode 1
X		    (let ((char (read-char)))
X		      (execute-command char))))))
X
X(defun execute-command (char)
X  (declare (special *editor-readtable*))
X  (funcall (aref *editor-readtable* (char-int char)) char))
X
X;;; readtable
X
X(defun make-editor-readtable ()
X  (let ((tr (make-array '(128))))
X    (do ((i 0 (1+ i))) ((> i 31))
X	(setf (aref tr i) 'illegal-operation))
X    (do ((i 32 (1+ i))) ((> i 127))
X	(setf (aref tr i) 'self-insert))
X    (dolist (l `((#\% exit-editor)	       ; test
X		 (#\^A beginning-of-line)
X		 (#\^B backward-character)
X		 (#\^D delete-next-character)
X		 (#\^E end-of-line)
X		 (#\^F forward-character)
X		 (#\tab indent-line)
X		 (#\newline newline-and-indent)
X		 (#\^K kill-to-end-of-line)
X		 (#\return newline)
X		 (#\^N next-line)
X		 (#\^P previous-line)
X		 (,$right-paren-char$ self-insert) ; right-paren
X		 (#\; illegal-operation)
X		 (#\rubout delete-previous-character)))
X      (setf (aref tr (char-int (car l))) (cadr l)))
X    tr))
X
X(locally (declare (special *editor-readtable*))
X  (setq *editor-readtable* (make-editor-readtable)))
X
X;;; utility functions
X
X(defun display-buffer (buffer)
X  (declare (special *indent*))
X  (check-type buffer buffer-structure)
X  (princ (car (buffer-lines buffer)))
X  (terpri)
X  (dolist (line (cdr (buffer-lines buffer)))
X    (printblanks *indent*)
X    (princ line)
X    (terpri))
X  (termcap-set-cursor-relative 
X    (+ (buffer-cursor-x buffer) *indent*)
X    (- (buffer-cursor-y buffer) (length (buffer-lines buffer)))))
X
X(defun set-cursor (buffer x y)
X  (setf (buffer-cursor-x buffer) x
X	(buffer-cursor-y buffer) y))
X
X(locally (declare (special *line-resources*))
X  (setq *line-resources* nil))
X
X(defun dispose-line (line)
X  (declare (special *line-resources*))
X  (setf (fill-pointer line) 0)
X  (push line *line-resources*))
X
X(defun get-empty-line ()
X  (declare (special *line-resources*))
X  (or (pop *line-resources*)
X      (make-array '(80) :element-type 'string-char :fill-pointer 0 :adjustable t)))
X
X(defun printblanks (n &optional stream)
X  (let ((easy (member n '( 0  ""
X			   1  " "
X			   2  "  "
X			   3  "   "
X			   4  "    "
X			   5  "     "
X			   6  "      "
X			   7  "       "
X			   8  "        "))))
X    (if easy
X	(princ (cadr easy) stream)
X	(dotimes (i n)
X	  (write-char #\space stream)))))
X
X(defun beep ()
X  (write-char #\^G)
X  (force-output))
X
X(defun delete-linefeed ()
X  (declare (special *buffer*))
X  (cond ((eql (buffer-cursor-y *buffer*) (1- (length (buffer-lines *buffer*))))
X	 (beep))
X	(t (let ((current-line (nth (buffer-cursor-y *buffer*)
X				    (buffer-lines *buffer*)))
X		 (next-line (pop (cdr (nthcdr (buffer-cursor-y *buffer*)
X					      (buffer-lines *buffer*))))))
X	     (princ next-line)
X	     (dotimes (x (length next-line))
X	       (vector-push-extend (aref next-line x) current-line))
X	     (termcap-set-cursor-relative (- (length current-line)) +1)
X	     (termcap-delete-line)
X	     (termcap-set-cursor-relative (buffer-cursor-x *buffer*) -1)))))
X
X(locally (declare (special *main-buffer*))
X  (setq *main-buffer* (make-buffer-structure)))
X
X;;; reading a s-expression from an editor buffer
X
X(locally (declare (special *read-buffer*))
X  (setq *read-buffer*
X	(make-array '(500) :element-type 'string-char :fill-pointer 0)))
X
X(defun read-from-edit-buffer (buffer)
X  (declare (special *read-buffer*))
X  (setf (fill-pointer *read-buffer*) 0)
X  (format *read-buffer* "~A" (car (buffer-lines buffer)))
X  (dolist (line (cdr (buffer-lines buffer)))
X    (format *read-buffer* "~%~A" line))
X  (values (read-from-string *read-buffer*)))
X
X;;; termcap interface
X
X(defun termcap-set-cursor-relative (dx dy)
X  (if (minusp dx)
X      (dotimes (x (- dx))
X	(termcapexe "kl"))
X      (dotimes (x dx)
X	(termcapexe "kr")))
X  (if (minusp dy)
X      (dotimes (y (- dy))
X	(termcapexe "ku"))
X      (dotimes (y dy)
X	(termcapexe "kd"))))
X
X(defun termcap-insert-character (char)
X  (termcapexe "ic")
X  (write-char char)
X  (force-output))
X  
X(defun termcap-delete-character ()
X  (termcapexe "dc"))
X
X(defun termcap-clear-to-end-of-line ()
X  (termcapexe "ce"))
X
X(defun termcap-add-blank-line ()
X  (termcapexe "al"))
X
X(defun termcap-delete-line ()
X  (termcapexe "dl"))
X
X;;; commands
X
X(defun illegal-operation (char)
X  (declare (ignore char))
X  (beep))
X
X(defun self-insert (char)
X  (declare (special *buffer*))
X  (termcap-insert-character char)
X  (force-output)
X  (let* ((line (nth (buffer-cursor-y *buffer*) (buffer-lines *buffer*)))
X	 (line-length (length line))
X	 (column (buffer-cursor-x *buffer*)))
X    (cond ((eql column line-length)
X	   (vector-push-extend char line))
X	  (t (vector-push-extend #\space line)
X	     (do ((x line-length (1- x)))
X		 ((eql x column)
X		  (setf (aref line x) char))
X		 (setf (aref line x) (aref line (1- x))))))
X    (incf (buffer-cursor-x *buffer*))))
X
X(defun exit-editor (char)
X  (declare (special *exit-flag*) (ignore char))
X  (setq *exit-flag* t))
X
X(defun beginning-of-line (char)
X  (declare (special *buffer*) (ignore char))
X  (termcap-set-cursor-relative (- (buffer-cursor-x *buffer*)) 0)
X  (setf (buffer-cursor-x *buffer*) 0))
X
X(defun backward-character (char)
X  (declare (special *buffer*) (ignore char))
X  (cond ((plusp (buffer-cursor-x *buffer*))
X	 (termcap-set-cursor-relative -1 0)
X	 (decf (buffer-cursor-x *buffer*)))
X	((zerop (buffer-cursor-y *buffer*))
X	 (beep))
X	(t (decf (buffer-cursor-y *buffer*))
X	   (let ((column (length (nth (buffer-cursor-y *buffer*)
X				      (buffer-lines *buffer*)))))
X	     (termcap-set-cursor-relative column -1)
X	     (setf (buffer-cursor-x *buffer*) column)))))
X
X(defun delete-next-character (char)
X  (declare (special *buffer*) (ignore char))
X  (let* ((line (nth (buffer-cursor-y *buffer*) (buffer-lines *buffer*)))
X	 (line-length (length line)))
X    (cond ((eql (buffer-cursor-x *buffer*) line-length)
X	   (delete-linefeed))
X	  (t (do ((x (buffer-cursor-x *buffer*) (1+ x)))
X		 ((>= x (1- line-length))
X		  (vector-pop line))
X		 (setf (aref line x) (aref line (1+ x))))
X	     (termcap-delete-character)))))
X
X(defun end-of-line (char)
X  (declare (special *buffer*) (ignore char))
X  (let ((line-length
X	  (length (nth (buffer-cursor-y *buffer*) (buffer-lines *buffer*)))))
X    (termcap-set-cursor-relative (- line-length (buffer-cursor-x *buffer*)) 0)
X    (setf (buffer-cursor-x *buffer*) line-length)))
X
X(defun forward-character (char)
X  (declare (special *buffer*) (ignore char))
X  (cond ((< (buffer-cursor-x *buffer*)
X	    (length (nth (buffer-cursor-y *buffer*) (buffer-lines *buffer*))))
X	 (termcap-set-cursor-relative +1 0)
X	 (incf (buffer-cursor-x *buffer*)))
X	((eql (buffer-cursor-y *buffer*) (1- (length (buffer-lines *buffer*))))
X	 (beep))
X	(t (termcap-set-cursor-relative (- (buffer-cursor-x *buffer*)) +1)
X	   (incf (buffer-cursor-y *buffer*))
X	   (setf (buffer-cursor-x *buffer*) 0))))
X
X(defun indent-line (char)
X  (declare (special *buffer*) (ignore char))
X)
X
X(defun newline-and-indent (char)
X  (newline char)
X  (indent-line char))
X
X(defun kill-to-end-of-line (char)
X  (declare (special *buffer* *indent*) (ignore char))
X  (let ((line (nth (buffer-cursor-y *buffer*) (buffer-lines *buffer*))))
X    (cond ((eql (buffer-cursor-x *buffer*) (length line))
X	   (delete-linefeed))
X	  (t (setf (fill-pointer line) (buffer-cursor-x *buffer*))
X	     (termcap-clear-to-end-of-line)
X	     (terpri)
X	     (termcap-set-cursor-relative
X	       (+ (buffer-cursor-x *buffer*) *indent*) -1)))))
X
X(defun newline (char)
X  (declare (special *buffer* *indent*) (ignore char))
X  (let ((current-line (nth (buffer-cursor-y *buffer*) (buffer-lines *buffer*)))
X	(next-line (get-empty-line)))
X    (push next-line
X	  (cdr (nthcdr (buffer-cursor-y *buffer*) (buffer-lines *buffer*))))
X    (let ((column (buffer-cursor-x *buffer*)))
X      (when (< column (length current-line))
X	(dotimes (x (- (length current-line) column))
X	  (vector-push-extend (aref current-line (+ x column)) next-line))
X	(setf (fill-pointer current-line) column)
X	(termcap-clear-to-end-of-line)))
X    ;; terpri must be in last line of buffer iff scrolling is necessary
X    (let ((dy (- (length (buffer-lines *buffer*)) (buffer-cursor-y *buffer*) 2)))
X      (unless (zerop dy)
X	(termcap-set-cursor-relative 0 dy))
X      (terpri)
X      (unless (zerop dy)
X	(termcap-set-cursor-relative 0 (- dy))))
X    (termcap-add-blank-line)
X    (printblanks *indent*)
X    (princ next-line)
X    (termcap-set-cursor-relative (- (length next-line)) 0)
X    (force-output)
X    (incf (buffer-cursor-y *buffer*))
X    (setf (buffer-cursor-x *buffer*) 0)))
X
X(defun next-line (char)
X  (declare (special *buffer*) (ignore char))
X  (cond ((eql (buffer-cursor-y *buffer*) (1- (length (buffer-lines *buffer*))))
X	 (beep))
X	(t (incf (buffer-cursor-y *buffer*))
X	   (let ((line-length (length (nth (buffer-cursor-y *buffer*)
X					   (buffer-lines *buffer*))))
X		 (dx 0))
X	     (when (> (buffer-cursor-x *buffer*) line-length)
X	       (setf dx (- line-length (buffer-cursor-x *buffer*))
X		     (buffer-cursor-x *buffer*) line-length))
X	     (termcap-set-cursor-relative dx +1)))))
X
X(defun previous-line (char)
X  (declare (special *buffer*) (ignore char))
X  (cond ((zerop (buffer-cursor-y *buffer*))
X	 (beep))
X	(t (decf (buffer-cursor-y *buffer*))
X	   (let ((line-length (length (nth (buffer-cursor-y *buffer*)
X					   (buffer-lines *buffer*))))
X		 (dx 0))
X	     (when (> (buffer-cursor-x *buffer*) line-length)
X	       (setf dx (- line-length (buffer-cursor-x *buffer*))
X		     (buffer-cursor-x *buffer*) line-length))
X	     (termcap-set-cursor-relative dx -1)))))
X
X(defun delete-previous-character (char)
X  (declare (special *buffer*))
X  (cond ((and (zerop (buffer-cursor-x *buffer*))
X	      (zerop (buffer-cursor-y *buffer*)))
X	 (beep))
X	(t (backward-character char)
X	   (delete-next-character char))))
X
END_OF_FILE
if test 11130 -ne `wc -c <'edit.lsp'`; then
    echo shar: \"'edit.lsp'\" unpacked with wrong size!
fi
# end of 'edit.lsp'
fi
echo shar: End of shell archive.
exit 0

