(DEFINE-FILE-INFO READTABLE "XCL" PACKAGE "INTERLISP")
(FILECREATED "19-Oct-87 16:09:03" 
|{SUMEX}PS:<LISPUSERS.LYRIC>ACTIVEREGIONS.LSP;1| 8850   )


(PRETTYCOMPRINT ACTIVEREGIONSCOMS)

(RPAQQ ACTIVEREGIONSCOMS ((* * |public| |part|)
                          (RECORDS ACTIVEREGION)
                          (FNS * ACTIVEREGIONSFNS)
                          (* * |private| |part|)
                          (FNS * ACTIVEREGIONSHIDDENFNS)))
(* * |public| |part|)

(DECLARE\: EVAL@COMPILE

(RECORD ACTIVEREGION (REGION HELPSTRING DOWNFN UPFN HIGHLIGHTFN LOWLIGHTFN DATA
                            ))
)

(RPAQQ ACTIVEREGIONSFNS (SETACTIVEREGIONS ADDACTIVEREGION DELETEACTIVEREGION 
                               FINDACTIVEREGION SETPICKREGION GETPICKREGION))
(DEFINEQ

(SETACTIVEREGIONS
  (LAMBDA (|Window| |Regionlist| |Highlightfn| |Lowlightfn|)
                                               (* DRB\: " 1-SEP-82 15:28")
    (COND
       ((NOT (WINDOWP |Window|))
        (ERROR "SETACTIVEREGIONS: ARG NOT WINDOW" |Window|))
       (T (WINDOWPROP |Window| 'ACTIVEREGIONS |Regionlist|)
          (WINDOWPROP |Window| 'HIGHLIGHTFN
                 (AND |Regionlist| (OR |Highlightfn| (FUNCTION 
                                               ACTIVEREGIONS/DEFAULTHIGHLIGHTFN
                                                      ))))
          (WINDOWPROP |Window| 'LOWLIGHTFN (AND |Regionlist|
                                                (OR |Lowlightfn| |Highlightfn|
                                                    (FUNCTION 
                                               ACTIVEREGIONS/DEFAULTHIGHLIGHTFN
                                                     ))))
          (WINDOWPROP |Window| 'BUTTONEVENTFN (AND |Regionlist|
                                                   (FUNCTION 
                                                    ACTIVEREGIONS/BUTTONEVENTFN
                                                    )))
          (WINDOWPROP |Window| 'PICKREGION NIL)))))

(ADDACTIVEREGION
  (LAMBDA (|Window| |Activeregion|)            (* DRB\: " 1-SEP-82 15:17")
    (COND
       ((NOT (WINDOWP |Window|))
        (ERROR "ADDACTIVEREGION: ARG NOT WINDOW" |Window|)
        NIL)
       (T (WINDOWPROP |Window| 'ACTIVEREGIONS
                 (CONS |Activeregion| (WINDOWPROP |Window| 'ACTIVEREGIONS)))))))

(DELETEACTIVEREGION
  (LAMBDA (|Window| |Activeregion|)            (* DRB\: " 1-SEP-82 15:21")
    (COND
       ((NOT (WINDOWP |Window|))
        (ERROR "DELETEACTIVEREGION: ARG NOT WINDOW" |Window|)
        NIL)
       (T (AND (EQ |Activeregion| (GETPICKREGION |Window|))
               (SETPICKREGION |Window| NIL))
          (WINDOWPROP |Window| 'ACTIVEREGIONS
                 (DREMOVE |Activeregion| (WINDOWPROP |Window|
                                                'ACTIVEREGIONS)))))))

(FINDACTIVEREGION
  (LAMBDA (|Window| |Xcoord| |Ycoord| |Regionlist/optional|)
                                               (* DRB\: " 1-SEP-82 15:11")
    (COND
       ((NOT (WINDOWP |Window|))
        (ERROR "FINDACTIVEREGION: ARG NOT WINDOW" |Window|)
        NIL)
       (T (|for| X |in| (OR |Regionlist/optional| (WINDOWPROP |Window|
                                                         'ACTIVEREGIONS))
             |thereis| (ACTIVEREGIONS/CHECKPOSITION (|fetch|
                                                     (ACTIVEREGION REGION)
                                                       |of| X)
                              |Xcoord| |Ycoord|))))))

(SETPICKREGION
  (LAMBDA (|Window| |Activeregion| |Oldregion/local|)
                                               (* DRB\: " 2-SEP-82 15:12")
    (COND
       ((NOT (WINDOWP |Window|))
        (ERROR "DELETEACTIVEREGION: ARG NOT WINDOW" |Window|)
        NIL)
       ((NEQ |Activeregion| (SETQ |Oldregion/local| (GETPICKREGION |Window|)))
        (AND |Oldregion/local| (ACTIVEREGIONS/DOLOWLIGHT |Window| 
                                      |Oldregion/local|))
        (AND |Activeregion| (PROGN (APPLY* (OR (|fetch| (ACTIVEREGION DOWNFN)
                                                  |of| |Activeregion|)
                                               (FUNCTION NILL))
                                          |Window|
                                          (|fetch| (ACTIVEREGION REGION)
                                             |of| |Activeregion|)
                                          (|fetch| (ACTIVEREGION DATA)
                                             |of| |Activeregion|))
                                   (MOUSESTATE LEFT))
             (PROGN (ACTIVEREGIONS/DOHIGHLIGHT |Window| |Activeregion|)
                    |Activeregion|)))
       (T |Activeregion|))))

(GETPICKREGION
  (LAMBDA (|Window|)                           (* DRB\: " 1-SEP-82 10:43")
    (WINDOWPROP |Window| 'PICKREGION)))
)
(* * |private| |part|)


(RPAQQ ACTIVEREGIONSHIDDENFNS (ACTIVEREGIONS/BUTTONEVENTFN 
                                     ACTIVEREGIONS/CHECKPOSITION 
                                     ACTIVEREGIONS/DOHIGHLIGHT 
                                     ACTIVEREGIONS/DOLOWLIGHT 
                                     ACTIVEREGIONS/DEFAULTHIGHLIGHTFN))
(DEFINEQ

(ACTIVEREGIONS/BUTTONEVENTFN
  (LAMBDA (|Window|)                           (* DRB\: " 2-SEP-82 14:09")
    (|while| (MOUSESTATE LEFT) |bind| (PLACELIST _ (WINDOWPROP |Window|
                                                          'ACTIVEREGIONS))
                                     (LASTPLACE _ (GETPICKREGION |Window|))
       |do| (SETQ LASTPLACE (SETPICKREGION |Window| (FINDACTIVEREGION
                                                     |Window|
                                                     (LASTMOUSEX |Window|)
                                                     (LASTMOUSEY |Window|)
                                                     PLACELIST)))
       |finally| (PROGN (AND LASTPLACE (APPLY*
                                        (OR (|fetch| (ACTIVEREGION UPFN)
                                               |of| LASTPLACE)
                                            (FUNCTION NILL))
                                        |Window|
                                        (|fetch| (ACTIVEREGION REGION)
                                           |of| LASTPLACE)
                                        (|fetch| (ACTIVEREGION DATA)
                                           |of| LASTPLACE)))
                        (RETURN LASTPLACE)))))

(ACTIVEREGIONS/CHECKPOSITION
  (LAMBDA (|Region| |Xcoord| |Ycoord|)         (* DRB\: " 1-SEP-82 09:44")
                                               (* |Returns| NIL |unless|
                                               (|Xcoord| |Ycoord|) |is| 
                                               |within| |Region|)
    (AND (IGEQ |Xcoord| (|fetch| (REGION LEFT) |of| |Region|))
         (ILEQ |Xcoord| (|fetch| (REGION RIGHT) |of| |Region|))
         (IGEQ |Ycoord| (|fetch| (REGION BOTTOM) |of| |Region|))
         (ILEQ |Ycoord| (|fetch| (REGION TOP) |of| |Region|)))))

(ACTIVEREGIONS/DOHIGHLIGHT
  (LAMBDA (|Window| |Activeregion|)            (* DRB\: " 2-SEP-82 15:10")
    (APPLY* (OR (|fetch| (ACTIVEREGION HIGHLIGHTFN) |of| |Activeregion|)
                (WINDOWPROP |Window| 'HIGHLIGHTFN)
                (FUNCTION NILL))
           |Window| |Activeregion|)
    (WINDOWPROP |Window| 'PICKREGION |Activeregion|)))

(ACTIVEREGIONS/DOLOWLIGHT
  (LAMBDA (|Window| |Activeregion|)            (* DRB\: " 2-SEP-82 15:11")
    (APPLY* (OR (|fetch| (ACTIVEREGION LOWLIGHTFN) |of| |Activeregion|)
                (WINDOWPROP |Window| 'LOWLIGHTFN)
                (FUNCTION NILL))
           |Window| |Activeregion|)
    (WINDOWPROP |Window| 'PICKREGION NIL)))

(ACTIVEREGIONS/DEFAULTHIGHLIGHTFN
  (LAMBDA (|Window| |Activeregion|)            (* |ejs:| "12-OCT-82 23:58")
    (PROG ((WC (DSPCLIPPINGREGION NIL |Window|)))
          (BITBLT NIL NIL NIL |Window| (|fetch| (REGION LEFT) |of| WC)
                 (|fetch| (REGION BOTTOM) |of| WC)
                 (|fetch| (REGION WIDTH) |of| WC)
                 (|fetch| (REGION HEIGHT) |of| WC)
                 'TEXTURE
                 'INVERT BLACKSHADE (|fetch| (ACTIVEREGION REGION)
                                       |of| |Activeregion|)))))
)
(DECLARE\: DONTCOPY
  (FILEMAP (NIL (807 5096 (SETACTIVEREGIONS 819 . 2070) (ADDACTIVEREGION 2074 . 
2426) (DELETEACTIVEREGION 2430 . 2955) (FINDACTIVEREGION 2959 . 3674) (
SETPICKREGION 3678 . 4946) (GETPICKREGION 4950 . 5093)) (5465 8825 (
ACTIVEREGIONS/BUTTONEVENTFN 5477 . 6834) (ACTIVEREGIONS/CHECKPOSITION 6838 . 
7474) (ACTIVEREGIONS/DOHIGHLIGHT 7478 . 7853) (ACTIVEREGIONS/DOLOWLIGHT 7857 . 
8218) (ACTIVEREGIONS/DEFAULTHIGHLIGHTFN 8222 . 8822)))))
STOP
