;;;;numb-o-rama
;;;; MCMXCII Northwestern University Institute for the Learning Sciences
;;;;Richard Lynch
;;;;lynch@ils.nwu.edu
;;;;
;;;;This code is provided free of charge.  No warranty, express or implied.
;;;;Please send [suggestions for] improvements to the above or Snail:
;;;;1890 Maple
;;;;Evanston, IL  60201

#|

I don't know about y'all, but I often find myself hacking furiously all night
and then fixing the detail work on the interface at dawn.  At that point,
estimating #@(57 69) and calculating #@(345 243) - #@(57 69) because that's
where the sub-view should go is a difficult problem.

My brain is numb.  [Pronounced with a hard B.]

I can't do numbers.

Hence, NUMB-O-RAMA:  (puns intended)

It is a windoid to display the current mouse position in global coordinates and
for  window-count windows.  window-count defaults to 0, and may be changed with
a control in the numb-o-rama.

NUMB-O-RAMA is available from the Tools menu [sorry if that's unkosher].
I made the command key:  -=.  A little inconvenient, but memorable.

When a NUMB-O-RAMA is visible, this menu-item pastes the current view mouse
position of the front-most window under the mouse into the front-most
fred-window.  ie, It pastes the coordinates you want where you want them.

Thus, you can have one or more fred-windows overlaying your display, move the
mouse around to the correct position on your display window and paste the right
coordinates into your fred-window.

Enjoy.

|#

;;;;I actually keep this in font-info.lisp along with font-ascent etc...
(defun font-widmax (&optional font-spec)
"&optional font-spec
Returns the widmax of font-spec."
  (third (multiple-value-list (font-info font-spec)))
)

;;;;I thought this had been done...
(defmethod find-view-containing-point ((view null) h &optional v direct-subviews-only)
  (declare (ignore direct-subviews-only))
  (find-if #'(lambda (w) (view-contains-point-p w (make-point h v)))
           (windows)
) )

(defparameter *numb-o-rama-menu-item*
  (make-instance 'menu-item
    :menu-item-title "Numb-O-Rama"
    :command-key #\=
    :menu-item-action
    #'(lambda ()
        (if (windows :class 'numb-o-rama :include-windoids t)
          (let* ((global (view-mouse-position nil))
                 (win (find-view-containing-point nil global))
                 (local (view-mouse-position win))
                 (string (point-string local))
                 (fred (front-window :class 'fred-window))
                )
            (if fred
              (progn
                (buffer-insert (fred-buffer fred) string)
                ;Invalidate the view and update window-needs-saving-p
                (fred-update fred)
              )
              (ed-beep)
          ) )
          (progn
            (make-instance 'numb-o-rama)
            (set-menu-item-title *numb-o-rama-menu-item* "Paste hv")
          )
      ) )
) )

(defclass numb-o-rama (windoid)
  ((window-count
     :documentation "Number of windows to display."
     :accessor window-count
     :initarg :window-count
     :initform 0
     :type 'fixnum
   )
   (last-mouse-pos
     :documentation "Maintains the last global mouse-position displayed."
     :accessor last-mouse-pos
     :initarg :last-mouse-pos
     :initform (view-mouse-position nil)
     :type 'fixnum
   )
  )
  (:default-initargs
    :close-box-p t
    :view-size #@(1 1)
    :view-font '("Monaco" 9)
  )
  (:documentation
   "Displays view-mouse-position in global coordinates and some windows.
User can alter number of windows to display."
  )
)

(defun short-window-title (window)
  "window
Returns mac-file-namestring if window is a fred-window and has a
window-filename.  Otherwise returns window-title."
  (if (and (typep window 'fred-window) (window-filename window))
    (mac-file-namestring (window-filename window))
    (window-title window)
) )

(defmethod window-strings ((view numb-o-rama))
  "numb-o-rama
Returns the list of strings of windows to display."
  (let* ((wins (windows))
         (wins (subseq wins 0 (min (length wins) (window-count view))))
         (strings (mapcar #'short-window-title wins))
        )
    (push "Global" strings)
) )

(defmethod coordinates-width ((view numb-o-rama))
  "view
Returns the maximum width of a point-string in the view."
  ;Far as I know, the largest screen available is O(1000) x O(100).
  ;So, #@(XXXX XXX) => 12 characters max.
  ;Thus, I use lucky 13 below, 1 extra for cousin Murphy.
  (* (font-widmax (view-font view)) 13)
)

(defmethod control-height ((view numb-o-rama))
  "Returns the height of the controls in a numb-o-rama."
  16
)

(defmethod auto-size ((view numb-o-rama))
  "numb-o-rama
Calculates the width that a numb-o-rama should be."
  (let* ((font (view-font view))
         (strings (window-strings view))

         (strings-widths (mapcar #'string-width strings))
         (strings-max-width (apply #'max strings-widths))

         (coordinates-max-width (coordinates-width view))
         (white-space-width 14)
         (width (+ strings-max-width coordinates-max-width white-space-width))

         (lines (length strings))
         (strings-height (* lines (font-line-height font)))
         (control-height (control-height view))
         (white-space-height 10)
         (height (+ strings-height control-height white-space-height))
        )
    (make-point width height)
) )

(defmethod set-view-size-auto ((view numb-o-rama))
  (set-view-size view (auto-size view))
)

(defmethod initialize-instance :after ((view numb-o-rama) &key)
  (set-view-size-auto view)
)

(defmethod view-draw-contents :before ((view numb-o-rama))
  (rlet ((rect :rect :topleft #@(0 0) :bottomright (view-size view)))
    (#_EraseRect rect)
) )

(defun string-lines (string-list)
  "string-list
Concatenates the strings of string-list with NewLines between them."
  (reduce #'(lambda (s1 s2) (concatenate 'string s1 #.(string #\NewLine) s2))
          string-list
) )

(defmethod view-draw-contents :after ((view numb-o-rama))
  ;Draw control
#|
  /\
  ==
  \/
|#
  (let* ((start-h 2)
         (start-v 9)
        )
    (#_MoveTo start-h start-v)
    (with-fore-color (if (zerop (window-count view)) *gray-color* *black-color*)
      (#_Line 16 0)
      (#_Line -8 -8)
      (#_Line -8 8)
    )
    (#_Move 0 2)
    (with-fore-color (if (>= (window-count view) (length (windows))) *gray-color* *black-color*)
      (#_Line 16 0)
      (#_Line -8 8)
      (#_Line -8 -8)
    )
    (#_MoveTo 24 14)
    (with-pstrs ((str (format nil "~A" (window-count view))))
      (#_DrawString str)
  ) )
  ;Draw strings.
  (let* ((topleft #@(2 22))
         (size (view-size view))
         (width (point-h size))
         (height (point-v size))

         ;The 4s below are for white-space.
         (right (- width (coordinates-width view) 4))
         (bottom (- height 4))
         (strings (window-strings view))
         (string (string-lines strings))
        )
    (rlet ((rect :rect :topleft topleft :right right :bottom bottom)
           (temp :pointer)
          )
      (with-pstrs ((str string))
        (%setf-macptr temp str)
        (%incf-ptr temp)
        (#_TextBox temp (%get-byte str) rect #$teJustRight)
  ) ) )
  ;Draw coordinates
  (let* ((size (view-size view))
         (view-width (point-h size))
         (view-height (point-v size))
         (top 22)
         (left (- view-width (coordinates-width view)))
         ;2 and 4 below are white-space.
         (bottom (- view-height 4))
         (right (- view-width 2))
         (w-c (min (length (windows)) (window-count view)))
         (coordinates
           (mapcar #'view-mouse-position (cons nil (subseq (windows) 0 w-c)))
         )
         (strings (mapcar #'point-string coordinates))
         (string (string-lines strings))
        )
    (rlet ((rect :rect :left left :top top :right right :bottom bottom)
           (temp :pointer)
          )
      (with-pstrs ((str string))
        (%setf-macptr temp str)
        (%incf-ptr temp)
        (#_TextBox temp (%get-byte str) rect #$teJustLeft)
) ) ) )

(defmethod view-click-event-handler :after ((view numb-o-rama) where)
  (rlet ((up :rect :left 2 :top 2  :right 18 :bottom 11)
         (dn :rect :left 2 :top 11 :right 18 :bottom 20)
        )
    (cond
      ((#_PtInRect where up)
       (unless (zerop (window-count view))
         (setf (window-count view)
               (min (1- (window-count view)) (length (windows)))
         )
         (set-view-size-auto view)
         (invalidate-view view)
      ))
      ((#_PtInRect where dn)
       (unless (>= (window-count view) (length (windows)))
         (setf (window-count view) (min (1+ (window-count view)) (length (windows))))
         (set-view-size-auto view)
         (invalidate-view view)
      ))
) ) )

(defmethod window-close :after ((view numb-o-rama))
  (set-menu-item-title *numb-o-rama-menu-item* "Numb-O-Rama")
)

(add-menu-items *tools-menu*
  (make-instance 'menu-item :menu-item-title "-")
  *numb-o-rama-menu-item*
)

;;;;This should really be replaced.
(defmethod window-null-event-handler :after ((view window))
  (mapc
    #'(lambda (view)
        (unless (= (last-mouse-pos view) (setf (last-mouse-pos view) (view-mouse-position nil)))
          (invalidate-view view)
      ) )
    (windows :class 'numb-o-rama :include-windoids t)
) )
;;;;Too bad windoids don't get a crack at window-null-event-handler...

#|

(defclass boxed-static-text-dialog-item (static-text-dialog-item) ())

(defmethod view-draw-contents :after ((view boxed-static-text-dialog-item))
  (let* ((topleft (view-position view))
         (bottomright (add-points topleft (view-size view)))
        )
    (rlet ((rect :rect :topleft topleft :bottomright bottomright))
      (#_InsetRect rect -2 -2)
      (#_FrameRect rect)
) ) )

(make-instance 'window
  :view-subviews
  (list
    (make-instance 'boxed-static-text-dialog-item
      :dialog-item-text "Where Am I?"
      :view-font '("Monaco" 14)
      :view-position (make-point
                       (print
                         (random
                           (- (point-h *window-default-size*)
                              (string-width "Where Am I?" '("Monaco" 14))
                       ) ) )
                       (print
                         (random
                           (- (point-v *window-default-size*)
                              (font-line-height '("Monaco" 14))
                      ) ) ) )
) ) )

(make-instance 'numb-o-rama)

|#
