;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; This code was written by James Rice.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.

;;; The development of this software was assisted by the following grants:
;;; Biomedical Research Technology Program of the National Institutes
;;; of Health under grant RR-00785
;;; Information Systems Technologies office of the Defense Advanced
;;; Research Projects Agency under contract N00039-86-C0033.

;;; **********************************************************************


(defmacro defsystems (names &body body)
"Define a number of systems with the same defintion but different names
and pathname defaults.
"
  `(progn ,@(mapcar #'(lambda (name)
			`(defsystem ,(first name)
			   (:Pathname-Default ,(second name))
			   ,@body
			 )
		      )
		    names
            )
   )
)

;;; The actual defsystem for the IMAP client and server.  Note:  this define
;;; both YW and New-YW.

(defsystems ((yes-way "Yes-Way:Yes-Way;") (new-yes-way "New-Yes-Way:Yes-Way;"))
  (:Name "Explorer IMAP Client and Server.")
  #-KSL (:Default-Output-Directory "lm:output;")
  (:output-version :newest)
  #-KSL (:Module compatibility (("KSL-ENVIRONMENT-EMULATION")))
  (:Module packages (("PACKAGE-DEFINITION") ("SERVER-PACKAGE-DEFINITION")))
  (:Module site (("SITE")))
  (:Module vars (("VARS") ("SYSTEM-VARS")))
  (:Module server-vars (("SERVER-VARS")))
  (:Module profile (("PROFILE-INTERFACE")))
  (:Module optimizers (("OPTIMIZERS") ("GETHASH")))
  (:Module defstructs (("DEFSTRUCTS")))
  (:Module environment (("PERSPECTIVES")))
  (:Module macros (("MACROS") ("ZMACS-MACROS")))
  (:Module server-defstructs (("SERVER-DEFSTRUCTS")))
  (:Module server-macros (("SERVER-MACROS")))
  (:Module server-definition
	   (("SERVER-PARSE-MAIL-FILE")
	    ("SERVER-TOP-LEVEL")
	    ("SERVER-FETCH-AND-STORE")
	    ("SERVER-SEARCH")
	    ("SERVER-IMPLEMENTATION")
	   )
  )
  (:Module protocol-flavors
	   (("PROTOCOL-FLAVORS"))
  )
  (:Module protocol-support
	   (("IMAP-PROTOCOL") ("IMAP-PARSER") ("SMTP") ("NNTP"))
  )
  (:Module mail-control-window (("MAIL-CONTROL-WINDOW")))
  (:Module body (("TYPEIN-MODES")
		 ("MESSAGE-DESCRIPTOR")
		 ("MESSAGE-SEQUENCE")
		 ("MULTIPART-MULTIMEDIA-STUFF")
		 ("MINOR-WINDOWS")
		 ("RULES")
		 ("SERVERS")
		 ("SUMMARY-WINDOW")
		)
  )
  (:Module mail-control-window-methods
	   (("MCW-METHODS")
	    ("TOP-LEVEL-COMMANDS")
	    ("MESSAGE-SEQUENCE-COMMANDS")
	    ("DATABASES")
	    ("COMMAND-PARSER")
	   )
  )
  (:Module ucl-stuff (("UCL-EXTENSIONS") ("RUBOUT-HANDLER-STUFF")))
  (:Module zmacs-stuff
	   (("ZMACS-MAIL-COMMANDS")
	    ("GRIND-REGION")
	    ("ZMACS-INTERFACE")
	    ("SUGGESTIONS")
	   )
  )
  (:Module wrapup
	   (("LATE-VARS") ("DEFSTRUCT-PATCHES") ("MAIL-PATCHES") ("WRAPUP"))
  )
  #-KSL (:Compile-Load compatibility) 
  (:Compile-Load packages #-KSL (:Fasload compatibility))
  (:Compile-Load site (:Fasload packages))
  (:Compile-Load profile (:Fasload packages))
  (:Compile-Load-Init vars (packages profile site)
		      (:Fasload packages site profile)
  )
  (:Compile-Load server-defstructs (:Fasload packages))
  (:Compile-Load-Init server-vars (packages server-defstructs)
		      (:Fasload packages server-defstructs)
		      (:Fasload packages server-defstructs)
  )
  (:Compile-Load server-macros
		 (:Fasload packages server-defstructs server-vars)
  )
  (:Compile-Load-Init optimizers (packages) (:fasload packages vars))
  (:Compile-Load-Init defstructs (packages) (:fasload packages vars optimizers))
  (:Compile-Load-Init macros (packages optimizers defstructs)
		      (:fasload packages optimizers defstructs vars)
  )
  (:Compile-Load-Init protocol-flavors (packages optimizers defstructs macros)
		      (:fasload packages optimizers defstructs macros vars)
  )
  (:Compile-Load-Init protocol-support (packages optimizers defstructs macros)
		      (:fasload packages optimizers defstructs macros vars
				protocol-flavors
		      )
  )
  (:Compile-Load-Init server-definition
		      (optimizers server-defstructs server-macros defstructs)
		      (:Fasload packages server-vars optimizers
				server-defstructs server-macros defstructs
                      )
  )
  (:Compile-Load-Init body (packages optimizers defstructs macros)
		      (:fasload packages optimizers defstructs macros vars)
  )
  (:Compile-Load-Init environment (packages optimizers defstructs macros)
		      (:fasload packages optimizers defstructs macros vars)
  )
  (:Compile-Load-Init mail-control-window
		      (packages optimizers defstructs macros)
		      (:fasload packages optimizers defstructs macros vars)
  )
  (:Compile-Load-Init mail-control-window-methods
		      (packages optimizers defstructs macros)
		      (:fasload packages optimizers defstructs macros vars
				mail-control-window body
		      )
  )
  (:Compile-Load-Init zmacs-stuff (packages optimizers defstructs macros)
		      (:fasload packages optimizers defstructs macros vars)
  )
  (:Compile-Load-Init ucl-stuff (packages optimizers defstructs macros)
		      (:fasload packages optimizers defstructs macros vars
				mail-control-window
		      )
  )
  (:Compile-Load-Init wrapup (packages optimizers defstructs macros)
		      (:fasload packages optimizers defstructs macros vars
				body zmacs-stuff ucl-stuff
				protocol-support mail-control-window
				mail-control-window-methods
		      )
  )
)

;-------------------------------------------------------------------------------
