;;; -*- Mode:Common-Lisp; Package:Yes-Way; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; This code was written by James Rice.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.

;;; The development of this software was assisted by the following grants:
;;; Biomedical Research Technology Program of the National Institutes
;;; of Health under grant RR-00785
;;; Information Systems Technologies office of the Defense Advanced
;;; Research Projects Agency under contract N00039-86-C0033.

;;; **********************************************************************


(defreset-var *netnews-flag-alist* nil
"The seen/deleted type alist that maps netnews group names to flag lists."
)

(defreset-var *netnews-probe-time* nil
"The last time that NNTP was probed for new news groups."
)

(defreset-var *address-object-for-user-address* nil
"The address object that represents the current user."
)

(defvar *end-of-daemon-actions*
	'(check-for-wedged-mail ensure-all-windows-are-updated)
"A list of functions to call at the end of the daemon cycle."
)

(defreset-var *mm-init-info* nil
"Info read in from the MM init file."
)

(defreset-var *all-rejected-imap-command-lines* nil
"A list containing all of the erroneous command lines in this session."
)

(defvar *delay-before-notification-of-wedged-mail* 240
"The delay before you start to get notifications if mail starts to back up in
the lm:mailer; directory.  This is in seconds.
"
)

(defvar *user-ids-no-to-start-up-for*
	'("" "NIL" "FILE-SERVER" "File Server" "LispM")
  "A list of user ids that start-up-yw knows not to start up for."
)
(defvar *summary-window-background-right-button-menu-items*
	'(("Iconify" :Value :Iconify-Me
	   :Documentation "Iconify this window."
	  )
	  ("Select" :Value :Select-Me
	   :Documentation "Select this mailbox/sequence combination as current."
	  )
	  ("Kill" :Value :Forget-Me
	   :Documentation "Get rid of this window."
	  )
	  ("Read" :Value :Read-me
	   :Documentation "Read the messages specified by this sequence."
	  )
	 )
"A list of the menu items to use for the right button menu on the background of
a summary window.
"
)

(defvar *default-delay-before-imperative-reset-of-daemons* 40
"The time in seconds to wait before we go ahead and reset the daemon processes,
assuming that they are hung up in some way.  Imperative resets might result in
loss of synchronisation.
"
)
(defvar *enable-completion-on-eof-chars-p* t
"When true the rubout handler completion stuff kicks in when it detects an
EOF.
"
)
(defvar *read-buffer-bound-p* nil
"Used to make sure that we only bind the read buffer once, i.e. we only do one
level of recursive rubout handler entry.
"
)
(defvar *old-internal-read-char* nil
"Is bound to the global value of sys:internalread-char, which is a function
that we letf rather a lot.
"
)
(defvar *End-Of-Line-Found-P* :Unbound
"Is true if we have found the eol when parsing YW input lines."
)
(Defvar *Eof-Found* :Unbound
"Is bound to the eof char we found if we have found the eof when parsing YW
 input lines."
)
(Defvar *eol-chars* '(#\newline #\end #\page)
"Characters that indicate an eol."
)
(Defvar *completion-compulsory-p* t
"When true it means that when we hit a completion char it is illegal for us not
to have a valid completion.
"
)
(defvar *named-sequence-alist* nil
"Is an alist that maps names to sequences.  These names act like message
 sequence specifiers in in put lines.  By this means we are able to have
 sequence arguments in rules.
"
)
(defvar *disable-add-associated-filters* nil
"When true it prevents filters from being associated with windows when they
are created.  This is used in the rule evaluator.
"
)
(defvar *sequences-created-are-associated* t
"When true it indicates that any new message sequence objects that are created
are, in fact, associated with the specified mailbox.  When false the sequences
are created as disembodied sequences.
"
)
(defvar *all-event-types* nil
"A list of the names of all of the event types that the rule
 system is sensitive to.
"
)
(defvar *All-Rule-Sets* nil
"A list of all of the rule sets."
)
(defvar *all-rules* nil
"A list of all of the rules."
)
(defvar *completion-function* 'tv:complete-lisp-atom
"The completion function to use for typein."
)
(defvar *using-special-completer-p* nil
"A hack to help make deffilters work properly"
)
(defvar *make-sequence-with-no-mailbox-ok-p* nil
"When true it is ok to create disembodied message sequences."
)
(defvar *complete-to-command-p* t
"When true it requires that completion completes to a command in the active
command tables.  WHen false we are going to complete to something else.
"
)
(defvar *parenthesis-chars* '((#\( #\)) (#\[ #\]) (#\{ #\}) (#\< #\>))
"a list of the matching types of parenthesis chars."
)
(defvar *simple-term-specifiers*
	'((:Sequence-All	"ALL")
	  (:Sequence-Recent	"RECENT"	:\\Recent)
	  (:Sequence-New	"NEW")
	  (:Sequence-Old	"OLD")
	  (:Sequence-Seen	"SEEN"		:\\Seen)
	  (:Sequence-Unseen	"UNSEEN")
	  (:Sequence-~Seen	"UNSEEN")
	  (:Sequence-Flagged	"FLAGGED"	:\\Flagged)
	  (:Sequence-Unflagged	"UNFLAGGED")
	  (:Sequence-~Flagged	"UNFLAGGED")
	  (:Sequence-Deleted	"DELETED"	:\\Deleted)
	  (:Sequence-Undeleted	"UNDELETED")
	  (:Sequence-~Deleted	"UNDELETED")
	  (:Sequence-Answered	"ANSWERED"	:\\Answered)
	  (:Sequence-Unanswered	"UNANSWERED")
	  (:Sequence-~Answered	"UNANSWERED")
	  (:Sequence-Keyword	"KEYWORD"	:\\Keyword)
	  (:Sequence-Unkeyword	"UNKEYWORD")
	  (:Sequence-~Keyword	"UNKEYWORD")

	  (:Sequence-Bcc	"BCC")
	  (:Sequence-Before	"BEFORE")
	  (:Sequence-Body	"BODY")
	  (:Sequence-Cc		"CC")
	  (:Sequence-From	"FROM")
	  (:Sequence-On		"ON")
	  (:Sequence-Since	"SINCE")
	  (:Sequence-Subject	"SUBJECT")
	  (:Sequence-Text	"TEXT")
	  (:Sequence-To		"TO")
	 )
"An alist that maps sequence method keys to the imap search command names
and the flags that get modified as a result.
"
)

(setf (get :\\Seen     :Inverse) :\\UnSeen)
(setf (get :\\Flagged  :Inverse) :\\UnFlagged)
(setf (get :\\Deleted  :Inverse) :\\UnDeleted)
(setf (get :\\Keyword  :Inverse) :\\UnKeyword)
(setf (get :\\Answered :Inverse) :\\UnAnswered)
(setf (get :\\UnSeen     :Inverse) :\\Seen)
(setf (get :\\UnFlagged  :Inverse) :\\Flagged)
(setf (get :\\UnDeleted  :Inverse) :\\Deleted)
(setf (get :\\UnKeyword  :Inverse) :\\Keyword)
(setf (get :\\UnAnswered :Inverse) :\\Answered)

(Defvar *cache-directory-lists-p* nil
	"Bind this to true to make directory caching possible."
)

(defvar *look-in-directory-cache-first-p* nil
"When true directory list operations look in the cache first."
)

(defvar *directory-list-hash-table* (make-hash-table :Test #'equal)
"The cache of directory lists."
)

(defvar *interned-address-table* (make-hash-table :Test #'equal))

(defvar *header-types-to-include* nil
"When non-nil it is the list of header types to include when filtering."
)

(defvar *literal-mailbox-name-strings* '("UnDigestified")
"A list of the names of mailboxes, which if it appears in the mailbox name
debotes that the name is a literal and should not be processed by
check-user-mailbox.
"
)

(defconstant *blank-line*
"

"
"A string denoting a blank line.  Used in RFC822 parsing."
)

(defvar *digest-separators*
	'((("Message " :Multiple " **************") t)
	  ("-----------------------------------------------------" t)
	  ("
Date: " nil)
         )
"All of the separator strings used in digests.  Actually a pair of the
form (pattern strip-p).  Pattern can be either a string or the sort of
pattern that's emitted by fs:parse-search-string.  If strip-p is true
then this separator is assumex not to be part of the message and
whitespace it stripped off after the line after this text."
)

(defvar *digest-lines-to-modify* '((">From:" "From: "))
"A list of lines to modify in digested messages."
)

(defvar *save-addresses-in-database-p* nil
"When true, all new addresses that are parsed are put in the address database."
)

(defvar *all-locks* nil)

(defvar *address-database-area*
	(sys:make-area
	  :name 'address-database
	  :representation :structure
	  :gc :temporary
	  :force-temporary t
        )
)

(defvar *Address-Database*
	(Make-hash-table :Test #'equal :Area *address-database-area*)
"The address database"
)

(defvar *new-mail-icon*
	(w:read-bit-array-file
	  (if (loading-yw-p)
	      "Yes-Way:Yes-Way;yw-new-mail.bitmap"
	      "New-Yes-Way:Yes-Way;yw-new-mail.bitmap"
	  )
	)
"The icon to use to show that we've got new mail."
)

(defvar *empty-mail-icon*
	(w:read-bit-array-file
	  (if (loading-yw-p)
	      "Yes-Way:Yes-Way;yw-empty.bitmap"
	      "New-Yes-Way:Yes-Way;yw-empty.bitmap"
	  )
	)
"The icon to use to show that we've got no new."
)

(defvar *size-of-icon* '(47 47)
"The width and height of the icon pictures to display."
)

(defvar *Ideal-Imap-Version-To-Select*
	'((:Unix-Ucb :Version 3.0)
	  (:LispM :Select.Version 3.0
		  :Add.Message
		  :Auto.Set.Seen
;		  :Eight.Bit.Transparent ;;; {!!!!}
		  :Encoding
		  :Indexable.Fields
		  :New.Mail.Notify
		  :Renumber
		  :Send
		  :Set.Eol
		  :Tagged.Solicited
		  :Wildcard.Searches ;;; Experimental {!!!!}
          )
	  (:Default :Select.Version 3.0)
	 )
"The version of the IMAP protocol that the server supports that we would
really like for this client.
"
)

(defvar *all-daemons* nil
"A list of all of the daemons."
)

(defvar *processes-to-show-in-status-window*
	'((*edit-server*    "Task: ")
	  (*yw-daemon*      "Daemon: ")
	  (*address-server* "Addr: ")
	 )
"An alist that maps process identifiers to be shown in status window to
the format string to be used to introduce the process.  The process specifier
can be a symbol that names a specifier, a process or a window with
tv:process-mixin.
"
)

(defvar *other-things-to-do-in-status-window*
	'(print-prefix-args)
"A list that specifies functions to call to put things into the process status
window.
"
)

(defreset-var *address-database-changed* nil
"When new addresses are added to the address hash table this is set to true.
This tells us whether we need to save the address database on quitting and such.
"
)

(defreset-var *address-database-creation-date* nil
"Set when the address hash table is read.  Is used to determine whether it has
 been bashed when you try to write it.
"
)

(defreset-var *address-database-loaded* nil
"Is true if we have loaded the user's address database.  We won't have to
do this again if this is true.
"
)

(defreset-var *rule-base-changed* nil
"When rules are added or edited, this flag is true."
)

(defreset-var *rule-base-creation-date* nil
"Set when the rule base is read.  Is used to determine whether it has been
 bashed when you try to write it.
"
)

(defreset-var *rule-base-loaded* nil
"Is true if we have loaded the user's rule base.  We won't have to
do this again if this is true.
"
)

(defvar *waiting-message-text* (tv:fontify-string "Waiting for " 1)
"The text string to use when displaying that we are waiting for the header of a
message in a summary window.
"
)

(defvar *ignore-exists* nil
"A magic flag which is bound so as to prevent us from acting on exists
type messages whilst doing things like copy and move.  If we start to
do all of the proactive things that result from exists whilst swapping
the mailboxes trhat the streams are pointing to we get lossage.
"
)

(defvar *IMAP-ReadTable*
	(let ((Table (copy-readtable nil)))
	     (set-syntax-from-char #\, #\A table)
	     (set-syntax-from-char #\: #\A table)
	     (set-syntax-from-char #\+ #\A table)
	     (set-syntax-from-char #\- #\A table)
	     (setf (sys:pttbl-package-prefix table) (string (int-char 250)))
	     (setf (sys:pttbl-uninterned-symbol-prefix table)
		   (string-append "#" (string (int-char 250)))
             )
	     (setf (aref (sys:character-attribute-table table) (char-int #\:))
		   (aref (sys:character-attribute-table table) (char-int #\A))
	     )
	     (set-syntax-from-char #\\ #\A Table)
	     Table
	)
  "Used to ignore backslash quoting for YW flags like \Seen, \Answered."
)

(set-syntax-from-char #\; #\A *Imap-Readtable* *Imap-Readtable*)

(Defvar *init-file-parsing-readtable*
        (let ((table (copy-readtable)))
	     (set-syntax-from-char #\, #\A table)
	     (set-syntax-from-char #\: #\A table)
	     (set-syntax-from-char #\+ #\A table)
	     (set-syntax-from-char #\- #\A table)
	     (set-syntax-from-char #\# #\A table)
	     (setf (sys:pttbl-package-prefix table) (string (int-char 250)))
	     (setf (sys:pttbl-uninterned-symbol-prefix table)
		   (string-append "#" (string (int-char 250)))
             )
	     (setf (aref (sys:character-attribute-table table) (char-int #\:))
		   (aref (sys:character-attribute-table table) (char-int #\A))
	     )
	     table
	)
"Used when parsing yw-init files.
"
)

(defvar yw-stream-mixin-rubout-handler 'tv:alternate-rubout-handler
"The rubout handler used by YW in the prompt window."
)

(defvar *completion-characters*
	'(#\space #\newline #\ #\
)
"A list of characters that provoke completion in the prompt window."
)

(defvar *whitespace-chars*
	(loop for i from 0 to 255
	      for char = (int-char i)
	      when (si:whitespacep char)
	      collect char
	)
"A list of all of the whitespace chars."
)

(defvar *whitespace-chars-and-parens*
	(cons #\( (cons #\) *Whitespace-Chars*))
  "Used in turning comment fields into personal names."
)

(Defvar *all-command-table-builders* nil
"A list of all of the functions that know how to build command tables for YW."
)

(defvar yw:*sequence-key-to-control-structure-method-mappings*
       '((:Sequence-Then      :one-after-another)
	 (:Sequence-Reverse   :reverse-order)
	 (:Sequence-Sorted-by :sort-the-sequence)
	)
"An alist that maps the names of message sequence control sequence specifier
names to the methods that implement the transformations on the message
sequence in order to implement the control sequence.  For instance, if the
sequence contains a THEN specifier then the :Sequence-Then keyword will be
used in the sequence.  This control sequence is implemented with the
:one-after-another method.
"
)

(defvar *end-of-line-characters* '(#\newline #\ #\
)
"a list of the characters that indicate to the reader in the prompt
window that we've seen the end of a line.
"
)

(defvar *IMAP.Arg-Breaks* '(#\Return #\newline #\" #\{)
  "Special action characters when sending IMAP args."
)

(defvar *all-open-imap-streams* nil
"A list of all of the currently open IMAP sterams."
)

(defconstant *System-Flags*
	'(:\\Seen :\\Deleted :\\Flagged :\\Answered :\\Recent :\\XXXX :\\YYYY)
"The YW system flags; the user Keywords are the Set-Difference of :FlagList
and these flags.
Note:  The order in this list is critical.  It is the order of the system flags
in YW files.
"
)

(defparameter *dbg* nil "Changes the way that things get printed out.")
;(setq *dbg* t)


(defvar *All-Mailer-Command-Tables* nil
"A list of the *names of all of the mailer command tables."
)

(Defvar *read-line-completion-function-alist* nil
"A list of extra functions to be called in the completion part of the reader
in certain circumstances.  It maps characrers that are read into functions to
call to perform the completion.
"
)

(Defvar *initial-active-mailer-command-tables*
	'(*top-level-command-table*)
"A list of the command tables that are initially active in the mailer
prompt window.
"
)

(defvar *all-mail-control-windows* nil
"A list of all of the mail control windows.  If the user creates a mailer
on his own then these might be more than those in the resource of mailers.
"
)

(defvar *mailer* :Unbound
"A magic variable that points to the mail control window that we're
interested in.
"
)

(defvar *no-mailbox-open-text* "Mailer.  No current mailbox"
"The string used as a label for the prompt window to say that there are no
currently open mailboxes.
"
)

(defvar *message-sequence-documentation*
"


A message sequence is a potentially complex specification of a set of
messages.  You can think of a sequence as being a sequence much like a message
sequence in YW only there are more options available to you.  Another way to
think of a sequence is as a filtering predicate that is applied successively
to all of the messages in the mailbox.

This documentation goes on to describe the following topics:
Sequences that are specified by numbers, sequences that are
specified by keywords, mouse clicks, logical expressions in
sequences, control structure in sequences, and user defined named
sequences expressions.


Message Numbers
===============

Although message numbers have no particular significance in
themselves.  It is often easy to type \"Read 42, 57\" without
having to build a sequence that will select these messages.  Thus,
just as is the case in YW, a message sequence can be specified in
terms of numbers.  For instance,

1		The message numbered \"1\"
1, 3, 5		Messages 1, 3 and 5 (actually 1 ior 3 ior 5)
1:42		Messages 1 through 42 (1 -> 42 inclusive)
>		The last message in the sequence
%		Same as >
*		Same as >
<		The first message in the sequence


Sequence Specifier Keywords
===========================

There are a number of message sequence specifiers such as \"From\" these are:
All		All of the message in the mailbox
Answered	Answered messages
Bcc <arg>	Messages BCCed to <arg>
Before <date>	Messages sent before a given date/time
Cc <arg>	Messages CCed to <arg>
Deleted		Deleted messages
Field <name> <arg>	Messages matching <arg> in the field keyed by <name>
Flagged		Flagged messages
From <arg>	Messages from <arg>
Keyword <arg>	Messages with the keyword <arg> set
Id <arg>	Messages with <arg> in their message Id tag
Inverse		Equivalent to \"Reverse All\" (see Control Structure below)
Length		Messages whose length comares to some value
Mailbox-is	Messages in a milbox whose name contains its argument
New		New messages.  Equivalent to \"Recent And Unseen\"
Old		Old messages.  Equivalent to \"Not Recent\"
On <date>	Messages sent on a particular date
Recent		Recent messages
Seen		Messages that have been seen
Since <date>	Messages sent since a particular date/time
Subject <arg>	Messages containing <arg> in their subject field
Text <arg>	Messages containing <arg>
To <arg>	Messages to <arg>
UnAnswered	Equivalent to \"Not Answered\"
UnDeleted	Equivalent to \"Not Deleted\"
UnFlagged	Equivalent to \"Not Flagged\"
UnKeyword <arg>	Equivalent to \"Not Keyword <arg>\"
UnSeen		Equivalent to \"Not Seen\"


Mouse Clicks
============

Mouse clicks are also allowed as arguments to message sequences.
Thus, if you want to get all of the messages from a particular
sender it is perfectly acceptable to say:

  \"From <click>\"

where <click> denotes clicking on a message from the person in
question.  When no argument expecting keyword, such as From, has
been typed, the mouse selection of a message will result in that
message being selected as if it had been typed in as a message
number.


Logical Expressions
===================

Complex message sequences can also be built out of the boolean
operators: And, Or, Not, Xor.  For instance them sequence:

  \"From rice And Not To info-ti-explorer\"

denotes the messages sent by Rice but excluding those sent to
Info-TI-Explorer.

The diadic operators mentioned above all have equal precedence and
right associativity.  It is also possible to build yet more
complex sequences by the use of parentheses.  Thus one could add
to the above expression as follows:

  \"(From rice And Not To info-ti-explorer) Or From acuff\"


Control Structure
=================

The simple specification of a sequence says nothing about the
order in which the messages are to be processed, it simple defined
a predicate that can be thought of as filtering the messages the
mailbox.  It is possible, however to influence the order in which
messages are processed.  This is done by the use of the keywords
Then and Reverse..

<a> Then <b>	Specifies a series of activites; sequence A followed by B
Reverse <seq>	Specifies that a subsequence be processed in reverse order
<seq> Sort-by <key>	Specifies that a sequence is to be sorted by a predicate key

For instance, if one wanted to read one's recent messages in
reverse order so as to see the most recent ones first then one
need only say:

  \"Reverse Recent\"

If one wanted to have a more complex way of reading one's mail
then one could say:

  \"Reverse (Not Deleted And To rice) Then (Not Deleted And CC rice)\"

This would read all undeleted messages that were sent to Rice
first in reverse order.  After this any undeleted messages that
were CCed to Rice would then be processed, but only those messages
that did not match the first operation.  Thus messages that are
both To rice and CC rice will only be processed once.

Sorting allows messages to be ordered in some useful way.  This
is particularly likely to be useful when tracking conversations
on BBoards, where messages often appear in a confusing order.
Thus:

  \"Subject money Sort-by Date\"

will specify all of the message about money sorted into date order.

The keywords that can be used to sort messages are the following:
Bcc		Sort by the text in the Bcc field
CC		Sort by the text in the CC field
Date		Sort by the date field
From		Sort by the text in the From field
Id		Sort by the message Id
Subject		Sort by the text in the Subject field
Text		Sort by the text in message
To		Sort by the text in the To field


Quotification
=============

A quoting convention in message sequences allows the searching for
messages that have spaces in them.  The sequence:

  From \"james rice\"

would match to any message that was from \"james rice\", though
not necessarily from rice.

A quote character can be specified by saying \\\".

User Defined Message Sequence Keywords
======================================

The user can make his own named abstractions for sequences.  This allows
complex mail reading strategies to be accessed by simple commands and
allows sequences to be set up in an init file.  This is done using the
Deffilter form.  The Deffilter form is fully documented internally,
however, the large message sequence mentioned above could be implemented
using the following form:

(deffilter magic ()
  \"[Reverse (Not Deleted And To Rice)] Then (Not Deleted And CC Rice)\"
)

(deffilter magic ()
  (then (reverse (and (not (deleted)) (to rice)))
	(and (not (deleted)) (cc rice))
  )
)

This will define a sequence keyword called \"Magic\", which will
match in the manner mentioned above.

"
)

(defparameter *pending-imap-requests* (make-hash-table :Test #'equal)) ;;; Not used right now.


(defvar *all-specials-that-cause-blips-from-background-mouse-clicks*
	'(*reading-a-mailbox* *reading-a-filter*)
"A list of all of the specials, which when bound to t will cause a mouse
click on the background of a summary window to be sent to the mcw as a blip.
"
)

(defvar *catch-imap-stream-errors-p* :close
"When :catch, causes errors to throw away the current input line
and throw out to the top.
When :close causes the stream to be closed.
Otherwise causes an error. 
"
)


(defvar *number-chars* '(#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
  "The chars that can be numeric."
)

;-------------------------------------------------------------------------------

;;; Multipart stuff

(defvar *default-content-type* :Text)
(defvar *default-content-subtype* :Default)
(defvar *x-server-display* "36.44.0.190:0.1")
(defvar *base64-mapping-table*
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
)
(defvar *inverse-base64-mapping-table*
	(let ((array (make-array 256)))
	     (loop for index from 0
		   for char being the array-elements of *base64-mapping-table*
		   do (setf (aref array (char-code char)) index)
	     )
	     array
	)
)
(defvar *hex-char-table* "0123456789ABCDEF")
(defconstant *tspecials* " ()<>@,;:\\\"/[]?.=")
(defconstant *bcharsnospace* " '()+,-./:=?")

