;;; -*- Mode:Common-Lisp; Package:YW-Zwei; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; This code was written by James Rice.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.

;;; The development of this software was assisted by the following grants:
;;; Biomedical Research Technology Program of the National Institutes
;;; of Health under grant RR-00785
;;; Information Systems Technologies office of the Defense Advanced
;;; Research Projects Agency under contract N00039-86-C0033.

;;; **********************************************************************

;; Suggestions for the mailer in zmacs.

;;; Define the items in the suggestions menu yw-read mode.
(if (not (sys:mx-p))
    (sugg:suggestions-build-menu
      'Things-to-do-in-yw-read-mode
      "A menu of commands to perform when in Yes-Way Read mode in Zmacs."
      '(("Single Key Commands" :no-select ignore :font sugg:menu-subtitle-std-font)
	("Reply" #\R :Documentation "Reply to this message.  Numeric arg to toggle reply to all/reply to sender.")
	("Forward" #\F :Documentation "Forward this message to someone else")
	("Copy" #\C :Documentation "Copy this message to another mailbox.")
	("Move" #\M :Documentation "Move this message to another mailbox (deletes the message in this mailbox.")
	("Send" #\S :Documentation "Send a new message.")
	("Delete and move on" #\D :Documentation "Delete this message and move on to the next.")
	("UnDelete" #\U :Documentation "UnDeletes this message.")
	("Toggle Delete" #\C-D :Documentation "Toggle the Deleted status of this message and continue to read it.")
	("Set a keyword" #\K :Documentation "Set a keyword for this message.")
	("UnSet a keyword" #\M-K :Documentation "Set a keyword for this message.")
	("Next message" #\N :Documentation "Move to the next message in the sequence you are reading.")
	("Previous message" #\P :Documentation "Move to the previous message in the sequence you are reading.")
	("Next in mailbox" #\S-N :Documentation "Move to the next message in the mailbox independent of the current sequence.")
	("Previous in mailbox" #\S-P :Documentation "Move to the previous message in the mailbox independent of the current sequence.")
	("Flag/UnFlag" #\! :Documentation "Toggle the flagged status of this message.")
	("Print" #\M-Sh-P :Documentation "Print this message.")
	("Quit" #\End :Documentation "Throw away this message and go back to the mailer.")
	("Abort" #\Abort :Documentation "Throw away this message and stay in Zmacs.")
	("" :Noselect ignore)
	("M-x Commands" :no-select ignore :font sugg:menu-subtitle-std-font)
	("Forward Command" #\m-c-sh-x :Documentation "Type a command in the minibuffer to be executed by the mailer.")
	("Remail"  . Com-yw-remail)
	("Forget Address" . Com-Forget-Address)
	("Edit Address" . Com-Edit-Address)
       )
      '(yw-zwei-list-menus)
    )
    nil
)

;;; Add these suggestions onto the end of the mode turn-on suggestions list.
(if (not (sys:mx-p))
    (if (assoc 'yw-read-mode sys:*suggestions-zmacs-modes*)
	(setf (rest (assoc 'yw-read-mode sys:*suggestions-zmacs-modes*))
	      '(Things-to-do-in-yw-read-mode)
	)
	(nconc sys:*suggestions-zmacs-modes*
	       '((yw-read-mode Things-to-do-in-yw-read-mode))
	)
    )
    nil
)

;-------------------------------------------------------------------------------
