;;; -*- Mode:Common-Lisp; Package:Yes-Way; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; This code was written by James Rice.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.

;;; The development of this software was assisted by the following grants:
;;; Biomedical Research Technology Program of the National Institutes
;;; of Health under grant RR-00785
;;; Information Systems Technologies office of the Defense Advanced
;;; Research Projects Agency under contract N00039-86-C0033.

;;; **********************************************************************

;-------------------------------------------------------------------------------

;;; This file contains a reasonable set of default settings for the naive
;;; IMAP client user.  It should be loaded after the IMAP client has
;;; been loaded.

;-------------------------------------------------------------------------------

;;; Window set-up variables.
(setq *default-yw-zmacs-frame* (yw-zwei:Make-default-Yw-Zmacs-Frame))
(setq *mail-control-window-width*
      (- (send tv:default-screen :Width) (yw-zwei:default-yw-zmacs-size))
)
(setq *message-window-width*
      (- (send tv:default-screen :Width) (yw-zwei:default-yw-zmacs-size))
)
(setq *new-headers-window-y-offset* -15)
(setq *default-ideal-mail-control-window-position*
      (list (yw-zwei:default-yw-zmacs-size)
	    (- (send tv:default-screen :Height) *mail-control-window-height*)
      )
)
(setq *default-ideal-message-display-pane-position*
      (list (yw-zwei:default-yw-zmacs-size)
	    (- (second *default-ideal-mail-control-window-position*)
	       *message-window-height*
	    )
      )
)
;-------------------------------------------------------------------------------
(setq *try-to-expose-all-summary-windows-on-mailer-expose* t)
(setq yw-zwei:*address-disposition-notifications-to-suppress* '(:Queued))
(setq yw-zwei:*silent-mail-delivery* :minibuffer)
(setq mail:*use-primary-mail-servers* :always)
(setq yw-zwei:*mail-reply-indent-rejustify-right-margin* 59)
(setq yw:*basic-header-types-to-filter*
      '(:Received :Return-Path :message-id :Full-Name :Character-Type-Mappings
	:Fonts :Posted-Date :Content-Type :Content-Transfer-Encoding :X-Fonts
       )
)
(setq zwei:*unsent-message-query-p* nil)
(setq mail:*try-mail-now-p* nil)
(setq zwei:*reformat-headers-include-list*
      '(:date :from :reply-to :to :cc :subject)
)
(setq *user-summary-window-inits* '(:scroll-bar-side :right))
(setq *user-mailbox-selector-inits* '(:scroll-bar-side :right))
(setq *user-system-output-window-inits* '(:scroll-bar-side :right))