;;; -*- Mode:Common-Lisp; Package:ZWEI; Base:10; Patch-File: t -*-

;;; TI code.
(DEFUN INCREMENTAL-SEARCH (REVERSE-P &AUX (ORIG-PT (COPY-BP (POINT))))
  (SYS:WITH-SUGGESTIONS-MENUS-FOR ZWEI:INCREMENTAL-SEARCH
    (SELECT-WINDOW *WINDOW*)
    (FORMAT *QUERY-IO* "~&")			;Necessary if in the mini-buffer
    (UNWIND-PROTECT
	(TYPEIN-LINE-ACTIVATE
	  (PROG (CHAR				; The current command.
		 XCHAR				; Upcase version of character
		 MUST-REDIS			; T => The echo-area must be completely redisplayed.
		 (P 0)				; The stack pointer into *IS-BP*, etc. for input and rubout
		 (P1 0)				; The pointer for which search we are doing.
						; Can never exceed P.
		 SUPPRESSED-REDISPLAY		; T if the last input char was read before
						;  redisplay had a chance to finish.
						;  A G read that way acts like a failing search quit.
		 BP1				; Aux BP used for actual search  g.
		 NEW-BP
		 TIME-OUT			; Set by SEARCH when it times out so we can check input.
		 INPUT-DONE			; An ESCAPE or control char has been seen.
						; Do not look for input any more; just search, then exit.
		 )
		;; Clear out the search string.
		(STORE-ARRAY-LEADER 0 *IS-STRING* 0) 
		;; Initialize the stacks.
		(SETF (AREF *IS-STATUS* 0) T)	
		(SETF (AREF *IS-REVERSE-P* 0) REVERSE-P)
		(SETF (AREF *IS-OPERATION* 0) :NORMAL)
		(SETF (AREF *IS-POINTER* 0) 0)
		(SETF (AREF *IS-BP* 0) (COPY-BP (POINT)))
		;; Initially we must redisplay.
		(SETQ MUST-REDIS T)		
		(GO CHECK-FOR-INPUT)
		;; Come here if there is input, or nothing to do until there is input.
	     INPUT
		(SETQ SUPPRESSED-REDISPLAY NIL)
		(AND (WINDOW-READY-P *WINDOW*)	;In case of minibuffer,
		     (REDISPLAY *WINDOW* :POINT))	;redisplay point position while waiting.
		(IF (= (WINDOW-REDISPLAY-DEGREE *WINDOW*) DIS-NONE)
		    (REDISPLAY-MODE-LINE)	;Update indication of more above or below.
		    (SETQ SUPPRESSED-REDISPLAY T))
		(IF SUPPRESSED-REDISPLAY
		    (SETQ CHAR (READ-ANY-WITHOUT-SCROLLING))          
		    ;; If must wait for input, make the window's 
		    ;; blinker blink even though not selected.
		    (UNWIND-PROTECT
			(PROGN
			  (SEND (WINDOW-POINT-BLINKER *WINDOW*) :SET-VISIBILITY :BLINK)
			  (SEND (WINDOW-POINT-BLINKER *WINDOW*) :SET-DESELECTED-VISIBILITY :BLINK)
			  (SETQ CHAR (READ-ANY-WITHOUT-SCROLLING)))    
		      (SEND (WINDOW-POINT-BLINKER *WINDOW*) :SET-VISIBILITY
			    (IF (EQ *WINDOW* W:SELECTED-WINDOW)
				:BLINK
				(W:SHEET-EXPOSED-P *WINDOW*)))
		      (SEND (WINDOW-POINT-BLINKER *WINDOW*) :SET-DESELECTED-VISIBILITY :ON)))
		(WHEN (CONSP CHAR)
		  (SEND *STANDARD-INPUT* :UNREAD-ANY CHAR)
		  (SETQ INPUT-DONE T)
		  (GO CHECK-FOR-INPUT))
		(SETQ XCHAR (CHAR-UPCASE CHAR))
		(COND ((NOT (OR (PLUSP (TV:CHAR-CMSH-BITS CHAR))
				(CHAR-BIT CHAR :MOUSE)
				(MEMBER CHAR '(#\ESCAPE #\END #\RUBOUT #\HELP #\ABORT #\CLEAR-INPUT)
					:TEST #'EQ)))
		       (GO NORMAL))
		      ;; Added Meta-S and Meta-R for mail, 9-18-86 (rpm from wjb).
		      ((char= xchar #\c-y)
		       (let ((ELEMENT (HISTORY-ELEMENT-SET-YANK-POINTER
					*KILL-HISTORY* nil)))
			 (LET ((STRING (if element (string-interval element) (barf))))
			   (COPY-ARRAY-CONTENTS STRING *IS-STRING*)
			   (SETF (AREF *IS-POINTER* P) (ARRAY-ACTIVE-LENGTH STRING)))
			 (SETQ MUST-REDIS T))
		       (GO CHECK-FOR-INPUT))
		      ((MEMBER XCHAR '(#\c-S #\c-R #\m-S #\m-R) :TEST #'EQ)
		       (PUSH-ISEARCH-STATUS)
		       (SETF (AREF *IS-OPERATION* P) :REPEAT)
		       ;; Added Meta-R for mail, 9-18-86 (rpm from wjb). 
		       (LET ((NEW-REVERSE-P (or (CHAR= XCHAR #\c-R) (CHAR= XCHAR #\m-R))))
			 ;; In reverse mode, just go to forward.
			 (COND ((NEQ (AREF *IS-REVERSE-P* P) NEW-REVERSE-P)
				(SETF (AREF *IS-REVERSE-P* P) NEW-REVERSE-P)
				(SETQ MUST-REDIS T)
				(SETF (AREF *IS-OPERATION* P) :REVERSE))
			       ((ZEROP (AREF *IS-POINTER* P))
				(LET ((STRING (STRING (OR (CAAR *SEARCH-RING*) (BARF)))))
				  (COPY-ARRAY-CONTENTS STRING *IS-STRING*)
				  (SETF (AREF *IS-POINTER* P) (ARRAY-ACTIVE-LENGTH STRING)))
				(SETQ MUST-REDIS T))))
		       (GO CHECK-FOR-INPUT))
		      ((CHAR= XCHAR #\c-Q)
		       (LET ((NEW-CH (READ-CHAR)))
			 (SETQ CHAR (IF (CHAR-BIT NEW-CH :CONTROL)
					(INT-CHAR (LOGAND 37 (CHAR-CODE NEW-CH)))
					(MAKE-CHAR NEW-CH))))
		       (GO NORMAL))
		      ((CHAR= CHAR #\HELP)
		       (PRINT-DOC :FULL *CURRENT-COMMAND*)
		       (SEND *STANDARD-INPUT* :UNREAD-ANY (SEND *STANDARD-INPUT* :READ-ANY))
		       (GO INPUT))
		      ((OR (CHAR= XCHAR #\c-G) (CHAR= CHAR #\ABORT))
		       (BEEP)
		       (COND ((AND (OR SUPPRESSED-REDISPLAY (NEQ (AREF *IS-STATUS* P) T))
				   (PLUSP P))
			      ;; G in other than a successful search
			      ;; rubs out until it becomes successful.
			      (SETQ P (DO ((P (1- P) (1- P)))
					  ((EQ (AREF *IS-STATUS* P) T) P)))
			      (SETQ P1 (MIN P P1)
				    MUST-REDIS T)
			      (GO CHECK-FOR-INPUT))
			     (T
			      (MOVE-TO-BP (AREF *IS-BP* 0))
			      (SEND *QUERY-IO* :MAKE-COMPLETE)
			      (RETURN))))
		      ((OR (CHAR= CHAR #\ESCAPE) (CHAR= CHAR #\END))
		       (AND (ZEROP P)
			    ;; Call string search, and make self-doc print the right thing there.
			    (LET ((*CURRENT-COMMAND* 'COM-STRING-SEARCH-INTERNAL))
			      (RETURN (COM-STRING-SEARCH-INTERNAL REVERSE-P NIL NIL NIL))))
		       (SETQ INPUT-DONE T)
		       (GO CHECK-FOR-INPUT))
		      ((OR (CHAR= CHAR #\RUBOUT) (CHAR= CHAR #\CLEAR-INPUT))
		       ;; Clear-input rubs out all the way.  Set P to 1 and let it be decremented.
		       (IF (CHAR= CHAR #\CLEAR-INPUT)
			   (SETQ P 1))
		       (COND ((<= P 0)		; If he over-rubbed out,
			      (BEEP)		; that is an error.
			      (GO CHECK-FOR-INPUT))
			     (T
			      ;; Rubout pops all of these PDLs.
			      (SETQ P (1- P))
			      (SETQ P1 (MIN P P1))
			      (SETQ MUST-REDIS T)
			      (GO CHECK-FOR-INPUT))))
		      (T
		       (UNREAD-CHAR CHAR)
		       (SETQ INPUT-DONE T)
		       (GO CHECK-FOR-INPUT)))
		(FERROR NIL "A clause fell through.")
		;; Normal chars to be searched for come here.
	     NORMAL
		(OR MUST-REDIS (FORMAT *QUERY-IO* "~C" CHAR))
		(PUSH-ISEARCH-STATUS)
		(LET ((IDX (AREF *IS-POINTER* P)))
		  (AND (>= IDX (ARRAY-TOTAL-SIZE *IS-STRING*))
		       (ADJUST-ARRAY *IS-STRING* (+ IDX 100)))
		  (SETF (AREF *IS-STRING* IDX) CHAR)
		  (SETF (AREF *IS-POINTER* P) (1+ IDX)))
		(SETF (AREF *IS-OPERATION* P) :NORMAL)
		;; Come here after possibly processing input to update the search tables
		;; to search for a while.  First, if necessary and not suppressed
		;; update the search string displayed in the echo area.
	     CHECK-FOR-INPUT
		;; If there is input available, go read it.
		;; Otherwise, do work if there is work to be done.
		(AND (NOT INPUT-DONE)
		     (LISTEN)
		     (GO INPUT))
		;; Now do some work for a while, then go back to CHECK-FOR-INPUT.
		(COND (MUST-REDIS
		       (SETQ MUST-REDIS NIL)
		       (FORMAT *QUERY-IO* "~&~:|")
		       (OR (AREF *IS-STATUS* P1) (FORMAT *QUERY-IO* "Failing "))
		       (AND (AREF *IS-REVERSE-P* P) (FORMAT *QUERY-IO* "Reverse "))
		       (FORMAT *QUERY-IO* "I-Search: ")
		       (STORE-ARRAY-LEADER (AREF *IS-POINTER* P) *IS-STRING* 0)
		       (FORMAT *QUERY-IO* "~A" *IS-STRING*)))
		;; Now see what sort of state the actual search is in, and what work there is to do.
		;; P1 points at the level of the table on which we are actually working.
		(SETF BP1 (AREF *IS-BP* P1))
		;; Display point at the end of the last search level which has succeeded.
		(DO ((P0 P1 (1- P0)))
		    ((EQ (AREF *IS-STATUS* P0) T)
		     (and (AREF *IS-BP* P0)
		     (MOVE-TO-BP (AREF *IS-BP* P0)))))
		(MUST-REDISPLAY *WINDOW* DIS-BPS)
		(COND ((EQ (AREF *IS-STATUS* P1) :GO)
		       (STORE-ARRAY-LEADER (AREF *IS-POINTER* P1) *IS-STRING* 0)
		       ;; If the level we were working on is still not finished,
		       ;; search at most 100 more lines.  If we find it or the end of the buffer
		       ;; before then, this level is determined and we can work on the next.
		       ;; Otherwise, we remain in the :GO state and do 100 more lines next time.
		       (MULTIPLE-VALUE-SETQ (NEW-BP TIME-OUT)
			 ;; Removed dependence on mail, 9-18-86 (rpm from wjb).
			 (FUNCALL (OR (GET (SEND *INTERVAL* :MAJOR-MODE) 'MAJOR-MODE-INCREMENTAL-SEARCH-FUNCTION)
				      #'SEARCH)
				  BP1
				  *IS-STRING*
				  (AREF *IS-REVERSE-P* P1)
				  NIL
				  100))
		       ;; What happened?
		       (COND (TIME-OUT
			      ;; Nothing determined.  NEW-BP has where we stopped.
			      (MOVE-BP BP1 NEW-BP)
			      (DBP BP1))	;Avoids missing occurrences if string starts with CR.
			     ((NULL NEW-BP)
			      ;; This search was determined to be a failure.
			      (OR (AND (MEMBER :MACRO-ERROR (SEND *STANDARD-INPUT* :WHICH-OPERATIONS)
					       :TEST #'EQ)
				       (SEND *STANDARD-INPUT* :MACRO-ERROR))
				  (BEEP))
			      (SETF (AREF *IS-STATUS* P1) NIL)
			      (MOVE-BP BP1 (AREF *IS-BP* (1- P1)))
			      (MOVE-TO-BP BP1)	
			      (SETQ MUST-REDIS T))
			     (T
			      ;; This search level has succeeded.
			      (SETF (AREF *IS-STATUS* P1) T)
			      (MOVE-TO-BP NEW-BP)	
			      (MOVE-BP BP1 NEW-BP))))
		      ((/= P P1)
		       ;; This level is finished, but there are more pending levels typed ahead.
		       (SETQ P1 (1+ P1))
		       (SETF (AREF *IS-BP* P1) (SETQ BP1 (COPY-BP BP1)))
		       (STORE-ARRAY-LEADER (AREF *IS-POINTER* P1) *IS-STRING* 0)
		       (COND ((NULL (AREF *IS-STATUS* (1- P1)))
			      (COND ((NEQ (AREF *IS-OPERATION* P1) :REVERSE)
				     ;; A failing search remains so unless we reverse direction.
				     (SETF (AREF *IS-STATUS* P1) ()))
				    (T
				     ;; If we reverse direction, change prompt line.
				     (SETQ MUST-REDIS T))))
			     ((EQ (AREF *IS-OPERATION* P1) :NORMAL)
			      ;; Normal char to be searched for comes next.
			      ;; We must adjust the bp at which we start to search
			      ;; so as to allow the user to extend the string already found.
			      (MOVE-BP BP1 (FORWARD-CHAR BP1
							 (COND ((AREF *IS-REVERSE-P* P1)
								(COND ((= (ARRAY-ACTIVE-LENGTH *IS-STRING*) 1)
								       0)
								      (T
								       (ARRAY-ACTIVE-LENGTH *IS-STRING*))))
							       (T
								(- 1 (ARRAY-ACTIVE-LENGTH *IS-STRING*))))
							 T)))))
		      ;; If there is nothing left to do, and terminator seen, exit.
		      (INPUT-DONE
		       (SEARCH-RING-PUSH
			 ;; Entries on the search ring should have a leader
			 (STRING-NCONC (MAKE-ARRAY (ARRAY-ACTIVE-LENGTH *IS-STRING*)
						   :ELEMENT-TYPE 'STRING-CHAR
						   :LEADER-LIST '(0))
				       *IS-STRING*)
			 'SEARCH)
		       (FORMAT *QUERY-IO* "~C" #\ESCAPE)
		       (MAYBE-PUSH-POINT ORIG-PT)
		       (SELECT-WINDOW *WINDOW*)
		       (RETURN))
		      ;; Nothing to do and no terminator, wait for input.
		      (T
		       (GO INPUT)))
		(GO CHECK-FOR-INPUT))
	  (SETQ ORIG-PT NIL))
      (PROGN
	(IF ORIG-PT (MOVE-TO-BP ORIG-PT))
	(MUST-REDISPLAY *WINDOW* DIS-BPS)
	(SEND *MODE-LINE-WINDOW* :DONE-WITH-MODE-LINE-WINDOW)
	(ARRAY-INITIALIZE *IS-BP* NIL 0 (ARRAY-LENGTH *IS-BP*)))) ;;; ADDED BY HRC.
    DIS-BPS))