; -*- Mode:Common-Lisp; Package:TV; Fonts:(tvFONT tr8B); Base:10 -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (b)(3)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1985, 1988 Texas Instruments Incorporated. All rights reserved.

1;; Suggestions for the Inspector.*

(sugg:suggestions-build-menu
  'interesting-globals-menu
  "A menu of variables whose values are interesting to inspect"
  '((1"General"* :no-select ignore :font fonts:hl10b)
    ("current-process" :symbol current-process)
    ("all-packages" :symbol si:list-all-packages)
    ("package" :symbol package)
    ("*all-flavor-names*" :symbol *all-flavor-names*)
    ("*standard-input*" :symbol *standard-input*)
    ("*standard-output*" :symbol *standard-output*)
    ("" :no-select ignore)
    (1"TV"* :no-select ignore :font fonts:hl10b)
    ("w:all-the-screens" :symbol w:all-the-screens)
    ("Previously Selected Window" :Symbol
     "(aref w:previously-selected-windows 0)")
    ("w:previously-selected-windows" :symbol w:previously-selected-windows)
    ("w:window-resource-names" :symbol w:window-resource-names)
    ("w:*system-keys*" :symbol w:*system-keys*)
    ("w:*terminal-keys*" :symbol w:*terminal-keys*)
    ("w:selected-window" :symbol w:selected-window)
    ("tv:selected-io-buffer" :symbol tv:selected-io-buffer)
    ("w:mouse-window" :symbol w:mouse-window)
    ("w:initial-lisp-listener" :symbol w:initial-lisp-listener)
    ("w:default-screen" :symbol w:default-screen)
    ("w:main-screen" :symbol w:main-screen)
    ("w:who-line-screen" :symbol w:who-line-screen)
    ("w:mouse-process" :symbol w:mouse-process)
    ("tv:*SYSTEM-MENU-PROGRAMS-COLUMN*" :Symbol
     tv:*SYSTEM-MENU-PROGRAMS-COLUMN*)
    ("" :no-select ignore)
    (1"SI" *:no-select ignore :font fonts:hl10b)
    ("si:self-mapping-table" :symbol sys:self-mapping-table)
    ("si:patch-systems-list" :symbol si:patch-systems-list)
    ("si:*systems-list*" :symbol si:*systems-list*)
    ("si:active-processes" :symbol si:active-processes)
    ("si:all-processes" :symbol sys:all-processes)
    ("":no-select ignore)
    (1"FS"* :no-select ignore :font fonts:hl10b)
    ("fs:*default-pathname-defaults*" :symbol fs:*default-pathname-defaults*))
  '(inspector-list-menus))


(sugg:suggestions-build-menu
  'all-inspector-cmds-menu
  "All of the commands available in the Inspector."
  (APPEND inspector-menu-cmds inspector-non-menu-cmds)
  '(inspector-list-menus))


(sugg:suggestions-build-menu
  'inspector-list-menus
  "The menus of commands that are useful when using the Inspector"
  `(,(sugg:compute-label-from-menu-symbol 'all-inspector-cmds-menu)
    ,(sugg:compute-label-from-menu-symbol 'interesting-globals-menu)
    ,@(get 'w:com-list-menus 'zwei:menu))
  nil)


(DEFPARAMETER *inspector-top-menu-contents*               ;1!*
	  `(("Inspector:" :NO-SELECT IGNORE :FONT sugg:*BOLD-SUGGESTIONS-FONT*)
	    ("List Menus" :suggestions-menu inspector-list-menus)
            ,sugg:*menu-tools-menu-item*
            ))
  
(DEFPARAMETER *Inspector-Bottom-Menu-Contents*
	      ;1!Swapped help with menu-tools*
	  `(("   " :no-select ignore)
            ("Help" #\help :documentation
	     "Basic documentation for the data-structure inspector.")
	    ("Lisp Expressions" :suggestions-menu zwei:lisp-expressions)
	    ;1!added zwei:*
	    ))

(sugg:initialize-suggestions-for-application
  general-inspector;  inspect-frame
  *inspector-top-menu-contents*
  *inspector-bottom-menu-contents*
  interesting-globals-menu
  inspector-list-menus)

;-------------------------------------------------------------------------------

(locally (declare (special tv:flavor-inspector-menu))
	 (sugg:suggestions-build-menu
	   'all-flavor-inspector-cmds-menu
	   "All of the commands available in the Flavor Inspector."
	   tv:flavor-inspector-menu
	   '(flavor-inspector-list-menus)))


(sugg:suggestions-build-menu
  'flavor-inspector-list-menus
  "The menus of commands that are useful when using the Flavor Inspector"
  `(,(sugg:compute-label-from-menu-symbol 'all-flavor-inspector-cmds-menu)
    ,@(get 'tv:com-list-menus 'zwei:menu)))


(DEFPARAMETER *flavor-inspector-top-menu-contents*               ;1!*
	  `(("Flavor Inspector:" :NO-SELECT IGNORE :Font
	     sugg:*BOLD-SUGGESTIONS-FONT*)
	    ("List Menus" :suggestions-menu flavor-inspector-list-menus)
            ,sugg:*menu-tools-menu-item*
            ))
  
(DEFPARAMETER *flavor-inspector-bottom-menu-contents*
	      ;1!swapped help with menu-tools*
	  `(("   " :no-select ignore)
            ("Help" #\help :documentation
	     "Basic documentation for the data-structure inspector.")
	    ;("Lisp Expressions" :suggestions-menu zwei:lisp-expressions)
	    ;1!added zwei:*
	    ))

(sugg:initialize-suggestions-for-application
  flavor-inspector
  *flavor-inspector-top-menu-contents*
  *flavor-inspector-bottom-menu-contents*
  flavor-inspector-list-menus)

