;;; -*- Mode:Common-Lisp; Package:TICLOS; Base:10 -*-

;;; ***** Copyright (c) 1987 Texas Instruments.  All rights reserved.
;;; ***** Portions of this file contain code belonging to TI.

;;; This file written by James Rice of the Stanford University
;;; Knowledge Systems Laboratory (Rice@Sumex-Aim.Stanford.Edu)
;;; Some of this code was written by modifying existing
;;; code belonging to TI.

;;; This file contains some horrendously system dependent stuff to force TICLOS
;;; to tell the inspector about method combination.  What is does is to fake it
;;; into thinking that it has to rebuild the combined method and intercepts the
;;; code generated by this.  It then grovels over this code so that it can
;;; be turned into a set of inspector items.  This involves pseudo-grinding
;;; the code and substituting the method invokation calls for itemisations
;;; of the methods themselves.


;(defun my-compute-effective-code (gen-function &rest arg-types)
;"this is my modified version of the system's compute-effective-code.
; the original system version did a lot of stuff to determine whether it really
; wanted to go and compute the effective method.  this, however, is precisely
; what we want to do, so all we have to do is compute the handler and
; then recombine the methods.
;"
;  (let ((rargs (reorder-parameter-specializers gen-function arg-types)))
;    (multiple-value-bind (handler code derivation methods)
;	(find-handler gen-function rargs)
;      (ignore derivation)
;      (if (null handler)
;	  (if (null code)
;	      (ferror nil "couldn't compute a handler for ~s." gen-function)
;	      (recombine-methods
;		gen-function
;		(mapcar #'(lambda (x) (class-of (individual-type x))) rargs)
;		(compute-initial-points methods (length rargs)))
;	      )
;	  (ferror nil "couldn't compute a handler for ~s." gen-function)))))

;(defun go-ahead-and-compute-the-effective-method (method gf)
;"Computes the effective method code for a call to the generic function GF if
; it is called with args whose types match the parameter specializers of method.
; This function runs inside a magic dynamic environment of function bindings
; such that the generated code gets stashed off to the side, rather than the
; effective method actually being computed/compiled.  The stuff in this
; function about `(eql...) I got by looking at the disassembled code for
; a generic function.  I don't understand much what it's doing, but it seems to
; need arg specs of the type that I generate.
;"
;  (apply #'my-compute-effective-code
;    gf
;    (mapcar #'(lambda (x)
;		`(eql ,(or (catch-error (class-prototype x) nil) t))
;	      )
;	      (method-parameter-specializers method)
;    )
;  )
;)


;(defun method-combination-of-method (method)
;"Computes the method combination for Method.  This means that it returns a
; set of items suitable for the inspector that will display the method call
; sequence for this method.  What I mean by the method call sequence is as
; follows:  The method is invoked by the generic function which names it. 
; If this generic function is invoked with a set of args that are the same
; as the parameter specializers of this method then a particular set of
; actual methods (including the one in question) i.e. a combined method
; will be invoked.  The combined method is really just a piece of code
; that invokes the methods in the manner specified by the method combination
; for that method.  For instance, standard method combination might have a
; call sequence something like the following:
;   (progn <before method 1>
;          <before method 2>
;          ...
;          <before method n>
;          (multiple-value-prog1
;            <primary method>
;            <after method 1>
;            <after method 2>
;            ...
;            <after method n>))
; It is the job of this function to computed the form (like that above) that
; would be invoked by calling Method with its parameter specializers and
; turning it into a suitable item list.
;"

;  (let ((old #'si:macroexpand-all)
;	(form nil)
;	(gf (method-generic-function method))
;       )
;       (letf ((#'have-combined-method #'(lambda (&rest ignore) nil))
;	      (#'si:macroexpand-all
;	       #'(lambda (&rest args)
;		   (let ((results (multiple-value-list (apply old args))))
;		        (setq form (first results))
;			(values-list results)
;		   )
;		 )
;	      )
;	     )
;	     (let ((fef (generic-function-discriminator-code gf)))
;		  (catch-error
;		    (apply fef (make-list
;				 (length (set-difference
;					   (arglist fef)
;					   lisp:lambda-list-keywords
;					 )
;				 )
;				 :initial-element nil
;			       )
;		    )
;		    nil
;		  )
;		  (go-ahead-and-compute-the-effective-method method gf)
;		  (let ((*this-line* nil)
;			(*all-lines* nil)
;		       )
;		       (declare (special *this-line* *all-lines*))
;		       (post-process-combined-method form)
;		       (push (reverse *this-line*) *all-lines*)
;		       (let ((result (reverse (remove nil *all-lines*))))
;			    result
;		       )
;		  )
;	     )
;       )
;  )
;)



;;; This code from David Gray.

;;;RDA
(unless (= 6 (sys:get-system-version))
  (defgeneric compute-effective-method (generic-function method-combination methods)
    (:documentation "This is used to create an effective method.  
The arguments are a generic function, a method combination object [such as 
returned by GENERIC-FUNCTION-METHOD-COMBINATION], and a sorted list of 
applicable methods [such as returned by COMPUTE-APPLICABLE-METHODS].
The value returned is a Lisp form which will be used as the body of the 
effective method; within it are invocations of the CALL-METHOD macro.")
    (:generic-function-class gfun-generic-function))
  
  (defmethod compute-effective-method ((gfun generic-function) (combination cons) methods)
    ;; This method is temporary until method combinations are actually implemented as objects.
    (let ((generic-function gfun))
      (declare (special generic-function))
      (apply (or (get (car combination) 'method-combinator)
		 (error "Undefined method combination: ~S" (car combination)))
	     methods (rest combination))))
  )

