;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.  Where functionality implemented herein replicates
;;; similarly named functionality on Symbolics machines, this code was
;;; developed solely from the interface specification in the documentation
;;; or through guesswork, never by examination of Symbolics source code.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.
;;; **********************************************************************

(let ((compiler:compile-encapsulations-flag t))
     (advise finger :around "Do IP finger too" nil
       (let ((host (get-host-from-spec (first arglist))))
	 (if (send host :chaos-address)
	     :do-it
	     (apply 'ip:tcp-finger arglist)
	     )
	 )
       )
)

(defun get-host-from-spec (spec)
  (if spec
      (let* ((spec (string spec))
	     (host-name
	       (subseq
		 spec
		 (or (1+ (position #\@ spec :test #'char= :from-end t))
		     0
		     )
		 )
	       )
	     )
	(net:parse-host host-name))
      si:associated-machine
      )
  )

(defun get-name-from-spec (spec)
  (if spec
      (let ((spec (string spec)))
	(subseq
	  spec
	  0
	  (position #\@ spec :test #'char= :from-end t)
	  )
	)
      ""
      )
  )

(defun ip:tcp-finger (&optional spec (stream *standard-output*) hack-brackets-p)
  (let ((host (get-host-from-spec spec)))
    (with-open-stream (remote (ip:open-stream host
					      :remote-port ip:finger-port-number
					      :characters :ascii
					      :error nil
					      :timeout 60))
      (write-line (get-name-from-spec spec) remote)
      (force-output remote)
      (write-line "" stream)
      (stream-copy-until-eof-newline remote stream)
      )
    )
  )

(defun STREAM-COPY-UNTIL-EOF-newline (input output)
  "Copy INPUT to OUTPUT, but change any bar LineFeed chars to CR-LF."
  (loop with cr-seen? nil
	as c = (read-char input nil :eof)
	while (neq c :eof)
	do
	(if (and (= c #\linefeed)
		 (not cr-seen?))
	    ;; do CR instead of LF
	    (write-char #\cr output)
	    ;; else
	    (write-char c output)
	    )
	(if (= c #\cr)
	    (setf cr-seen? t)
	    (setf cr-seen? nil))
	)
  )