;;; -*- Mode:Common-Lisp; Package:TOOLS; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.  Where functionality implemented herein replicates
;;; similarly named functionality on Symbolics machines, this code was
;;; developed solely from the interface specification in the documentation
;;; or through guesswork, never by examination of Symbolics source code.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.
;;; **********************************************************************

;;; This software developed by:
;;;	Rich Acuff
;;;	James Rice
;;; at the Stanford University Knowledge Systems Lab in 1986, 1987, 1988, 1989.
;;;
;;; This work was supported in part by:
;;;	NIH Grant 5 P41 RR00785-15
;;;	DARPA Grant F30602-85-C-0012

;;;  This file has all the definitions for the "tool" systems.  Each
;;;  tool has a call to ADD-TOOL, and many have DEFSYSTEM declarations
;;;  in this file as well.  This file is loaded with the TOOLS system so
;;;  that time (and space) is not wasted looking for .SYSTEM files.

;===============================================================================
;===============================================================================

;;;	W A R N I N G     ! ! ! ! ! !

;;;	When you compile this file make sure that the XLD file has the SAME
;;;	VERSION NUMBER AS THE SOURCE FILE.  This is because of a bogosity in
;;;	Defsystem/Make-System.

;===============================================================================
;===============================================================================



(add-tool 'ksl-patches "Patches for Lisp developed at the KSL"
"This system fixes bugs and problems with the software supplied for this
machine.  It is highly advised that you load this tool, though it is
usually already a part of the running software.  The lisp machine will
not reload it if it knows it has not changed.")

(add-tool '36xx-Explorer
"Compatibility Package for porting code from a Symbolics 36xx to a TI Explorer"
"This system adds functionality to the TI Explorer to make it work more
like a Symbolics 36xx.  It should be used if you are porting code from a
36xx to an Explorer.")

(add-tool :ANSI-CL-Compatibility
"Compatibility Package for porting code to ANSI Common Lisp."
"Adds a bunch of features that enhance the Explorer environment to make it
more compatible with ANSI Common Lisp (largely CLtL2).
These are at present:
  - ANSI Defpackage support.
")

(defsystem :ANSI-CL-Compatibility
  (:name "ANSI Common Lisp Compatibility package")
  (:output-version :newest)
  (:module System ("TOOLS:TOOLS;DEFPACKAGE"))
  (:Compile-Load System)
)

(add-tool 'Explorer-36xx
"Compatibility Package for porting code from a TI Explorer to a Symbolics 36xx"
"This system adds functionality to the Symbolics 36xx to make it work more
like a TI Explorer.  It should be used if you are porting code from an
Explorer to a 36xx.")

(add-tool 'source-code-debugger
"Source Code Debugger"
" This system allows the user to do debugging at the source code level.  This
 is done by putting back pointers into functions as they are compiled, so that
 when in the debugger the source code can be reconstituted in the debugger's
 inspect pane.

 Using source code debugging should only slow down your code a bit (2x is the
 worst that I have seen).  This makes it a good 10 times faster than the
 interpreter, much less consey and it shows you the real source code, not some
 horrible macro expanded version in the debugger.

 Switching on source code debugging is either done by calling the function
 eh:turn-source-code-debugging-on (eh:turn-source-code-debugging-off switches
 it off) or by the zmacs command M-x Source Code Debugging, which toggles it on
 or off.

 In the debugger you will find that functions will be displayed in their source
 code form in the inspect pane.  Different fonts are used to indicate either
 the code that has just been executed or that code which has just been entered.
 A reminder in the history window is given to allow the user to know what the
 fonts mean.  You are advised to have the general inspector (which will be
 loaded) switched on.  Double clicking on the source code debugged stack frame
 entry in the inspect history window will show the real disassembled code.

 When you compile two things could happen:  If you are compiling within Zmacs
 then any function that is successfully compiled with source code debugging
 will print its name as (:debug foo) instead of foo.  If you are compiling a
 file then a notification will appear when you load the file to tell you that
 source code debugging was switched on during the compilation of that file.

 If errors or warnings occur during the compilation of the function then the
 compilation is retried without source code debugging, just in case anything
 went wrong during the compilation.  If you really want it to generate source
 code debugging code in spite of warnings you should setq
 eh:*still-source-code-debug-for-warnings* to t.

 Source code debugging and tail recursion:  The act of inserting source code
 debug code in a function disables tail recursion elimination.  Therefore if
 a function declares optimize safety 0 then the source code debugger doesn't
 operate because the tail recursion optimization is reasoned to be more
 important.  Anyway you shouldn't go around putting in such declarations if
 you aren't sure that it works.

 Potentially interesting variables:
  eh:*source-code-debuggable-forms* - If you have DefFoo macros which expand
    into defuns or defmethods and would like to source code debug the DefFoo
    then add DefFoo to this suitably.

  eh:*ignorable-warnings* - add to this if you really want to source code debug
    for warnings other than just breakpoints.
"
)

(defsystem Source-Code-Debugger
  (:name "Source Code Debugger")
  (:output-version :newest)
  (:module System ("TOOLS:TOOLS;SOURCE-CODE-DEBUGGING"))
  (:Compile-Load System)
)

(add-tool 'Pathname-Extensions
"Extensions to TI pathname syntax."
"
This file contains extensions to the Explorer pathname system which add the
following functionality:
a) :Wild-Inferiors - This is like the Symbolics :Wild-Inferiors directory
   component.  It is expressed either as :Wild-Inferiors as a directory
   item to Make-Pathname etc. or as \"**\" in a namestring.  Thus the path
   \"Foo:Bar.**.Baz;Frob.Lisp\" will match to any Frob.Lisps on Foo, which
   are under the top level directory Bar (or logical directory) and have
   Baz as their last directory component, e.g.
   \"Foo:Bar.Bax.Frob.Baz;Frob.Lisp\".

b) Relativised wild pathname versions (for want of a better name).  These
   allow you to express wild pathnames such as \"foo.lisp#>-*\", i.e.
   everything other than the most recent version, or \"foo.lisp#-2+*\", i.e.
   everything after the -2th version (in fact the most recent two versions.
   Any version can be relativised like this, be it an absolute version
   (e.g. 42) or a relative one (e.g. -2, :Oldest, :Newest, >, <, 0).
   A + sign denotes everything after and a - sign denotes everything before.

c) Logical expressions in directory, name, types and versions.  These
   allow you to express such things as: all the files whose names begin
   with \"L\" but not \"LOGIN-INIT\" .lisp.  Such a pathname would be expressed
   as \"lm:foo;(and l* (not login-init)).lisp\".  Any depth of nesting of
   expressions is allowed.  Any function/special form name which is fbound
   can be used, e.g. And, Or, Not.  The function must be a function which
   takes boolean args and returns a boolean value.  The args for a call
   to such a function are T if the expression denotes a match and Nil
   if not.

As an example of the above:

x6:rice.**.(not frob);*.(or lisp grammar)#-1-*

will match to all of the files in the Rice directory tree, except for
those in the Frob directory, which are either of the type Lisp or Grammar
and whose version is lower than the most recent but one.

This tool also puts a fix into Zmacs so that when you dired a path such as
foo:bar.**.baz; the directory will also be shown along with the file name and
type so that you know where the file actually comes from.
"
)

(defsystem Pathname-Extensions
  (:name "Pathname Extensions")
  (:output-version :newest)
  (:module System ("TOOLS:TOOLS;PATHNAME-EXTENSIONS"))
  (:Compile-Load System)
)

(add-tool 'Live-Listener
"A flavor of lisp listener that's mouse-sensitive."
"This system defines a new flavor of lisp listener called
   W:Live-Listener
Listeners of this flavor are mouse-sensitive and have a bunch
of commands on different mouse buttons.
"
)

;;;Edited by RICE                  1 Feb 90  14:51
(defsystem Live-Listener
  (:name "Live Listener")
  (:output-version :newest)
  (:module System ("TOOLS:TOOLS;Live-Listener"))
  (:Compile-Load System)
)

;;;Edited by RICE                  1 Feb 90  14:51
(add-tool :Genera-to-Explorer
"Genera release 7 compatibility package."
"Defines all sorts of things that come for free with Genera.
This can be used as a compatibility package for porting large systems
from Symbolics machines.
"
)

(add-tool 'Batch-Processor
"A batch processor to allow work to be done overnight."
"This system defines a batch processing facility.  It is enabled when it is loaded.
If it is loaded, it will wait until between 3 and 6 in the morning and then look for a
file named by the variable TICL:*BATCH-INPUT-COMMAND-FILE-NAME*, which defaults to
<User-Homedir>Batch.Lisp.  If this file exists, will be used as the
source of commands for the command file processor.  Indirection to other
command files is supported, as is the specification of different input streams,
to provide answers to input requests by the software being run.  The default
input stream returns a series of Y characters.  The batch processor creates a log
file named by the variable ticl:*BATCH-LOG-FILE-NAME*, which defaults to
<User-Homedir>Batch.Log.  If this system is built into a band then
it will start itself up automatically after both warm and cold booting.
Other variables of interest are *batch-batch-process-start-time*, 
*batch-batch-process-stop-time*, and *All-Batch-Processor-Commands*.")

(defsystem Batch-Processor
  (:name "Batch Processor")
  (:output-version :newest)
  (:module System ("TOOLS:TOOLS;BATCH-PROCESSOR"))
  (:Compile-Load System)
)

(add-tool 'utilities
"Useful functions"
 `("This is a group of useful functions, no one of which is wonderous enough
to be a tool of its own:

- BG runs a form in the \"background\" by creating a process with a
  low priority for it.

- The CALL-MANY function to invoke a function on many args in parallel.
   Useful when a function you want to call a lot spends a lot of time waiting
   (eg. for a network server).

- REBOOT to shutdown the system safely and reload the current world.

- Functions MAKE-MAP, MAP-LOOKUP, MAP-SET, MAP-REMOVE, and MAP-MAP for mapping
  between objects.

- TIME:DD-MMM-YY-STRING that takes a universal time (defaulting to the current
  time) and returns a date in the form 11-Feb-89.

- A SETF method for ASSOC.

- A facility for forcing the compilation of the method tables for all defined
  flavors and classes. sys:compile-flavors-and-classes
  (&optional (notify-stream *standard-output*) will do this.  A full-gc
  initialization is added such that if
  sys:*compile-flavors-and-classes-before-full-gc-p* (default nil) is true
  then the above function will be called before you do your gc-and-disk-save
  with sys:*full-gc-compile-flavor-methods-notify-stream* as its notify stream
  (default 'sys:null-stream).

- Adds an override to the bogus warning that defsystem gives you if you are in
  :safe mode.  This is controlled by:
  sys:*defeat-bogus-make-system-file-newer-than-file-p-message-p* (default nil)

- Defines the macro ticl:with-metering to help you meter you code.

- Defines a bunch of stack-consing primitives:
    ticl:with-stack-lists
    ticl:With-Stack-Backquote
    ticl:With-Variable-Length-Stack-List
    ticl:With-Variable-Length-Stack-List*
    ticl:With-Stack-Append

- Patches trace so that it prompts you if you want to trace methods
  separately etc. if you are tracing a generic function or keyword.

- Substantially enhances Who-Calls to traverse a whole bunch of different
  data structures, such as clos methods and plists and adds a generic
  method for adding your own types of who-calls traversal path, see
  sys:def-who-calls-function and sys:defwho-calls-report-type .
  The current doc string for who-calls is:
  ========================================
"
  ,#'(lambda () (format t "~A" (documentation 'who-calls 'function)))
 )
)

(defsystem utilities
  (:name "Utilities")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;UTILITIES"
		 "TOOLS:TOOLS;FILE-NEWER-THAN-FILE-P"
		 "TOOLS:TOOLS;MAYBE-WITH-METERING"
		 "TOOLS:TOOLS;TRACE-ENHANCEMENTS"
		 "TOOLS:TOOLS;STACK-CONS"
		 "TOOLS:TOOLS;WHO-CALLS"))
  (:compile-load main)
  )

(add-tool 'ZMacs-Enhancements
"Adds some new useful commands to Zmacs."
"This system adds the following commands to ZMacs:
  - m-X Mouse Indent Rigidly (c-m-sh-i)
    This is simply a key binding for the command that's normally on the
    right button menu.

  - m-X Compile Macro Callers
    This allows you to click on/type in a macro name and all calls to that
    macro in the current buffer will be recompiled.

  - m-X Tags Compile Macro Callers
    This allows you to click on/type in a macro name and all calls to that
    macro in the selected system/tag table will be recompiled.

  - m-X Macro Expand Into Buffer
    Takes the currently selected region or the next s-expression following
    the cursor, if there is no selected region, and macroexpands it putting
    the result into the current buffer, just before the expression which is
    to be macroexpanded.

  - m-X Rotate Buffer (c-sh-L)
    Rotates the current buffer on the buffer list to the bottom and moves the
    second buffer down to the top.

  - m-X Rotate Buffer Backwards (m-sh-L)
    Rotates the current buffer so that is becomes the second buffer in the
    buffer list and moves the buffer at the end of the buffer list to become
    the current buffer.

  - m-X Add File To Tag Table
    Prompts for a file and adds it to the current tag table if it is not
    present in the table.

  - m-X Remove File From Tag Table
    Prompts for a file and removes it from the current tag table if it is
    present in the table.

  - m-X Add Buffer to Tag Table
    Like Add File to tag table, but for buffers.

  - m-X Remove Buffer from Tag Table
    Like Remove File from tag table, but for buffers.

  - m-X Select Pathname as Tag Table
    Prompts for and uses a (wild) directory specification as the basis for a tag table.

  - m-X Make Tag Table
    Makes an empty tag table, into which you can put files and buffers.

  - m-X Add Buffer to Tag Table
    Adds a named buffer to the current tag table.

  - m-X Remove Buffer from Tag Table
    Removes a named buffer from the current tag table.

  - m-X Select All Buffers as Tag Table
    Selects absolutely all buffers as the tag table, including non-file buffers.

  - m-X Select All File Buffers as Tag Table
    Selects all file type buffers as the current tag table.

  - m-X Select System Version as Tag Table
    Selects a system as a tag table, but specifies the versions numbers for the
    files to be included explicitly.  For instance, all of the previous versions
    of a system's files can be selected if the selected version number is -1.

  - m-X Tags Source Compare
    Applies Source Compare to related files from two tag tables.

  - m-X Evaluate And Insert Into Buffer
    Takes the currently selected region, or the next s-expression following
    the cursor if there is no selected region, and evaluates it, putting
    the result into the current buffer, just before the expression which is
    to be evaluated.

  - s-sh-M Show Optimized Code
    Displays the resulting code after running compiler optimizers on the
    region.

  - m-sh-A Check Args in Expression
    Checks, wherever possible whether the actual parameters supplied match
    the formal parameters of the functions specified.

  - m-X Tags Chech Args
    Checks arglists like m-sh-A, only over a tag table.

  - m-X Enable Spawning
    Allows those m-X commands which the system knows can be done in the
    background to be spawned into a background process.

  - m-X Disable Spawning
    Stops processes from being spun off to evaluate m-X commands.

  - m-X Make System
    Runs make-system for a named system, prompting for useful make-system arguments.
    (spawnable)

  - m-X Load System
    A quick way to load a named system.  (spawnable)

  - m-X Compile System
    Make-system :Compile a named system.  (spawnable)

  - m-X ReCompile System
    Make-system :ReCompile a named system.  (spawnable)

  - m-X Load Tool
    Loads a named tool (completion and help provided).
    [This is actually added by the Load-Tools tool, but this is a good
     place to document it.]

  - m-X Document Tool
    Print the documentation for a tool (completion and help
    provided) in the Zmacs typeout window.  Interesting
    names in the documentation are printed mouse
    sensitively.  Clicking on them will edit the source
    for that name.
    [This is actually added by the Load-Tools tool, but this is a good
     place to document it.]

  - m-X Source Compare Regions
    Compare two regions with source compare, as opposed to compare two whole buffers.

  - m-X Highlight Region
    Highlight a region of text according to the following specification.
    Four types of highlighing are allowed: Upcase, DownCase, Capitalize and
    Fontification.  Fontification can be mixed with any of the other modes.
    Highlighing is currently defined for the following types of things.

    :Globals             - all symbols in the Lisp and TICL packages.
    :Defined-In-File     - all symbols defined (defun etc.) in the current file.
    :Keywords            - all symbols in the keyword package.
    :Not-Defined-In-File - all non-global symbols defined in a file other than
                           the current file.
    :Else                - all things which do not satisfy any of the above.

    Which things are highlighted is controlled by
    zwei:*user-highlight-preferences*, whose default value is:
	      '((:Globals             (:upcase     2) t)
		(:Defined-In-File     (:capitalize 1) nil)
		(:Keywords            (:downcase   3) nil)
		(:Not-Defined-In-File (:capitalize 4) nil)
	       )
    This is Alist of definition types.  Each type is something like
    (:Global <spec> <function calls only>).  The value of the spec can be either
    a font number (zero indexed), :UpCase or :DownCase :Capitalize or a list or
    any of these, e.g. (:Upcase 3).  The third element of the type is a flag
    which, if true, will cause a call to happen only for function calls.

  - m-X Highlight Mode
    Toggles on/off a minor mode, like uppercase globals mode, only it
    highlights instead.

  - m-X UnFasl
    Prompts for a xld file and unfasls it into the typeout window.

  - s-c-space (m-X Move To Menu Selected Section From Point Pdl)
    Gives a completing minibuffer of the functions that have previously
    been pushed onto the point pdl of the current window and goes to
    the selected one.

  The attatchment of the commands to the defined keys is optional.  This is
  controlled by the variable Zwei:*Zmacs-Enhancements-to-add*.  This can have
  the values:
    
    - :All (default)
    - :Menu in which case a menu is produced.  Those commands which are
      selected are added to the command tables as key strokes.
    - A list of either strings, denoting the names given above, or items taken
      from the list of commands zwei:*Zmacs-Enhancements-Commands*.

  Other interesting variables:

  Zwei:*Dired-Default-Type* - this controls the type that dired will search for
    by default when you do c-X c-D.  If this is nil (default) then everything
    is as normal.  If you set it to something like (or \"LISP\" \"DIRECTORY\")
    then the directory will default to all of the lisp and directory files,
    unless you say something different.

  Zwei:*Dired-Default-Version* - this controls the version that dired will
    search for by default when you do c-X c-D.  If this is :wild (default)
    then everything is as normal.  If you set it to :newest
    then the directory will default to the most recent version.  If you set
    it to \"-2+*\" or (:version -2 :after) then it'll default to the most
    recent two versions on systems that support the pathname-extensions tool.

  Zwei:*Special-Directory-To-Type-Mappings* - this alist controls whether any
    directory types are to be taken to be special by dired (default nil = not).
    If, for instance, you set this to
    ((\"SITE\" (or \"LISP\" \"SYSTEM\" \"TRANSLATIONS\"))), then whenever you
    dired something and the default path has SITE at the end, it will have
    a default type of (or \"LISP\" \"SYSTEM\" \"TRANSLATIONS\").

  Zwei:*make-files-that-are-not-mine-read-only*  - When true (default NIL) Zmacs
    will make any buffer read-only by default unless it either comes from a
    host whose is the same as the current user id, or if the user's name is
    in the directory path.  For example, if your name is FOO any you try to
    edit the file bar:foo;frob.lisp then this will not be made read-only,
    but sys:debug-tools;inspect.lisp will be unless there is a logical host
    called FOO that points to SYS.

  Zwei:*Select-Previous-Definitions-For-C-u-M-.-p* - when you do a M-. all of
    the places that you have M-.ed to are remembered.  If this variable is true
    then, when you do C-u, M-. it will give you a completing minibuffer
    of the definitions you have previously gone to.  Default is disabled.

  Zwei:*open-dired-directories-with-inherited-constraints* - when this flag
    is true (default = true) dired by default inherits the pathname constraints
    that you applied when you selected the initial pathname when you open
    subdirectories.  For instance, if you dired *.(or lisp directory)#> then
    when you S or E a subdirectory it will inherit the *.(or lisp directory)#>
    constraint.  If you don't want this to happen then you can use the Sh-E
    and Sh-S commands to ogo into subdirectories.

  Note: also on the subject of Dired, there is now a check to stop you from
    closing a subdirectory if you have marked/deleted some files without
    confirming.

 This tool also allows completion in Zmacs.  This is enabled by default and
 is controlled by the variable:
  Zwei:*Enable-Lisp-Type-Completion-In-Zmacs-P*

 When this is true, four completion commands become available:
  Escape - simple initial substring completion.
  Control-/ - menu of initial substring completions.
  Super-/ - menu of apropos completions.
  Hyper-Escape - Spell checking completion.
 Other interesting variables for completion are:
  zwei:*completion-prefered-replacement-case*
  zwei:*use-menu-even-if-only-one-completion-found-p*


 The system also allows the user definition of ZMacs section names. 
 This means that if you have your own top-level macro constructs,
 e.g. Rule then
  (rule foo ...)
 can be caused to get the section name FOO, so that M-. will work properly.

 Also adds functionality to i-search, so that you can yank text from the
 kill ring into a search, e.g.  c-s c-y c-s will search for the last string
 in the kill ring.

 m-, has been enhanced so that it will work on things other than function,
 e.g. method keywords.  The pathnames that are printed out are also mouse
 selectable.
"
)

(defsystem ZMacs-Enhancements
  (:name "ZMacs Enhancements")
  (:output-version :newest)
  (:module System (("TOOLS:TOOLS;ZMACS-ENHANCEMENTS")
		   ("TOOLS:TOOLS;I-SEARCH-YANK-HACK")
		   ("TOOLS:TOOLS;ZMACS-COMPLETION")
		   ("TOOLS:TOOLS;EPSILONS")))
  (:Compile-Load System)
)

(add-tool 'Window-Debugger-Enhancements
"Adds some new useful commands and behaviour to the Window Debugger."
"This system adds the following commands and behaviour to the Window Debugger:

  - Allows the debugger to print the value of Self in the Locals window for
    those methods which do not explicitly use self.  This facility is switched
    on by the variable eh:*show-self-in-locals-window-anyway*.  This can have
    the values; Nil, in which case the behaviour is like the default, :Always,
    in which case Self is always printed, even for non-method functions, and any
    other non-nil value, in which case the value of Self will be displayed for
    all methods.

  - Allow the debugger to show not only the specials that are bound in the
    current frame, but also the specials that are read.  This is controlled
    by eh:*show-referenced-specials-in-locals-window* whose default is T.

  - Debug Stack Group (h-S)
    This option prompts the user for a stack group or something that can be
    coerced into a stack group and then instantiates a new window debugger
    frame, looking at the defined stack group.  That which determines what
    can be coerced into a stack group is whether the name of its type has
    a property called :Stack-Group-Accessor.  If it has then the value of
    this property, it is taken to be an access function, which when called with
    the object as its argument will deliver an object of type stack group.

  - Modify Inspect (c-M)
    This allows the inspect pane to have modifications made in it like the
    Modify command in the inspector.

    The user is not forced to have all of these commands added.  The commands
    that are loaded are controlled by the variable
    eh:*Window-debugger-Enhancements-to-add*.  This can have the values:
    
    - :All (default)
    - :Menu in which case a menu is produced, which has two columns.  Those
      on the left, if selected, will be put into the command menus of the
      relevant constraint frames where appropriate, those on the right will
      be added only to the command tables as key strokes.
    - A list of either strings, denoting the names given above, or items taken
      from the list of commands eh:*Window-Debugger-Enhancements-Commands*.

  - Extends the Search command (search for function on stack) [C-S] so that
    with a numeric argument it will search for a frame which binds a special
    that you specify.  If the numeric argument equals two, then it searches for a frame
    that references (reads or binds) a special.  Like searching for function
    names, it searches for specials that contain the text you typed.

  - In the non-window debugger there is now code to show you all of the open
    catches on the stack when you M-l, not just those for the current frame.

  - Adds a bunch of functionality to the debugger and zmacs for the evaluation
    of expressions.  In the debugger interactor it defines all variables, args
    instance-variables, closure variables, local functions etc, such that
    if you type an expression to the listener it will be evaluated in the
    context of the erroring frame.  Note: if you say (setq x 42) and x is the
    name of a local, that local will be set (i.e. it does the right thing).

    In zmacs similar functionality can be found.  If you evaluate an expression
    then it knows how to look at the section you are in and then look for a
    stack frame in a halted process that is named by the section name.  It uses
    this to bind up context for the evaluation.
    The search starts at the current stack pointer position in the erroring
    process and heads down to the bottom of the stack.  If it fails then
    it start again at the top and looks down until it gets to the erroring
    frame.
    This allows you to control the context in which you evaluate forms, simply
    by moving the debugger up and down the stack if there are multiple calls
    to the same function.
    Whether this functionality is enabled is controlled by the variable:
    zwei:*try-to-eval-in-debugger-context-p* (default :on-error)
    When this is :on-error then this functionbality is only invoked if there
    is an unbound variable type of error during the evaluation of your
    selected form.  If it is T then it will always do the above.  If it is nil
    then it will never do so.
"
)

(defsystem Window-Debugger-Enhancements
  (:name "Window Debugger Enhancements")
  (:output-version :newest)
  (:module System (("TOOLS:TOOLS;WINDOW-DEBUGGER-ENHANCEMENTS")
		   ("TOOLS:TOOLS;BIND-VARS-WHEN-IN-DEBUGGER"))
  )
  (:Compile-Load System)
)

(add-tool 'Inspector-Enhancements
"Adds some new useful commands to the Inspector."
"This system adds the following commands to the Inspector:
  - Debug Stack Group (h-S)
    This option prompts the user for a stack group or something that can be
    coerced into a stack group and then instantiates a new window debugger
    frame, looking at the defined stack group.  That which determines what
    can be coerced into a stack group is whether the name of its type has
    a property called :Stack-Group-Accessor.  If it has then the value of
    this property is taken to be an access function, which when called with
    the object as its argument will deliver an object of type stack group.

    The user is not forced to have all of these commands added.  The commands
    that are loaded are controlled by the variable
    tv:*Inspector-Enhancements-to-add*.  This can have the values:
    
    - :All (default)
    - :Menu in which case a menu is produced, which has two columns.  Those
      on the left, if selected, will be put into the command menus of the
      relevant constraint frames where appropriate, those on the right will
      only be added to the command tables as key strokes.
    - A list of either strings, denoting the names given above, or items taken
      from the list of commands tv:*Inspector-Enhancements-Commands*.

As well as adding the above command it adds the following functionality:

    Named structures printed with the default #S(foo....) syntax
    can be made mouse sensitive.  Mouse sensitivity applies to all of the
    slot values and the structure type name, though not the slot
    names themselves, since these are just keywords.  This facility is
    ON by default.  You can switch it off by
    (setq tv:*make-structure-instances-mouse-sensitive* nil).

    The inspect behaviour for FEFs and Stack frames has been extended.  They
    now show at the top (mouse sensitively) the function name and its
    debug info struct.  This helps get around the inability to find
    out about a function once you are stuck looking at its disassembled
    code.  This facility ON by default.  You can switch it off by
    (setq tv:*show-dbis-fof-fefs-in-inspector* nil).

    The Inspector now supports multiple fonts.  Thus fontified
    strings come out in the relevant font.  The function
    tv:fontify-string (string, font-number) will return a string
    like String only shifted into font Font-Number.

This system defines mouse-sensitive format directives.  These allow you to
have things be mouse-sensitive in inspect windows with user defined behaviour.
When printed in a non-inspect window the text comes out looking the same, only
it is not mouse-sensitive.  The format directives are all like ~<x>, where
<x> is some character like .  They are defined as follows:

 - ~	Takes two arguments.  The first is the thing to format and
	the second is the slashification.
	Thus (format stream \"A structure :- ~\" a-struct slashify)
	will print out a-struct slashifiedly if slashify is non-nil,
	otherwise unslashifiedly.  If the thing being printed is being
	printed in an inspector pane then the thing to be printed is
	printed out mouse sensitively as long as the *inspect-details*
	flag is true.  When the mouse-sensitive thing is clicked on, the
	inspector selects the first argument, i.e. a-struct, above.

 - ~	Takes one argument, which is a two/three/four list.
	This list is as follows:
	   The first is the thing to format
	   The second is the slashification
	   The third, if provided, is the printed representation of the
	   first (i.e. the thing to print).
	   The font in which to print it.
	Thus
	(format stream \#A structure :- ~\" (list a-struct nil \"#<struct>\")
	will print out a-struct as the string \"#<struct>\", which will be
	princed. If the thing being printed is being printed in an inspector
	pane then the thing to be printed is printed out mouse sensitively as
	long as the *inspect-details* flag is true.  Similarly,	
	(format stream \"#<foo ~>\" (list x t y 2)) will
	print out x so that it looks like y but will return x if you
	click on it in an inspect window.  It will be slashified and
	displayed in font 2.

 - ~	Takes one argument, which is a two/three list.  This list
	is as follows:
	   The first is the thing to format
	   The second is the slashification
	   The third, if provided, is the printed representation of the
	   first (i.e the thing to print).
	Thus
	(format stream \"A structure :- ~\" (list a-struct nil \"#<struct>\")
	will print out a-struct as the string \"#<struct>\", which will be
	princed.  This format directive does not provide mouse sensitivity.  
	The reason for this is that it is compatible with ~, which does 
        provide mouse sensitivity.  This means that you can make alternate
        elements in lists, for instance, mouse sensitive whilst still format-
        ting the list as for ~.

 - ~		Formats a list of things, taking two arguments.  The first argument
	is the list of things to print out.  The second is the slashification
	to use for all of them.  The list of things is printed out with
	spaces between them, using the ~ format directive.  This means that
	the elements will come out mouse sensitive if they are printed out in
	an inspector pane and the *inspect-details* flag is true.
	Thus (format stream \"A list: ~	\" '(a b c) slashify) will print out
	A list: foo:a foo:b foo:c
	if slashify is true and
	A list: a b c
	if it is not.

 - ~ 	Formats a list of things, taking two arguments.  The first argument
	is the list of things to print out.  The second is the slashification
	to use for all of them.  The alternate elements in the list of things
	are printed out using the ~ format directive.  This means that these
	elements will come out mouse sensitive if they are printed out in an
	inspector pane and the *inspect-details* flag is true.
	Thus (format stream \"A list: ~	\" '(a b c) slashify) will print out
	A list: foo:a foo:b foo:c
	if slashify is true and
	A list: a b c
	if it is not.

 - ~
	Formats a list of things, taking seven arguments.
	i)   the list of things to print out.
	ii)  the slashification to use for all of them.
	iii) The whole structure of which i) is a part.
	iv)  something which can be converted into a string to use as a
	     separator.
	v)   a string which is used as the left bracket for i).  This could be,
	     for instance, \"[\".
	vi)  a string which is used as the right bracket for i).  This could be,
	     for instance, \"]\".
	vii)  the current print depth level.
	The list of things is printed out with the separator princed between
	them, using the ~ format directive and with the brackets princed at
	each end.  This means that the elements will come out mouse sensitive
	if they are printed out in an inspector pane and the *inspect-details*
        flag is true.
	Thus
	(format stream \"A list: ~
\"
	        '(a b c) slashify fred \", \" \"{\" \"}\" 0)
	will print out as
	A list: {foo:a, foo:b, foo:c}
	if slashify is true and
	A list: {a, b, c}
	if it is not.

Mouse sensitive print directives work when grinding out
lists.  There is a problem about what the user might want to
happen in a print method when a slot whose value is a list is
printed out.  Should this list be ground or printed on the same line?
The default behaviour is to print it on the same line.  You can
switch this off by binding tv:*allow-breaks-in-unbreakables* to
t around the thing that does the printing.

The inspection behaviour for Locatives has been enhanced considerably.  Now,
if you are inspecting a locative to the Foo slot of a defstruct instance of
type Bar, then the inspector will show you something like:
  Locative to the FOO slot of #S(BAR :FOO 42)
and it will then display all of the contents of the instance below.

A fix has been added so that when you inspect a PDL only the active
part of the PDL is inspected.  This is because the unallocated part of
a PDL often has bad pointers that kills the machine if you inspect them.

Enhances Peek so that the windows display shows more about the window and
so that the file system peek display shows all open files on the local
file system properly.  Provides the var tv:*sort-processes-in-peek-p* ,
which when true causes the processes in the process display to be
sorted by process name (default nil).

Adds a new type of blinker (tv:value-displaying-hollow-rectangular-blinker)
so that it will pop up a little window showing a value as you track the mouse
over items.  This can be turned on in the inspector with
  tv:*use-show-value-blinker-in-inspector-p* (default nil)
and in the debugger with
  eh:*use-show-value-blinker-in-debugger-p* (default nil)
In the debugger it will show the value of locals and args and such bound in the
current frame.
"
)

(defsystem Inspector-Enhancements
  (:name "Inspector Enhancements")
  (:output-version :newest)
  (:module sigh ("TOOLS:TOOLS;DEVELOPMENT-TOOL-CONSISTENCY-ENHANCEMENTS"))
  (:module System ("TOOLS:TOOLS;INSPECTOR-ENHANCEMENTS"
		   "TOOLS:TOOLS;PEEK-ENHANCEMENTS"))
  (:Compile-load sigh)
  (:Compile-Load System)
)

(add-tool 'Development-Tool-Consistency-Enhancements
"A set of commands that make the tools talk to one another better."
"This system adds the following major bits of functionality:
  - Streams created within edit buffers can appear in the who-line, as if
    they were normal files.  This allows you to see how compilations are
    going and such like.  To enable this facility set the global variable
    Zwei:*Zmacs-Buffer-Streams-Displayed-In-Who-Line-P* to T.

  - Two open streams can be shown in the who line.  This involves reformatting
    the who line and displaying it in a smaller font.  This feature is under the
    control of three variables and one function.  These are:
    w:*Chars-for-who-line-package* (default 7) - the number of chars used to
    display the current package.
    w:*Chars-for-who-line-process-state* (default 10) - the number of chars
    used to display the current process state.
    w:*Show-Two-Files-In-Who-Line* (default nil) - when true two files will be
    shown in the who line file sheet when appropriate. 
    The function w:reset-who-line will make the system take note of a change to
    the value of w:*Show-Two-Files-In-Who-Line*.
    If w:*Show-Two-Files-In-Who-Line* has been set back to nil then the who
    line will revert to its normal format.

  - Allows the current process run state part of the who line to show the run
    state of background processes if the current process is in keyboard mode.
    This is controlled by tv:*show-background-processes-in-who-line*,
    tv:*background-process-display-font* and tv:*who-line-run-state-toggle-time*
    tv:*Chars-for-who-line-process-state*.

  - Enhances the Help commands in the Inspector and Window Debugger so that
    they print out all of the commands available along with their help texts.
    This is useful because not all of the commands appear in their menus.

  - Add a number of commands to the Inspector, ZMacs, and the Window Debugger
    so that they talk to each other better.  This can involve either
    the addition of completely new commands or the addition of new keystrokes
    to existing commands, so that they are accessed in a regular way.

    The commands which are added to these tools are:

    Inspect - to Zmacs
    Eval - to the Inspector
    MacroExpand - to the Inspector
    Compile - to the Inspector and the Debugger
    Arglist - to the Inspector and the Debugger
    Trace - to all three
    Document - to the Inspector and the Debugger
    Flavor Inspect - to Zmacs and the Debugger
    ISearch and Reverse Isearch - to the Inspector and the Debugger
    Save Region (m-w) - to the Inspector and the Debugger

    The trace command, in fact, adds three new commands:
    - c-sh-T (Trace something with the trace menu)
    - m-sh-T (Just go ahead and trace something without the menu)
    - s-sh-T (Untrace something)
    The item that appears in a menu represents the first of these where
    appropriate.

    Note: The Reverse ISearch command is assigned to c-r in the Inspector.
    This results in the refresh command being reassigned to m-r.
    In the window debugger c-r and c-s are already assigned to Return and
    Search on stack for function name.  ISearch and Reverse ISearch have been
    assigned to c-sh-s and c-sh-r respectively.

    If a numeric arg is given with the ISearch, Reverse ISearch or Save Region
    commands then the operation happens in the window under the mouse.

    The user is not forced to have all of these commands added.  The commands
    that are loaded are controlled by the variable
    tv:*selected-consistancy-commands*.  This can have the values:
    
    - :All (default)
    - :Menu in which case a menu is produced, which has two columns.  Those
      on the left, if selected, will be put into the command menus of the
      relevant constraint frames where appropriate, those on the right will
      only be added to the command tables as key strokes.
    - A list of either strings, denoting the names given above, or items taken
      from the list of commands tv:*all-consistancy-commands*.

 Also generalizes the printing of long documentation, e.g. M-Sh-D.  To add your
 own way to document something, add an element to the list tv:*documentors*. 
 The element should be a list of two functions.  The first should return true
 if the argument has documentation of the type you want and the second
 function should return the docstring for the argument.  Example:

    (list
      #'(lambda (name) (get name 'si:flavor))
      #'(lambda (name &aux doc)
	  (let ((temp (get name 'si:flavor)))
	    (format t \"~%~s is a flavor~%\" name)
	    (when (and (setq temp (si:flavor-plist temp))
		       (setq doc
			     (second (member :documentation temp :test #'eq))))
	      (format t \"~a~%\" doc)))))

 The Help commands in the Inspector and the window debugger have been enhanced
 so as to give a list of the available keyboard commands.

")

(add-tool 'general-inspector
"Generalised Inspector tool, which provides Inspector/Flavor Inspector and Class Inspector behaviour in one window with a multiple perspective mechanism."
" This system defines new versions of the Inspector and Window Debugger
 Constraint frames.  This enables the user to do flavor-inspector like things
 whilst in the normal inspector and in the inspect pane of the window debugger.
 Major changes of note are as follows:
  Double left click will toggle between perspectives.  Thus double left
  clicking on a flavor object will flavor inspect that flavor.  Doing so on
  a flavor inspected flavor will inspect the flavor defstruct.

  Double left click behaviour is also used to present different perspectives
  of other things.  For example:

    L2 lists will allow the list to be viewed as a normal list, a Plist, an
    AList, a named defstruct, a non-named defstruct or just one element on a
    line.

    Symbols will allow viewing of different objects named by that symbol:
    Flavor, Class, Package, Resource, Defstruct descriptor, function, et
    cetera.

    For functions, double left click will toggle between disassembled code
    and source code if the source code debugger is enabled.

  You can always tell whether there are multiple perspectives available because
  the who line will a) tell you that L2 is an available command and b) will
  list the names of the perspectives after the other mouse docs.  These
  perspective names can be used to force the inspector to view something in
  a particular perspective.  For example, (inspect 'w:lisp-listener) will
  inspect the symbol W:Lisp-Listener, (inspect 'w:lisp-listener :class) will
  class-inspect the class named w:lisp-listener.  There are 28 perspectives
  defined by default.  They are all named in the list 
  tv:*all-perspective-names*.

  The user can define new perspectives fairly easily using the tv:defperspective
  form.  Extensive documentation exists for this in the source code at the top
  of the file general-inspector:general-inspector;general-inspector.lisp,
  including a worked example.

  Middle click, setq, =, and * echo the object in the interactor window.

 There were a number of bogosities in the inspector which decreased its
 performance significantly.  The item cache, which held the mouse sensitive
 representations of the things being inspected, got flushed pretty well all of
 the time.  This meant that the inspector spent all of its time recomputing
 things which had not changed.  This has been patched so that things will only
 be recomputed, by default, if either i) they are modified or ii) you click
 on Refresh.  You can switch this off if you really want to (by setting the
 variables tv:*flush-cache-if-left-button-on-something* to T or :Really and
 tv:*update-panes-base-ok* to nil).

 The following modifications apply to flavor inspection:

   a) Menu options for Flavors:
     i)  Init Keywords - shows all init keywords and initable IVs for
	 all component flavors.
     ii) Init Keywords, Sorted - shows all init keywords, flat and sorted.
   
   b) Menu options for Methods:
     i)  Show Call Tree - Shows the method combination order for this method,
	 including wrappers and :Around methods.  Also works for all method
	 combination types, e.g. :Or etc.
     ii) Show Related methods - Shows all methods with the same method name
	 for all flavors which depend on and which are components of the flavor
	 of the current method.  This is a good way of seeing all of the
	 :kill methods for all types of window, for instance.
   
   c) Method typein.  Previously when typing in a method e.g.
      Flavor-Name :Method-Name
      it used to be required that <Flavor-Name> supported :Method-name
      directly.  It will now look for matches somewhat better, like it does
      in Zmacs for M-..

 The General Inspector introduces the variable
 EH::*DEBUGGER-FRAME-DEFAULT-EDGES*.  This variable can be set to a list of 4
 integers indicating what the default edges of new window debugger frames
 should be.

")


;;;  W A R N I N G.  This File Contains pathname references to other files
;;; in Tools:Tools;  These will have to be compiled separately. 
(defsystem Development-Tool-Consistency-Enhancements
  (:name "Development Tool Consistency Enhancements")
  (:output-version :newest)
  (:module System ("TOOLS:TOOLS;DEVELOPMENT-TOOL-CONSISTENCY-ENHANCEMENTS"))
  (:Compile-Load System)
)

(add-tool 'Structure-Enhancements
"A modification to DEFSTRUCT, which allows type checking for access functions, and a default message handler."
" This system adds changes to the DEFSTRUCT facility so that the access
 functions, which are defined by subsequent DEFSTRUCT compilations, will
 cause type checking code to be generated.  This will work also for SETFs to
 structure fields.  To get this typechecking behaviour use the macro
 Defstruct-Safe, instead of Defstruct.  Whether type checking is enabled
 or not is determined by the global special variable *TYPECHECKING-ON*, which
 when non-NIL will cause type checking code to be generated.  The default
 value for this variable is T.

 Also defined is a general message handler for named structures called
 General-Structure-Message-Handler.  This message handler allows structures to
 act just like they do normally but if a message is sent to one it causes an
 error instead of returning nil, which is the currently defined behaviour.  To add
 the message handler to a given structure you should evaluate the following
 form:
 (PUTPROP '<The-name-of-the-named-structure>
          'GENERAL-STRUCTURE-MESSAGE-HANDLER
          'NAMED-STRUCTURE-INVOKE)
")

(defsystem Structure-Enhancements
  (:name "Structure Enhancements")
  (:output-version :newest)
  (:module System ("TOOLS:TOOLS;STRUCTURE-ENHANCEMENTS"))
  (:Compile-Load System)
)


#|  In W-S-A for now
(add-tool 'analog-clock
"A clock with hands"
"Provides a clock with hands.  Call the function W:ANALOG-CLOCK, and play
with the result (click on it)."
)

(defsystem analog-clock
  (:name "Analog-Clock")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;ANALOG-CLOCK"))
  (:compile-load main)
  )
|#

(add-tool 'Window-System-Additions
"Many useful additions to the window system"
" This file contains many pieces of generally useful window system related
utilities.  With a few exceptions, they don't affect the environment
directly.  Those that can are under the control of user settable variables.
In general, things later in the file might use thing earlier in the file.
The following facilities are defined:

- WINDOW-SYSTEM-UTILITIES: A set of utilities, including:
  -- TEMP-PIXEL-ARRAYS, a resource of pixel arrays
  -- MAKE-BITMAP, makes a 1 bit pixel array, rounding up the width to a
     multiple of 32, as the Explorer requires
  -- BITMAP-WIDTH and BITMAP-HEIGHT, replacing the disfavored PIXEL-ARRAY-...
  -- CLEAR-BITMAP which zeros a bitmap.
  -- Functions to read and write bitmaps written from InterLisp-D
  -- WITH-MOUSE-SHEET to execute some code with MOUSE-SHEET temporarily
     set to some window.
  -- LEFT-DOWN?, MIDDLE-DOWN?, and RIGHT-DOWN? for testing mouse button
     states.

- A definition for <Term> P so that it can be used to easily change the
  priority of the process associated with the selected window.

- DEEXPOSED-MOUSE:  Redefinitions of some system functions so that
  :DEEXPOSED-MOUSE-BUTTONS and :DEEXPOSED-WHO-LINE-DOCUMENTATION-STRING
  get called if a window is deexposed, under the mouse, and handles
  them.

- SNAPSHOT-WINDOWS:  'Snapshots' of the screen--the user specifies a
  rectangle, and a new  window is created with that part of the screen
  image in it.  SNAP-REGION or the window oriented system menu are the
  usual interfaces.

- BACKGROUNDS:  A 'background' or 'curtain' window, providing an easy way
  to hide temporarily unwanted windows if the user is employing a
  desk-top window style.  See doc strings for *WINDOWS-TO-LEAVE-EXPOSED*,
  CREATE-BACKGROUND, SET-BACKGROUND, and CHOOSE-BACKGROUND.

- TRANSPARENT-WINDOW:  The flavor W:TRANSPARENT-WINDOW-MIXIN which allows
  the image underneath a window to bleed through, giving the illusion of
  non-rectangular windows.

- WINDOW-MANAGER-SYSTEM-MENU:  A window manager oriented system menu,
  under the control of W:*USE-WINDOW-MANAGER-SYSTEM-MENU*.

- ANALOG-CLOCK: An analog clock accessable via the W:ANALOG-CLOCK
  function.

- VERTICALLY-ORDERED-MENU-COLUMNS:  A mixin flavor which allows the ordering
  of items in multi-column menus to be vertical, like a phone book, as opposed
  to the default, which is horizontal.

- CHOICE-FACILITY-ENHANCEMENTS:  Two macros W:Assign-Using-Menu and
  W:Values-Using-Menu.  These provide a more friendly interface to the
  w:choose-variable-values function.  They do not require the use of
  Special variables.  The former Setfs the value denoting expressions
  with the new values, the latter returns multiple values.

- RUBBER-BAND-RECTANGLES:  If *USE-RUBBER-BANDS?* is non-NIL then
  rectangles (eg. for new window shapes) are specified with a mouse-
  following box.

- WINDOW-DRAGGING:  If W:*DRAGGING-ENABLED?* is non-NIL then most windows that
  don't already have some action associated with the Middle mouse button
  can be 'dragged'.  'Grab' a window by pressing and holding the Middle
  mouse button, move the ghost box to the desired new position, and
  release.  This works with LISP-LISTENERs, SINGLE-WINDOW-VT100s, Zmacs
  frames (in the mini-buffer area), ANALOG-CLOCK, Snap windows,
  non-sensitive areas of Inspectors, and Window Debuggers, and
  GRAPHICAL-VALUE-MONITORs.

- The variable W:*MOUSE-WARP-GRATUITOUSLY?* which when non-NIL causes the
  system to warp the mouse less (eg. after menu selection or during menu
  pop-up).

- The function ticl:WUM , which finds the tv:window-under-mouse.  Takes an
  optional arg which specifies how many superiors to go up from the window-
  under-mouse (default 0).

- The macros tv:with-window-ops-on-bit-array
  and tv:without-window-ops-on-bit-array  Execute a BODY with a SHEET
  pretending to be deexposed so that any window ops happen on its bit
  save array, not directly onto the screen.  This can be much faster
  than normal output because the screen memory into which the normal
  screen array is mapped is very slow wrt the machine's normal memory.
")

(defsystem Window-System-Additions
  (:name "Window System Additions")
  (:output-version :newest)
  (:module System ("TOOLS:TOOLS;WINDOW-SYSTEM-ADDITIONS"))
  (:Compile-Load System)
)

#|  In W-S-A for now
(add-tool 'backgrounds
"A `curtain' for hiding currently uninteresting windows, suitable for holding an intersting backdrop image"
"Provides a `background' window so that uninteresting windows can be
hidden, making it possible to use a ``desk-top'' screen management
metaphore.  Evaluate (TV:CREATE-BACKGROUND) after loading.  Push any
windows that you always want up (eg. from Graphical-Monitors) onto
TV:*WINDOWS-TO-LEAVE-EXPOSED*, and then use <Term> Z to `reset' the
screen.  Clicking left on the background will get you a `background
menu' that offers to let you clean up your windows (same as <Term> Z),
or choose a new background image, which can be a gray level, or one of
several images stored on X1:IMAGES;*.FASTBM.  Use <TERM> 1 C to
complement the background's video."
)

(defsystem backgrounds
  (:name "Backgrounds")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;BACKGROUNDS"))
  (:compile-load main)
  )

|#

(add-tool 'backup-to-file-system
"Define functions for backing up files from one file system to another (not tape)."
"This system defines FULL-BACKUP, BACKUP-FILES, and RESTORE-FILES for
making backup copies of directories.  See the documentation in
TOOLS:TOOLS;BACKUP-TO-FILE-SYSTEM.DOC or Sumex:<LispM>BACKUP-TO-FILE-SYSTEM.*"
)

(defsystem BACKUP-TO-FILE-SYSTEM
  (:name "File System to File System Backup")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;BACKUP-TO-FILE-SYSTEM"))
  (:compile-load main)
  )

(add-tool 'graphical-value-monitors
"Chart graphs to monitor time varying values"
"Defines the flavors W:GRAPHICAL-MONITOR-MIXIN and
W:GRAPHICAL-MONITOR-WINDOW which can be used to watch values change over
time.  Also defines W:MONITOR-NET-TRANSMISSIONS,
W:MONITOR-NET-RECEPTIONS, W:MONITOR-CONSING, and W:MONITOR-DISK-OPS
which show Ethernet transmissions, receptions, space consed, and Disk
Swapping operations (reads and writes)." )

(defsystem graphical-value-monitors
  (:name "Graphical-Value-Monitors")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;GRAPHICAL-VALUE-MONITORS"))
  (:Compile-Load main)
)

(add-tool 'rstat
"Charts parameters like load, net use, etc. for RSTAT servers.  See RSTATS:WATCH"
"Defines facilities to let the Explorer act as a client for the RPC
RSTAT service found on many Unix machines.  The function RSTATS:WATCH is
the main interface--see it's doc.  There is code to make an Explorer a
server but it isn't well tested and probably doesn't work."
)

(defsystem rstat
  (:name "rstat")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;RSTAT"))
  (:Compile-Load main)
)

(add-tool 'soft-keys
"Allows putting arbitrary functions on keys"
"Allows putting arbitrary functions on keys.  In particular, things like
window selection and window burying.  The functions TV:ADD-SOFT-KEY,
TV:REMOVE-SOFT-KEY, TV:ADD-SOFT-SELECT-KEY, and
TV:REMOVE-SOFT-SELECT-KEY are the programmatic interface.  <Term> K can
be used to make windows selectable via the pressing of one key."
)

(defsystem soft-keys
  (:name "Soft-keys")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;SOFT-KEYS"))
  (:Compile-Load main)
)

;;; Commented out by JPR on 4 Feb 88.  Noone uses this any more and
;;; I've had a complaint about it being loaded accidentally when attempting
;;; to click on the Source Code Debugger.
;(add-tool 'Source-Code-Controller
;"Source Code Control System"
;"This system provides a source code control system, which looks after the
;sources for a number of systems.  A system menu option called System Manager is
;defined, which provides access to the SCCS once it is loaded.  On-line
;documentation is available through the Help option on the right button menu
;in this system.")

(add-tool 'single-window-vt100
"A version of the VT100 emulator that runs in a single window"
"Provides the flavor TELNET:SINGLE-WINDOW-VT100, which is a version of
the VT100 emulator that uses only one pane, so that it looks like one
window.  You can click middle on these windows to get a menu of
commands.  The label tells how many characters wide and tall the
window is.  The following variables control fonts used in new windows:
 
	telnet:*VT100-default-standard-font*
	telnet:*VT100-default-bold-font*
	telnet:*VT100-default-double-wide-font*
	telnet:*VT100-default-double-height-top-font*
	telnet:*VT100-default-double-height-bottom-font*
	telnet:*VT100-default-graphics-font*
	telnet:*VT100-default-narrow-font*
	telnet:*VT100-default-double-wide-graphics-font*
	telnet:*VT100-default-double-height-graphics-top-font*
	telnet:*VT100-default-double-height-graphics-bottom-font*
"
)

(defsystem single-window-VT100
  (:name "Single-window-VT100")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;SINGLE-WINDOW-VT100"))
  (:compile-load main)
  )

(add-tool 'imagen-printer-via-tcp
"Support for printing on network based Imagen printers."
"This system brings the TCP/IP and IMAGEN packages together to be able
to print files and bitmaps on Imagen 8/300's and related printers.  You
must have both packages loaded to use this.  (They are already loaded at
the KSL.)"
)

;;;Edited by Acuff                 16 Mar 88  13:32
;;;Edited by acuff                 6 Jan 89  10:06
;;;Edited by acuff                 6 Jan 89  10:08
(defsystem imagen-printer-via-tcp
  (:name "Imagen Printer via TCP")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;IMAGEN-PRINTER-VIA-TCP"))
  (:compile-load main)
  )

#+TI
(add-tool 'Map-Over-Files
"Utility to map over files."
"This tool defines the function Map-Over-Files.  It is a higher order function
 which allows you to map a given function over a collection of files in,
 hopefully, quite a sophisticated way.  It takes two mandatory arguments and a
 number of optional keyword arguments.  The two mandatory arguments are:

	a-function    - This is the function which will be applied to the
			files selected.  For a specification of the
			arguments to this function see the optional arguments
			below.  The pathname denoting the file being mapped
			over is always the first argument.
	paths	      - This item can be either an individual item or a list
			of items.  Each item can be one of three things: a
			string denoting a path, a pathname object denoting the
			desired path or a two-list of the form (:Wild-Inferiors
			<path>).  The pathnames given for this argument can be
			arbitarily wildcarded.  The list form for an item
			should be used if the host type being referred to in the
			path does not support the :Wild-Inferiors pathname
			option.  In this case the expression
			(:Wild-Inferiors 'host:>foo>bar>baz.lisp') is
			equivalent to 'host:>foo>bar>**>baz.lisp'.

The optional (keyword) arguments are as follows:

	Accumulate    - This argument allows you to accumulate the results of
			the calls to the a-function argument.  If this option
			is selected to be non-nil then the Second argument to
			the a-function argument will be the currently
			accumulated result.  If this option is not specified
			then no accumulation argument will be supplied to the
			a-function argument when it is called.  An initial value
			is needed for the accumulation process.  The default
			value for the initial value is nil.  If you want
			something different from this then you should use the
			Initial-Value keyword argument (see below).
	Exclude	      - This option allows you to supply an item or a list of
			items, like for the paths parameter.  In this case,
			however, all files whose paths match any of the paths in
			the exclude component do not have the a-function
			argument applied to them.  Like the paths argument this
			argument can be arbirarily wildcarded.
	Log	      - This argument, if non-nil, will cause the name of the
			file being processed to be printed out just before it
			is processed.  If the value of Log is a stream then the
			output will be printed onto that stream, otherwise it
			will come out on Standard-Output.
	Arguments     - This argument must be a list of extra arguments that are
			to be passed to the a-function argument when it is
			called.  The arguments are placed after the path to be
			operated on and after the accumulation argument if it
			has been specified.
	Confirm	      - This argument, if supplied, will cause the user to be
			prompted with the name of the file to be operated on
			before it is operated on with a y-or-n-p.  If the user
			selects N then the operation will not be performed.  If
			the value of the Confirm argument is a stream then the
			query will come out on this stream, otherwise it will
			come out, as usual, on *Query-io*.
	Bottom-First -  This argument is useful if the order in which you
			traverse the directory structure is of importance.
			Normally the traversal is from top to bottom.  If,
			however, it is of importance that the directories should
			be traversed from bottom up then this option should be
			non-nil.  This is particularly useful, for instance, if
			you are trying to do a delete and expunge of a tree of
			directories.  On some file systems, directories can only
			be deleted if their contents have been deleted and
			expunged.  Thus you have to start at the bottom.
	Initial-Value - This argument has to be used in conjunction with
			Accumulate.  A value specified for this argument will
			be used as the initial argument for the accumulation of
			results.  For more information please see above under
			Accumulate.
"
)

#+TI
(defsystem Map-Over-Files
  (:name "Map over files")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;MAP-OVER-FILES"))
  (:compile-load main)
)

#+TI
(add-tool 'Search-and-replace
"Search for string (with wildcards) in filespec and substitute (optional)."
"
 Defines the function Search-And-Replace, whose documentation follows:

 Searches over the files in Files for Search-String.

 Search-String     - Can have two sorts of wildcards; \"?\", which is a single
                     character wildcard, and \"*\", which is a multi
                     character wildcard.  This argument can be a string or a
                     list of strings.

 Files             - Is a string/pathname or list of strings/pathnames, denoting
                     the files to be searched.

 Returns either a) the list of these files in which the search string was found
 if no Replace-String is specified or b) the list of files for which a
 replacement was performed if Replace-String is specified.

 Takes the following keyword args:-
 Replace-String    - If there is a Replace-String the replacement is made
                     either unconditionally or according to Confirm-Replace-P.
                     If this is a list of strings then the strings are matched
                     for replacement with the search strings by their position
                     in the list.  The last element in the list of replace
                     strings is used for replacement for all of those elements
                     in the list of search strings, which do not have
                     associated replace strings.  The replace string can be
                     wildcarded in the same way that the search string is, but
                     the shape of the pattern must be congruent with that of
                     the search string.  For example, you could search and
                     and replace the following patterns:
                          \"Hello*Jim\" -> \"Good*Bye\"
                          \"Hello*Jim\" -> \"Goodbye\" ; because no wildcards
                     but not the pattern:
                          \"Hello*Jim\" -> \"Good?Bye\"
 Confirm-Replace-P - Replacements of strings are made unconditionally if this
                     is Nil, otherwise the user is asked to confirm that the
                     substitution should take place.
 Exclude           - A filespec, like that given to Map-Over-Files.  The files
                     specified are not Search-And-Replaced.
 Case-Sensitive-P  - If this is non-nil then string comparisons are case
                     sensitive, otherwise they are case insensitive.
 Line-Numbers-P    - If true then line numbers are printed out before the
                     matching lines.
 Silent-P          - If Silent-p is true then the matches are not printed, nor
                     are the names of the files searched.  This cannot be
                     non-nil if Confirm-Replace-P is true.  If this is
                     :Just-Print-Matching-Lines then only the mayching lines are
                     echoed, and the file names searched are not.
 Wildcards         - A list of two characters to be used as wildcard characters.
                     The first is the multiple character wildcard, the second is
                     the single character wildcard.  Note: wildcard chars can be
                     quoted in search strings using
                     *wildcard-char-quoting-character* (default =#\\).  If you
                     are just typing a call to search-and-replace to a listener
                     then you'll need to quote the \ char, i.e. type in
                     \"Hello\\*Jim\" in order for the reader to read the string
                     \"Hello\*Jim\", which will search for the literal string
                     \"Hello*Jim\".
 Confirm-Files-P   - If true then the user is prompted before each file is
                     searched.
 Echo-replacement-p- When true causes the strings that have been replaced to
                     be echoed after the replacement.
 Search-Not        - If true will find those files not including the string.
 Remote-Host       - The same as the remote-host argument for map-over-files.
 Remote-Bindings   - The same as the remote-bindings argument to map-over-files.

--------------------------------

Also defines the following M-x commands.
  Search Files        - Searches in files for a string.
  Search Files Not    - Searches for files not containing a string.
  Remote Search Files - Searches in files for a string on a remote host.
  Search System Files - Searches the files in a system for a string.
  Search and Replace in Files - Searches in files for a string and
                                replaces it with another.
  Search and Replace in System Files - Searches the files in a system for a
                                       string and replaces it with another.
  Remote Search and Replace in Files - Searches in files on a remote host for
                                       a string and replaces it with another.
")

#+TI
(defsystem Search-and-replace
  (:name "Search for (and optional replace) string in filespec.")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;SEARCH-AND-REPLACE"))
  (:compile-load main)
)

#+TI
(add-tool 'spelling-checker
"Zmacs based spelling checker."
"
This is a spelling correction program for the Explorer.  It now gives
full support for multiple dictionaries.  The user may associate
any number of dictionaries with any Zmacs buffer.  This allows
dictionaries particular to a user and to a particular document to be
defined.  The user can either be prompted for which dictionary to insert
a new word into or can select one dictionary as the target one.

Spelling correction is quite fast--instantaneous if the word is
correct, a few seconds if SPELLER has to search for possible
replacements.  The first use of the SPELLER might be a little slow,
though, as it has to initialize itself.

There is a Logout initialization, which will prompt you to save
any modified dictionaries when you logout or call si:shutdown.

Interesting Variables:
----------------------

SPELLER:*PROMPT-IN-MINIBUFFER*	(default nil)
The speller sometimes prompts you for input with a menu.  It can also 
prompt you for the same commands in the minibuffer.  People who like 
to keep their hands on the keyboard will prefer this.  It is also 
somewhat faster than popping up a menu.  Just set 
SPELLER:*PROMPT-IN-MINIBUFFER* to t.

ZWEI:*COUNT-WORDS-CHECKED*	(default nil)
When true a count of the number of words is displayed in the minibuffer 
as a row of dots and plusses.  Dots indicate 100 words, plusses come 
every 500.


ZMacs Commands:
---------------

The Speller implements a number of ZWEI commands, listed below.  All 
of the commands below use completion, where appropriate, and provide
legal completions with the help key.

Where a name is given in parentheses this is a name of a function
with the same functionality as the Zmacs command which can be called
from outside zmacs.  For instance (Load-Dictionary from-path) will
load a dictionary from a file named by from-path.  An argument specified as
Dict-Name is any string, path, symbol or dictionary that can be coerced
into the name or pathname for a dictionary.

M-$ will correct either a region or the word at the point, if no
region is defined.  For a single word, it will display 'OK' in the
mini-buffer if the word is correct.  If not, a menu will pop up.  The
bold menu entries are replacement suggestions.  Click on one of those to
replace the word in the buffer with the suggestion.  The italic entries
are commands to SPELLER.
  
     'Skip' will cause the speller to not correct this word.  
     'Type-in' will let you type in a replacement word (which will
               not be checked).  
     'Abort' ends spelling correction.  
     'Accept' tells SPELLER to assume this word is correct in all
              further occurrences in the document.


M-X Correct Spelling will correct the spelling of the entire document.
It starts at the beginning of the document looking for words in error.
When one is found, it is highlighted with reverse video and the menu
described above is displayed.  Unless aborted, it will continue this
until the end of the document.  The point is restored to the same
location it had when the Correct Spelling command was entered.

The following are commands for manipulating dictionary files:

M-x Load Dictionary	Loads a dictionary but does not add to current buffer.
(Zwei:Load-Dictionary from-path)

M-x Save Dictionary	Saves a dictionary to a file.
(Zwei:Save-Dictionary dict-name)

M-x Revert Dictionary	Reverts a dictionary to the last saved version.
(Zwei:Revert-Dictionary dict-name)

M-x Create Dictionary	Creates a named, empty dictionary.
(Zwei:Create-Dictionary)

The following commands affect the association of dictionaries with
buffers.

M-x Add Dictionary To Buffer	Adds a dictionary to the list of
dictionaries to search, for the current buffer.

M-x Remove Dictionary From Buffer.

M-x Add Global Dictionary	Adds a dictionary to all buffers.
(Zwei:Add-Global-Dictionary dict-name)

M-x Remove Global Dictionary	Removes a dictionary from all buffers.
(Zwei:Remove-Global-Dictionary dict-name)

M-x List Dictionaries	This is like M-x List Buffers.  It gives you a
right-button menu of operations on dictionaries.

The following command affects the selection of the dictionary to put
any new words into.

M-x Select Dictionary	Makes the selected dictionary the one into which
all new words will be put.  Numeric argument deselects.

The following commands allow the manipulation of dictionaries as
textual entities.

M-x Edit Dictionary	Prints dictionary into a named buffer.

M-x Save Buffer As Dictionary	Writes a named buffer out as a
 dictionary File.

M-x Auto Spell Check Mode   This selects a minor mode that automatically checks
 your spelling as you type.  This is useful when typing mail, for instance.

M-X Show Dictionary  Displays the contents of a dictionary.
--------

The dictionary is based on the Ackerman/Mattson/Gorin/Adler
dictionary that was used on some CP/M systems.  While a little bit
lightweight by today's standards, it is about 40,000 words long and
fairly heavy on technical words.  It contains some place names (states
and a few cities) and some personal names.  Where there are two
acceptable variants for a word, e.g.  'labelled' and 'labeled', only one
is represented in the dictionary.  The theory is that consistency is
more important than artistic license.  

When the make-system is done, a process is spun off to load the
main dictionary.  This takes a couple of minutes, so if you try to use
one of correction commands immediately, you will get the message 'Loading
main dictionary...' until the load completes.  If the process loading the
dictionary gets an error, it will quietly die and the speller will retry
the load when a spelling command is first used.  Any errors on that load
will be visible and correctable by you.

This code is made available with the usual hacker restrictions: It
is not to be sold nor included in any package that is sold.  Otherwise, it
may be copied freely.  I would appreciate it if any modifications would
be sent to me for inclusion in the package.  I would also like to hear
of any bugs, although fixes are neither promised nor likely.  I can be
reached at JOHNSON@TI-CSL.CSNET-RELAY or

Douglas Johnson MS 238
Texas Instruments
P.O. Box 226015
Dallas, Texas 75226
")

#+TI
(si:set-system-source-file 'spelling-checker
			   "TOOLS:TOOLS.SPELLER;DEFSYSTEM.LISP")

(add-tool 'dvi-previewer
"Show the contents of a DVI format document on the Explorer screen."
"Show the contents of a DVI format document on the Explorer screen.
Use the function SHOW-DVI from a Lisp Listener, and the <HELP> key.
It helps if the Listener window is large.  The DVI file cannot be on a
Tops-20 system."
)

(when (= (si:get-system-version) 4)
  (defsystem mac-type-scrolling
    (:name "Mac Type Scrolling")
    (:output-version :newest)
    (:module main ("TOOLS:TOOLS;MAC-TYPE-SCROLLING"))
    (:compile-load main)
    )
  )

(when (= (si:get-system-version) 4)
  (add-tool 'mac-type-scrolling
	    "Make scroll bars look and act like Macintosh ones.  ****BREAKS CURRENT WINDOWS THAT SCROLL****"
	    "Scroll bars that look and function like those on the Macintosh.  This
tool breaks scrolling for windows that have already been made, so it
should be loaded before any windows are created.  This code is from TI
Austin."
	    )
  )

(defsystem window-icons
  (:name "Window Icons")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;WINDOW-ICONS"))
  (:compile-load main)
)

(add-tool 'window-icons
"Allow windows to be shrunk to Icons."
"See doc at top of source file for details.  Allows windows to be shrunk
to iconic representations that can later be expanded.  Defines
W:SHRINK-WINDOW and adds a 'Shrink' command to the Window manager system
menu.  The only kind of icon currently implemented are small boxes with
the label/name of the window in them.  This facility requires the
UTILITIES and WINDOW-SYSTEM-ADDITIONS tools to work properly."
)


(add-tool 'Grapher
"A Grapher, rather like the Interlisp-D grapher."
 `("Defines a number of interesting functions/flavors.

Functions:
  Tv:Plot-a-Graph - takes a lot of keyword arguments and plots something.

  Tv:graph-something - takes something and, if it knows how to, will graph
   it.  This uses the perspective mechanism defined by the general inspector.
   Perspectives defined on the perspective flavor tv:grapher-perspective will
   be available perspectives for this function.

Consistency command:
  C-Sh-G, M-Sh-G - Plots a graph of something.

Flavor:
  Tv:graph-window - a useful flavor to build graphical windows on.

Grapher windows can generate postscript representations of the graphs they
denote.  Postscript is generated by sending messages to the window in
question.  The methods that you should be most interested in are called
:generate-postscript and :maximum-number-of-pages.

The following is the documentation for the :generate-postscript method:
======================================================================

"
   ,#'(lambda () (format t "~A" (documentation '(:Method tv:rendering-mixin :generate-postscript) 'function)))

"
The following is the documentation for the :maximum-number-of-pages method:
===========================================================================

"

   ,#'(lambda () (format t "~A" (documentation '(:Method tv:rendering-mixin :maximum-number-of-pages) 'function)))


"
The following is the documentation for the function Tv:Plot-a-Graph:
====================================================================

"
   ,#'(lambda () (format t "~A" (documentation 'tv:plot-a-graph 'function)))
 )
)

(defsystem window-accelerators
  (:name "Window Accelerators")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;WINDOW-ACCELERATORS"))
  (:compile-load main)
)

(add-tool 'window-accelerators
"Facilitate window managing by allowing windows to be moved, etc. directly with the mouse."
"Defines W:WINDOW-ACCELERATOR-MIXIN and W:LABEL-ACCELERATOR-MIXIN which allow
windows to be operated on by just using the mouse.  By default the following
operations are done:

   #\Mouse-L-1   Drag-Move the window
   #\Mouse-L-2   Drag-Reshape the window
   #\Mouse-M-1   Standard-Reshape the window
   #\Mouse-M-2   Shrink the window if possible
   #\Mouse-R-1   Zoom the window size if possible, else System Menu
   #\Mouse-R-2   System Menu

Redefines Lisp Listeners, Debugger frames, Zmacs, Peek, Vt100, and the
Inspector to use accelerators.

Also defines window \"zooming\".  This allows a window to have more than one
size associated with it.  For instance, you can use a narrow Zmacs most
of the time, \"zoom\" it wider for editing files with long lines, and \"zoom\"
it back again easily."
)

(defsystem west-coast-windows
  (:name "Window Accelerators")
  (:output-version :newest)
  (:module main ("TOOLS:TOOLS;WEST-COAST-WINDOWS"))
  (:compile-load main)
)

(add-tool 'west-coast-windows
"Sets things up so it's easy to use a messy-desk windowing style."
"Loads tools and sets variables to facilitate usage of a messy-desk style of
windowing.  Loads and activates features of Window-System-Additions,
Window-Icons, and Window-Accelerators.

The user should define a function similar to the example given below and call
it in her LOGIN-INIT to set up her windowing environment.

tv:
(defun set-up-windows ()
  \"Function to put windows where I like them, sort of.\"

  ;; Fast ways to Bury, Shrink, or Zoom a window.
  (add-soft-key #\keypad-equal 'soft-key-bury nil)
  (add-soft-key #\keypad-0 'soft-key-shrink nil)
  (add-soft-key #\keypad-7 'soft-key-zoom nil)

  ;; Setup background
  (create-background)
  (set-background (read-bit-array-file \"IMAGES:IMAGES;DOUBLE-GRIFFON#>\"))
  ;;Make sure it's the right color on the mX
  (when (sys:mx-p)
    (when (send *background* :reverse-video-p)
      (kbd-complement-with-background 1)))
  (clean-up-windows 1)

  ;; Start a round clock
  (push (analog-clock nil `(,(- (sheet-width main-screen) 71)
			    0
			    ,(sheet-width main-screen)
			    71)
		      )
	*windows-to-leave-exposed*)
  ;; Don't use the first Lisp or Zmacs
  (setf *windows-not-to-pick*
	(list initial-lisp-listener (find-window \"Zmacs Frame 1\")))

  ;; Main working windows
  ;; Little Listener in the middle of the screen
  (setup-application 'lisp-listener \"Listener\" #\keypad-period
		     (if (sys:mx-p)
			 `(35 116 700 520)
			 `(160 225 825 630)
			 )
		     )
  ;; Editor on the left-hand side of the screen
  (setup-application 'zwei:zmacs-frame \"Editor\" #\keypad-enter
		     `(0 71 ,(if (sys:mx-p) 560 655) 0))
  (if (sys:mx-p)
      (setup-application 'zwei:zmacs-frame \"Mail\" #\keypad-plus `(303 71 0 0))
      (setup-application 'zwei:zmacs-frame \"Mail\" #\keypad-tab `(303 71 0 0))
      )
  (setup-application 'telnet:single-window-VT100 \"VT100\"
		     #\keypad-minus `(280 50 0 631))
  (setup-application 'tv:peek-frame \"Peek\" #\keypad-space `(50 71 770 0))
  (setup-application 'tv:general-inspector \"Inspector\" #\keypad-1)
  )
"
)


(add-tool :Yes-Way
"Loads the Explorer IMAP Client mail reading system."
"This tool is a distributed mail reading mechanism that allows
you to keep your mail on a \"reliable\" mail server (e.g. Sumex)
and to read it from a workstation of your choice.  The
idea then is to develop client programs to run on those
workstations to take full advantage of the machine's
capabilities to give you the best mail reading software
under the circumstances.

Client programs for the IMAP protocol currently run on
Macs, NeXT machines and Explorers.  This tool is the Explorer
Client for IMAP.

The following is a brief description of the mailer/list of some
of the features that might incline you to use it:

a) Provides [broadly] a superset of MM functionality.

b) Supports multiple usage model.
   - If you like to click on things then you can.
   - If you like mm style commands then you can use them too.

c) Highly customisable.
   - There are over a hundred profile variables and a
     large number of functional hooks to let you make it
     act the way that you want it to.

d) Multiple mailboxes.
   - You can read multiple mailboxes simultaneously,
     including bboards.

e) Multiple, active views of mailboxes.
   - You can have any number of windows displaying headers
     for messages for any mailbox(s).  These windows can
     have filters associated with them so that, for
     instance, you can have a window for flagged messages,
     another for unseen messages and yet another simply
     showing all of the mailbox.  These windows are active
     and update as appropriate when new mail arrives or
     flags change.

f) Arguments given to commands can be specified in a
   number of ways by mouse clicks as well as typing.
   - Typing for instance:  \"Read <<Click on message>>\" will
     select a message as an argument to the command.
   - Clicking on messages or dragging over a region can be
     used to select messages.  These can be taken as
     prefix arguments to the operators invoked.  Thus
     \"<<Click on message>> Read\" is also legal.
   - Mouse selection of a message selects the semantically
     appropriate field.  Thus \"Read From <<Click on
     message>>\" will read all of the messages from the
     person who sent the message clicked on.

g) Complex message sequence specifications can be built
   (much more powerful than in MM.)
   - And Or and Not can all be used in boolean expressions
     of messages.
   - Parentheses are supported.
   - Control structures are provided that allow the
     reading  of mail in orders other than strictly
     chronologically matching the sequence predicate.
     For instance, a filter can easily be built that
     expresses the desire to read mail sent to you first,
     then any mail that was CCed to you and finally mail
     that came in as a result of you being on a mailing
     list.

h) The user can build named abstractions for commands and
   filter combinations.
   - Macro commands can be built that execute a number of
     mailer commands.
   - Named filters can be built that attach a name to a
     complex filter.  For instance, a filter called
     \"UnCrispin\" can be easily defined that specifies all
     mesages not from Mark Crispin.  These filters can be
     attached automatically to bboards.

i) Address completion is supported.
   - A database is built automatically of the addresses
     that are seen by the system.  Normal recognition,
     apropos and spelling correcting completion can be
     performed on the basis of this database.  No more
     need to hang onto old messages so as to be able to
     reply to them over and over again.

j) Message prefecthing.
   - A number of user specifiable heuristics allow the
     mailer to second-guess the user and prefetch messages
     that the user is likely to want to read, thus
     improving responsiveness.

k) Message composition is supported in Zmacs.
     Reply inclusion is provided, as is automatic
     rejustification if the indentation of the reply
     causes wrapping.  The mailer detects inclusion prefix
     characters and reinserts them after refilling the
     paragraph.  For example:

>>  Reply inclusion is provided, as is automatic
>>  rejustification if the indentation of the reply
>>  causes wrapping.  The mailer detects inclusion prefix
>>  characters and reinserts them after refilling the
>>  paragraph.  For example:

->  >>  Reply inclusion is provided, as is automatic
->  >>  rejustification if the indentation of the reply
->  >>  causes wrapping.  The mailer detects inclusion
->  >>  prefix characters and reinserts them after
->  >>  refilling the paragraph.  For example:

--> ->  >>  Reply inclusion is provided, as is automatic
--> ->  >>  rejustification if the indentation of the
--> ->  >>  reply causes wrapping.  The mailer detects
--> ->  >>  inclusion prefix characters and reinserts them
--> ->  >>  after refilling the paragraph.  For example:

--->--> ->  >>  Reply inclusion is provided, as is
--->--> ->  >>  automatic rejustification if the
--->--> ->  >>  indentation of the reply causes wrapping.
--->--> ->  >>  The mailer detects inclusion prefix
--->--> ->  >>  characters and reinserts them after
--->--> ->  >>  refilling the paragraph.  For example:

System-M starts up the mailer and the Get command selects
mailboxes.  If you've used mm before the rest should be
pretty easy.  The Help key usually does meaningful things.

If you want to set up any environment stuff then you will
find this in the file: Yes-Way:Yes-Way;Vars.lisp, or you
can use the Profile tool, which you can get to from the
Profile command to the mailer.

An example set of useful inits can be found in
Yes-Way:Yes-Way;default-settings.lisp.
"
)

(si:set-system-source-file 'network-services
			   "TOOLS:TOOLS.REXEC;DEFSYSTEM.LISP")

(add-tool :network-services
 "Adds ability to use REXEC, RSHELL, and LPD Unix services."
 "This tool is imported from Berkeley.  See TOOLS:TOOLS.REXEC;_README.TEXT
for more information.  When this tool is loaded the Explorer can use Unix's
REXEC, RSHELL, and LPD facilities.  Thus, it is possible to print to any
printer the serving Unix can print to (if the Explorer knows how to drive
that printer type).
"
)