;;; -*- Mode: Common-Lisp; Package: User; Base: 10.; Patch-File: T -*-
;;; Written 12-Feb-91 16:47:00 by acuff,
;;; Reason: SPR 172: Don't error when reading dotted list in read suppressed mode.
;;; while running on KSL-Mac-62 from band KSLA
;;; With SYSTEM 6.41, GC 6.7, VIRTUAL-MEMORY 6.3, MICRONET 6.0, MICRONET-COMM 6.4,
;;;  DISK-IO 6.4, DISK-LABEL 6.1, BASIC-PATHNAME 6.5, MAC-PATHNAME 6.0, NETWORK-SUPPORT-COLD 6.2,
;;;  BASIC-NAMESPACE 6.8, BASIC-FILE 6.15, RPC 6.2, NFS-MX 6.9, EH 6.8, MAKE-SYSTEM 6.5,
;;;  MEMORY-AUX 6.0, COMPILER 6.18, TV 6.32, NVRAM 6.4, UCL 6.1, INPUT-EDITOR 6.1,
;;;  MACTOOLBOX 2.25, METER 6.2, ZWEI 6.28, DEBUG-TOOLS 6.5, WINDOW-MX 6.12, PRINTER 6.8,
;;;  MAC-PRINTER-TYPES 6.2, CLIPBOARD 6.1, TI-CLOS 6.53, CLEH 6.5, NETWORK-PATHNAME 6.2,
;;;  NETWORK-NAMESPACE 6.1, DATALINK 6.0, CHAOSNET 6.9, NETWORK-SUPPORT 6.1, NETWORK-SERVICE 6.3,
;;;  DATALINK-DISPLAYS 6.0, MX-DATALINK 6.1, NAMESPACE-EDITOR 6.7, IP 3.65, NFS-MX-SERVER 6.0,
;;;  MX-SERIAL 6.2, PRINTER-TYPES 6.2, IMAGEN 6.1, MAIL-DAEMON 6.6, MAIL-READER 6.9,
;;;  TELNET 6.1, VT100 6.0, STREAMER-TAPE 6.6, DECNET 1.72, VISIDOC 6.7, PROFILE 6.3,
;;;  Experimental KSL-PATCHES 10.5,  microcode 195, Band Name: 6.1(41), KSL9 10.2,
;;;  17-Jan

#!C
; From file PATCHES-9.LISP#> SYS-PATCHES; KSL-EXP-7:
#10R USER#:
(lisp:COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "USER"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "KSLx: SYS-PATCHES; PATCHES-9.#"


sys:
(defun internal-read-list (stream &optional character)
  (let* ((thelist nil)
	 (listtail (locf thelist))
	 (top-level-list top-level-list)
	 correspondence-entry)
    (when (and read-Check-Indentation  Last-Whitespace (Char= Last-Whitespace #\Cr)
	       (null *read-suppress*)) ;;we are truly reading, not skipping things 
      (If (Null Top-Level-List)
	  (unless (and (listp xr-list-so-far)	; PDC 8/7/86
		       (symbolp (car xr-list-so-far))
		       (get (car xr-list-so-far) 'may-surround-defun))
	  (progn 
	    (signal-proceed-case (() 'sys:missing-closeparen
				     "Open paren found in column zero; missing closeparens assumed.")
	      (:no-action))
	    (setf missing-close-paren t)
	    (unread-char #\( stream)
	    (setf xr-splice-p t)
	    (return-from internal-read-list nil)))))
    (setf last-whitespace nil)
    (setf missing-close-paren nil)
    (setf top-level-list nil)
    (when xr-correspondence-flag
      (unread-char character  stream)
      (setq correspondence-entry `(nil ,(funcall stream :read-bp)  ,@xr-correspondence))
      (setq xr-correspondence correspondence-entry) (read-char stream))
    (do ((firstchar (flush-whitespace stream) (flush-whitespace stream)))
	((char= firstchar #\))
	 (when xr-correspondence-flag (rplaca correspondence-entry thelist))
	 thelist)
      (when (char= firstchar #\.)
	    (let ((nextchar (internal-read-char stream t)))
	      ;;RDA: Don't get error because several reader macros which
	      ;;would result in one object if evaluated follow a dot when
	      ;;we're not evaluating the macros.  Add (UNLESS *READ-SUPPRESS*
	      (unless *read-suppress* 
		(cond ((token-delimiterp nextchar)
		       (cond ((eq listtail (locf thelist))
			      (cerror :no-action nil 'sys:read-error-1
				      "Nothing appears before . in list."))
			     ((whitespacep nextchar)
			      (setq nextchar (flush-whitespace stream))))
		       (rplacd listtail
			       (let* ((XR-LIST-SO-FAR ':AFTER-DOT)
				      (XR-SPLICE-P NIL)
				      (values (read-after-dot stream nextchar)))
				 (WHEN XR-SPLICE-P
				   (return XR-LIST-SO-FAR))
				 ;;return list containing last thing.
				 (car values)))
		       (when xr-correspondence-flag (rplaca correspondence-entry thelist))
		       (return thelist))
		      ;;put back nextchar so we can read it normally.
		      (t (unread-char  nextchar stream))))))
      ;;next thing is not an isolated dot.
      (let* ((XR-LIST-SO-FAR thelist)
	     (XR-SPLICE-P NIL)
	     (listobj (read-maybe-nothing stream firstchar)))
	(COND (XR-SPLICE-P
	       (SETQ theLIST XR-LIST-SO-FAR)
	       (SETQ listtail
		     (COND ((ATOM theLIST) (LOCF theLIST))
			   ( (LAST theLIST)))))
	;;allows the possibility that a comment was read.
	      (t (when listobj
		   (rplacd listtail listobj)
		   (setq listtail listobj)))))
      (when (and missing-close-paren (null top-level-list))
	(when xr-correspondence-flag (rplaca correspondence-entry thelist))
	(return thelist))
      )))
))
