;;; -*- Mode:Common-Lisp; Package:SYSTEM; Base:10; Patch-File:T -*-

;;; This software developed by:
;;;	Rich Acuff
;;;	except where noted
;;; at the Stanford University Knowledge Systems Lab in 1987-1989.
;;;
;;; This work was supported in part by:
;;;	NIH Grant 5 P41 RR00785-15

;;; No TI copyright applies to this file.

;;; Customizations specific to the KSL loaded by KSL-Patches.  Other
;;; sites will probably not want to load this file, though they may want
;;; to copy and modify it for use.

;;;  Let it be known that this is a KSL world
(push :ksl *features*)
(push :release-6 *features*)

;;; Always compile
(setf compile-encapsulations-flag t)

;;; Try to not mess up screen images so much on mX's--turn off direct drawing
(when (sys:mx-p)
  (sys:add-initialization
    "No Direct Drawing"
    '(let ((direct-drawing-mode-function
	     (SYMBOL-FUNCTION (FIND-SYMBOL "SET-DIRECT-DRAWING-MODE" "MAC"))))
       (FUNCALL direct-drawing-mode-function :off))
    :warm))

;;; Use rubber bands for window sizing
(setq w:*use-rubber-bands?* t)

;;; Where to get pictures
(add-logical-pathname-host
  "IMAGES"
  "X1"	   ;Change this to name of host if different
  '(("IMAGES" "IMAGES;"))
  nil
;  nil						;Update Namespace?
  )

;;; A cute KSL hack
(defvar *stanford-logo* (w:read-bit-array-file "IMAGES:IMAGES;STANFORD-CIRCLE"))

(advise sys:initial-screen-heading :after "Stanford Logo" nil
  (when (and (typep *terminal-io* 'w:stream-mixin)
	     (typep *stanford-logo* 'array))
    (format *terminal-io* "~3%")
    (send *terminal-io* :bitblt w:alu-seta
	  (array-dimension *stanford-logo* 1)	;Width
	  (array-dimension *stanford-logo* 0)	;Height
	  *stanford-logo*
	  0 0
	  (- (tv:sheet-width *terminal-io*)	;Right edge
	     (array-dimension *stanford-logo* 1)	;Width
	     5)					;A little margin
	  5
	  )
    )
  )

;;; We like mouse cursors we can see
(setf w:*menu-mouse-item-glyph* (make-char w:MOUSE-GLYPH-THIN-CROSS))

;;; Shorter heralds, please
sys:
(defvar *ksl-systems-not-to-see*
	'("VIRTUAL-MEMORY" "EH" "MAKE-SYSTEM" "MICRONET" "LOCAL-FILE"
	  "BASIC-PATHNAME" "NETWORK-SUPPORT-COLD" "NAMESPACE"
	  "NETWORK-NAMESPACE" "DISK-IO" "DISK-LABEL" "BASIC-FILE"
	  "MAC-PATHNAME" "NETWORK-PATHNAME" "COMPILER" "TV" "DATALINK"
	  "CHAOSNET" "GC" "MEMORY-AUX" "NVRAM" "SYSLOG" "STREAMER-TAPE"
	  "UCL" "INPUT-EDITOR" "METER" "ZWEI" "ZMACS-EXTRAS" "DEBUG-TOOLS"
	  "NETWORK-SUPPORT" "NETWORK-SERVICE" "DATALINK-DISPLAYS"
	  "FONT-EDITOR" "SERIAL" "PRINTER" "PRINTER-TYPES" "IMAGEN"
	  "SUGGESTIONS" "MAIL-DAEMON" "MAIL-READER" "TELNET" "VT100"
	  "NAMESPACE-EDITOR" "PROFILE")
  )

;; I'd rather do this with an arg to PRINT-HERALD but that can't be done without
;; hacking PRINT-HERALD.
(defvar *ksl-short-herald* t 
   "   Non-NIL causes systems on *KSL-SYSTEMS-NOT-TO-SEE* to not appear in
   PRINT-HERALD's output.")

sys:
(advise-within describe-system-versions get-relevant-systems-list
	       :around "KSL Invisible Systems" nil
	       (if *ksl-short-herald*
		   (delete-if
		     #'(lambda (x)
			 (if (typep x 'cons)
			     (member (first x) *ksl-systems-not-to-see* :test #'equalp)
			     nil
			     )
			 )
		     :do-it
		     )
		   :do-it
		   )
	       )

;;;  Load the tool loading tool.  Note that users should still do this
;;;  in their login-init files to get the most up to date version.
(make-system 'tools :noconfirm :nowarn)

;;; Fix up NEW-USER for the KSL (NYI)
;(sys:load-if "KSLx:KSL-PATCHES;KSL-NEW-USER")

;;; We trust each other, I think
(chaos:eval-server-on :notify)

;;; Easy way to find addresses
NET:
;;;Edited by acuff                 2 Feb 89  16:53
(defun addr (host-name &optional (stream *standard-output*))
  "Prints the IP and Chaos addresses for HOST-NAME.  Chaos address is given as
   an octal number and as (XX-YY) where XX and YY are the net and host
   numbers, respectively, in decimal."
  (let* ((host (net:parse-host host-name))
	 (ips (mapcar #'ip:address-string-from-number (send host :ip-addresses)))
	 (chaos (send host :chaos-address))
	 )
    (format stream "~&~A: ~A~{, ~A~}: " host (first ips) (rest ips))
    (if chaos
	(format stream "#o~O (~D-~D)" chaos (truncate chaos 256) (mod chaos 256))
	(format stream "no Chaos address"))
    (values)
    )
  )

;;; Don't get MORE in the lisp listener during boot, etc.
(send tv:initial-lisp-listener :set-more-p nil)

;;; Important tools
(load-tools '(pathname-extensions
	      imagen-printer-via-tcp
	      network-services		    ;RDA: For LPD PostScript printing
	      backup-to-file-system))

(setq imagen::*imagen-font-directory-host-name* "X7")

;;;NOTE: Other tools are now loaded by the system KSL-STANDARD-TOOLS
