;;; -*- Mode:Common-Lisp; Package:Ip; Base:10 -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;; Use, duplication, or disclosure by the Government is subject to
;;; restrictions as set forth in subdivision (b)(3)(ii) of the Rights in
;;; Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;; Copyright (C) 1988 Texas Instruments Incorporated. All rights reserved.

(si:load-if "ksl:sys-patches;ip-ns-fixes.xld")

(defvar *UDP-WHO-AM-I-PORT* 235.
  "Port number to use. Right now it is an expermental port number but we should get a well known port.")

(defvar *UDP-WHO-AM-I-DESTINATION-ADDRESS*  #xffffffff "Use the ip broadcast address.")

(add-server *udp-who-am-i-port*
	    '(process-run-function '(:name "UDP who-am-i") 'udp-who-am-i-server)
	    '*udp-server-alist*)

(defvar *DEBUG-ON-NON-SERVER* nil "set to t to use client namespace function to look up host.")

(defvar *DEBUG-UDP-WHO-AM-I-SERVER* nil "Set to t to stop errors from being caught.")

;; Note that in the spirit of TGC we will just cons away with no thought of reusing the buffers. Cringe!!! 
;;;Edited by Acuff                 20 Mar 88  12:33
(defun UDP-WHO-AM-I-SERVER (&aux port)
  "UDP who-am-i server"
  (condition-call-if  (not *debug-udp-who-am-i-server*) (cond)
      (unwind-protect
	  (let* (name data-p source-port source-address length
		 (buffer (make-array 256 :element-type 'string-char :fill-pointer 0)))
	    
	    (setf port (send *udp-handler* :get-port *udp-who-am-i-port*))
	    (setf (send port :who-state) "Who Am I")
	    
	    (setf (values length source-port source-address data-p) (send port :receive-data buffer))
	    (setf (fill-pointer buffer) length)
	    
	    (when (and data-p
		       (search "WHO-AM-I" buffer :test #'string-equal :end2 (max 9 length)))
	      
	      (setf name 
		    (let* ((start (position #\" buffer :test 'char-equal)))		      
		      (if start 
			  (subseq buffer (1+ start) (position #\" buffer :start (1+ start) :test 'char-equal)))))
	      
	      (let* ((domain-name
		       (when name 
			 (if *debug-on-non-server*
			     (format nil "~a" (second (multiple-value-list (name:lookup-object name :host))))
			     (funcall name:*who-am-i-answer-function* name))))
		     
		     (his-host-object (when domain-name (si:parse-host (name:qualified-name name domain-name) :no-error)))
		     
		     (his-addresses (when his-host-object (send his-host-object :send-if-handles :network-address-list :ip)))
		     
		     (his-best (when his-addresses (best-relative-address his-addresses my-addresses)))
		     
		     (my-best (when his-addresses (best-relative-address my-addresses his-addresses))))
		
		(when (and his-best my-best)
		  (let ((*print-base* 16.)
			(*print-radix* t)
			
			;; Bind this to get around ip's changing the address in to a subnet broadcast.
			(*really-broadcast* t))		    
		        
		    (send port :transmit-data
			  :data (format nil "UR ~s ~s ~s ~a ~a"
					name
					domain-name
					si:local-host-name
					his-best
					my-best)
			  :destination-port source-port ;;*udp-who-am-i-port*
			  :destination-host *udp-who-am-i-destination-address*
			  ))))))
	
	(when port (send *udp-handler* :return-port port)))
    ((not (or (send cond :dangerous-condition-p)
	      (send cond :debugging-condition-p)))
     (tv:notify nil "Udp Who Am I server got an error: ~a" (send cond :report-string)))))

;; Note that more work needs to be done to find the closest address.
(defun BEST-RELATIVE-ADDRESS (my-addresses his-addresses)
  "Address of this host with the shortest routing path to the given host"
  (let ((returned-addr (first his-addresses)) first-hop-rte)
    (condition-case ()
	(progn
	  (setf first-hop-rte (get-routing-entry (first my-addresses)))
	  (when (not (eq (ip-routing-address first-hop-rte) :direct))
		(setf first-hop-rte (get-routing-entry (ip-routing-address first-hop-rte))))
	  (dolist (a his-addresses)
		  (when (equal (get-routing-entry a) first-hop-rte)
			(setf returned-addr a))))
      (incomplete-routing-table))
    returned-addr))

(defvar *UDP-WHO-AM-I-TIMEOUT* 5 "Max time in secs to wait for replys")

(defvar *UDP-WHO-AM-I-RETRY-COUNT* 5 "Number of times to retry send the who-am-i before giving up.")

(defun WHO-AM-I (&optional (name (si:get-pack-host-name)) (retry *udp-who-am-i-retry-count*) &aux port)
  "Return basic namespace info about a host."
  (declare (values domain-name server-name server-address my-address :ip))
  (unwind-protect
      (let ((buffer (make-array 256 :element-type 'string-char :fill-pointer 0))
	    length
	    source-port
	    source-address
	    data-p
	    cursor1
	    cursor2
	    domain-name
	    server-name
	    server-address
	    my-address)
	
	(setf port (send *udp-handler* :get-port))
	(setf (send port :who-state) "Who Am I")

	(dotimes (i retry)

	  (let ((*really-broadcast* t))
	    (declare (special *really-broadcast*))
	    (send port :transmit-data
		  :data (format nil "WHO-AM-I ~s" name)
		  :destination-port *udp-who-am-i-port*
		  :destination-host *udp-who-am-i-destination-address*
		  :source-host *udp-who-am-i-destination-address*
		  ))
	  

	  (loop
	    (setf (values length source-port source-address data-p) (send port :receive-data buffer *udp-who-am-i-timeout*))
	    (when (not data-p)
	      (return))

	    (setf (fill-pointer buffer) length)
	    
	    (when (and (search "UR" buffer :test #'string-equal :end2 3)
		       (progn (setf cursor1 (1+ (position #\" buffer :test #'char-equal)))
			      (setf cursor2 (position #\" buffer :test #'char-equal :start (1+ cursor1)))
			      (string-equal name (subseq buffer cursor1 cursor2))))

	      ;; Get the domain name.
	      (setf cursor1 (1+ (position #\" buffer :test #'char-equal :start (1+ cursor2))))
	      (setf cursor2 (position #\" buffer :test #'char-equal :start (1+ cursor1)))
	      (setf domain-name (subseq buffer cursor1 cursor2))

	      ;; get my name
	      (setf cursor1 (1+ (position #\" buffer :test #'char-equal :start (1+ cursor2))))
	      (setf cursor2 (position #\" buffer :test #'char-equal :start (1+ cursor1)))
	      (setf server-name (subseq buffer cursor1 cursor2))

	      ;; Get server-address
	      (setf cursor1 (position #\space buffer :test #'char-not-equal :start (1+ cursor2)))
	      (setf cursor2 (position #\space buffer :test #'char-equal     :start cursor1))
	      (setf server-address (net:parse-network-address (subseq buffer cursor1 cursor2) :ip nil))

	      ;; Get my address
	      (setf cursor1 (position #\space buffer  :test #'char-not-equal :start (1+ cursor2)))
	      (setf cursor2  (position #\space buffer :test #'char-equal     :start cursor1))
	      (setf my-address (net:parse-network-address (subseq buffer cursor1 cursor2) :ip nil))

	      (when (and domain-name server-name server-address my-address)
		(return-from who-am-i (values domain-name server-name server-address my-address :ip)))))))
    (when port (send *udp-handler* :return-port port))))

(defun TURN-ON-WHO-AM-I-SERVER () (who-am-i-switch t))
(defun TURN-OFF-WHO-AM-I-SERVER () (who-am-i-switch nil))

(defun WHO-AM-I-SWITCH (on?)
  (if on?
     (add-server *udp-who-am-i-port*
	    '(process-run-function '(:name "UDP who-am-i") 'udp-who-am-i-server)
	    '*udp-server-alist*)
     (delete-server *udp-who-am-i-port*
		    '*udp-server-alist*)))

;; Add who-am-i  to the appropriate lists.
(when (boundp 'name:*who-am-i-implementations*)
  (unless (member 'who-am-i name:*who-am-i-implementations*)
    (pushnew 'who-am-i name:*who-am-i-implementations*)))

(when (boundp 'name:*enable-who-am-i-service-functions*)
  (unless (member 'turn-on-who-am-i-server name:*enable-who-am-i-service-functions*)
    (pushnew 'turn-on-who-am-i-server name:*enable-who-am-i-service-functions*)))

(when (boundp 'name:*disable-who-am-i-service-functions*)
  (unless (member 'turn-off-who-am-i-server name:*disable-who-am-i-service-functions*)
    (pushnew 'turn-off-who-am-i-server name:*disable-who-am-i-service-functions*)))

;; Some functions that were helpful when debugging.
(defun DELETE-UDP-WHO-AM-I ()
    (setf name:*who-am-i-implementations*
	  (delete 'who-am-i name:*who-am-i-implementations*))
    (setf name:*enable-who-am-i-service-functions*
	  (delete 'turn-on-who-am-i-server name:*enable-who-am-i-service-functions*))
    (setf  name:*disable-who-am-i-service-functions*
	   (delete 'turn-off-who-am-i-server name:*disable-who-am-i-service-functions*)))

(defun DELETE-CHAOS-WHO-AM-I ()
    (setf name:*who-am-i-implementations*
	  (delete 'chaos:who-am-i name:*who-am-i-implementations*))
    (setf name:*enable-who-am-i-service-functions*
	  (delete 'chaos:turn-on-who-am-i-server name:*enable-who-am-i-service-functions*))
    (setf  name:*disable-who-am-i-service-functions*
	   (delete 'chaos:turn-off-who-am-i-server name:*disable-who-am-i-service-functions*)))

(defun ENABLE-UDP-WHO-AM-I ()
  "Delete the chaos who-am-i code and add the udp code."
  (pushnew 'who-am-i name:*who-am-i-implementations*)
  (pushnew 'turn-on-who-am-i-server name:*enable-who-am-i-service-functions*)
  (pushnew 'turn-off-who-am-i-server name:*disable-who-am-i-service-functions*)
  (delete-chaos-who-am-i))

(defun ENABLE-CHAOS-WHO-AM-I ()
  (pushnew 'chaos:who-am-i name:*who-am-i-implementations*)
  (pushnew 'chaos:turn-on-who-am-i-server name:*enable-who-am-i-service-functions*)
  (pushnew 'chaos:turn-off-who-am-i-server name:*disable-who-am-i-service-functions*)
  (delete-udp-who-am-i))

